/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.jsf.ActionSourceRule;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentRule;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.tag.jsf.EditableValueHolderRule;
import com.sun.facelets.tag.jsf.ValueHolderRule;
import com.sun.facelets.util.FacesAPI;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ComponentHandler
extends MetaTagHandler {
    private static final Logger log = Logger.getLogger("facelets.tag.component");
    private final TagAttribute binding;
    private final String componentType;
    private final TagAttribute id;
    private final String rendererType;
    private static final String PARAM_RECREATE_VALUE_EXPRESSION_ON_BUILD_BEFORE_RESTORE = "facelets.RECREATE_VALUE_EXPRESSION_ON_BUILD_BEFORE_RESTORE";

    public ComponentHandler(ComponentConfig config) {
        super(config);
        this.componentType = config.getComponentType();
        this.rendererType = config.getRendererType();
        this.id = this.getAttribute("id");
        this.binding = this.getAttribute("binding");
    }

    @Override
    public final void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        String facetName = this.getFacetName(ctx, parent);
        String id = ctx.generateUniqueId(this.tagId);
        UIComponent c = ComponentSupport.findChildByTagId(parent, id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Found, marking children for cleanup");
            }
            ComponentSupport.markForDeletion(c);
            if (this.isRecreateValueExpressionsOnBuildBeforeRestore(ctx.getFacesContext())) {
                this.recreateValueExpressions(ctx, c);
            }
        } else {
            c = this.createComponent(ctx);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Created: " + c.getClass().getName());
            }
            this.setAttributes(ctx, c);
            c.getAttributes().put("com.sun.facelets.MARK_ID", id);
            if (this.id != null) {
                c.setId(this.id.getValue(ctx));
            } else {
                UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
                if (root != null) {
                    String uid = root.createUniqueId();
                    c.setId(uid);
                }
            }
            if (this.rendererType != null) {
                c.setRendererType(this.rendererType);
            }
            this.onComponentCreated(ctx, c, parent);
        }
        this.applyNextHandler(ctx, c);
        if (componentFound) {
            ComponentSupport.finalizeForDeletion(c);
            if (facetName == null) {
                parent.getChildren().remove(c);
            }
        }
        this.onComponentPopulated(ctx, c, parent);
        if (facetName == null) {
            parent.getChildren().add(c);
        } else {
            parent.getFacets().put(facetName, c);
        }
    }

    private boolean isRecreateValueExpressionsOnBuildBeforeRestore(FacesContext context) {
        ExternalContext extContext = context.getExternalContext();
        Map<String, Object> appMap = extContext.getApplicationMap();
        Boolean flag = Boolean.FALSE;
        flag = (Boolean)appMap.get(PARAM_RECREATE_VALUE_EXPRESSION_ON_BUILD_BEFORE_RESTORE);
        if (null == flag) {
            String setting = extContext.getInitParameter(PARAM_RECREATE_VALUE_EXPRESSION_ON_BUILD_BEFORE_RESTORE);
            Boolean bl = flag = setting == null || Boolean.parseBoolean(setting) ? Boolean.TRUE : Boolean.FALSE;
            if (flag.booleanValue() && !"true".equals(extContext.getInitParameter("facelets.BUILD_BEFORE_RESTORE")) && !"true".equals(appMap.get("facelets.BUILD_BEFORE_RESTORE"))) {
                flag = Boolean.FALSE;
                log.warning("facelets.RECREATE_VALUE_EXPRESSION_ON_BUILD_BEFORE_RESTORE is set to 'true' but facelets.BUILD_BEFORE_RESTORE is set to 'false' or unset. To use facelets.RECREATE_VALUE_EXPRESSION_ON_BUILD_BEFORE_RESTORE you must also set facelets.BUILD_BEFORE_RESTORE to 'true'!");
            }
            appMap.put(PARAM_RECREATE_VALUE_EXPRESSION_ON_BUILD_BEFORE_RESTORE, flag);
        }
        return flag;
    }

    protected final String getFacetName(FaceletContext ctx, UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    protected UIComponent createComponent(FaceletContext ctx) {
        UIComponent c = null;
        FacesContext faces = ctx.getFacesContext();
        Application app = faces.getApplication();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, Object.class);
            if (FacesAPI.getVersion() >= 12) {
                c = app.createComponent(ve, faces, this.componentType);
                if (c != null) {
                    if (FacesAPI.getComponentVersion(c) >= 12) {
                        c.setValueExpression("binding", ve);
                    } else {
                        LegacyValueBinding vb = new LegacyValueBinding(ve);
                        c.setValueBinding("binding", vb);
                    }
                }
            } else {
                LegacyValueBinding vb = new LegacyValueBinding(ve);
                c = app.createComponent(vb, faces, this.componentType);
                if (c != null) {
                    c.setValueBinding("binding", vb);
                }
            }
        } else {
            c = app.createComponent(this.componentType);
        }
        return c;
    }

    protected String getId(FaceletContext ctx) {
        if (this.id != null) {
            return this.id.getValue(ctx);
        }
        return ctx.generateUniqueId(this.tagId);
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.ignore("binding").ignore("id");
        m.addRule(ComponentRule.Instance);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.Instance);
            }
        }
        return m;
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }

    protected void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        this.nextHandler.apply(ctx, c);
    }
}

