/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class BeanPropertyTagRule
extends MetaRule {
    public static final BeanPropertyTagRule Instance = new BeanPropertyTagRule();

    BeanPropertyTagRule() {
    }

    @Override
    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method m = meta.getWriteMethod(name);
        if (m != null) {
            if (attribute.isLiteral()) {
                return new LiteralPropertyMetadata(m, attribute);
            }
            return new DynamicPropertyMetadata(m, attribute);
        }
        return null;
    }

    static final class LiteralPropertyMetadata
    extends Metadata {
        private final Method method;
        private final TagAttribute attribute;
        private Object[] value;

        public LiteralPropertyMetadata(Method method, TagAttribute attribute) {
            this.method = method;
            this.attribute = attribute;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            if (this.value == null) {
                String str = this.attribute.getValue();
                this.value = new Object[]{ctx.getExpressionFactory().coerceToType((Object)str, this.method.getParameterTypes()[0])};
            }
            try {
                this.method.invoke(instance, this.value);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.attribute, (Throwable)e);
            }
        }
    }

    static final class DynamicPropertyMetadata
    extends Metadata {
        private final Method method;
        private final TagAttribute attribute;
        private final Class type;

        public DynamicPropertyMetadata(Method method, TagAttribute attribute) {
            this.method = method;
            this.type = method.getParameterTypes()[0];
            this.attribute = attribute;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            try {
                this.method.invoke(instance, this.attribute.getObject(ctx, this.type));
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.attribute, (Throwable)e);
            }
        }
    }
}

