/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.services;

import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.dao.ITransazioneService;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.DriverTracciamento;
import org.openspcoop2.pdd.logger.TracciamentoOpenSPCoopAppenderDB;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.as4.services.BaseConnettoreUtils;
import org.openspcoop2.protocol.as4.services.DomibusRicevuta;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.threads.RunnableLogger;
import org.slf4j.Logger;

public class RicezioneNotificheConnettoreUtils
extends BaseConnettoreUtils {
    private AS4Properties properties;
    private DAOFactory daoFactory;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni;

    public RicezioneNotificheConnettoreUtils(RunnableLogger log, AS4Properties properties) throws Exception {
        super(log);
        this.properties = properties;
        this.daoFactory = DAOFactory.getInstance((Logger)log.getLog());
        DAOFactoryProperties daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)log.getLog());
        this.daoFactoryServiceManagerPropertiesTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
        boolean debug = true;
        this.daoFactoryServiceManagerPropertiesTransazioni.setShowSql(debug);
        this.daoFactoryServiceManagerPropertiesTransazioni.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
    }

    public void updateTraccia(TextMessage textMsg) throws Exception {
        String idNotifica = this.getPropertyJms((Message)textMsg, "MESSAGE_ID", true);
        String messageStatus = this.getPropertyJms((Message)textMsg, "NOTIFICATION_TYPE", true);
        String datasource = this.properties.getAckTraceDatasource();
        Properties datasourceJndiContext = this.properties.getAckTraceDatasource_jndiContext();
        String tipoDatabase = this.properties.getAckTraceTipoDatabase();
        if (tipoDatabase == null) {
            tipoDatabase = OpenSPCoop2Properties.getInstance().getDatabaseType();
        }
        GestoreJNDI gestoreJNDI = new GestoreJNDI(datasourceJndiContext);
        DataSource ds = (DataSource)gestoreJNDI.lookup(datasource);
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            DomibusRicevuta ricevuta;
            connection = ds.getConnection();
            ISQLQueryObject sqlQueryObjectCore = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectCore.addFromTable("tracce");
            sqlQueryObjectCore.addFromTable("tracce_ext_protocol_info");
            sqlQueryObjectCore.addSelectField("idtraccia");
            sqlQueryObjectCore.addWhereCondition("tracce.id=tracce_ext_protocol_info.idtraccia");
            sqlQueryObjectCore.addWhereCondition("tracce.pdd_ruolo=?");
            sqlQueryObjectCore.addWhereCondition("tracce_ext_protocol_info.name=?");
            sqlQueryObjectCore.addWhereCondition("tracce_ext_protocol_info.value=?");
            sqlQueryObjectCore.setANDLogicOperator(true);
            String query = sqlQueryObjectCore.createSQLQuery();
            pstmt = connection.prepareStatement(query);
            int index = 1;
            pstmt.setString(index++, TipoPdD.DELEGATA.getTipo());
            pstmt.setString(index++, "ebmsUserMessageId");
            pstmt.setString(index++, idNotifica);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getLong("idtraccia"));
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
            if (ids.size() <= 0) {
                this.log.error("Traccia con propriet\u00e0 'as4' con nome [ebmsUserMessageId] e valore[" + idNotifica + "] non trovata");
                return;
            }
            for (int i = 0; i < ids.size(); ++i) {
                Long id = (Long)ids.get(i);
                sqlQueryObjectCore = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                sqlQueryObjectCore.addUpdateTable("tracce_ext_protocol_info");
                sqlQueryObjectCore.addUpdateField("value", "?");
                sqlQueryObjectCore.addWhereCondition("idtraccia=?");
                sqlQueryObjectCore.addWhereCondition("name=?");
                sqlQueryObjectCore.setANDLogicOperator(true);
                String update = sqlQueryObjectCore.createSQLUpdate();
                pstmt = connection.prepareStatement(update);
                pstmt.setString(1, messageStatus);
                pstmt.setLong(2, id);
                pstmt.setString(3, "ebmsUserMessageSendStatus");
                int n = pstmt.executeUpdate();
                if (n <= 0) {
                    this.log.error("Traccia con propriet\u00e0 'as4' con nome [ebmsUserMessageSendStatus] e idtraccia[" + id + "] non trovata");
                } else {
                    this.log.debug("Traccia con propriet\u00e0 'as4' con nome [ebmsUserMessageSendStatus] e idtraccia[" + id + "] aggiornata allo stato [" + messageStatus + "]");
                }
                pstmt.close();
                pstmt = null;
            }
            if (ids.size() > 0 && (ricevuta = this.readRicevuta(idNotifica, messageStatus)) != null) {
                DriverTracciamento driverTracciamento = new DriverTracciamento(connection, tipoDatabase, this.log.getLog());
                for (int i = 0; i < ids.size(); ++i) {
                    Long id = (Long)ids.get(i);
                    sqlQueryObjectCore = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                    sqlQueryObjectCore.addFromTable("tracce");
                    sqlQueryObjectCore.addSelectField("id_transazione");
                    sqlQueryObjectCore.addWhereCondition("id=?");
                    sqlQueryObjectCore.setANDLogicOperator(true);
                    query = sqlQueryObjectCore.createSQLQuery();
                    pstmt = connection.prepareStatement(query);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    String idTransazione = null;
                    if (rs.next()) {
                        idTransazione = rs.getString("id_transazione");
                    } else {
                        this.log.error("Traccia con id[" + id + "] non trovata ? (Id recuperato grazie alla notifica '" + idNotifica + "')");
                    }
                    rs.close();
                    pstmt.close();
                    rs = null;
                    pstmt = null;
                    if (idTransazione == null) {
                        this.log.error("Traccia con id[" + id + "] senza id di transazione ? (Id recuperato grazie alla notifica '" + idNotifica + "')");
                        continue;
                    }
                    Traccia traccia = driverTracciamento.getTraccia(idTransazione, RuoloMessaggio.RICHIESTA);
                    TracciamentoOpenSPCoopAppenderDB appender = new TracciamentoOpenSPCoopAppenderDB();
                    OpenspcoopAppender appenderProperties = new OpenspcoopAppender();
                    Property propertyDatasource = new Property();
                    propertyDatasource.setNome("datasource");
                    propertyDatasource.setValore(datasource);
                    appenderProperties.addProperty(propertyDatasource);
                    Property propertyTipoDatabase = new Property();
                    propertyTipoDatabase.setNome("tipoDatabase");
                    propertyTipoDatabase.setValore(tipoDatabase);
                    appenderProperties.addProperty(propertyTipoDatabase);
                    Property propertyUsePdDConnnection = new Property();
                    propertyUsePdDConnnection.setNome("usePdDConnection");
                    propertyUsePdDConnnection.setValore("true");
                    appenderProperties.addProperty(propertyUsePdDConnnection);
                    appender.initializeAppender(appenderProperties);
                    Busta bustaRicevuta = traccia.getBusta().invertiBusta(traccia.getBusta().getTipoOraRegistrazione(), traccia.getBusta().getTipoOraRegistrazioneValue());
                    bustaRicevuta.setID(ricevuta.id);
                    bustaRicevuta.setRiferimentoMessaggio(traccia.getBusta().getID());
                    bustaRicevuta.setTipoServizio(traccia.getBusta().getTipoServizio());
                    bustaRicevuta.setServizio(traccia.getBusta().getServizio());
                    bustaRicevuta.setVersioneServizio(traccia.getBusta().getVersioneServizio());
                    bustaRicevuta.setAzione(traccia.getBusta().getAzione());
                    Riscontro r = new Riscontro();
                    r.setTipoOraRegistrazione(traccia.getBusta().getTipoOraRegistrazione());
                    r.setOraRegistrazione((Date)ricevuta.date);
                    r.setRicevuta(ricevuta.xml);
                    r.setID(traccia.getBusta().getID());
                    bustaRicevuta.addRiscontro(r);
                    Traccia tracciaRisposta = new Traccia();
                    tracciaRisposta.setBusta(bustaRicevuta);
                    tracciaRisposta.setEsitoElaborazioneMessaggioTracciato(EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioRicevuto());
                    tracciaRisposta.setCorrelazioneApplicativa(traccia.getCorrelazioneApplicativa());
                    tracciaRisposta.setCorrelazioneApplicativaRisposta(traccia.getCorrelazioneApplicativaRisposta());
                    tracciaRisposta.setGdo(DateManager.getDate());
                    tracciaRisposta.setIdSoggetto(traccia.getIdSoggetto());
                    tracciaRisposta.setIdTransazione(traccia.getIdTransazione());
                    tracciaRisposta.setLocation("XmlReceiptByDomibus");
                    tracciaRisposta.setProtocollo(traccia.getProtocollo());
                    tracciaRisposta.setTipoMessaggio(RuoloMessaggio.RISPOSTA);
                    tracciaRisposta.setTipoPdD(traccia.getTipoPdD());
                    appender.log(connection, tracciaRisposta);
                    this.log.info("Creata traccia con riscontro con id '" + bustaRicevuta.getID() + "' come risposta alla traccia con id long '" + id + "' e id '" + traccia.getBusta().getID() + "'");
                    JDBCServiceManager jdbcServiceManager = (JDBCServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), connection, true, this.daoFactoryServiceManagerPropertiesTransazioni, this.log.getLog());
                    ITransazioneService transazioneService = jdbcServiceManager.getTransazioneService();
                    UpdateField updateField = new UpdateField(Transazione.model().ID_MESSAGGIO_RISPOSTA, (Object)bustaRicevuta.getID());
                    transazioneService.updateFields((Object)idTransazione, new UpdateField[]{updateField});
                    this.log.info("Aggiornata transazione con id '" + idTransazione + "' per indicare l'id di risposta '" + bustaRicevuta.getID() + "' come risposta alla traccia con id long '" + id + "' e id '" + traccia.getBusta().getID() + "'");
                }
            }
        }
        catch (Throwable t) {
            this.log.error(t.getMessage(), t);
            throw new Exception(t);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DomibusRicevuta readRicevuta(String idNotifica, String messageStatus) throws Exception {
        boolean sendSuccess = "MESSAGE_SEND_SUCCESS".equalsIgnoreCase(messageStatus);
        String prefixError = "Ricevuta con id di notifica '" + idNotifica + "' (messageStatus: " + messageStatus + ") non trovata.";
        String datasource = this.properties.getAckDomibusDatasource();
        Properties datasourceJndiContext = this.properties.getAckDomibusDatasource_jndiContext();
        String tipoDatabase = this.properties.getAckDomibusTipoDatabase();
        if (tipoDatabase == null) {
            tipoDatabase = OpenSPCoop2Properties.getInstance().getDatabaseType();
        }
        GestoreJNDI gestoreJNDI = new GestoreJNDI(datasourceJndiContext);
        DataSource ds = (DataSource)gestoreJNDI.lookup(datasource);
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            connection = ds.getConnection();
            ISQLQueryObject sqlQueryObjectCore = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectCore.addFromTable("TB_MESSAGE_INFO");
            sqlQueryObjectCore.addSelectField("ID_PK");
            sqlQueryObjectCore.addSelectField("MESSAGE_ID");
            sqlQueryObjectCore.addSelectField("TIME_STAMP");
            sqlQueryObjectCore.addWhereCondition("REF_TO_MESSAGE_ID=?");
            sqlQueryObjectCore.setANDLogicOperator(true);
            String query = sqlQueryObjectCore.createSQLQuery();
            pstmt = connection.prepareStatement(query);
            pstmt.setString(1, idNotifica);
            rs = pstmt.executeQuery();
            long idPK = -1L;
            String idMessage = null;
            Timestamp gdoMessage = null;
            if (rs.next()) {
                idPK = rs.getLong("ID_PK");
                idMessage = rs.getString("MESSAGE_ID");
                gdoMessage = rs.getTimestamp("TIME_STAMP");
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
            if (idPK <= 0L) {
                String msg = prefixError + " Query utilizzata: " + query;
                if (sendSuccess) {
                    this.log.error(msg);
                } else {
                    this.log.debug(msg);
                }
                DomibusRicevuta domibusRicevuta = null;
                return domibusRicevuta;
            }
            sqlQueryObjectCore = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectCore.addFromTable("TB_SIGNAL_MESSAGE");
            sqlQueryObjectCore.addSelectField("receipt_ID_PK");
            sqlQueryObjectCore.addWhereCondition("messageInfo_ID_PK=?");
            sqlQueryObjectCore.setANDLogicOperator(true);
            query = sqlQueryObjectCore.createSQLQuery();
            pstmt = connection.prepareStatement(query);
            pstmt.setLong(1, idPK);
            rs = pstmt.executeQuery();
            long idRicevuta = -1L;
            if (rs.next()) {
                idRicevuta = rs.getLong("receipt_ID_PK");
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
            if (idRicevuta <= 0L) {
                String msg = prefixError + " Query utilizzata (messageInfo_ID_PK=" + idPK + "): " + query;
                if (sendSuccess) {
                    this.log.error(msg);
                } else {
                    this.log.debug(msg);
                }
                DomibusRicevuta domibusRicevuta = null;
                return domibusRicevuta;
            }
            sqlQueryObjectCore = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectCore.addFromTable("TB_RECEIPT_DATA");
            sqlQueryObjectCore.addSelectField("RAW_XML");
            sqlQueryObjectCore.addWhereCondition("RECEIPT_ID=?");
            sqlQueryObjectCore.setANDLogicOperator(true);
            query = sqlQueryObjectCore.createSQLQuery();
            pstmt = connection.prepareStatement(query);
            pstmt.setLong(1, idRicevuta);
            rs = pstmt.executeQuery();
            String xml = null;
            if (rs.next()) {
                xml = rs.getString("RAW_XML");
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
            if (xml == null || "".equals(xml)) {
                String msg = prefixError + " Query utilizzata (RECEIPT_ID=" + idRicevuta + "): " + query;
                if (sendSuccess) {
                    this.log.error(msg);
                } else {
                    this.log.debug(msg);
                }
                DomibusRicevuta domibusRicevuta = null;
                return domibusRicevuta;
            }
            DomibusRicevuta ricevuta = new DomibusRicevuta();
            ricevuta.xml = xml;
            ricevuta.id = idMessage;
            ricevuta.date = gdoMessage;
            this.log.debug("Recuperata ricevuta con id '" + ricevuta.id + "' (data:" + String.valueOf(ricevuta.date) + "): " + ricevuta.xml);
            DomibusRicevuta domibusRicevuta = ricevuta;
            return domibusRicevuta;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

