/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.as4.pmode.beans.API;
import org.openspcoop2.protocol.as4.pmode.beans.APS;
import org.openspcoop2.protocol.as4.pmode.beans.Azione;
import org.openspcoop2.protocol.as4.pmode.beans.Index;

public class Soggetto {
    private org.openspcoop2.core.registry.Soggetto base;
    private String ebmsUserMessagePartyId;
    private String ebmsUserMessagePartyIdTypeName;
    private String ebmsUserMessagePartyIdTypeValue;
    private String ebmsUserMessagePartyEndpoint;
    private String ebmsUserMessagePartyCN;
    private List<APS> aps;

    public Soggetto(org.openspcoop2.core.registry.Soggetto base, Map<IDAccordo, API> accordi, Index index) throws Exception {
        this.base = base;
        for (ProtocolProperty prop : this.base.getProtocolPropertyList()) {
            if (prop.getName().equals("ebmsUserMessagePartyIdTypeName")) {
                this.ebmsUserMessagePartyIdTypeName = prop.getValue();
                continue;
            }
            if (prop.getName().equals("ebmsUserMessagePartyIdTypeValue")) {
                this.ebmsUserMessagePartyIdTypeValue = prop.getValue();
                continue;
            }
            if (prop.getName().equals("ebmsUserMessagePartyId")) {
                this.ebmsUserMessagePartyId = prop.getValue();
                continue;
            }
            if (prop.getName().equals("ebmsUserMessagePartyEndpoint")) {
                this.ebmsUserMessagePartyEndpoint = prop.getValue();
                continue;
            }
            if (!prop.getName().equals("ebmsUserMessagePartyCommonName")) continue;
            this.ebmsUserMessagePartyCN = prop.getValue();
        }
        if (this.ebmsUserMessagePartyIdTypeName == null) {
            throw this.getException("nessuna property ebmsUserMessagePartyIdTypeName trovata", base);
        }
        if (this.ebmsUserMessagePartyIdTypeValue == null) {
            throw this.getException("nessuna property ebmsUserMessagePartyIdTypeValue trovata", base);
        }
        if (this.ebmsUserMessagePartyId == null) {
            throw this.getException("nessuna property ebmsUserMessagePartyId trovata", base);
        }
        if (this.ebmsUserMessagePartyEndpoint == null) {
            throw this.getException("nessuna property ebmsUserMessagePartyEndpoint trovata", base);
        }
        if (this.ebmsUserMessagePartyCN == null) {
            throw this.getException("nessuna property ebmsUserMessagePartyCommonName trovata", base);
        }
        this.aps = new ArrayList<APS>();
        for (AccordoServizioParteSpecifica aps : base.getAccordoServizioParteSpecificaList()) {
            IDAccordo apcKey = IDAccordoFactory.getInstance().getIDAccordoFromUri(aps.getAccordoServizioParteComune());
            if (accordi.containsKey(apcKey)) {
                API api = accordi.get(apcKey);
                this.aps.add(new APS(aps, api, index, "Process_" + index.getNextProcessId()));
                continue;
            }
            throw new Exception("APC[" + String.valueOf(apcKey) + "] erogato dal soggetto [" + base.getTipo() + "/" + base.getNome() + "] non trovato");
        }
    }

    private Exception getException(String msg, org.openspcoop2.core.registry.Soggetto soggetto) {
        return new Exception(msg + " per il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome());
    }

    public org.openspcoop2.core.registry.Soggetto getBase() {
        return this.base;
    }

    public void setBase(org.openspcoop2.core.registry.Soggetto base) {
        this.base = base;
    }

    public String getEbmsUserMessagePartyIdTypeName() {
        return this.ebmsUserMessagePartyIdTypeName;
    }

    public void setEbmsUserMessagePartyIdTypeName(String ebmsUserMessagePartyIdTypeName) {
        this.ebmsUserMessagePartyIdTypeName = ebmsUserMessagePartyIdTypeName;
    }

    public String getEbmsUserMessagePartyIdTypeValue() {
        return this.ebmsUserMessagePartyIdTypeValue;
    }

    public void setEbmsUserMessagePartyIdTypeValue(String ebmsUserMessagePartyIdTypeValue) {
        this.ebmsUserMessagePartyIdTypeValue = ebmsUserMessagePartyIdTypeValue;
    }

    public String getEbmsUserMessagePartyId() {
        return this.ebmsUserMessagePartyId;
    }

    public void setEbmsUserMessagePartyId(String ebmsUserMessagePartyId) {
        this.ebmsUserMessagePartyId = ebmsUserMessagePartyId;
    }

    public String getEbmsUserMessagePartyCN() {
        return this.ebmsUserMessagePartyCN;
    }

    public void setEbmsUserMessagePartyCN(String ebmsUserMessagePartyCN) {
        this.ebmsUserMessagePartyCN = ebmsUserMessagePartyCN;
    }

    public String getEbmsUserMessagePartyEndpoint() {
        return this.ebmsUserMessagePartyEndpoint;
    }

    public void setEbmsUserMessagePartyEndpoint(String ebmsUserMessagePartyEndpoint) {
        this.ebmsUserMessagePartyEndpoint = ebmsUserMessagePartyEndpoint;
    }

    public int sizeAzioni() {
        int numAzioni = 0;
        for (APS aps : this.aps) {
            numAzioni += aps.getAzioni().size();
        }
        return numAzioni;
    }

    public List<APS> getAps() {
        return this.aps;
    }

    public List<APS> getAps(String nomeSoggettoOperativo) {
        return this.getAps(nomeSoggettoOperativo, false);
    }

    public List<APS> getAps(String nomeSoggettoOperativo, boolean splitByBinding) {
        ArrayList<APS> listFiltrato = new ArrayList<APS>();
        for (APS apsCheck : this.aps) {
            if (apsCheck.getBase().getTipoSoggettoErogatore().equals(this.base.getTipo()) && apsCheck.getBase().getNomeSoggettoErogatore().equals(this.base.getNome()) && nomeSoggettoOperativo.equals(this.ebmsUserMessagePartyCN)) {
                listFiltrato.add(apsCheck);
                continue;
            }
            if (!apsCheck.getCnFruitori().contains(nomeSoggettoOperativo)) continue;
            listFiltrato.add(apsCheck);
        }
        if (splitByBinding) {
            ArrayList<APS> listFiltrato_byBinding = new ArrayList<APS>();
            for (APS apsCheck : listFiltrato) {
                HashMap<String, APS> mapByBinding = new HashMap<String, APS>();
                for (String key : apsCheck.getAzioni().keySet()) {
                    Azione azione = apsCheck.getAzioni().get(key);
                    String binding = azione.getEbmsUserMessageCollaborationInfoActionBinding();
                    APS aps = null;
                    if (mapByBinding.containsKey(binding)) {
                        aps = (APS)mapByBinding.remove(binding);
                    } else {
                        aps = apsCheck.newInstance();
                        aps.setId(aps.getId() + "_" + binding);
                        aps.setEbmsBinding(binding);
                        aps.getAzioni().clear();
                    }
                    aps.getAzioni().put(key, azione);
                    mapByBinding.put(binding, aps);
                }
                listFiltrato_byBinding.addAll(mapByBinding.values());
            }
            return listFiltrato_byBinding;
        }
        return listFiltrato;
    }

    public void setAps(List<APS> aps) {
        this.aps = aps;
    }
}

