/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode.beans;

import java.io.File;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;

public class APC {
    private AccordoServizioParteComune base;
    private byte[] ebmsServicePayloadProfile;
    private byte[] ebmsServiceProperties;
    private String ebmsUserMessageCollaborationInfoServiceName;
    private String ebmsUserMessageCollaborationInfoServiceType;
    private String id;

    public APC(Logger log, AccordoServizioParteComune base, int index) throws Exception {
        this.base = base;
        this.id = "Servizio_" + index;
        for (ProtocolProperty prop : base.getProtocolPropertyList()) {
            File fCheck;
            if (prop.getName().equals("ebmsServicePayloadProfile")) {
                if (prop.getByteFile() != null) {
                    this.ebmsServicePayloadProfile = prop.getByteFile();
                    continue;
                }
                fCheck = new File(prop.getFile());
                if (!fCheck.exists()) {
                    fCheck = new File(AS4Properties.getInstance().getPModeTranslatorPayloadProfilesFolder(), prop.getFile());
                }
                this.ebmsServicePayloadProfile = FileSystemUtilities.readBytesFromFile((File)fCheck);
                continue;
            }
            if (prop.getName().equals("ebmsServiceProperties")) {
                if (prop.getByteFile() != null) {
                    this.ebmsServiceProperties = prop.getByteFile();
                    continue;
                }
                fCheck = new File(prop.getFile());
                if (!fCheck.exists()) {
                    fCheck = new File(AS4Properties.getInstance().getPModeTranslatorPropertiesFolder(), prop.getFile());
                }
                this.ebmsServiceProperties = FileSystemUtilities.readBytesFromFile((File)fCheck);
                continue;
            }
            if (prop.getName().equals("ebmsUserMessageCollaborationInfoServiceType")) {
                this.ebmsUserMessageCollaborationInfoServiceType = prop.getValue();
                continue;
            }
            if (!prop.getName().equals("ebmsUserMessageCollaborationInfoService")) continue;
            this.ebmsUserMessageCollaborationInfoServiceName = prop.getValue();
        }
        if (this.ebmsUserMessageCollaborationInfoServiceName == null) {
            throw new Exception("Property [ebmsUserMessageCollaborationInfoService] non definita per l'apc [" + String.valueOf(base) + "]");
        }
    }

    public AccordoServizioParteComune getBase() {
        return this.base;
    }

    public void setBase(AccordoServizioParteComune base) {
        this.base = base;
    }

    public String getEbmsUserMessageCollaborationInfoServiceName() {
        return this.ebmsUserMessageCollaborationInfoServiceName;
    }

    public void setEbmsUserMessageCollaborationInfoServiceName(String ebmsUserMessageCollaborationInfoServiceName) {
        this.ebmsUserMessageCollaborationInfoServiceName = ebmsUserMessageCollaborationInfoServiceName;
    }

    public String getEbmsUserMessageCollaborationInfoServiceType() {
        return this.ebmsUserMessageCollaborationInfoServiceType;
    }

    public void setEbmsUserMessageCollaborationInfoServiceType(String ebmsUserMessageCollaborationInfoServiceType) {
        this.ebmsUserMessageCollaborationInfoServiceType = ebmsUserMessageCollaborationInfoServiceType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public byte[] getEbmsServicePayloadProfile() {
        return this.ebmsServicePayloadProfile;
    }

    public void setEbmsServicePayloadProfile(byte[] ebmsServicePayloadProfile) {
        this.ebmsServicePayloadProfile = ebmsServicePayloadProfile;
    }

    public byte[] getEbmsServiceProperties() {
        return this.ebmsServiceProperties;
    }

    public void setEbmsServiceProperties(byte[] ebmsServiceProperties) {
        this.ebmsServiceProperties = ebmsServiceProperties;
    }
}

