/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.archive;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.openspcoop2.protocol.as4.pmode.PModeRegistryReader;
import org.openspcoop2.protocol.as4.pmode.Translator;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.slf4j.Logger;

public class XMLWriteUtils {
    protected Logger log = null;
    protected IProtocolFactory<?> protocolFactory;
    protected IRegistryReader registryReader;
    protected IConfigIntegrationReader configIntegrationReader;
    protected Translator translator;

    public XMLWriteUtils(Logger log, IProtocolFactory<?> protocolFactory, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        this.log = log;
        this.protocolFactory = protocolFactory;
        this.registryReader = registryReader;
        this.configIntegrationReader = configIntegrationReader;
        PModeRegistryReader pModeRegistryReader = new PModeRegistryReader(registryReader, configIntegrationReader, protocolFactory);
        this.translator = new Translator(pModeRegistryReader);
    }

    public byte[] generate(String nomeSoggetto) throws ProtocolException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.generate(bout, nomeSoggetto);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public void generate(OutputStream out, String nomeSoggetto) throws ProtocolException {
        try {
            this.translator.translate(out, nomeSoggetto);
        }
        catch (Exception e) {
            throw new ProtocolException("Il soggetto '" + nomeSoggetto + "' non risulta configurato correttamente al fine di generazione una configurazione 'pmode' corrispondente: " + e.getMessage(), (Throwable)e);
        }
    }
}

