/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing.plaf;

import java.lang.reflect.Method;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.OutputField;

public class LookAndFeelFactory {
    public static final String DEFAULT_LAF = "org.tp23.jgoodies.plaf.plastic.PlasticXPLookAndFeel";
    public static final String GREYMETAL_LAF = "greymetal";
    public static final String NATIVE_LAF = "native";
    public static final String JGOODIES_LAF = "jgoodies";
    public static final String NULL_LAF = "null";
    private final String specifiedLAF;
    private final InstallerContext ctx;

    public LookAndFeelFactory(InstallerContext ctx) {
        this.ctx = ctx;
        this.specifiedLAF = ctx.getInstaller().getLookAndFeel();
    }

    public void setLAF() {
        String lafClassName = null;
        try {
            Method setAntialiased;
            lafClassName = LookAndFeelFactory.getLafFromToken(this.specifiedLAF);
            if (lafClassName == null) {
                return;
            }
            LookAndFeel look = (LookAndFeel)Class.forName(lafClassName).newInstance();
            this.ctx.log("Setting look and feel:" + lafClassName);
            UIManager.setLookAndFeel(look);
            boolean antialias = OutputField.isTrue(this.ctx.getInstaller().getAntialiased());
            if (antialias && (setAntialiased = look.getClass().getMethod("setAntiAliased", Boolean.TYPE)) != null) {
                this.ctx.log("Setting antialiasing:" + antialias);
                Object[] args = new Boolean[]{new Boolean(antialias)};
                setAntialiased.invoke(null, args);
            }
        }
        catch (Exception ex) {
            this.ctx.getLogger().log("Can not correctly set Look And Feel:" + ex.getMessage());
            this.ctx.getLogger().log(this.ctx.getInstaller(), ex);
        }
    }

    public static boolean isDefault(String laf) {
        return laf == null || laf.equals(JGOODIES_LAF) || laf.equals(DEFAULT_LAF);
    }

    public static String getLafFromToken(String token) {
        Object laf = null;
        laf = token == null || token.equals(JGOODIES_LAF) ? DEFAULT_LAF : (token.equals(NULL_LAF) ? null : (token.equals(NATIVE_LAF) ? UIManager.getSystemLookAndFeelClassName() : (token.equals(GREYMETAL_LAF) ? "org.tp23.antinstaller.renderer.swing.plaf.ModMetalLookAndFeel" : token)));
        return laf;
    }
}

