/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.XMLRootElement;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.core.UtilityTransazioni;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.servlet.DiagnosticiExporter;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class TracceExporter
extends HttpServlet {
    private static final long serialVersionUID = 1272767433184676700L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static ITracciaDriver tracciamentoService = null;
    private static Boolean enableHeaderInfo = false;

    public static void setTracciamentoService(ITracciaDriver tracciamentoService) {
        TracceExporter.tracciamentoService = tracciamentoService;
    }

    public static void setEnableHeaderInfo(Boolean enableHeaderInfo) {
        TracceExporter.enableHeaderInfo = enableHeaderInfo;
    }

    public void init() throws ServletException {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            TracceExporter.setEnableHeaderInfo(govwayMonitorProperties.isAttivoTransazioniExportHeader());
            TracceExporter.setTracciamentoService(govwayMonitorProperties.getDriverTracciamento());
        }
        catch (Exception e) {
            log.error("Inizializzazione servlet fallita, setto enableHeaderInfo=false", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            if (context == null) {
                throw new CoreException("Context is null");
            }
            ITransazioniService service = (ITransazioniService)context.getBean("transazioniService");
            HttpServletResponse response = resp;
            String isAllString = req.getParameter("isAll");
            Boolean isAll = Boolean.parseBoolean(isAllString);
            String idtransazioni = req.getParameter("ids");
            String[] ids = StringUtils.split((String)idtransazioni, (String)",");
            HttpSession sessione = req.getSession();
            Boolean isAllFromSession = (Boolean)sessione.getAttribute("isAllOriginale");
            String idTransazioniFromSession = (String)sessione.getAttribute("idTransazioniOriginali");
            sessione.removeAttribute("isAllOriginale");
            sessione.removeAttribute("idTransazioniOriginali");
            String[] idsFromSession = StringUtils.split((String)idTransazioniFromSession, (String)",");
            boolean exportConsentito = DiagnosticiExporter.checkParametri(isAll, ids, isAllFromSession, idsFromSession);
            if (!exportConsentito) {
                String msgErrore = "L'utente non dispone dei permessi necessari per effettuare l'export delle tracce.";
                String redirectUrl = req.getContextPath() + "/public/error.jsf?msg_errore=" + msgErrore;
                response.sendRedirect(redirectUrl);
                return;
            }
            String fileName = "Tracce.zip";
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            response.setStatus(200);
            response.flushBuffer();
            int start = 0;
            int limit = 25;
            List transazioni = new ArrayList<TransazioneBean>();
            Utility.setLoginMBean((LoginBean)((LoginBean)context.getBean("loginBean")));
            if (isAll != null && isAll.booleanValue()) {
                transazioni = service.findAll(start, limit);
            } else {
                for (int j = 0; j < ids.length; ++j) {
                    transazioni.add(service.findByIdTransazione(ids[j]));
                }
            }
            if (!transazioni.isEmpty()) {
                byte[] buf = new byte[1024];
                ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
                InputStream in = null;
                while (!transazioni.isEmpty()) {
                    for (TransazioneBean t : transazioni) {
                        Traccia tracciaRichiesta = this.getTraccia(t.getIdTransazione(), RuoloMessaggio.RICHIESTA);
                        Traccia tracciaRisposta = this.getTraccia(t.getIdTransazione(), RuoloMessaggio.RISPOSTA);
                        ArrayList<Traccia> tracce = new ArrayList<Traccia>();
                        if (tracciaRichiesta != null) {
                            tracce.add(tracciaRichiesta);
                        }
                        if (tracciaRisposta != null) {
                            tracce.add(tracciaRisposta);
                        }
                        if (tracce.isEmpty()) continue;
                        zip.putNextEntry(new ZipEntry(t.getIdTransazione() + " (" + tracce.size() + " entries).xml"));
                        if (enableHeaderInfo != null && enableHeaderInfo.booleanValue()) {
                            zip.write(UtilityTransazioni.getHeaderTransazione(t).getBytes());
                        }
                        Object tail = null;
                        for (int j = 0; j < tracce.size(); ++j) {
                            int len;
                            Object head;
                            XMLRootElement xmlRootElement;
                            Traccia tr = (Traccia)tracce.get(j);
                            String newLine = j > 0 ? "\n\n" : "";
                            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tr.getProtocollo());
                            ITracciaSerializer tracciaBuilder = pf.createTracciaSerializer();
                            if (j == 0 && (xmlRootElement = tracciaBuilder.getXMLRootElement()) != null && (head = xmlRootElement.getAsStringStartTag()) != null && !"".equals(head)) {
                                head = (String)head + "\n\n";
                                zip.write(((String)head).getBytes(), 0, ((String)head).length());
                                tail = xmlRootElement.getAsStringEndTag();
                                if (tail != null && !"".equals(tail)) {
                                    tail = "\n\n" + (String)tail;
                                }
                            }
                            tracciaBuilder.setOmitXmlDeclaration(true);
                            String traccia = tracciaBuilder.toString(tr, TipoSerializzazione.DEFAULT);
                            in = new ByteArrayInputStream((newLine + traccia).getBytes());
                            while ((len = in.read(buf)) > 0) {
                                zip.write(buf, 0, len);
                            }
                        }
                        if (tail != null && !"".equals(tail)) {
                            zip.write(((String)tail).getBytes(), 0, ((String)tail).length());
                        }
                        zip.closeEntry();
                        zip.flush();
                        in.close();
                    }
                    start += limit;
                    response.flushBuffer();
                    if (isAll == null || !isAll.booleanValue()) break;
                    transazioni = service.findAll(start, limit);
                }
                zip.flush();
                zip.close();
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    private Traccia getTraccia(String idTransazione, RuoloMessaggio ruolo) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id_transazione", idTransazione);
        try {
            return tracciamentoService.getTraccia(ruolo, properties);
        }
        catch (DriverTracciamentoException | DriverTracciamentoNotFoundException throwable) {
            return null;
        }
    }
}

