/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneRisorsaContenuto;
import org.openspcoop2.monitor.engine.config.transazioni.ConfigurazioneTransazioneStato;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.web.lib.users.dao.Stato;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.bean.SelectItem;
import org.openspcoop2.web.monitor.core.constants.ModalitaRicercaTransazioni;
import org.openspcoop2.web.monitor.core.constants.NomiTabelle;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.ISearchFormService;
import org.openspcoop2.web.monitor.core.dao.IUserService;
import org.openspcoop2.web.monitor.core.dao.UserService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.DynamicPdDBean;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.transazioni.bean.GruppoStorico;
import org.openspcoop2.web.monitor.transazioni.bean.Storico;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.exporter.ColonnaExportManager;
import org.slf4j.Logger;

public class TransazioniBean
extends DynamicPdDBean<TransazioneBean, String, ISearchFormService<TransazioneBean, String, TransazioniSearchForm>> {
    public static final String COLUMNS_VISIBILITY_STATO_TABELLE_KEY = "columnsVisibility";
    public static final String COLUMNS_ORDER_STATO_TABELLE_KEY = "columnsOrder";
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private List<javax.faces.model.SelectItem> stati = new ArrayList<javax.faces.model.SelectItem>();
    private List<javax.faces.model.SelectItem> risorse = new ArrayList<javax.faces.model.SelectItem>();
    private List<String> esportazioniSelezionate = new ArrayList<String>();
    private String tableState = "";
    private transient IUserService userService = null;
    private boolean visualizzaIdCluster = false;
    private boolean exportCsvCompletato = false;
    private boolean visualizzaDataAccettazione = false;
    private boolean updateTipoStorico = false;
    private ApplicationBean applicationBean = null;
    private List<GruppoStorico> tipiStorico;
    private String tipoStorico;
    private List<GruppoStorico> tipiStoricoLivello2;
    private boolean visualizzazioneStoricoTabellare = false;
    private boolean exportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti = false;
    private boolean transazioniLatenzaPortaEnabled = false;
    private List<javax.faces.model.SelectItem> esportazioniSelezionateDisponibili = null;
    private Boolean showSelezioneContenuti = false;
    private String exportCsvErrorMessage = null;
    private List<javax.faces.model.SelectItem> exportDisponibili = null;
    private String tipoExport = "CSV";
    private List<javax.faces.model.SelectItem> tipiColonneEsportate = null;
    private String colonneEsportate = null;
    private List<SelectItem> elencoColonneDisponibili = null;
    private List<javax.faces.model.SelectItem> elencoImmagineColonne = null;
    private List<SelectItem> elencoColonneSelezionate = null;
    private Boolean showSelezioneColonne = false;
    private Boolean showSelezioneTipoColonne = false;

    public TransazioniBean() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            List govwayMonitorare = govwayMonitorProperties.getListaPdDMonitorate_StatusPdD();
            this.setVisualizzaIdCluster(govwayMonitorare != null && govwayMonitorare.size() > 1);
            this.visualizzaDataAccettazione = govwayMonitorProperties.isAttivoTransazioniDataAccettazione();
            this.applicationBean = ApplicationBean.getInstance();
            this.applicationBean.setLoginBean(Utility.getLoginBean());
            this.visualizzazioneStoricoTabellare = !govwayMonitorProperties.isAttivoUtilizzaVisualizzazioneCustomTransazioni();
            this.exportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti = govwayMonitorProperties.isExportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti();
            this.transazioniLatenzaPortaEnabled = govwayMonitorProperties.isTransazioniLatenzaPortaEnabled();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.userService = new UserService();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setSearch(BaseSearchForm searc) {
        this.search = searc;
        if (this.search instanceof TransazioniSearchForm) {
            ((TransazioniSearchForm)this.search).setTransazioniService((ITransazioniService)this.service);
        }
    }

    public List<javax.faces.model.SelectItem> getStati() {
        try {
            String nomeServizioKey;
            this.stati = new ArrayList<javax.faces.model.SelectItem>();
            if (this.search == null || this.search.getNomeServizio() == null) {
                return this.stati;
            }
            IDServizio idServizio = Utility.parseServizioSoggetto((String)this.search.getNomeServizio());
            String nomeServizio = idServizio.getNome();
            String tipoServizio = idServizio.getTipo();
            String nomeErogatore = idServizio.getSoggettoErogatore().getNome();
            String tipoErogatore = idServizio.getSoggettoErogatore().getTipo();
            Integer versioneServizio = idServizio.getVersione();
            AccordoServizioParteSpecifica aspsFromValues = this.dynamicUtils.getAspsFromValues(tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio);
            IdAccordoServizioParteComune idAccordoServizioParteComune = aspsFromValues.getIdAccordoServizioParteComune();
            Integer ver = idAccordoServizioParteComune.getVersione();
            String nomeSoggettoReferente = null;
            String tipoSoggettoReferente = null;
            if (idAccordoServizioParteComune.getIdSoggetto() != null) {
                nomeSoggettoReferente = idAccordoServizioParteComune.getIdSoggetto().getNome();
                tipoSoggettoReferente = idAccordoServizioParteComune.getIdSoggetto().getTipo();
            }
            String nomeAS = idAccordoServizioParteComune.getNome();
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAS, tipoSoggettoReferente, nomeSoggettoReferente, ver);
            List<ConfigurazioneTransazioneStato> l = ((ITransazioniService)this.service).getStatiByValues(idAccordo, nomeServizioKey = aspsFromValues.getPortType() != null ? aspsFromValues.getPortType() : nomeServizio, this.search.getNomeAzione());
            if (l != null) {
                for (ConfigurazioneTransazioneStato s : l) {
                    this.stati.add(new javax.faces.model.SelectItem((Object)s.getNome()));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.stati;
    }

    public List<javax.faces.model.SelectItem> getRisorse() {
        try {
            String nomeServizioKey;
            this.risorse = new ArrayList<javax.faces.model.SelectItem>();
            if (this.search == null || this.search.getNomeServizio() == null) {
                return this.risorse;
            }
            IDServizio idServizio = Utility.parseServizioSoggetto((String)this.search.getNomeServizio());
            String nomeServizio = idServizio.getNome();
            String tipoServizio = idServizio.getTipo();
            String nomeErogatore = idServizio.getSoggettoErogatore().getNome();
            String tipoErogatore = idServizio.getSoggettoErogatore().getTipo();
            Integer versioneServizio = idServizio.getVersione();
            AccordoServizioParteSpecifica aspsFromValues = this.dynamicUtils.getAspsFromValues(tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio);
            IdAccordoServizioParteComune idAccordoServizioParteComune = aspsFromValues.getIdAccordoServizioParteComune();
            Integer ver = idAccordoServizioParteComune.getVersione();
            String nomeSoggettoReferente = null;
            String tipoSoggettoReferente = null;
            if (idAccordoServizioParteComune.getIdSoggetto() != null) {
                nomeSoggettoReferente = idAccordoServizioParteComune.getIdSoggetto().getNome();
                tipoSoggettoReferente = idAccordoServizioParteComune.getIdSoggetto().getTipo();
            }
            String nomeAS = idAccordoServizioParteComune.getNome();
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAS, tipoSoggettoReferente, nomeSoggettoReferente, ver);
            List<ConfigurazioneTransazioneRisorsaContenuto> l = ((ITransazioniService)this.service).getRisorseContenutoByValues(idAccordo, nomeServizioKey = aspsFromValues.getPortType() != null ? aspsFromValues.getPortType() : nomeServizio, this.search.getNomeAzione(), ((TransazioniSearchForm)this.search).getNomeStato());
            if (l != null) {
                for (ConfigurazioneTransazioneRisorsaContenuto r : l) {
                    this.risorse.add(new javax.faces.model.SelectItem((Object)r.getNome()));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.risorse;
    }

    public String submit() {
        return "transazioni";
    }

    public String saveDiagnostici() {
        try {
            ArrayList<String> idTransazioni = new ArrayList<String>();
            if (!this.isSelectedAll()) {
                Iterator it = this.selectedIds.keySet().iterator();
                while (it.hasNext()) {
                    TransazioneBean t = (TransazioneBean)((Object)it.next());
                    if (!((Boolean)this.selectedIds.get((Object)t)).booleanValue()) continue;
                    idTransazioni.add(t.getIdTransazione());
                    it.remove();
                }
            }
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            HttpSession sessione = (HttpSession)context.getExternalContext().getSession(false);
            sessione.setAttribute("idTransazioniOriginali", (Object)StringUtils.join(idTransazioni, (String)","));
            sessione.setAttribute("isAllOriginale", (Object)this.isSelectedAll());
            response.sendRedirect(context.getExternalContext().getRequestContextPath() + "/diagnosticiexporter?isAll=" + this.isSelectedAll() + "&ids=" + StringUtils.join(idTransazioni, (String)","));
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione dei diagnostici.");
        }
        return null;
    }

    public String saveTracce() {
        try {
            ArrayList<String> idTransazioni = new ArrayList<String>();
            if (!this.isSelectedAll()) {
                Iterator it = this.selectedIds.keySet().iterator();
                while (it.hasNext()) {
                    TransazioneBean t = (TransazioneBean)((Object)it.next());
                    if (!((Boolean)this.selectedIds.get((Object)t)).booleanValue()) continue;
                    idTransazioni.add(t.getIdTransazione());
                    it.remove();
                }
            }
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            HttpSession sessione = (HttpSession)context.getExternalContext().getSession(false);
            sessione.setAttribute("idTransazioniOriginali", (Object)StringUtils.join(idTransazioni, (String)","));
            sessione.setAttribute("isAllOriginale", (Object)this.isSelectedAll());
            response.sendRedirect(context.getExternalContext().getRequestContextPath() + "/tracceexporter?isAll=" + this.isSelectedAll() + "&ids=" + StringUtils.join(idTransazioni, (String)","));
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione delle tracce.");
        }
        return null;
    }

    public String exportCsvSelected() {
        try {
            String formatoExport = this.getTipoExport();
            String colonneEsportate = this.getColonneEsportate();
            List<String> colonneSelezionate = this.getIdentificativiColonneSelezionate(colonneEsportate);
            String idColonneSelezionate = UUID.randomUUID().toString().replace("-", "");
            ArrayList idTransazioni = new ArrayList();
            if (this.elencoID != null && this.elencoID.length() > 0) {
                String[] split = this.elencoID.split(",");
                ArrayList<String> orderFix = new ArrayList<String>();
                for (String idString : split) {
                    String tmpId = idString.substring(0, idString.lastIndexOf(":"));
                    tmpId = tmpId.substring(tmpId.lastIndexOf(":") + 1);
                    orderFix.add(tmpId);
                }
                idTransazioni.addAll(orderFix);
            }
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            HttpSession sessione = (HttpSession)context.getExternalContext().getSession(false);
            if ("ZIP".equals(formatoExport)) {
                sessione.setAttribute("idTransazioniOriginali", (Object)StringUtils.join(idTransazioni, (String)","));
                sessione.setAttribute("isAllOriginale", (Object)this.isSelectedAll());
                sessione.setAttribute("exporterOriginali", (Object)StringUtils.join(this.esportazioniSelezionate, (String)","));
                response.sendRedirect(context.getExternalContext().getRequestContextPath() + "/transazioniexporter?isAll=" + this.isSelectedAll() + "&ids=" + StringUtils.join(idTransazioni, (String)",") + "&exporter=" + StringUtils.join(this.esportazioniSelezionate, (String)","));
            } else {
                sessione.setAttribute("idTransazioniOriginali", (Object)StringUtils.join(idTransazioni, (String)","));
                sessione.setAttribute("isAllOriginale", (Object)this.isSelectedAll());
                sessione.setAttribute("exporterOriginali", (Object)StringUtils.join(this.esportazioniSelezionate, (String)","));
                sessione.setAttribute("fExOriginali", (Object)formatoExport);
                sessione.setAttribute("idSelezOriginali", (Object)idColonneSelezionate);
                sessione.setAttribute("lstSelezOriginali", colonneSelezionate);
                response.sendRedirect(context.getExternalContext().getRequestContextPath() + "/transazionicsvexporter?isAll=" + this.isSelectedAll() + "&ids=" + StringUtils.join(idTransazioni, (String)",") + "&exporter=" + StringUtils.join(this.esportazioniSelezionate, (String)",") + "&fEx=" + formatoExport + "&idSelez=" + idColonneSelezionate);
            }
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione dei diagnostici.");
        }
        return null;
    }

    public void initExportListener(ActionEvent ae) {
        super.initExportListener(ae);
        this.tipoExport = "CSV";
        this.showSelezioneContenuti = this.exportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti;
        this.showSelezioneTipoColonne = true;
        this.colonneEsportate = null;
        this.tipiColonneEsportate = null;
    }

    public boolean isExportCsvCompletato() {
        return this.exportCsvCompletato;
    }

    public void setExportCsvCompletato(boolean exportCsvCompletato) {
        this.exportCsvCompletato = exportCsvCompletato;
    }

    /*
     * Unable to fully structure code
     */
    public List<String> getIdentificativiColonneSelezionate(String colonneEsportate) {
        colonneSelezionate = new ArrayList<String>();
        if (colonneEsportate.equals("Tutte")) {
            colonneSelezionateTmp = ColonnaExportManager.getInstance().getKeysColonne();
            for (String key : colonneSelezionateTmp) {
                if (!this.isCsvColumnEnabled(key)) continue;
                colonneSelezionate.add(key);
            }
        } else if (colonneEsportate.equals("Visualizzate nello Storico")) {
            if (this.visualizzazioneStoricoTabellare) {
                try {
                    jsonUtils = JSONUtils.getInstance();
                    json = (ObjectNode)jsonUtils.getAsNode(this.getTableState());
                    if (json == null) ** GOTO lbl46
                    jsonArrayColumnsOrder = (ArrayNode)json.get("columnsOrder");
                    jsonObjectColumnsVisibility = (ObjectNode)json.get("columnsVisibility");
                    for (i = 0; i < jsonArrayColumnsOrder.size(); ++i) {
                        keyNode = jsonArrayColumnsOrder.get(i);
                        key = keyNode.asText();
                        visibilityNode = jsonObjectColumnsVisibility.get(key);
                        visibility = visibilityNode.asInt();
                        if (!this.isCsvColumnEnabled(key)) {
                            visibility = -1;
                        }
                        if (!ColonnaExportManager.getInstance().containsColonna(key) || visibility <= 0) continue;
                        colonneSelezionate.add(key);
                    }
                }
                catch (Exception e) {
                    TransazioniBean.log.error("Errore durante la lettura dei nomi colonne: " + e.getMessage(), (Throwable)e);
                }
            } else {
                colonneSelezionateTmp = ColonnaExportManager.getInstance().getKeysColonneCustomView();
                for (String key : colonneSelezionateTmp) {
                    if (!this.isCsvColumnEnabled(key)) continue;
                    colonneSelezionate.add(key);
                }
            }
        } else if (this.getElencoColonneSelezionate() != null) {
            for (SelectItem selItem : this.getElencoColonneSelezionate()) {
                if (colonneSelezionate.contains(selItem.getValue())) continue;
                colonneSelezionate.add(selItem.getValue());
            }
        }
lbl46:
        // 8 sources

        if (this.exportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti && this.esportazioniSelezionate.contains("tracce")) {
            colonneSelezionate.addAll(ColonnaExportManager.getInstance().getKeysColonneTracce());
        } else {
            colonneSelezionate.removeAll(ColonnaExportManager.getInstance().getKeysColonneTracce());
        }
        if (this.exportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti && this.esportazioniSelezionate.contains("diagnostici")) {
            colonneSelezionate.addAll(ColonnaExportManager.getInstance().getKeysColonneDiagnostici());
        } else {
            colonneSelezionate.removeAll(ColonnaExportManager.getInstance().getKeysColonneDiagnostici());
        }
        return colonneSelezionate;
    }

    public boolean isCsvColumnEnabled(String key) {
        if (key.equals("colIDCluster") && !this.isVisualizzaIdCluster()) {
            return false;
        }
        if (key.equals("colStato") && !this.applicationBean.getShowInformazioniContenutiTransazioniGrid()) {
            return false;
        }
        if (key.equals("colEventi") && !this.applicationBean.getShowInformazioniEventiTransazioniGrid()) {
            return false;
        }
        if (key.equals("colPdd") && Utility.getLoggedUser().getSizeSoggetti() == 1) {
            return false;
        }
        if (key.equals("colDataAccettazioneRich") && !this.isVisualizzaDataAccettazione()) {
            return false;
        }
        return !key.equals("colDataAccettazioneRisposta") || this.isVisualizzaDataAccettazione();
    }

    public List<String> getEsportazioniSelezionate() {
        try {
            if (this.esportazioniSelezionate.size() == 0) {
                if ("ZIP".equals(this.tipoExport)) {
                    if (PddMonitorProperties.getInstance((Logger)log).isExportTransazioniZipTracceDefaultValue()) {
                        this.esportazioniSelezionate.add("tracce");
                    }
                    if (PddMonitorProperties.getInstance((Logger)log).isExportTransazioniZipDiagnosticiDefaultValue()) {
                        this.esportazioniSelezionate.add("diagnostici");
                    }
                    if (PddMonitorProperties.getInstance((Logger)log).isExportTransazioniZipContenutiDefaultValue()) {
                        this.esportazioniSelezionate.add("contenuti");
                    }
                } else if (this.showSelezioneContenuti.booleanValue()) {
                    if (PddMonitorProperties.getInstance((Logger)log).isExportTransazioniCsvTracceDefaultValue()) {
                        this.esportazioniSelezionate.add("tracce");
                    }
                    if (PddMonitorProperties.getInstance((Logger)log).isExportTransazioniCsvDiagnosticiDefaultValue()) {
                        this.esportazioniSelezionate.add("diagnostici");
                    }
                } else {
                    this.esportazioniSelezionate.clear();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.esportazioniSelezionate;
    }

    public void setEsportazioniSelezionate(List<String> esportazioniSelezionate) {
        this.esportazioniSelezionate = esportazioniSelezionate;
    }

    public List<javax.faces.model.SelectItem> getEsportazioniSelezionateDisponibili() {
        this.esportazioniSelezionateDisponibili = new ArrayList<javax.faces.model.SelectItem>();
        if ("ZIP".equals(this.tipoExport)) {
            this.esportazioniSelezionateDisponibili.add(new javax.faces.model.SelectItem((Object)"tracce", "Tracce"));
            this.esportazioniSelezionateDisponibili.add(new javax.faces.model.SelectItem((Object)"diagnostici", "Diagnostici"));
            this.esportazioniSelezionateDisponibili.add(new javax.faces.model.SelectItem((Object)"contenuti", "Contenuti"));
        } else {
            this.esportazioniSelezionateDisponibili.add(new javax.faces.model.SelectItem((Object)"tracce", "Tracce"));
            this.esportazioniSelezionateDisponibili.add(new javax.faces.model.SelectItem((Object)"diagnostici", "Diagnostici"));
        }
        return this.esportazioniSelezionateDisponibili;
    }

    public void setEsportazioniSelezionateDisponibili(List<javax.faces.model.SelectItem> esportazioniSelezionateDisponibili) {
        this.esportazioniSelezionateDisponibili = esportazioniSelezionateDisponibili;
    }

    public Boolean getShowSelezioneContenuti() {
        this.showSelezioneContenuti = "ZIP".equals(this.tipoExport) ? Boolean.valueOf(true) : Boolean.valueOf(this.exportTransazioniCsvVisualizzaCheckBoxSelezioneContenuti);
        return this.showSelezioneContenuti;
    }

    public void setShowSelezioneContenuti(Boolean showSelezioneContenuti) {
        this.showSelezioneContenuti = showSelezioneContenuti;
    }

    public String getTableState() {
        if (StringUtils.isNotEmpty((CharSequence)this.tableState)) {
            return this.tableState;
        }
        Stato state = this.userService.getTableState(NomiTabelle.TRANSAZIONI.toString(), Utility.getLoggedUtente());
        this.tableState = state.getStato();
        return this.tableState;
    }

    public void setTableState(String tableState) {
        this.tableState = tableState;
        Stato state = this.userService.getTableState(NomiTabelle.TRANSAZIONI.toString(), Utility.getLoggedUtente());
        state.setStato(this.tableState);
        this.userService.saveTableState(NomiTabelle.TRANSAZIONI.toString(), Utility.getLoggedUtente(), state);
    }

    public boolean isVisualizzaIdCluster() {
        return this.visualizzaIdCluster;
    }

    public void setVisualizzaIdCluster(boolean visualizzaIdCluster) {
        this.visualizzaIdCluster = visualizzaIdCluster;
    }

    public boolean isVisualizzaProfiloTransazione() {
        return this.search != null && ModalitaRicercaTransazioni.RICERCA_LIBERA.getValue().equals(((TransazioniSearchForm)this.search).getModalitaRicercaStorico()) && "qualsiasi".equals(this.search.getModalita()) && (this.search.getProtocollo() == null || "qualsiasi".equals(this.search.getProtocollo()));
    }

    public boolean isVisualizzaDataAccettazione() {
        return this.visualizzaDataAccettazione;
    }

    public void setVisualizzaDataAccettazione(boolean visualizzaDataAccettazione) {
        this.visualizzaDataAccettazione = visualizzaDataAccettazione;
    }

    public void esportazioneSelectListener(ActionEvent ae) {
    }

    public String visualizzaExportCsv() {
        return null;
    }

    public String getExportCsvErrorMessage() {
        return this.exportCsvErrorMessage;
    }

    public void setExportCsvErrorMessage(String exportCsvErrorMessage) {
        this.exportCsvErrorMessage = exportCsvErrorMessage;
    }

    public List<javax.faces.model.SelectItem> getExportDisponibili() {
        if (this.exportDisponibili == null) {
            this.exportDisponibili = new ArrayList<javax.faces.model.SelectItem>();
            this.exportDisponibili.add(new javax.faces.model.SelectItem((Object)"CSV"));
            this.exportDisponibili.add(new javax.faces.model.SelectItem((Object)"XLS"));
            this.exportDisponibili.add(new javax.faces.model.SelectItem((Object)"ZIP"));
        }
        return this.exportDisponibili;
    }

    public void setExportDisponibili(List<javax.faces.model.SelectItem> exportDisponibili) {
        this.exportDisponibili = exportDisponibili;
    }

    public String getTipoExport() {
        return this.tipoExport;
    }

    public void setTipoExport(String tipoExport) {
        this.tipoExport = tipoExport;
    }

    public void tipoExportSelected(ActionEvent ae) {
        this.esportazioniSelezionate.clear();
    }

    public void tipoColonneSelected(ActionEvent ae) {
    }

    public List<javax.faces.model.SelectItem> getTipiColonneEsportate() {
        if (this.tipiColonneEsportate == null) {
            this.tipiColonneEsportate = new ArrayList<javax.faces.model.SelectItem>();
            this.tipiColonneEsportate.add(new javax.faces.model.SelectItem((Object)"Visualizzate nello Storico"));
            this.tipiColonneEsportate.add(new javax.faces.model.SelectItem((Object)"Tutte"));
            this.tipiColonneEsportate.add(new javax.faces.model.SelectItem((Object)"Personalizza"));
        }
        return this.tipiColonneEsportate;
    }

    public void setTipiColonneEsportate(List<javax.faces.model.SelectItem> tipiColonneEsportate) {
        this.tipiColonneEsportate = tipiColonneEsportate;
    }

    public String getColonneEsportate() {
        if (this.colonneEsportate == null) {
            this.colonneEsportate = "Visualizzate nello Storico";
        }
        return this.colonneEsportate;
    }

    public void setColonneEsportate(String colonneEsportate) {
        this.colonneEsportate = colonneEsportate;
    }

    public List<SelectItem> getElencoColonneDisponibili() {
        if (this.elencoColonneDisponibili == null) {
            this.elencoColonneDisponibili = this._getColonneDisponibili(this.getTableState());
        }
        return this.elencoColonneDisponibili;
    }

    public void setElencoColonneDisponibili(List<SelectItem> elencoColonneDisponibili) {
        this.elencoColonneDisponibili = elencoColonneDisponibili;
    }

    public List<javax.faces.model.SelectItem> getElencoImmagineColonne() {
        if (this.elencoImmagineColonne == null) {
            this.elencoImmagineColonne = new ArrayList<javax.faces.model.SelectItem>();
            List<SelectItem> getSoggettiServizi = this._getColonneDisponibili(this.getTableState());
            if (!getSoggettiServizi.isEmpty()) {
                for (SelectItem selectItem : getSoggettiServizi) {
                    this.elencoImmagineColonne.add(new javax.faces.model.SelectItem((Object)selectItem));
                }
            }
        }
        return this.elencoImmagineColonne;
    }

    public void setElencoImmagineColonne(List<javax.faces.model.SelectItem> elencoImmagineColonne) {
        this.elencoImmagineColonne = elencoImmagineColonne;
    }

    public List<SelectItem> getElencoColonneSelezionate() {
        return this.elencoColonneSelezionate;
    }

    public void setElencoColonneSelezionate(List<SelectItem> elencoColonneSelezionate) {
        log.debug("Set colonne selezionate [{}]", elencoColonneSelezionate);
        this.elencoColonneSelezionate = elencoColonneSelezionate;
    }

    private List<SelectItem> _getColonneDisponibili(String tableStateUtente) {
        ArrayList<SelectItem> colonne = new ArrayList<SelectItem>();
        List<SelectItem> colonneTmp = ColonnaExportManager.getInstance().getColonne();
        for (SelectItem selectItem : colonneTmp) {
            if (!this.isCsvColumnEnabled(selectItem.getValue())) continue;
            colonne.add(selectItem);
        }
        return colonne;
    }

    public void colonnaSelectListener(ActionEvent ae) {
        log.debug("Evento selezione [{}]", (Object)ae);
    }

    public Boolean getShowSelezioneColonne() {
        this.showSelezioneColonne = this.getColonneEsportate().equals("Personalizza");
        return this.showSelezioneColonne;
    }

    public void setShowSelezioneColonne(Boolean showSelezioneColonne) {
        this.showSelezioneColonne = showSelezioneColonne;
    }

    public Boolean getShowSelezioneTipoColonne() {
        this.showSelezioneTipoColonne = !this.getTipoExport().equals("ZIP");
        return this.showSelezioneTipoColonne;
    }

    public void setShowSelezioneTipoColonne(Boolean showSelezioneTipoColonne) {
        this.showSelezioneTipoColonne = showSelezioneTipoColonne;
    }

    public List<GruppoStorico> getTipiStorico() {
        if (this.tipiStorico == null) {
            boolean visualizzaPurposeId;
            this.tipiStorico = new ArrayList<GruppoStorico>();
            GruppoStorico gruppoTemporale = new GruppoStorico();
            gruppoTemporale.setLabel(MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.label"));
            ArrayList<Storico> listaGruppoTermporale = new ArrayList<Storico>();
            listaGruppoTermporale.add(new Storico(ModalitaRicercaTransazioni.ANDAMENTO_TEMPORALE.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaTemporale.label"), ModalitaRicercaTransazioni.ANDAMENTO_TEMPORALE, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaTemporale.icona")));
            listaGruppoTermporale.add(new Storico(ModalitaRicercaTransazioni.RICERCA_LIBERA.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaLibera.label"), ModalitaRicercaTransazioni.RICERCA_LIBERA, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.ricercaLibera.icona")));
            listaGruppoTermporale.add(new Storico(ModalitaRicercaTransazioni.ESAMINA_ARCHIVIO_ZIP.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.esaminaArchivioZip.label"), ModalitaRicercaTransazioni.ESAMINA_ARCHIVIO_ZIP, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.temporale.esaminaArchivioZip.icona")));
            gruppoTemporale.setListaStorico(listaGruppoTermporale);
            this.tipiStorico.add(gruppoTemporale);
            GruppoStorico gruppoMittente = new GruppoStorico();
            gruppoMittente.setLabel(MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.label"));
            ArrayList<Storico> listaGruppoMittente = new ArrayList<Storico>();
            listaGruppoMittente.add(new Storico(ModalitaRicercaTransazioni.MITTENTE_TOKEN_INFO.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaTokenInfo.label"), ModalitaRicercaTransazioni.MITTENTE_TOKEN_INFO, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaTokenInfo.icona")));
            listaGruppoMittente.add(new Storico(ModalitaRicercaTransazioni.MITTENTE_SOGGETTO.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaSoggetto.label"), ModalitaRicercaTransazioni.MITTENTE_SOGGETTO, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaSoggetto.icona")));
            listaGruppoMittente.add(new Storico(ModalitaRicercaTransazioni.MITTENTE_APPLICATIVO.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaApplicativo.label"), ModalitaRicercaTransazioni.MITTENTE_APPLICATIVO, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaApplicativo.icona")));
            listaGruppoMittente.add(new Storico(ModalitaRicercaTransazioni.MITTENTE_IDENTIFICATIVO_AUTENTICATO.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIdentificativoAutenticato.label"), ModalitaRicercaTransazioni.MITTENTE_IDENTIFICATIVO_AUTENTICATO, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIdentificativoAutenticato.icona")));
            listaGruppoMittente.add(new Storico(ModalitaRicercaTransazioni.MITTENTE_INDIRIZZO_IP.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIndirizzoIP.label"), ModalitaRicercaTransazioni.MITTENTE_INDIRIZZO_IP, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.mittente.ricercaIndirizzoIP.icona")));
            gruppoMittente.setListaStorico(listaGruppoMittente);
            this.tipiStorico.add(gruppoMittente);
            GruppoStorico gruppoId = new GruppoStorico();
            gruppoId.setLabel(MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.label"));
            ArrayList<Storico> listaGruppoId = new ArrayList<Storico>();
            Storico storicoIdTransazione = new Storico(ModalitaRicercaTransazioni.ID_TRANSAZIONE.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoTransazione.label"), ModalitaRicercaTransazioni.ID_TRANSAZIONE, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoTransazione.icona"));
            listaGruppoId.add(storicoIdTransazione);
            Storico storicoIdApplicativo = new Storico(ModalitaRicercaTransazioni.ID_APPLICATIVO_AVANZATA.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.label"), ModalitaRicercaTransazioni.ID_APPLICATIVO_AVANZATA, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.icona"));
            storicoIdApplicativo.setAction("transazioni_lvl2");
            listaGruppoId.add(storicoIdApplicativo);
            Storico storicoIdMessaggio = new Storico(ModalitaRicercaTransazioni.ID_MESSAGGIO.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoMessaggio.label"), ModalitaRicercaTransazioni.ID_MESSAGGIO, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoMessaggio.icona"));
            listaGruppoId.add(storicoIdMessaggio);
            Storico storicoIdToken = new Storico(ModalitaRicercaTransazioni.ID_TOKEN.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoToken.label"), ModalitaRicercaTransazioni.ID_TOKEN, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoToken.icona"));
            listaGruppoId.add(storicoIdToken);
            String loggedUtenteModalita = Utility.getLoggedUtenteModalita();
            boolean bl = visualizzaPurposeId = "qualsiasi".equals(loggedUtenteModalita) || "modipa".equals(loggedUtenteModalita);
            if (visualizzaPurposeId) {
                Storico storicoPurposeId = new Storico(ModalitaRicercaTransazioni.PURPOSE_ID.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaPurposeId.label"), ModalitaRicercaTransazioni.PURPOSE_ID, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaPurposeId.icona"));
                listaGruppoId.add(storicoPurposeId);
            }
            gruppoId.setListaStorico(listaGruppoId);
            this.tipiStorico.add(gruppoId);
        }
        return this.tipiStorico;
    }

    public void setTipiStorico(List<GruppoStorico> tipiStorico) {
        this.tipiStorico = tipiStorico;
    }

    public String getTipoStorico() {
        return this.tipoStorico;
    }

    public void setTipoStorico(String tipoStorico) {
        this.tipoStorico = tipoStorico;
        if (this.updateTipoStorico) {
            this.search.initSearchListener(null);
            ((TransazioniSearchForm)this.search).setModalitaRicercaStorico(this.tipoStorico);
            if (!TipologiaRicerca.all.equals((Object)this.search.getDefaultTipologiaRicercaEnum())) {
                ((TransazioniSearchForm)this.search).setTipologiaRicerca(this.search.getDefaultTipologiaRicercaEnum());
            } else {
                ((TransazioniSearchForm)this.search).setTipologiaRicerca("--");
            }
            ((TransazioniSearchForm)this.search).updateRiconoscimentoByModalitaRicercaStorico();
            this.updateTipoStorico = false;
        }
    }

    public boolean isUpdateTipoStorico() {
        return this.updateTipoStorico;
    }

    public void setUpdateTipoStorico(boolean updateTipoStorico) {
        this.updateTipoStorico = updateTipoStorico;
    }

    public void setTipiStoricoLivello2(List<GruppoStorico> tipiStoricoLivello2) {
        this.tipiStoricoLivello2 = tipiStoricoLivello2;
    }

    public List<GruppoStorico> getTipiStoricoLivello2() {
        if (this.tipoStorico == null) {
            return this.tipiStoricoLivello2;
        }
        this.tipiStoricoLivello2 = new ArrayList<GruppoStorico>();
        GruppoStorico gruppoId = new GruppoStorico();
        gruppoId.setLabel(MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.label"));
        ArrayList<Storico> listaGruppoId = new ArrayList<Storico>();
        listaGruppoId.add(new Storico(ModalitaRicercaTransazioni.ID_APPLICATIVO_BASE.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.lvl2.ricercaBase.label"), ModalitaRicercaTransazioni.ID_APPLICATIVO_BASE, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.lvl2.ricercaBase.icona"), 2));
        listaGruppoId.add(new Storico(ModalitaRicercaTransazioni.ID_APPLICATIVO_AVANZATA.getValue(), MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.lvl2.ricercaLibera.label"), ModalitaRicercaTransazioni.ID_APPLICATIVO_AVANZATA, MessageManager.getInstance().getMessage("transazioni.search.tipoRicerca.id.ricercaIdentificativoApplicativo.lvl2.ricercaLibera.icona"), 2));
        gruppoId.setListaStorico(listaGruppoId);
        this.tipiStoricoLivello2.add(gruppoId);
        return this.tipiStoricoLivello2;
    }

    public boolean isTransazioniLatenzaPortaEnabled() {
        return this.transazioniLatenzaPortaEnabled;
    }

    public void setTransazioniLatenzaPortaEnabled(boolean transazioniLatenzaPortaEnabled) {
        this.transazioniLatenzaPortaEnabled = transazioniLatenzaPortaEnabled;
    }

    public boolean isShowButtonEsporta() {
        return ((TransazioniSearchForm)this.search).isShowButtonEsporta();
    }
}

