/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.beans.BlackListElement;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;
import org.openspcoop2.web.monitor.transazioni.mbean.BustaBean;
import org.slf4j.Logger;

public class TracciaBean
extends Traccia {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private transient IProtocolFactory<?> protocolFactory;
    private BustaBean bustaBean;

    public TracciaBean(Traccia traccia, ServiceBinding tipoApi) {
        try {
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(traccia.getProtocollo());
        }
        catch (ProtocolException e) {
            log.error("Errore durante la creazione della Factory", (Throwable)e);
        }
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>(0);
        metodiEsclusi.add(new BlackListElement("setBusta", new Class[]{Busta.class}));
        metodiEsclusi.add(new BlackListElement("setListaAllegati", new Class[]{List.class}));
        metodiEsclusi.add(new BlackListElement("setProtocolFactory", new Class[]{IProtocolFactory.class}));
        BeanUtils.copy((Object)((Object)this), (Object)traccia, metodiEsclusi);
        this.setListaAllegati(traccia.getListaAllegati());
        this.bustaBean = new BustaBean(traccia.getBusta(), this.protocolFactory, tipoApi);
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public void setProtocolFactory(IProtocolFactory<?> protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public BustaBean getBustaBean() {
        return this.bustaBean;
    }

    public String getLocationLabel() {
        String in = "IN:";
        String out = "OUT:";
        if (this.getLocation() != null) {
            if (this.getLocation().startsWith(in)) {
                return "Indirizzo di provenienza della busta";
            }
            if (this.getLocation().startsWith(out)) {
                return "Indirizzo a cui \u00e8 stata spedita la busta";
            }
            return "Indirizzo provenienza/spedizione della busta";
        }
        return "";
    }

    public String getLocationValue() {
        String in = "IN:";
        String out = "OUT:";
        if (this.getLocation() != null) {
            if (this.getLocation().startsWith(in)) {
                return this.getLocation().substring(in.length());
            }
            if (this.getLocation().startsWith(out)) {
                return this.getLocation().substring(out.length());
            }
            return this.getLocation();
        }
        return "";
    }
}

