/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.Resource;
import org.openspcoop2.core.commons.search.dao.IServiceManager;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.utils.TempiElaborazione;
import org.openspcoop2.core.transazioni.utils.TempiElaborazioneUtils;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.pdd.logger.info.DatiEsitoTransazione;
import org.openspcoop2.pdd.logger.info.DatiMittente;
import org.openspcoop2.pdd.logger.info.InfoEsitoTransazioneFormatUtils;
import org.openspcoop2.pdd.logger.info.InfoMittenteFormatUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.PDNDTokenInfo;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiException;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiNotFoundException;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.beans.BlackListElement;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.MBeanUtilsService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.transazioni.bean.Gruppo;
import org.openspcoop2.web.monitor.transazioni.bean.TempiElaborazioneBean;
import org.openspcoop2.web.monitor.transazioni.constants.TransazioniCostanti;
import org.openspcoop2.web.monitor.transazioni.dao.TransazioniService;
import org.openspcoop2.web.monitor.transazioni.utils.FormatoFaultUtils;
import org.openspcoop2.web.monitor.transazioni.utils.TransazioniEsitiUtils;
import org.slf4j.Logger;

public class TransazioneBean
extends Transazione {
    private static final long serialVersionUID = 1L;
    private Long latenzaTotale = null;
    private Long latenzaServizio = null;
    private Long latenzaPorta = null;
    private String socketClientAddressLabel = null;
    private String transportClientAddressLabel = null;
    private String trasportoMittenteLabel = null;
    private String tipoTrasportoMittenteLabel = null;
    private String tokenIssuerLabel = null;
    private String tokenSubjectLabel = null;
    private String tokenClientIdLabel = null;
    private IDServizioApplicativo tokenClient = null;
    private String tokenClientNameLabel = null;
    private String tokenClientOrganizationNameLabel = null;
    private String tokenUsernameLabel = null;
    private String tokenMailLabel = null;
    private String eventiLabel = null;
    private String gruppiLabel = null;
    private String operazioneLabel;
    private String soggettoPddMonitor;
    private String pdndOrganizationName;
    private String pdndOrganizationExternalId;
    private String pdndOrganizationCategory;
    private String pdndOrganizationSubUnit;
    private String pdndOrganizationConsumerId;
    private String pdndClientName;
    private String pdndClientDescription;
    private String dettaglioErrore;

    public TransazioneBean() {
    }

    public TransazioneBean(Transazione transazione, String soggettoPddMonitor) {
        this.soggettoPddMonitor = soggettoPddMonitor;
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>(0);
        metodiEsclusi.add(new BlackListElement("setLatenzaTotale", new Class[]{Long.class}));
        metodiEsclusi.add(new BlackListElement("setLatenzaServizio", new Class[]{Long.class}));
        metodiEsclusi.add(new BlackListElement("setLatenzaPorta", new Class[]{Long.class}));
        metodiEsclusi.add(new BlackListElement("setSocketClientAddressLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTransportClientAddressLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTrasportoMittenteLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTipoTrasportoMittenteLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTokenIssuerLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTokenSubjectLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTokenClientIdLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTokenClient", new Class[]{IDServizioApplicativo.class}));
        metodiEsclusi.add(new BlackListElement("setTokenClientNameLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTokenClientOrganizationNameLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTokenClientWithOrganizationNameLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTokenUsernameLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setTokenMailLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setPdndOrganization", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setPdndOrganizationName", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setPdndOrganizationExternalId", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setPdndOrganizationCategory", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setPdndOrganizationSubUnit", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setPdndOrganizationConsumerId", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setPdndClient", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setPdndClientName", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setPdndClientDescription", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setEventiLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setGruppiLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setOperazioneLabel", new Class[]{String.class}));
        metodiEsclusi.add(new BlackListElement("setListaGruppi", new Class[]{List.class}));
        metodiEsclusi.add(new BlackListElement("setConsegnaMultipla", new Class[]{Boolean.TYPE}));
        BeanUtils.copy((Object)((Object)this), (Object)transazione, metodiEsclusi);
    }

    private String formatHTML(String tmp) {
        String[] split = tmp.split(",");
        if (split != null && split.length > 0) {
            StringBuilder bf = new StringBuilder();
            for (int i = 0; i < split.length; ++i) {
                if (bf.length() > 0) {
                    bf.append("<BR/>");
                }
                bf.append(split[i].trim());
            }
            return bf.toString();
        }
        return tmp;
    }

    public Long getLatenzaTotale() {
        if (this.latenzaTotale == null && this.dataUscitaRisposta != null && this.dataIngressoRichiesta != null) {
            this.latenzaTotale = this.dataUscitaRisposta.getTime() - this.dataIngressoRichiesta.getTime();
        }
        if (this.latenzaTotale == null) {
            return -1L;
        }
        return this.latenzaTotale;
    }

    public void setLatenzaTotale(Long latenzaTotale) {
        this.latenzaTotale = latenzaTotale;
    }

    public Long getLatenzaServizio() {
        if (this.latenzaServizio == null && this.dataUscitaRichiesta != null && this.dataIngressoRisposta != null) {
            this.latenzaServizio = this.dataIngressoRisposta.getTime() - this.dataUscitaRichiesta.getTime();
        }
        if (this.latenzaServizio == null) {
            return -1L;
        }
        return this.latenzaServizio;
    }

    public void setLatenzaServizio(Long latenzaServizio) {
        this.latenzaServizio = latenzaServizio;
    }

    public Long getLatenzaPorta() {
        if (this.latenzaPorta == null && this.getLatenzaTotale() != null && this.getLatenzaTotale() >= 0L) {
            this.latenzaPorta = this.getLatenzaServizio() != null && this.getLatenzaServizio() >= 0L ? Long.valueOf(this.getLatenzaTotale() - this.getLatenzaServizio()) : this.getLatenzaTotale();
        }
        if (this.latenzaPorta == null) {
            return -1L;
        }
        return this.latenzaPorta;
    }

    public void setLatenzaPorta(Long latenzaPorta) {
        this.latenzaPorta = latenzaPorta;
    }

    public String getEsitoStyleClass() {
        return TransazioniEsitiUtils.getEsitoStyleClass(this.getEsito(), this.getProtocollo());
    }

    public boolean isEsitoOk() {
        return !this.isEsitoSendInCorso() && TransazioniEsitiUtils.isEsitoOk(this.getEsito(), this.getProtocollo());
    }

    public boolean isEsitoFaultApplicativo() {
        return TransazioniEsitiUtils.isEsitoFaultApplicativo(this.getEsito(), this.getProtocollo());
    }

    public boolean isEsitoKo() {
        return TransazioniEsitiUtils.isEsitoKo(this.getEsito(), this.getProtocollo());
    }

    public boolean isEsitoSendInCorso() {
        String esitoContesto = this.getEsitoContesto();
        return EsitoUtils.isFaseRequestIn((String)esitoContesto) || EsitoUtils.isFaseRequestOut((String)esitoContesto);
    }

    public boolean isEsitoSendResponseInCorso() {
        String esitoContesto = this.getEsitoContesto();
        return EsitoUtils.isFaseResponseOut((String)esitoContesto);
    }

    public String getEsitoIcona() {
        String esitoContesto = this.getEsitoContesto();
        if (EsitoUtils.isFaseRequestIn((String)esitoContesto) || EsitoUtils.isFaseRequestOut((String)esitoContesto)) {
            return MessageManager.getInstance().getMessage("transazioni.elenco.esito.send.icon");
        }
        if (EsitoUtils.isFaseResponseOut((String)esitoContesto)) {
            return MessageManager.getInstance().getMessage("transazioni.elenco.esito.sendResponse.icon");
        }
        if (TransazioniEsitiUtils.isEsitoOk(this.getEsito(), this.getProtocollo())) {
            return MessageManager.getInstance().getMessage("transazioni.elenco.esito.ok.icon");
        }
        if (TransazioniEsitiUtils.isEsitoFaultApplicativo(this.getEsito(), this.getProtocollo())) {
            return MessageManager.getInstance().getMessage("transazioni.elenco.esito.error.icon");
        }
        if (TransazioniEsitiUtils.isEsitoKo(this.getEsito(), this.getProtocollo())) {
            return MessageManager.getInstance().getMessage("transazioni.elenco.esito.warning.icon");
        }
        return MessageManager.getInstance().getMessage("transazioni.elenco.esito.warning.icon");
    }

    public String getEsitoLabel() {
        String esitoContesto = this.getEsitoContesto();
        if (EsitoUtils.isFaseRequestIn((String)esitoContesto)) {
            return "Richiesta ricevuta";
        }
        if (EsitoUtils.isFaseRequestOut((String)esitoContesto)) {
            return "Richiesta in consegna";
        }
        return TransazioniEsitiUtils.getEsitoLabel(this.getEsito(), this.getProtocollo());
    }

    public String getEsitoLabelSyntetic() {
        String esitoContesto = this.getEsitoContesto();
        if (EsitoUtils.isFaseRequestIn((String)esitoContesto)) {
            return "Richiesta ricevuta";
        }
        if (EsitoUtils.isFaseRequestOut((String)esitoContesto)) {
            return "Richiesta in consegna";
        }
        Integer httpStatus = null;
        if (this.getCodiceRispostaUscita() != null && !"".equals(this.getCodiceRispostaUscita())) {
            try {
                httpStatus = Integer.valueOf(this.getCodiceRispostaUscita());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return TransazioniEsitiUtils.getEsitoLabelSyntetic(this.getEsito(), this.getProtocollo(), httpStatus, this.getTipoApi());
    }

    public String getEsitoLabelDescription() {
        return this.getEsitoLabelDescription(false);
    }

    public String getEsitoLabelDescriptionCheckResponseOut() {
        return this.getEsitoLabelDescription(true);
    }

    private String getEsitoLabelDescription(boolean verifyResponseOut) {
        String esitoContesto = this.getEsitoContesto();
        if (EsitoUtils.isFaseRequestIn((String)esitoContesto)) {
            return "Richiesta ricevuta";
        }
        if (EsitoUtils.isFaseRequestOut((String)esitoContesto)) {
            return "Richiesta in consegna";
        }
        String prefixResponseOut = "";
        if (verifyResponseOut && EsitoUtils.isFaseResponseOut((String)esitoContesto)) {
            prefixResponseOut = "Risposta in consegna<BR/>";
        }
        Integer httpStatus = null;
        if (this.getCodiceRispostaUscita() != null && !"".equals(this.getCodiceRispostaUscita())) {
            try {
                httpStatus = Integer.valueOf(this.getCodiceRispostaUscita());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Integer httpInStatus = null;
        if (this.getCodiceRispostaIngresso() != null && !"".equals(this.getCodiceRispostaIngresso())) {
            try {
                httpInStatus = Integer.valueOf(this.getCodiceRispostaIngresso());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return prefixResponseOut + TransazioniEsitiUtils.getEsitoLabelDescription(this.getEsito(), this.getProtocollo(), httpStatus, httpInStatus, this.getTipoApi());
    }

    public boolean isShowContesto() {
        try {
            if (EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)this.getProtocollo()).getEsitiTransactionContextCode().size() > 1) {
                return true;
            }
            String esitoContesto = this.getEsitoContesto();
            return EsitoUtils.isFaseResponseOut((String)esitoContesto);
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il calcolo dei contesti: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getEsitoContestoLabel() {
        String esitoContesto = this.getEsitoContesto();
        boolean moreContext = false;
        try {
            moreContext = EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)this.getProtocollo()).getEsitiTransactionContextCode().size() > 1;
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il calcolo dei contesti: " + e.getMessage(), (Throwable)e);
        }
        if (EsitoUtils.isFaseRequestIn((String)esitoContesto)) {
            return TransazioniEsitiUtils.getEsitoContestoLabel(EsitoUtils.getRawEsitoContext((String)esitoContesto), this.getProtocollo());
        }
        if (EsitoUtils.isFaseRequestOut((String)esitoContesto)) {
            return TransazioniEsitiUtils.getEsitoContestoLabel(EsitoUtils.getRawEsitoContext((String)esitoContesto), this.getProtocollo());
        }
        if (EsitoUtils.isFaseResponseOut((String)esitoContesto)) {
            if (moreContext) {
                return TransazioniEsitiUtils.getEsitoContestoLabel(EsitoUtils.getRawEsitoContext((String)esitoContesto), this.getProtocollo()) + " - Risposta in consegna";
            }
            return "Risposta in consegna";
        }
        return TransazioniEsitiUtils.getEsitoContestoLabel(this.getEsitoContesto(), this.getProtocollo());
    }

    public String getFaultCooperazionePretty() {
        return FormatoFaultUtils.getFaultPretty(super.getFaultCooperazione(), super.getFormatoFaultCooperazione());
    }

    public boolean isVisualizzaFaultCooperazione() {
        return FormatoFaultUtils.isVisualizzaFault(super.getFaultCooperazione());
    }

    public String getBrushFaultCooperazione() {
        return FormatoFaultUtils.getBrushFault(super.getFaultCooperazione(), super.getFormatoFaultCooperazione());
    }

    public String getErroreVisualizzaFaultCooperazione() {
        return FormatoFaultUtils.getErroreVisualizzaFault(super.getFaultCooperazione());
    }

    public String getFaultIntegrazionePretty() {
        return FormatoFaultUtils.getFaultPretty(super.getFaultIntegrazione(), super.getFormatoFaultIntegrazione());
    }

    public boolean isVisualizzaFaultIntegrazione() {
        return FormatoFaultUtils.isVisualizzaFault(super.getFaultIntegrazione());
    }

    public String getBrushFaultIntegrazione() {
        return FormatoFaultUtils.getBrushFault(super.getFaultIntegrazione(), super.getFormatoFaultIntegrazione());
    }

    public String getErroreVisualizzaFaultIntegrazione() {
        return FormatoFaultUtils.getErroreVisualizzaFault(super.getFaultIntegrazione());
    }

    public String getNomePorta() {
        String nomePorta = super.getNomePorta();
        String prefixNull = "null_";
        if (nomePorta != null && nomePorta.startsWith(prefixNull) && nomePorta.length() > prefixNull.length()) {
            return nomePorta.substring(prefixNull.length());
        }
        return nomePorta;
    }

    public String getSoggettoFruitore() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.getNomeSoggettoFruitore())) {
            return NamingUtils.getLabelSoggetto((String)this.getProtocollo(), (String)this.getTipoSoggettoFruitore(), (String)this.getNomeSoggettoFruitore());
        }
        return "";
    }

    public String getSoggettoErogatore() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.getNomeSoggettoErogatore())) {
            return NamingUtils.getLabelSoggetto((String)this.getProtocollo(), (String)this.getTipoSoggettoErogatore(), (String)this.getNomeSoggettoErogatore());
        }
        return "";
    }

    public String getSoggettoPdd() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.getPddNomeSoggetto())) {
            return NamingUtils.getLabelSoggetto((String)this.getProtocollo(), (String)this.getPddTipoSoggetto(), (String)this.getPddNomeSoggetto());
        }
        return "";
    }

    public String getProtocolloLabel() throws Exception {
        return NamingUtils.getLabelProtocollo((String)this.getProtocollo());
    }

    public String getServizio() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.getNomeServizio())) {
            return NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)this.getProtocollo(), (String)this.getTipoServizio(), (String)this.getNomeServizio(), (Integer)this.getVersioneServizio());
        }
        return "";
    }

    public String getPortaLabel() throws ProtocolException {
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(this.getProtocollo());
        PorteNamingUtils n = new PorteNamingUtils(protocolFactory);
        switch (this.getPddRuolo()) {
            case APPLICATIVA: {
                return n.normalizePA(this.getNomePorta());
            }
            case DELEGATA: {
                return n.normalizePD(this.getNomePorta());
            }
        }
        return this.getNomePorta();
    }

    public String getSocketClientAddressLabel() {
        return this.socketClientAddressLabel;
    }

    public void setSocketClientAddressLabel(String socketClientAddressLabel) {
        this.socketClientAddressLabel = socketClientAddressLabel;
    }

    public String getTransportClientAddressLabel() {
        return this.transportClientAddressLabel;
    }

    public void setTransportClientAddressLabel(String transportClientAddressLabel) {
        this.transportClientAddressLabel = transportClientAddressLabel;
    }

    public String getTrasportoMittenteLabel() {
        return this.trasportoMittenteLabel;
    }

    public void setTrasportoMittenteLabel(String trasportoMittenteLabel) {
        this.trasportoMittenteLabel = trasportoMittenteLabel;
    }

    public String getTipoTrasportoMittenteLabel() {
        return this.tipoTrasportoMittenteLabel;
    }

    public void setTipoTrasportoMittenteLabel(String tipoTrasportoMittenteLabel) {
        this.tipoTrasportoMittenteLabel = tipoTrasportoMittenteLabel;
    }

    public String getTokenIssuerLabel() {
        return this.tokenIssuerLabel;
    }

    public void setTokenIssuerLabel(String tokenIssuerLabel) {
        this.tokenIssuerLabel = tokenIssuerLabel;
    }

    public String getTokenSubjectLabel() {
        return this.tokenSubjectLabel;
    }

    public void setTokenSubjectLabel(String tokenSubjectLabel) {
        this.tokenSubjectLabel = tokenSubjectLabel;
    }

    public String getTokenClientIdLabel() {
        return this.tokenClientIdLabel;
    }

    public void setTokenClientIdLabel(String tokenClientIdLabel) {
        this.tokenClientIdLabel = tokenClientIdLabel;
    }

    public IDServizioApplicativo getTokenClient() {
        return this.tokenClient;
    }

    public void setTokenClient(IDServizioApplicativo tokenClient) {
        this.tokenClient = tokenClient;
    }

    public String getTokenClientNameLabel() {
        return this.tokenClientNameLabel;
    }

    public void setTokenClientNameLabel(String tokenClientNameLabel) {
        this.tokenClientNameLabel = tokenClientNameLabel;
    }

    public String getTokenClientOrganizationNameLabel() {
        return this.tokenClientOrganizationNameLabel;
    }

    public void setTokenClientOrganizationNameLabel(String tokenClientOrganizationNameLabel) {
        this.tokenClientOrganizationNameLabel = tokenClientOrganizationNameLabel;
    }

    public String getTokenClientWithOrganizationNameLabel() {
        if (this.tokenClientNameLabel != null && StringUtils.isNotEmpty((CharSequence)this.tokenClientNameLabel)) {
            if (this.tokenClientOrganizationNameLabel != null && StringUtils.isNotEmpty((CharSequence)this.tokenClientOrganizationNameLabel)) {
                boolean equals = false;
                try {
                    equals = this.tokenClientOrganizationNameLabel.equals(this.getSoggettoFruitore());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!equals) {
                    return this.tokenClientNameLabel + "@" + this.tokenClientOrganizationNameLabel;
                }
                return this.tokenClientNameLabel;
            }
            return this.tokenClientNameLabel;
        }
        return null;
    }

    public void setTokenClientWithOrganizationNameLabel(String tokenClientOrganizationNameLabel) {
    }

    public String getTokenUsernameLabel() {
        return this.tokenUsernameLabel;
    }

    public void setTokenUsernameLabel(String tokenUsernameLabel) {
        this.tokenUsernameLabel = tokenUsernameLabel;
    }

    public String getTokenMailLabel() {
        return this.tokenMailLabel;
    }

    public void setTokenMailLabel(String tokenMailLabel) {
        this.tokenMailLabel = tokenMailLabel;
    }

    public void setPdndOrganizationName(String pdndOrganizationName) {
        this.pdndOrganizationName = pdndOrganizationName;
    }

    public String getPdndOrganizationName() {
        if (this.pdndOrganizationName != null) {
            boolean esaminaTokenInfo;
            boolean bl = esaminaTokenInfo = "modipa".equals(this.getProtocollo()) && ("Informazione non disponibile".equals(this.pdndOrganizationName) || StringUtils.isEmpty((CharSequence)this.pdndOrganizationName));
            if (esaminaTokenInfo && this.tokenInfo != null && StringUtils.isNotEmpty((CharSequence)this.tokenInfo)) {
                try {
                    Logger log = LoggerManager.getPddMonitorCoreLogger();
                    this.pdndOrganizationName = PDNDTokenInfo.readOrganizationNameFromTokenInfo((Logger)log, (String)this.tokenInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((CharSequence)this.pdndOrganizationName)) {
                return null;
            }
            return this.pdndOrganizationName;
        }
        this.pdndOrganizationName = "";
        return this.pdndOrganizationName;
    }

    public void setPdndOrganizationExternalId(String pdndOrganizationExternalId) {
        this.pdndOrganizationExternalId = pdndOrganizationExternalId;
    }

    public String getPdndOrganizationExternalId() {
        if (this.pdndOrganizationExternalId != null) {
            boolean esaminaTokenInfo;
            boolean bl = esaminaTokenInfo = "modipa".equals(this.getProtocollo()) && ("Informazione non disponibile".equals(this.pdndOrganizationExternalId) || StringUtils.isEmpty((CharSequence)this.pdndOrganizationExternalId));
            if (esaminaTokenInfo && this.tokenInfo != null && StringUtils.isNotEmpty((CharSequence)this.tokenInfo)) {
                this.setPdndOrganizationExternalIdFromTokenInfo();
            }
            if (StringUtils.isEmpty((CharSequence)this.pdndOrganizationExternalId)) {
                return null;
            }
            return this.pdndOrganizationExternalId;
        }
        this.pdndOrganizationExternalId = "";
        return this.pdndOrganizationExternalId;
    }

    private void setPdndOrganizationExternalIdFromTokenInfo() {
        try {
            Logger log = LoggerManager.getPddMonitorCoreLogger();
            String origin = PDNDTokenInfo.readOrganizationExternalOriginFromTokenInfo((Logger)log, (String)this.tokenInfo);
            String id = PDNDTokenInfo.readOrganizationExternalIdFromTokenInfo((Logger)log, (String)this.tokenInfo);
            if (origin != null && StringUtils.isNotEmpty((CharSequence)origin) && id != null && StringUtils.isNotEmpty((CharSequence)id)) {
                this.pdndOrganizationExternalId = origin + " " + id;
            } else if (origin != null && StringUtils.isNotEmpty((CharSequence)origin)) {
                this.pdndOrganizationExternalId = origin;
            } else if (id != null && StringUtils.isNotEmpty((CharSequence)id)) {
                this.pdndOrganizationExternalId = id;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPdndOrganizationCategory(String pdndOrganizationCategory) {
        this.pdndOrganizationCategory = pdndOrganizationCategory;
    }

    public String getPdndOrganizationCategory() {
        if (this.pdndOrganizationCategory != null) {
            boolean esaminaTokenInfo;
            boolean bl = esaminaTokenInfo = "modipa".equals(this.getProtocollo()) && ("Informazione non disponibile".equals(this.pdndOrganizationCategory) || StringUtils.isEmpty((CharSequence)this.pdndOrganizationCategory));
            if (esaminaTokenInfo && this.tokenInfo != null && StringUtils.isNotEmpty((CharSequence)this.tokenInfo)) {
                try {
                    Logger log = LoggerManager.getPddMonitorCoreLogger();
                    this.pdndOrganizationCategory = PDNDTokenInfo.readOrganizationCategoryFromTokenInfo((Logger)log, (String)this.tokenInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((CharSequence)this.pdndOrganizationCategory)) {
                return null;
            }
            return this.pdndOrganizationCategory;
        }
        this.pdndOrganizationCategory = "";
        return this.pdndOrganizationCategory;
    }

    public void setPdndOrganizationSubUnit(String pdndOrganizationSubUnit) {
        this.pdndOrganizationSubUnit = pdndOrganizationSubUnit;
    }

    public String getPdndOrganizationSubUnit() {
        if (this.pdndOrganizationSubUnit != null) {
            boolean esaminaTokenInfo;
            boolean bl = esaminaTokenInfo = "modipa".equals(this.getProtocollo()) && ("Informazione non disponibile".equals(this.pdndOrganizationSubUnit) || StringUtils.isEmpty((CharSequence)this.pdndOrganizationSubUnit));
            if (esaminaTokenInfo && this.tokenInfo != null && StringUtils.isNotEmpty((CharSequence)this.tokenInfo)) {
                try {
                    Logger log = LoggerManager.getPddMonitorCoreLogger();
                    this.pdndOrganizationSubUnit = PDNDTokenInfo.readOrganizationSubUnitFromTokenInfo((Logger)log, (String)this.tokenInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((CharSequence)this.pdndOrganizationSubUnit)) {
                return null;
            }
            return this.pdndOrganizationSubUnit;
        }
        this.pdndOrganizationSubUnit = "";
        return this.pdndOrganizationSubUnit;
    }

    public void setPdndOrganizationConsumerId(String pdndOrganizationConsumerId) {
        this.pdndOrganizationConsumerId = pdndOrganizationConsumerId;
    }

    public String getPdndOrganizationConsumerId() {
        if (this.pdndOrganizationConsumerId != null) {
            boolean esaminaTokenInfo;
            boolean bl = esaminaTokenInfo = "modipa".equals(this.getProtocollo()) && ("Informazione non disponibile".equals(this.pdndOrganizationConsumerId) || StringUtils.isEmpty((CharSequence)this.pdndOrganizationConsumerId));
            if (esaminaTokenInfo && this.tokenInfo != null && StringUtils.isNotEmpty((CharSequence)this.tokenInfo)) {
                this.setPdndOrganizationConsumerIdFromTokenInfo();
            }
            if (StringUtils.isEmpty((CharSequence)this.pdndOrganizationConsumerId)) {
                return null;
            }
            return this.pdndOrganizationConsumerId;
        }
        this.pdndOrganizationConsumerId = "";
        return this.pdndOrganizationConsumerId;
    }

    private void setPdndOrganizationConsumerIdFromTokenInfo() {
        try {
            Logger log = LoggerManager.getPddMonitorCoreLogger();
            String id = PDNDTokenInfo.readOrganizationIdFromTokenInfo((Logger)log, (String)this.tokenInfo);
            if (id != null && StringUtils.isNotEmpty((CharSequence)id)) {
                this.pdndOrganizationConsumerId = id;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPdndOrganization(String pdndOrganization) {
    }

    public String getPdndOrganization() {
        StringBuilder sb = new StringBuilder();
        String name = this.getPdndOrganizationName();
        if (name != null && StringUtils.isNotEmpty((CharSequence)name)) {
            sb.append(name);
        }
        this.addPdndOrganizationCategory(sb);
        this.addPdndOrganizationSubUnit(sb);
        this.addPdndOrganizationExternalId(sb);
        this.addPdndOrganizationConsumerId(sb);
        return sb.length() > 0 ? sb.toString() : null;
    }

    private void addPdndOrganizationCategory(StringBuilder sb) {
        String cat = this.getPdndOrganizationCategory();
        if (cat != null && StringUtils.isNotEmpty((CharSequence)cat)) {
            if (sb.length() > 0) {
                sb.append("<BR/>");
            }
            sb.append("category: ");
            sb.append(cat);
        }
    }

    private void addPdndOrganizationSubUnit(StringBuilder sb) {
        String subUnit = this.getPdndOrganizationSubUnit();
        if (subUnit != null && StringUtils.isNotEmpty((CharSequence)subUnit)) {
            if (sb.length() > 0) {
                sb.append("<BR/>");
            }
            sb.append("subUnit: ");
            sb.append(subUnit);
        }
    }

    private void addPdndOrganizationExternalId(StringBuilder sb) {
        String extId = this.getPdndOrganizationExternalId();
        if (extId != null && StringUtils.isNotEmpty((CharSequence)extId)) {
            if (sb.length() > 0) {
                sb.append("<BR/>");
            }
            sb.append("externalId: ");
            sb.append(extId);
        }
    }

    private void addPdndOrganizationConsumerId(StringBuilder sb) {
        String consumerId = this.getPdndOrganizationConsumerId();
        if (consumerId != null && StringUtils.isNotEmpty((CharSequence)consumerId)) {
            if (sb.length() > 0) {
                sb.append("<BR/>");
            }
            sb.append("consumerId: ");
            sb.append(consumerId);
        }
    }

    public void setPdndClientName(String pdndClientName) {
        this.pdndClientName = pdndClientName;
    }

    public String getPdndClientName() {
        if (this.pdndClientName != null) {
            boolean esaminaTokenInfo;
            boolean bl = esaminaTokenInfo = "modipa".equals(this.getProtocollo()) && ("Informazione non disponibile".equals(this.pdndClientName) || StringUtils.isEmpty((CharSequence)this.pdndClientName));
            if (esaminaTokenInfo && this.tokenInfo != null && StringUtils.isNotEmpty((CharSequence)this.tokenInfo)) {
                try {
                    Logger log = LoggerManager.getPddMonitorCoreLogger();
                    this.pdndClientName = PDNDTokenInfo.readClientNameFromTokenInfo((Logger)log, (String)this.tokenInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((CharSequence)this.pdndClientName)) {
                return null;
            }
            return this.pdndClientName;
        }
        this.pdndClientName = "";
        return this.pdndClientName;
    }

    public void setPdndClientDescription(String pdndClientDescription) {
        this.pdndClientDescription = pdndClientDescription;
    }

    public String getPdndClientDescription() {
        if (this.pdndClientDescription != null) {
            boolean esaminaTokenInfo;
            boolean bl = esaminaTokenInfo = "modipa".equals(this.getProtocollo()) && ("Informazione non disponibile".equals(this.pdndClientDescription) || StringUtils.isEmpty((CharSequence)this.pdndClientDescription));
            if (esaminaTokenInfo && this.tokenInfo != null && StringUtils.isNotEmpty((CharSequence)this.tokenInfo)) {
                try {
                    Logger log = LoggerManager.getPddMonitorCoreLogger();
                    this.pdndClientDescription = PDNDTokenInfo.readClientDescriptionFromTokenInfo((Logger)log, (String)this.tokenInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((CharSequence)this.pdndClientDescription)) {
                return null;
            }
            return this.pdndClientDescription;
        }
        this.pdndClientDescription = "";
        return this.pdndClientDescription;
    }

    public void setPdndClient(String pdndClient) {
    }

    public String getPdndClient() {
        StringBuilder sb = new StringBuilder();
        String name = this.getPdndClientName();
        if (name != null && StringUtils.isNotEmpty((CharSequence)name)) {
            sb.append(name);
        }
        this.addPdndClientDescription(sb);
        return sb.length() > 0 ? sb.toString() : null;
    }

    private void addPdndClientDescription(StringBuilder sb) {
        String description = this.getPdndClientDescription();
        if (description != null && StringUtils.isNotEmpty((CharSequence)description)) {
            if (sb.length() > 0) {
                sb.append("<BR/>");
            }
            sb.append(description);
        }
    }

    public String getEventiGestione() {
        return this.eventiLabel;
    }

    public String getEventiGestioneRawValue() {
        return this.eventiGestione;
    }

    public String getEventiGestioneHTML() {
        String tmp = this.getEventiGestione();
        if (tmp != null) {
            if ((tmp = tmp.trim()).contains("Async=")) {
                tmp = tmp.replace("Async=", "");
            }
            if (tmp.contains(",")) {
                return this.formatHTML(tmp);
            }
            return tmp;
        }
        return null;
    }

    public List<String> getEventiGestioneAsList() {
        String tmp = this.getEventiGestione();
        ArrayList<String> l = new ArrayList<String>();
        if (tmp != null) {
            if ((tmp = tmp.trim()).contains(",")) {
                String[] split = tmp.split(",");
                if (split != null && split.length > 0) {
                    for (int i = 0; i < split.length; ++i) {
                        l.add(split[i].trim());
                    }
                } else {
                    l.add(tmp);
                }
            } else {
                l.add(tmp);
            }
        }
        return l;
    }

    public Integer getInResponseCodeFromEventiGestione() {
        List<String> l = this.getEventiGestioneAsList();
        if (!l.isEmpty()) {
            for (String evento : l) {
                if (evento == null || !evento.startsWith("In=") || evento.length() <= "In=".length()) continue;
                try {
                    String sub = evento.substring("In=".length());
                    int httpStatus = Integer.parseInt(sub);
                    if (httpStatus <= 0) continue;
                    return httpStatus;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public Integer getOutResponseCodeFromEventiGestione() {
        List<String> l = this.getEventiGestioneAsList();
        if (!l.isEmpty()) {
            for (String evento : l) {
                if (evento == null || !evento.startsWith("Out=") || evento.length() <= "Out=".length()) continue;
                try {
                    String sub = evento.substring("Out=".length());
                    int httpStatus = Integer.parseInt(sub);
                    if (httpStatus <= 0) continue;
                    return httpStatus;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public Integer getTipoApiFromEventiGestione() {
        List<String> l = this.getEventiGestioneAsList();
        if (!l.isEmpty()) {
            for (String evento : l) {
                if (evento == null || !evento.startsWith("API=") || evento.length() <= "API=".length()) continue;
                try {
                    String sub = evento.substring("API=".length());
                    int tipoApi = Integer.parseInt(sub);
                    if (tipoApi <= 0) continue;
                    return tipoApi;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public String getEventiLabel() {
        return this.eventiLabel;
    }

    public void setEventiLabel(String eventiLabel) {
        this.eventiLabel = eventiLabel;
    }

    public String getGruppi() {
        return this.gruppiLabel;
    }

    public String getGruppiRawValue() {
        return this.gruppi;
    }

    public String getGruppiHTML() {
        String tmp = this.getGruppi();
        if (tmp != null) {
            if ((tmp = tmp.trim()).contains(",")) {
                return this.formatHTML(tmp);
            }
            return tmp;
        }
        return null;
    }

    public String getGruppiLabel() {
        return this.gruppiLabel;
    }

    public void setGruppiLabel(String gruppiLabel) {
        this.gruppiLabel = gruppiLabel;
    }

    public List<Gruppo> getListaGruppi() {
        String tmp = this.getGruppi();
        ArrayList<Gruppo> gruppiObj = new ArrayList<Gruppo>();
        if (tmp != null) {
            List tagsDisponibili = Utility.getListaNomiGruppi();
            if ((tmp = tmp.trim()).contains(",")) {
                String[] split = tmp.split(",");
                if (split != null && split.length > 0) {
                    for (String nomeGruppo : split) {
                        Gruppo gruppo = new Gruppo();
                        gruppo.setLabel(nomeGruppo);
                        gruppiObj.add(gruppo);
                        int indexOf = tagsDisponibili.indexOf(nomeGruppo);
                        if (indexOf == -1) {
                            indexOf = 0;
                        }
                        gruppo.setValue("label-info-" + (indexOf %= TransazioniCostanti.NUMERO_GRUPPI_CSS.intValue()));
                    }
                }
            } else {
                Gruppo gruppo = new Gruppo();
                gruppo.setLabel(tmp);
                int indexOf = tagsDisponibili.indexOf(tmp);
                if (indexOf == -1) {
                    indexOf = 0;
                }
                gruppo.setValue("label-info-" + (indexOf %= TransazioniCostanti.NUMERO_GRUPPI_CSS.intValue()));
                gruppiObj.add(gruppo);
            }
        }
        return gruppiObj;
    }

    public void setListaGruppi(List<Gruppo> lista) {
    }

    public TempiElaborazioneBean getTempiElaborazioneObject() {
        String tempiElaborazione = this.getTempiElaborazione();
        try {
            TempiElaborazione tempi = TempiElaborazioneUtils.convertFromDBValue((String)tempiElaborazione);
            if (tempi != null) {
                return new TempiElaborazioneBean(tempi);
            }
            return null;
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il processamento dei tempi di elaborazione [" + tempiElaborazione + "]", (Throwable)e);
            return null;
        }
    }

    public void normalizeTipoApiInfo(IServiceManager service, Logger log) {
        if (TipoAPI.REST.getValoreAsInt() != this.getTipoApi() && TipoAPI.SOAP.getValoreAsInt() != this.getTipoApi()) {
            String uriAPI = this.getUriAccordoServizio();
            try {
                if (StringUtils.isNotEmpty((CharSequence)uriAPI)) {
                    IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAPI);
                    IdAccordoServizioParteComune idAPI = new IdAccordoServizioParteComune();
                    idAPI.setIdSoggetto(new IdSoggetto());
                    idAPI.getIdSoggetto().setTipo(idAccordo.getSoggettoReferente().getTipo());
                    idAPI.getIdSoggetto().setNome(idAccordo.getSoggettoReferente().getNome());
                    idAPI.setVersione(idAccordo.getVersione());
                    idAPI.setNome(idAccordo.getNome());
                    MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(service, log);
                    int tipo = mBeanUtilsService.getTipoApiFromCache(idAccordo);
                    this.setTipoApi(tipo);
                }
            }
            catch (Exception e) {
                log.info("Normalizzazione tipo di api '" + uriAPI + "' non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        this.operazioneLabel = this.getAzione();
    }

    public String getTipoApiLabel() {
        if (TipoAPI.REST.getValoreAsInt() == this.getTipoApi()) {
            return "Rest";
        }
        if (TipoAPI.SOAP.getValoreAsInt() == this.getTipoApi()) {
            return "Soap";
        }
        return "";
    }

    public boolean isShowParteComune() {
        String parteComune = this.getUriAccordoServizio();
        if (parteComune != null && !"".equals(parteComune)) {
            try {
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(parteComune);
                if (!idAccordo.getNome().equals(this.getNomeServizio())) {
                    return true;
                }
                if (idAccordo.getVersione().intValue() != this.getVersioneServizio()) {
                    return true;
                }
                IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(this.getProtocollo());
                if (protocolFactory.createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune()) {
                    if (!idAccordo.getSoggettoReferente().getTipo().equals(this.getTipoSoggettoErogatore())) {
                        return true;
                    }
                    if (!idAccordo.getSoggettoReferente().getNome().equals(this.getNomeSoggettoErogatore())) {
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getApi() throws Exception {
        String parteComune = this.getUriAccordoServizio();
        if (parteComune != null && !"".equals(parteComune)) {
            try {
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(parteComune);
                return NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public boolean isShowProfiloCollaborazione() {
        return TipoAPI.SOAP.getValoreAsInt() == this.getTipoApi();
    }

    public String getPddRuoloToolTip() {
        PddRuolo pddRuolo = this.getPddRuolo();
        if (pddRuolo != null) {
            switch (pddRuolo) {
                case DELEGATA: {
                    return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.delegata.label");
                }
                case APPLICATIVA: {
                    return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.applicativa.label");
                }
                case ROUTER: {
                    return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.router.label");
                }
                case INTEGRATION_MANAGER: {
                    return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.im.label");
                }
            }
        }
        return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.router.label");
    }

    public String getPddRuoloImage() {
        PddRuolo pddRuolo = this.getPddRuolo();
        if (pddRuolo != null) {
            switch (pddRuolo) {
                case DELEGATA: {
                    return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.delegata.icona");
                }
                case APPLICATIVA: {
                    return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.applicativa.icona");
                }
                case ROUTER: {
                    return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.router.icona");
                }
                case INTEGRATION_MANAGER: {
                    return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.im.icona");
                }
            }
        }
        return MessageManager.getInstance().getMessage("transazioni.elenco.ruoloPdd.router.icona");
    }

    public void normalizeRichiedenteInfo(Transazione t, TransazioneBean transazioneBean, TransazioniService transazioniService) throws ServiceException, MultipleResultException, NotImplementedException, ExpressionNotImplementedException {
        String sTokenUsername = this.getTokenUsername();
        if (StringUtils.isNotEmpty((CharSequence)sTokenUsername)) {
            transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteTokenUsername(transazioneBean, t);
            return;
        }
        String sTokenClientId = this.getTokenClientId();
        if (StringUtils.isNotEmpty((CharSequence)sTokenClientId)) {
            transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteTokenClientID(transazioneBean, t);
            transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteTokenPdnd(transazioneBean, t, false);
            return;
        }
        String sApplicativoFruitore = this.getServizioApplicativoFruitore();
        if (StringUtils.isNotEmpty((CharSequence)sApplicativoFruitore)) {
            return;
        }
        String sTokenSubject = this.getTokenSubject();
        boolean clientCredentialsFlow = false;
        if (StringUtils.isNotEmpty((CharSequence)sTokenClientId)) {
            boolean bl = clientCredentialsFlow = sTokenSubject == null || StringUtils.isEmpty((CharSequence)sTokenSubject) || sTokenSubject.equals(sTokenClientId);
        }
        if (clientCredentialsFlow && StringUtils.isNotEmpty((CharSequence)sTokenClientId)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)sTokenSubject)) {
            transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteTokenSubject(transazioneBean, t);
            String sTokenIssuer = this.getTokenIssuer();
            if (StringUtils.isNotEmpty((CharSequence)sTokenIssuer)) {
                transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteTokenIssuer(transazioneBean, t);
            }
            return;
        }
        if (!clientCredentialsFlow && StringUtils.isNotEmpty((CharSequence)sTokenClientId)) {
            return;
        }
        String sTrasportoMittente = this.getTrasportoMittente();
        if (StringUtils.isNotEmpty((CharSequence)sTrasportoMittente)) {
            transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteTrasporto(transazioneBean, t);
        }
    }

    public boolean isVisualizzaTextAreaRichiedente() throws Exception {
        String de = this.getRichiedente();
        return StringUtils.isNotEmpty((CharSequence)de) && de.length() > 150;
    }

    public DatiMittente convertToDatiMittente() {
        DatiMittente datiMittente = new DatiMittente();
        datiMittente.setTokenUsername(this.getTokenUsernameLabel());
        datiMittente.setTokenSubject(this.getTokenSubjectLabel());
        datiMittente.setTokenIssuer(this.getTokenIssuerLabel());
        datiMittente.setTokenClientId(this.getTokenClientIdLabel());
        if (this.getTokenClient() != null) {
            datiMittente.setTokenClient(this.getTokenClient().getNome());
            datiMittente.setTokenClientTipoSoggettoFruitore(this.getTokenClient().getIdSoggettoProprietario().getTipo());
            datiMittente.setTokenClientNomeSoggettoFruitore(this.getTokenClient().getIdSoggettoProprietario().getNome());
            try {
                datiMittente.setTokenClientSoggettoFruitore(this.getTokenClientOrganizationNameLabel());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        datiMittente.setPdndOrganizationName(this.getPdndOrganizationName());
        datiMittente.setTipoTrasportoMittente(this.getTipoTrasportoMittenteLabel());
        datiMittente.setTrasportoMittente(this.getTrasportoMittenteLabel());
        datiMittente.setServizioApplicativoFruitore(this.getServizioApplicativoFruitore());
        try {
            datiMittente.setSoggettoFruitore(this.getSoggettoFruitore());
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
        datiMittente.setTipoSoggettoFruitore(this.getTipoSoggettoFruitore());
        datiMittente.setNomeSoggettoFruitore(this.getNomeSoggettoFruitore());
        datiMittente.setPddRuolo(this.getPddRuolo());
        datiMittente.setSoggettoOperativo(this.soggettoPddMonitor);
        if (this.getTransportClientAddress() != null) {
            datiMittente.setTransportClientAddress(this.getTransportClientAddress());
        } else {
            datiMittente.setTransportClientAddress(this.getTransportClientAddressLabel());
        }
        if (this.getSocketClientAddress() != null) {
            datiMittente.setSocketClientAddress(this.getSocketClientAddress());
        } else {
            datiMittente.setSocketClientAddress(this.getSocketClientAddressLabel());
        }
        return datiMittente;
    }

    public DatiEsitoTransazione convertToDatiEsitoTransazione() {
        DatiEsitoTransazione datiEsitoTransazione = new DatiEsitoTransazione();
        datiEsitoTransazione.setEsito(Integer.valueOf(this.getEsito()));
        datiEsitoTransazione.setProtocollo(this.getProtocollo());
        datiEsitoTransazione.setFaultIntegrazione(this.getFaultIntegrazione());
        datiEsitoTransazione.setFormatoFaultIntegrazione(this.getFormatoFaultIntegrazione());
        datiEsitoTransazione.setFaultCooperazione(this.getFaultCooperazione());
        datiEsitoTransazione.setFormatoFaultCooperazione(this.getFormatoFaultCooperazione());
        datiEsitoTransazione.setPddRuolo(this.getPddRuolo());
        return datiEsitoTransazione;
    }

    public String getRichiedente() throws Exception {
        DatiMittente datiMittente = this.convertToDatiMittente();
        if ((datiMittente.getTokenUsername() == null || StringUtils.isEmpty((CharSequence)datiMittente.getTokenUsername())) && StringUtils.isNotEmpty((CharSequence)datiMittente.getTokenClient())) {
            boolean soggettoEqualsTokenSoggetto = false;
            if (datiMittente.getTokenClientSoggettoFruitore() != null && datiMittente.getTokenClientTipoSoggettoFruitore() != null && datiMittente.getTokenClientNomeSoggettoFruitore() != null) {
                boolean bl = soggettoEqualsTokenSoggetto = datiMittente.getTokenClientTipoSoggettoFruitore().equals(datiMittente.getTipoSoggettoFruitore()) && datiMittente.getTokenClientNomeSoggettoFruitore().equals(datiMittente.getNomeSoggettoFruitore());
            }
            if (!soggettoEqualsTokenSoggetto) {
                return this.getLabelRichiedenteConFruitore();
            }
        }
        return InfoMittenteFormatUtils.getRichiedente((DatiMittente)datiMittente);
    }

    public String getIpRichiedente() {
        DatiMittente datiMittente = this.convertToDatiMittente();
        return InfoMittenteFormatUtils.getIpRichiedente((DatiMittente)datiMittente);
    }

    public String getLabelRichiedenteConFruitore() throws Exception {
        DatiMittente datiMittente = this.convertToDatiMittente();
        return InfoMittenteFormatUtils.getLabelRichiedenteConFruitore((DatiMittente)datiMittente);
    }

    public String getLabelAPIConErogatore() throws Exception {
        StringBuilder bf = new StringBuilder();
        String api = this.getServizio();
        if (!StringUtils.isNotEmpty((CharSequence)api)) {
            return this.getLabelAPIConErogatoreAPInonTrovata();
        }
        bf.append(api);
        String sErogatore = this.getSoggettoErogatore();
        if (StringUtils.isNotEmpty((CharSequence)sErogatore)) {
            boolean addErogatore = true;
            if (PddRuolo.APPLICATIVA.equals((Object)this.getPddRuolo()) && this.soggettoPddMonitor != null && StringUtils.isNotEmpty((CharSequence)this.getTipoSoggettoErogatore()) && StringUtils.isNotEmpty((CharSequence)this.getNomeSoggettoErogatore())) {
                IDSoggetto idSoggettoErogatore = new IDSoggetto(this.getTipoSoggettoErogatore(), this.getNomeSoggettoErogatore());
                boolean bl = addErogatore = !this.soggettoPddMonitor.equals(idSoggettoErogatore.toString());
            }
            if (addErogatore) {
                bf = new StringBuilder();
                bf.append(NamingUtils.getLabelServizioConDominioErogatore((String)api, (String)sErogatore));
            }
        }
        return bf.toString();
    }

    public String getLabelAPIConErogatoreAPInonTrovata() throws Exception {
        if (this.esito > 0) {
            try {
                EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)this.getProtocollo());
                String label = esitiProperties.getEsitoLabel(Integer.valueOf(this.esito));
                if (label != null && StringUtils.isNotEmpty((CharSequence)label)) {
                    return label;
                }
            }
            catch (Exception e) {
                LoggerManager.getPddMonitorCoreLogger().error("Errore durante l'ottenimento della label a partire dall'esito: " + e.getMessage(), (Throwable)e);
            }
        }
        return "API non individuata";
    }

    public String getTipoOperazioneLabel() {
        if (TipoAPI.REST.getValoreAsInt() == this.getTipoApi()) {
            return "Risorsa";
        }
        return "Azione";
    }

    public String getOperazioneLabel() {
        return this.operazioneLabel;
    }

    public void setOperazioneLabel(String operazioneLabel) {
        this.operazioneLabel = operazioneLabel;
    }

    public void normalizeOperazioneInfo(IServiceManager service, Logger log) {
        if (TipoAPI.REST.getValoreAsInt() == this.getTipoApi()) {
            String uriAPI = this.getUriAccordoServizio();
            String op = this.getAzione();
            try {
                if (StringUtils.isNotEmpty((CharSequence)uriAPI) && StringUtils.isNotEmpty((CharSequence)op)) {
                    IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAPI);
                    IdAccordoServizioParteComune idAPI = new IdAccordoServizioParteComune();
                    idAPI.setIdSoggetto(new IdSoggetto());
                    idAPI.getIdSoggetto().setTipo(idAccordo.getSoggettoReferente().getTipo());
                    idAPI.getIdSoggetto().setNome(idAccordo.getSoggettoReferente().getNome());
                    idAPI.setVersione(idAccordo.getVersione());
                    idAPI.setNome(idAccordo.getNome());
                    MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(service, log);
                    List l = mBeanUtilsService.getInfoOperazioneFromCache(op, idAccordo);
                    if (l != null && l.size() == 1) {
                        Map map = (Map)l.get(0);
                        String method = (String)map.get(Resource.model().HTTP_METHOD.getFieldName());
                        String path = (String)map.get(Resource.model().PATH.getFieldName());
                        StringBuilder bf = new StringBuilder();
                        if (!"ALL".equals(method)) {
                            bf.append(method);
                            bf.append(" ");
                        }
                        if (!"*".equals(path)) {
                            bf.append(path);
                            this.operazioneLabel = bf.toString();
                            return;
                        }
                    }
                }
            }
            catch (Exception e) {
                log.info("Normalizzazione operazione '" + op + "' per api '" + uriAPI + "' non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        this.operazioneLabel = this.getAzione();
    }

    public String getLabelOperazioneConGestioneNonPresenza() {
        String op = this.getOperazioneLabel();
        if (StringUtils.isNotEmpty((CharSequence)op)) {
            return this.getOperazioneLabel();
        }
        return "-";
    }

    public String getCssColonnaEsito() {
        String esitoContesto = this.getEsitoContesto();
        if (EsitoUtils.isFaseRequestIn((String)esitoContesto) || EsitoUtils.isFaseRequestOut((String)esitoContesto)) {
            return "col-esito-ok";
        }
        if (this.isEsitoOk()) {
            return "col-esito-ok";
        }
        if (this.isEsitoFaultApplicativo()) {
            return "col-esito-fault";
        }
        if (this.isEsitoKo()) {
            return "col-esito-errore";
        }
        return "col-esito-errore";
    }

    public String getCssColonnaLatenza() {
        String esitoContesto = this.getEsitoContesto();
        if (EsitoUtils.isFaseRequestIn((String)esitoContesto) || EsitoUtils.isFaseRequestOut((String)esitoContesto)) {
            return "col-latenza-ok";
        }
        if (this.isEsitoOk()) {
            return "col-latenza-ok";
        }
        if (this.isEsitoFaultApplicativo()) {
            return "col-latenza-fault";
        }
        if (this.isEsitoKo()) {
            return "col-latenza-errore";
        }
        return "col-latenza-errore";
    }

    public boolean isConsegnaMultipla() {
        try {
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)this.getProtocollo());
            String name = esitiProperties.getEsitoName(Integer.valueOf(this.getEsito()));
            EsitoTransazioneName esitoName = EsitoTransazioneName.convertoTo((String)name);
            return EsitoTransazioneName.isConsegnaMultipla((EsitoTransazioneName)esitoName);
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il check consegna multipla: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isSavedInMessageBox() {
        try {
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)this.getProtocollo());
            String name = esitiProperties.getEsitoName(Integer.valueOf(this.getEsito()));
            EsitoTransazioneName esitoName = EsitoTransazioneName.convertoTo((String)name);
            return EsitoTransazioneName.isSavedInMessageBox((EsitoTransazioneName)esitoName);
        }
        catch (Exception e) {
            LoggerManager.getPddMonitorCoreLogger().error("Errore durante il check saved in message box: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void setConsegnaMultipla(boolean consegnaMultipla) {
    }

    public String getLabelDettaglioErrore() {
        return this.isEsitoOk() ? "Dettaglio Anomalia" : "Dettaglio Errore";
    }

    public boolean isVisualizzaTextAreaDettaglioErrore() {
        String de = this.getDettaglioErrore();
        return StringUtils.isNotEmpty((CharSequence)de) && de.length() > 150;
    }

    public String getDettaglioErrore() {
        if (this.dettaglioErrore != null) {
            return this.dettaglioErrore;
        }
        return this.getDettaglioErroreEngine(null);
    }

    public String getDettaglioErrore(List<MsgDiagnostico> msgs) {
        if (this.dettaglioErrore != null) {
            return this.dettaglioErrore;
        }
        return this.getDettaglioErroreEngine(msgs);
    }

    private synchronized String getDettaglioErroreEngine(List<MsgDiagnostico> msgsParams) {
        if (this.dettaglioErrore != null) {
            return this.dettaglioErrore;
        }
        Logger log = LoggerManager.getPddMonitorCoreLogger();
        List<MsgDiagnostico> msgs = null;
        if (msgsParams != null) {
            msgs = msgsParams;
        } else {
            EsitiProperties esitiProperties = null;
            EsitoTransazioneName esitoTransactionName = null;
            try {
                esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.getProtocollo());
                esitoTransactionName = esitiProperties.getEsitoTransazioneName(Integer.valueOf(this.getEsito()));
            }
            catch (Exception e) {
                log.error("Errore durante il recupero dell'esito della transazione: " + e.getMessage(), (Throwable)e);
                return "";
            }
            try {
                PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
                IDiagnosticDriver driver = govwayMonitorProperties.getDriverMsgDiagnostici();
                FiltroRicercaDiagnosticiConPaginazione filter = new FiltroRicercaDiagnosticiConPaginazione();
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("id_transazione", this.getIdTransazione());
                filter.setProperties(properties);
                filter.setApplicativo(null);
                filter.setCheckApplicativoIsNull(Boolean.valueOf(EsitoTransazioneName.isConsegnaMultipla((EsitoTransazioneName)esitoTransactionName)));
                filter.setSeverita(Integer.valueOf(2));
                filter.setAsc(true);
                msgs = this.getDiagnostici(driver, filter, log);
            }
            catch (Exception e) {
                LoggerManager.getPddMonitorCoreLogger().error("Errore durante il recupero dei diagnostici per la ricostruzione del motivo dell'errore: " + e.getMessage(), (Throwable)e);
            }
        }
        DatiEsitoTransazione datiEsitoTransazione = this.convertToDatiEsitoTransazione();
        String dettaglioErroreResult = InfoEsitoTransazioneFormatUtils.getDettaglioErrore((Logger)log, (DatiEsitoTransazione)datiEsitoTransazione, msgs);
        this.dettaglioErrore = dettaglioErroreResult != null ? dettaglioErroreResult : "";
        return this.dettaglioErrore;
    }

    private List<MsgDiagnostico> getDiagnostici(IDiagnosticDriver driver, FiltroRicercaDiagnosticiConPaginazione filter, Logger log) throws DriverMsgDiagnosticiException {
        ArrayList<MsgDiagnostico> msgs = null;
        try {
            msgs = driver.getMessaggiDiagnostici(filter);
        }
        catch (DriverMsgDiagnosticiNotFoundException notFound) {
            msgs = new ArrayList<MsgDiagnostico>();
            log.debug(notFound.getMessage(), (Throwable)notFound);
        }
        return msgs;
    }
}

