/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.InRequestHandler;
import org.openspcoop2.protocol.basic.registry.RegistryReader;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.config.ModISignalHubConfig;
import org.openspcoop2.protocol.modipa.config.ModISignalHubParamConfig;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.constants.ModISignalHubOperation;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationAccordiParteComuneUtilities;
import org.openspcoop2.protocol.modipa.utils.ModIUtilities;
import org.openspcoop2.protocol.registry.RegistroServiziReader;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaServizi;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.ProfiloUtils;
import org.slf4j.Logger;

public class SignalHubPushInProtocolRequestHandler
implements InRequestHandler {
    public void invoke(InRequestContext context) throws HandlerException {
        try {
            if (this.checkSignalHubPushConditions(context)) {
                List<ProtocolProperty> props = this.getSignalHubPushProperty(context);
                this.parseSignalHubPushProperty(context, props);
            }
        }
        catch (DriverRegistroServiziException | DynamicException | ProtocolException | RegistryException | RegistryNotFound e) {
            throw new HandlerException(e);
        }
    }

    private boolean checkSignalHubPushConditions(InRequestContext context) throws ProtocolException, DriverRegistroServiziException, RegistryNotFound, RegistryException {
        Logger logger = context.getLogCore();
        ModIProperties modiProperties = ModIProperties.getInstance();
        if (!modiProperties.isSignalHubEnabled()) {
            return false;
        }
        if (context.getTipoPorta() == null || !context.getTipoPorta().equals((Object)TipoPdD.DELEGATA) || context.getPddContext() == null) {
            return false;
        }
        IRegistryReader registryReader = this.getIRegistryReader(context);
        AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(this.getRequestInfo(context).getIdServizio());
        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
        if (idAccordo == null) {
            return false;
        }
        boolean isApiSignalHubPushAPI = false;
        Map readers = RegistroServiziReader.getDriverRegistroServizi();
        for (Map.Entry entry : readers.entrySet()) {
            try {
                RegistryReader reader = new RegistryReader((IDriverRegistroServiziGet)entry.getValue(), logger);
                isApiSignalHubPushAPI |= ModIDynamicConfigurationAccordiParteComuneUtilities.isApiSignalHubPushAPI(idAccordo, (IRegistryReader)reader, ModIProperties.getInstance(), logger);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        }
        if (!isApiSignalHubPushAPI) {
            return false;
        }
        logger.debug("Nuova richiesta di deposito di segnali SignalHub");
        return true;
    }

    private RequestInfo getRequestInfo(InRequestContext context) {
        return (RequestInfo)context.getPddContext().getObject(Costanti.REQUEST_INFO);
    }

    private IRegistryReader getIRegistryReader(InRequestContext context) throws ProtocolException {
        return context.getProtocolFactory().getCachedRegistryReader(context.getStato(), this.getRequestInfo(context));
    }

    private IDSoggetto getFruitore(InRequestContext context) {
        return this.getRequestInfo(context).getFruitore();
    }

    private List<ProtocolProperty> getSignalHubPushProperty(InRequestContext context) throws ProtocolException, RegistryNotFound, RegistryException {
        IRegistryReader reader = this.getIRegistryReader(context);
        IDServizio servizio = this.getRequestInfo(context).getIdServizio();
        IDSoggetto idFruitore = this.getFruitore(context);
        AccordoServizioParteSpecifica asps = reader.getAccordoServizioParteSpecifica(servizio, false);
        List fruitori = Objects.requireNonNullElseGet(asps.getFruitoreList(), ArrayList::new);
        Optional<Fruitore> fruitore = fruitori.stream().filter(f -> f.getNome().equals(idFruitore.getNome()) && f.getTipo().equals(idFruitore.getTipo())).findAny();
        if (fruitore.isEmpty()) {
            return List.of();
        }
        List props = fruitore.get().getProtocolPropertyList();
        if (props != null && !props.isEmpty()) {
            return props;
        }
        return List.of();
    }

    private String getDynamicProperty(List<ProtocolProperty> props, ModISignalHubParamConfig param, Context context, Map<String, Object> dynamicMap, boolean useDefault) throws ProtocolException {
        try {
            String key = "modipaSignalHubPushParamValue" + param.getPropertyId();
            String mode = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(props, (String)("modipaSignalHubPushParamMode" + param.getPropertyId()));
            String ridefinedValue = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(props, (String)("modipaSignalHubPushParamValue" + param.getPropertyId()));
            List<String> values = null;
            values = !useDefault && mode.equals("ridefinisci") ? List.of(ridefinedValue) : param.getRules();
            return ModIUtilities.getDynamicValue(key, values, dynamicMap, context);
        }
        catch (ProtocolException e) {
            return null;
        }
    }

    private void parseSignalHubPushProperty(InRequestContext context, List<ProtocolProperty> props) throws ProtocolException, DynamicException, HandlerException, RegistryNotFound, RegistryException, NumberFormatException, DriverRegistroServiziException {
        ModIProperties modiProperties = ModIProperties.getInstance();
        ModISignalHubConfig signalHubConfig = modiProperties.getSignalHubConfig();
        Logger logger = context.getLogCore();
        Map<String, ModISignalHubParamConfig> claims = signalHubConfig.getClaims().stream().collect(Collectors.toMap(v -> v.getPropertyId(), v -> v));
        Map dynamicMap = DynamicUtils.buildDynamicMap((OpenSPCoop2Message)context.getMessaggio(), (Context)context.getPddContext(), null, (Logger)logger, (boolean)modiProperties.isReadByPathBufferEnabled());
        boolean isSeedUpdate = false;
        String signalTypeRaw = this.getDynamicProperty(props, claims.get("signalType"), (Context)context.getPddContext(), dynamicMap, true);
        ModISignalHubOperation signalType = ModISignalHubOperation.fromString(signalTypeRaw);
        if (signalType != null && signalType.equals((Object)ModISignalHubOperation.SEEDUPDATE)) {
            isSeedUpdate = true;
        }
        String objectId = this.getDynamicProperty(props, claims.get("objectId"), (Context)context.getPddContext(), dynamicMap, isSeedUpdate);
        String objectType = this.getDynamicProperty(props, claims.get("objectType"), (Context)context.getPddContext(), dynamicMap, isSeedUpdate);
        signalTypeRaw = this.getDynamicProperty(props, claims.get("signalType"), (Context)context.getPddContext(), dynamicMap, isSeedUpdate);
        if (objectId == null) {
            throw this.newHandlerException("Parametro obbligatorio 'objectId' non rilevato", IntegrationFunctionError.BAD_REQUEST);
        }
        if (objectType == null) {
            throw this.newHandlerException("Parametro obbligatorio 'objectType' non rilevato", IntegrationFunctionError.BAD_REQUEST);
        }
        if (signalTypeRaw == null) {
            throw this.newHandlerException("Parametro obbligatorio 'signalType' non rilevato", IntegrationFunctionError.BAD_REQUEST);
        }
        signalType = ModISignalHubOperation.fromString(signalTypeRaw);
        if (signalType == null) {
            throw this.newHandlerException("Parametro 'signalType' con valore errato '" + signalTypeRaw + "'; valori supportati: UPDATE, CREATE, DELETE", IntegrationFunctionError.BAD_REQUEST);
        }
        String service = null;
        String serviceVersion = null;
        String serviceId = null;
        service = this.getDynamicProperty(props, claims.get("service"), (Context)context.getPddContext(), dynamicMap, isSeedUpdate);
        serviceVersion = this.getDynamicProperty(props, claims.get("serviceVersion"), (Context)context.getPddContext(), dynamicMap, isSeedUpdate);
        serviceId = this.getDynamicProperty(props, claims.get("serviceId"), (Context)context.getPddContext(), dynamicMap, isSeedUpdate);
        IRegistryReader reader = this.getIRegistryReader(context);
        IDServizio idServizio = null;
        List eServiceProperties = null;
        if (serviceId == null && (service == null || serviceVersion == null)) {
            throw this.newHandlerException("Un serviceId o in alternativa il nome e la versione devono essere obbligatoriamente indicati per poter individuare il servizio", IntegrationFunctionError.BAD_REQUEST);
        }
        if (serviceId == null) {
            int versioneServizio = -1;
            try {
                versioneServizio = Integer.valueOf(serviceVersion);
                if (versioneServizio <= 0) {
                    throw new CoreException("Valore deve essere maggiore di zero");
                }
            }
            catch (Exception e) {
                String msg = "Parametro 'serviceVersion' presenta un valore '" + serviceVersion + "' non valido; deve essere un numero intero maggiore di zero";
                logger.error(msg + ": " + e.getMessage(), (Throwable)e);
                throw this.newHandlerException(msg, IntegrationFunctionError.BAD_REQUEST);
            }
            try {
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(ProfiloUtils.toProtocollo((ProfiloEnum)ProfiloEnum.MODIPA), service, this.getFruitore(context), versioneServizio);
                AccordoServizioParteSpecifica asps = reader.getAccordoServizioParteSpecifica(idServizio);
                eServiceProperties = asps.getProtocolPropertyList();
            }
            catch (RegistryNotFound notFound) {
                String nomeSoggetto = idServizio != null && idServizio.getSoggettoErogatore() != null && idServizio.getSoggettoErogatore().getNome() != null ? idServizio.getSoggettoErogatore().getNome() : "Non identificato";
                throw this.newHandlerException("Il soggetto '" + nomeSoggetto + "' non risulta erogare un servizio con nome '" + service + "'  e versione '" + versioneServizio + "'", IntegrationFunctionError.BAD_REQUEST);
            }
        }
        ProtocolFiltroRicercaServizi filter = new ProtocolFiltroRicercaServizi();
        ProtocolProperties filterProps = new ProtocolProperties();
        filterProps.addProperty("modipaInfoGenEserviceId", serviceId);
        filter.setProtocolPropertiesServizi(filterProps);
        List idServices = null;
        try {
            idServices = reader.findIdAccordiServizioParteSpecifica(filter);
        }
        catch (RegistryNotFound registryNotFound) {
            // empty catch block
        }
        logger.debug("id servizi: {}", (Object)idServices);
        if (idServices == null || idServices.isEmpty() || idServices.get(0) == null) {
            throw this.newHandlerException("Non esiste una erogazione di servizio registrato con l'id servizio '" + serviceId + "' indicato", IntegrationFunctionError.BAD_REQUEST);
        }
        idServizio = (IDServizio)idServices.get(0);
        IDSoggetto soggettoFruitore = this.getFruitore(context);
        if (!idServizio.getSoggettoErogatore().equals((Object)soggettoFruitore)) {
            context.getPddContext().addObject(Costanti.ERRORE_AUTORIZZAZIONE, (Object)"true");
            throw this.newHandlerException("L'erogazione di servizio individuata con l'id servizio '" + serviceId + "' appartiene ad un soggetto '" + idServizio.getSoggettoErogatore().getNome() + "' differente dal soggetto pubblicatore '" + soggettoFruitore.getNome() + "'", IntegrationFunctionError.AUTHORIZATION_DENY);
        }
        AccordoServizioParteSpecifica asps = reader.getAccordoServizioParteSpecifica(idServizio);
        eServiceProperties = asps.getProtocolPropertyList();
        try {
            serviceId = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)eServiceProperties, (String)"modipaInfoGenEserviceId");
        }
        catch (Exception e) {
            throw this.newHandlerException("L'erogazione del servizio indicato non contiene la configurazione relativa al serviceId", IntegrationFunctionError.BAD_REQUEST);
        }
        try {
            BooleanNullable signalHub = ProtocolPropertiesUtils.getOptionalBooleanValuePropertyRegistry((List)eServiceProperties, (String)"modipaInfoGenSignalHub");
            if (signalHub == null || signalHub.getValue() == null || !signalHub.getValue().booleanValue()) {
                throw new CoreException("Non Attiva");
            }
        }
        catch (Exception e) {
            String msg = "Nell'erogazione del servizio indicato non risulta attiva la funzionalit\u00e0 Signal Hub";
            logger.error(msg + ": " + e.getMessage(), (Throwable)e);
            throw this.newHandlerException(msg, IntegrationFunctionError.BAD_REQUEST);
        }
        context.getPddContext().addObject(ModICostanti.MODIPA_KEY_INFO_SIGNAL_HUB_OBJECT_ID, (Object)objectId);
        context.getPddContext().addObject(ModICostanti.MODIPA_KEY_INFO_SIGNAL_HUB_ESERVICE_ID, (Object)serviceId);
        context.getPddContext().addObject(ModICostanti.MODIPA_KEY_INFO_SIGNAL_HUB_SERVICE, (Object)idServizio);
        context.getPddContext().addObject(ModICostanti.MODIPA_KEY_INFO_SIGNAL_HUB_OBJECT_TYPE, (Object)objectType);
        context.getPddContext().addObject(ModICostanti.MODIPA_KEY_INFO_SIGNAL_HUB_SIGNAL_TYPE, (Object)signalType);
        context.getPddContext().addObject(ModICostanti.MODIPA_KEY_INFO_SIGNAL_HUB_PROPERTIES, (Object)eServiceProperties);
    }

    private HandlerException newHandlerException(String msg, IntegrationFunctionError error) {
        HandlerException he = new HandlerException(msg);
        he.setIntegrationFunctionError(error);
        return he;
    }
}

