/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.renewal;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.renewal.LockEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RenewalTask
implements TimerTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final CommandAsyncExecutor executor;
    AtomicBoolean running = new AtomicBoolean();
    final Map<Integer, Set<String>> slot2names = new ConcurrentHashMap<Integer, Set<String>>();
    final Map<String, LockEntry> name2entry = new ConcurrentHashMap<String, LockEntry>();
    final long internalLockLeaseTime;
    final int chunkSize;

    boolean tryRun() {
        return this.running.compareAndSet(false, true);
    }

    void stop() {
        this.running.set(false);
    }

    public void schedule() {
        if (!this.running.get()) {
            return;
        }
        long internalLockLeaseTime = this.executor.getServiceManager().getCfg().getLockWatchdogTimeout();
        this.executor.getServiceManager().newTimeout(this, internalLockLeaseTime / 3L, TimeUnit.MILLISECONDS);
    }

    RenewalTask(long internalLockLeaseTime, CommandAsyncExecutor executor, int chunkSize) {
        this.executor = executor;
        this.internalLockLeaseTime = internalLockLeaseTime;
        this.chunkSize = chunkSize;
    }

    final CompletionStage<Void> execute() {
        if (this.name2entry.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (!this.executor.getServiceManager().getCfg().isClusterConfig()) {
            return this.renew(this.name2entry.keySet().iterator(), this.chunkSize);
        }
        return this.renewSlots(this.slot2names.values().iterator(), this.chunkSize);
    }

    private CompletionStage<Void> renewSlots(Iterator<Set<String>> iter, int chunkSize) {
        if (!iter.hasNext()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage<Void> c = this.renew(iter.next().iterator(), chunkSize);
        return c.thenCompose(r -> this.renewSlots(iter, chunkSize));
    }

    abstract CompletionStage<Void> renew(Iterator<String> var1, int var2);

    void cancelExpirationRenewal(String name, Long threadId) {
        LockEntry task = this.name2entry.get(name);
        if (task == null) {
            return;
        }
        if (threadId != null) {
            task.removeThreadId(threadId);
        }
        if (threadId == null || task.hasNoThreads()) {
            this.name2entry.remove(name);
            if (this.executor.getServiceManager().getCfg().isClusterConfig()) {
                int slot = this.executor.getConnectionManager().calcSlot(name);
                this.slot2names.computeIfPresent(slot, (k, v) -> {
                    v.remove(name);
                    if (v.isEmpty()) {
                        return null;
                    }
                    return v;
                });
            }
            if (!this.name2entry.isEmpty()) {
                return;
            }
            this.stop();
            if (!this.name2entry.isEmpty() && this.tryRun()) {
                this.schedule();
            }
        }
    }

    final void add(String rawName, String lockName, long threadId, LockEntry entry) {
        this.addSlotName(rawName);
        LockEntry oldEntry = this.name2entry.putIfAbsent(rawName, entry);
        if (oldEntry != null) {
            oldEntry.addThreadId(threadId, lockName);
        } else if (this.tryRun()) {
            this.schedule();
        }
    }

    void addSlotName(String rawName) {
        if (!this.executor.getServiceManager().getCfg().isClusterConfig()) {
            return;
        }
        int slot = this.executor.getConnectionManager().calcSlot(rawName);
        this.slot2names.compute(slot, (k, v) -> {
            if (v == null) {
                v = Collections.newSetFromMap(new ConcurrentHashMap());
            }
            v.add(rawName);
            return v;
        });
    }

    public void run(Timeout timeout) {
        if (this.executor.getServiceManager().isShuttingDown()) {
            return;
        }
        CompletionStage<Void> future = this.execute();
        future.whenComplete((result, e) -> {
            if (e != null) {
                this.log.error("Can't update locks {} expiration", this.name2entry.keySet(), e);
                this.schedule();
                return;
            }
            this.schedule();
        });
    }
}

