/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class TimeLongObjectDecoder
implements MultiDecoder<Long> {
    private final TimeUnit timeUnit;

    public TimeLongObjectDecoder() {
        this(null);
    }

    public TimeLongObjectDecoder(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public Long decode(List<Object> parts, State state) {
        long time = (Long)parts.get(0) * 1000L + (Long)parts.get(1) / 1000L;
        if (this.timeUnit != null) {
            return this.timeUnit.convert(time, TimeUnit.MILLISECONDS);
        }
        return time;
    }
}

