/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.redisson.LongSlotCallback;
import org.redisson.RedissonPatternTopic;
import org.redisson.ScanResult;
import org.redisson.api.AsyncIterator;
import org.redisson.api.DeletedObjectListener;
import org.redisson.api.ExpiredObjectListener;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RKeys;
import org.redisson.api.RObject;
import org.redisson.api.RType;
import org.redisson.api.listener.FlushListener;
import org.redisson.api.listener.NewObjectListener;
import org.redisson.api.listener.SetObjectListener;
import org.redisson.api.options.KeysScanOptions;
import org.redisson.api.options.KeysScanParams;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisException;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.iterator.BaseAsyncIterator;
import org.redisson.iterator.RedissonBaseIterator;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.CompositeAsyncIterator;
import org.redisson.misc.CompositeIterable;
import org.redisson.pubsub.PublishSubscribeService;
import org.redisson.reactive.CommandReactiveBatchService;
import org.redisson.rx.CommandRxBatchService;

public final class RedissonKeys
implements RKeys {
    private final CommandAsyncExecutor commandExecutor;
    private final RedisCommand<ListScanResult<String>> scan = new RedisCommand<Object>("SCAN", new ListMultiDecoder2(new ListScanResultReplayDecoder(){

        @Override
        public ListScanResult<Object> decode(List<Object> parts, State state) {
            return new ListScanResult<Object>((String)parts.get(0), RedissonKeys.this.unmap((List)parts.get(1)));
        }
    }, new ObjectListReplayDecoder()));
    private final RedisCommand<ListScanResult<Object>> binaryScan = new RedisCommand<Object>("SCAN", new ListMultiDecoder2(new ListScanResultReplayDecoder(){

        @Override
        public ListScanResult<Object> decode(List<Object> parts, State state) {
            return new ListScanResult<Object>((String)parts.get(0), (List)parts.get(1));
        }
    }, new ObjectListReplayDecoder()));
    private final RedisStrictCommand<String> randomKey = new RedisStrictCommand<String>("RANDOMKEY", new Convertor<String>(){

        @Override
        public String convert(Object obj) {
            if (obj == null) {
                return null;
            }
            return RedissonKeys.this.unmap((String)obj);
        }
    });

    public RedissonKeys(CommandAsyncExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public CommandAsyncExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public ConnectionManager getConnectionManager() {
        return this.commandExecutor.getConnectionManager();
    }

    @Override
    public RType getType(String key) {
        return this.commandExecutor.get(this.getTypeAsync(key));
    }

    @Override
    public RFuture<RType> getTypeAsync(String key) {
        return this.commandExecutor.readAsync(this.map(key), RedisCommands.TYPE, this.map(key));
    }

    @Override
    public int getSlot(String key) {
        return this.commandExecutor.get(this.getSlotAsync(key));
    }

    @Override
    public RFuture<Integer> getSlotAsync(String key) {
        return this.commandExecutor.readAsync(null, RedisCommands.KEYSLOT, this.map(key));
    }

    @Override
    public Iterable<String> getKeysByPattern(String pattern) {
        return this.getKeysByPattern(pattern, 10);
    }

    @Override
    public Iterable<String> getKeysByPattern(String pattern, int count) {
        return this.getKeys(KeysScanOptions.defaults().pattern(pattern).chunkSize(count));
    }

    public <T> Iterable<T> getKeysByPattern(RedisCommand<?> command, String pattern, int limit, int count, RType type) {
        ArrayList iterables = new ArrayList();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            Iterable iterable = () -> this.createKeysIterator(StringCodec.INSTANCE, entry, command, pattern, count, type);
            iterables.add(iterable);
        }
        return new CompositeIterable(iterables, limit);
    }

    @Override
    public Iterable<String> getKeysWithLimit(int limit) {
        return this.getKeysWithLimit(null, limit);
    }

    @Override
    public Iterable<String> getKeysWithLimit(String pattern, int limit) {
        return this.getKeys(KeysScanOptions.defaults().pattern(pattern).limit(limit));
    }

    @Override
    public Iterable<String> getKeys() {
        return this.getKeys(KeysScanOptions.defaults());
    }

    @Override
    public AsyncIterator<String> getKeysAsync() {
        return this.getKeysAsync(KeysScanOptions.defaults());
    }

    @Override
    public Iterable<String> getKeys(KeysScanOptions options) {
        KeysScanParams params = (KeysScanParams)options;
        return this.getKeysByPattern(this.scan, params.getPattern(), params.getLimit(), params.getChunkSize(), params.getType());
    }

    @Override
    public AsyncIterator<String> getKeysAsync(KeysScanOptions options) {
        final KeysScanParams params = (KeysScanParams)options;
        ArrayList asyncIterators = new ArrayList();
        for (final MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            BaseAsyncIterator<String, Object> asyncIterator = new BaseAsyncIterator<String, Object>(){

                @Override
                protected RFuture<ScanResult<Object>> iterator(RedisClient client, String nextItPos) {
                    return RedissonKeys.this.scanIteratorAsync(StringCodec.INSTANCE, client, entry, RedissonKeys.this.scan, nextItPos, params.getPattern(), params.getChunkSize(), params.getType());
                }
            };
            asyncIterators.add(asyncIterator);
        }
        return new CompositeAsyncIterator<String>(asyncIterators, params.getLimit());
    }

    @Override
    public Iterable<String> getKeys(int count) {
        return this.getKeysByPattern(null, count);
    }

    private RFuture<ScanResult<Object>> scanIteratorAsync(Codec codec, RedisClient client, MasterSlaveEntry entry, RedisCommand<?> command, String startPos, String pattern, int count, RType type) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(startPos);
        if (pattern != null) {
            pattern = this.map(pattern);
            args.add("MATCH");
            args.add(pattern);
        }
        if (count > 0) {
            args.add("COUNT");
            args.add(count);
        }
        if (type != null) {
            args.add("TYPE");
            args.add(type.getValue());
        }
        return this.commandExecutor.readAsync(client, entry, codec, command, args.toArray());
    }

    public RFuture<ScanResult<Object>> scanIteratorAsync(RedisClient client, MasterSlaveEntry entry, String startPos, String pattern, int count, RType type) {
        return this.scanIteratorAsync(StringCodec.INSTANCE, client, entry, this.scan, startPos, pattern, count, type);
    }

    private <T> Iterator<T> createKeysIterator(final Codec codec, final MasterSlaveEntry entry, final RedisCommand<?> command, final String pattern, final int count, final RType type) {
        return new RedissonBaseIterator<T>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, String nextIterPos) {
                return (ScanResult)RedissonKeys.this.commandExecutor.get(RedissonKeys.this.scanIteratorAsync(codec, client, entry, command, nextIterPos, pattern, count, type));
            }

            @Override
            protected void remove(Object value) {
                RedissonKeys.this.delete((String)value);
            }
        };
    }

    @Override
    public long touch(String ... names) {
        return this.commandExecutor.get(this.touchAsync(names));
    }

    @Override
    public RFuture<Long> touchAsync(String ... names) {
        if (names.length == 0) {
            return new CompletableFutureWrapper<Long>(0L);
        }
        return this.commandExecutor.writeBatchedAsync(null, RedisCommands.TOUCH_LONG, new LongSlotCallback(), this.map(names));
    }

    @Override
    public long countExists(String ... names) {
        return this.commandExecutor.get(this.countExistsAsync(names));
    }

    @Override
    public RFuture<Long> countExistsAsync(String ... names) {
        if (names.length == 0) {
            return new CompletableFutureWrapper<Long>(0L);
        }
        return this.commandExecutor.readBatchedAsync(StringCodec.INSTANCE, RedisCommands.EXISTS_LONG, new LongSlotCallback(), this.map(names));
    }

    @Override
    public String randomKey() {
        return this.commandExecutor.get(this.randomKeyAsync());
    }

    @Override
    public RFuture<String> randomKeyAsync() {
        return this.commandExecutor.readRandomAsync(StringCodec.INSTANCE, this.randomKey, new Object[0]);
    }

    @Override
    public long deleteByPattern(String pattern) {
        return this.commandExecutor.get(this.deleteByPatternAsync(pattern));
    }

    @Override
    public RFuture<Long> deleteByPatternAsync(String pattern) {
        return this.eraseByPatternAsync(RedisCommands.DEL, pattern);
    }

    @Override
    public long unlinkByPattern(String pattern) {
        return this.commandExecutor.get(this.unlinkByPatternAsync(pattern));
    }

    @Override
    public RFuture<Long> unlinkByPatternAsync(String pattern) {
        return this.eraseByPatternAsync(RedisCommands.UNLINK, pattern);
    }

    private RFuture<Long> eraseByPatternAsync(RedisStrictCommand command, String pattern) {
        Function<Object[], Long> delegate = keys -> this.commandExecutor.get(this.commandExecutor.writeBatchedAsync(null, command, new LongSlotCallback(), keys));
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            if (this.commandExecutor.getServiceManager().getCfg().isClusterConfig()) {
                throw new IllegalStateException("This method doesn't work in batch for Redis cluster mode. For Redis cluster execute it as non-batch method");
            }
            return this.commandExecutor.evalWriteAsync((String)null, null, RedisCommands.EVAL_LONG, "local keys = redis.call('keys', ARGV[1]) local n = 0 for i=1, #keys,5000 do n = n + redis.call(ARGV[2], unpack(keys, i, math.min(i+4999, table.getn(keys)))) end return n;", Collections.emptyList(), pattern, command.getName());
        }
        int batchSize = 500;
        ArrayList futures = new ArrayList();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            CompletableFuture future = new CompletableFuture();
            futures.add(future);
            this.commandExecutor.getServiceManager().getExecutor().execute(() -> {
                long count = 0L;
                try {
                    Iterator keysIterator = this.createKeysIterator(ByteArrayCodec.INSTANCE, entry, this.binaryScan, pattern, batchSize, null);
                    ArrayList keys = new ArrayList();
                    while (keysIterator.hasNext()) {
                        Object key = keysIterator.next();
                        keys.add(key);
                        if (keys.size() % batchSize != 0) continue;
                        count += ((Long)delegate.apply(keys.toArray())).longValue();
                        keys.clear();
                    }
                    if (!keys.isEmpty()) {
                        count += ((Long)delegate.apply(keys.toArray())).longValue();
                        keys.clear();
                    }
                    future.complete(count);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            });
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage res = future.handle((r, e) -> {
            long cc = futures.stream().filter(f -> f.isDone()).mapToLong(f -> f.getNow(0L)).sum();
            if (e != null) {
                if (cc > 0L) {
                    RedisException ex = new RedisException(cc + " keys have been deleted. But one or more nodes has an error", (Throwable)e);
                    throw new CompletionException(ex);
                }
                throw new CompletionException((Throwable)e);
            }
            return cc;
        });
        return new CompletableFutureWrapper<Long>((CompletableFuture<Long>)res);
    }

    @Override
    public long delete(String ... keys) {
        return this.commandExecutor.get(this.deleteAsync(keys));
    }

    @Override
    public long delete(RObject ... objects) {
        return this.commandExecutor.get(this.deleteAsync(objects));
    }

    @Override
    public RFuture<Long> deleteAsync(RObject ... objects) {
        ArrayList<String> keys = new ArrayList<String>();
        for (RObject obj : objects) {
            keys.add(obj.getName());
        }
        return this.deleteAsync(keys.toArray(new String[0]));
    }

    @Override
    public long unlink(String ... keys) {
        return this.commandExecutor.get(this.unlinkAsync(keys));
    }

    @Override
    public RFuture<Long> unlinkAsync(String ... keys) {
        if (keys.length == 0) {
            return new CompletableFutureWrapper<Long>(0L);
        }
        return this.commandExecutor.writeBatchedAsync(null, RedisCommands.UNLINK, new LongSlotCallback(), this.map(keys));
    }

    @Override
    public RFuture<Long> deleteAsync(String ... keys) {
        if (keys.length == 0) {
            return new CompletableFutureWrapper<Long>(0L);
        }
        return this.commandExecutor.writeBatchedAsync(null, RedisCommands.DEL, new LongSlotCallback(), this.map(keys));
    }

    private String map(String key) {
        return this.commandExecutor.getServiceManager().getConfig().getNameMapper().map(key);
    }

    private String unmap(String key) {
        return this.commandExecutor.getServiceManager().getConfig().getNameMapper().unmap(key);
    }

    private List<String> unmap(List<String> keys) {
        return keys.stream().map((? super T k) -> this.commandExecutor.getServiceManager().getConfig().getNameMapper().unmap((String)k)).collect(Collectors.toList());
    }

    private String[] map(String[] keys) {
        return (String[])Arrays.stream(keys).map((? super T k) -> this.commandExecutor.getServiceManager().getConfig().getNameMapper().map((String)k)).toArray(String[]::new);
    }

    @Override
    public long count() {
        return this.commandExecutor.get(this.countAsync());
    }

    @Override
    public RFuture<Long> countAsync() {
        List futures = this.commandExecutor.readAllAsync(RedisCommands.DBSIZE, new Object[0]);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> futures.stream().mapToLong(v -> v.getNow(0L)).sum());
        return new CompletableFutureWrapper<Long>((CompletableFuture<Long>)s);
    }

    @Override
    public void flushdbParallel() {
        this.commandExecutor.get(this.flushdbParallelAsync());
    }

    @Override
    public RFuture<Void> flushdbParallelAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FLUSHDB_ASYNC, new Object[0]);
    }

    @Override
    public void flushallParallel() {
        this.commandExecutor.get(this.flushallParallelAsync());
    }

    @Override
    public RFuture<Void> flushallParallelAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FLUSHALL_ASYNC, new Object[0]);
    }

    @Override
    public void flushdb() {
        this.commandExecutor.get(this.flushdbAsync());
    }

    @Override
    public RFuture<Void> flushdbAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FLUSHDB, new Object[0]);
    }

    @Override
    public void flushall() {
        this.commandExecutor.get(this.flushallAsync());
    }

    @Override
    public RFuture<Void> flushallAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FLUSHALL, new Object[0]);
    }

    @Override
    public long remainTimeToLive(String name) {
        return this.commandExecutor.get(this.remainTimeToLiveAsync(name));
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync(String name) {
        return this.commandExecutor.readAsync(this.map(name), (Codec)StringCodec.INSTANCE, RedisCommands.PTTL, this.map(name));
    }

    @Override
    public void rename(String currentName, String newName) {
        this.commandExecutor.get(this.renameAsync(currentName, newName));
    }

    @Override
    public RFuture<Void> renameAsync(String currentName, String newName) {
        return this.commandExecutor.writeAsync(this.map(currentName), RedisCommands.RENAME, this.map(currentName), this.map(newName));
    }

    @Override
    public boolean renamenx(String oldName, String newName) {
        return this.commandExecutor.get(this.renamenxAsync(oldName, newName));
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String oldName, String newName) {
        return this.commandExecutor.writeAsync(this.map(oldName), RedisCommands.RENAMENX, this.map(oldName), this.map(newName));
    }

    @Override
    public boolean clearExpire(String name) {
        return this.commandExecutor.get(this.clearExpireAsync(name));
    }

    @Override
    public RFuture<Boolean> clearExpireAsync(String name) {
        return this.commandExecutor.writeAsync(this.map(name), (Codec)StringCodec.INSTANCE, RedisCommands.PERSIST, this.map(name));
    }

    @Override
    public boolean expireAt(String name, long timestamp) {
        return this.commandExecutor.get(this.expireAtAsync(name, timestamp));
    }

    @Override
    public RFuture<Boolean> expireAtAsync(String name, long timestamp) {
        return this.commandExecutor.writeAsync(this.map(name), (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIREAT, this.map(name), timestamp);
    }

    @Override
    public boolean expire(String name, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.get(this.expireAsync(name, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> expireAsync(String name, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.writeAsync(this.map(name), (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIRE, this.map(name), timeUnit.toMillis(timeToLive));
    }

    @Override
    public void migrate(String name, String host, int port, int database, long timeout) {
        this.commandExecutor.get(this.migrateAsync(name, host, port, database, timeout));
    }

    @Override
    public RFuture<Void> migrateAsync(String name, String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(this.map(name), RedisCommands.MIGRATE, host, port, this.map(name), database, timeout);
    }

    @Override
    public void copy(String name, String host, int port, int database, long timeout) {
        this.commandExecutor.get(this.copyAsync(name, host, port, database, timeout));
    }

    @Override
    public RFuture<Void> copyAsync(String name, String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(this.map(name), RedisCommands.MIGRATE, host, port, this.map(name), database, timeout, "COPY");
    }

    @Override
    public boolean move(String name, int database) {
        return this.commandExecutor.get(this.moveAsync(name, database));
    }

    @Override
    public RFuture<Boolean> moveAsync(String name, int database) {
        return this.commandExecutor.writeAsync(this.map(name), RedisCommands.MOVE, this.map(name), database);
    }

    @Override
    public Stream<String> getKeysStreamByPattern(String pattern) {
        return this.toStream(this.getKeysByPattern(pattern).iterator());
    }

    protected <T> Stream<T> toStream(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return StreamSupport.stream(spliterator, false);
    }

    @Override
    public Stream<String> getKeysStreamByPattern(String pattern, int count) {
        return this.toStream(this.getKeysByPattern(pattern, count).iterator());
    }

    @Override
    public Stream<String> getKeysStream() {
        return this.toStream(this.getKeys().iterator());
    }

    @Override
    public Stream<String> getKeysStream(KeysScanOptions options) {
        return this.toStream(this.getKeys(options).iterator());
    }

    @Override
    public Stream<String> getKeysStream(int count) {
        return this.toStream(this.getKeys(count).iterator());
    }

    @Override
    public void swapdb(int db1, int db2) {
        this.commandExecutor.get(this.swapdbAsync(db1, db2));
    }

    @Override
    public RFuture<Void> swapdbAsync(int db1, int db2) {
        return this.commandExecutor.writeAsync(null, RedisCommands.SWAPDB, db1, db2);
    }

    @Override
    public int addListener(ObjectListener listener) {
        return this.commandExecutor.get(this.addListenerAsync(listener));
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof NewObjectListener) {
            return this.addListenerAsync("__keyevent@*:new", (NewObjectListener)listener, NewObjectListener::onNew);
        }
        if (listener instanceof SetObjectListener) {
            return this.addListenerAsync("__keyevent@*:set", (SetObjectListener)listener, SetObjectListener::onSet);
        }
        if (listener instanceof ExpiredObjectListener) {
            return this.addListenerAsync("__keyevent@*:expired", (ExpiredObjectListener)listener, ExpiredObjectListener::onExpired);
        }
        if (listener instanceof DeletedObjectListener) {
            return this.addListenerAsync("__keyevent@*:del", (DeletedObjectListener)listener, DeletedObjectListener::onDeleted);
        }
        if (listener instanceof FlushListener) {
            if (!this.commandExecutor.getServiceManager().isResp3()) {
                throw new IllegalStateException("`protocol` config setting should be set to RESP3 value");
            }
            PublishSubscribeService subscribeService = this.commandExecutor.getConnectionManager().getSubscribeService();
            CompletableFuture<Integer> r = subscribeService.subscribe(this.commandExecutor, (FlushListener)listener);
            return new CompletableFutureWrapper<Integer>(r);
        }
        throw new IllegalArgumentException();
    }

    private <T extends ObjectListener> RFuture<Integer> addListenerAsync(String name, T listener, BiConsumer<T, String> consumer) {
        RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, name);
        return topic.addListenerAsync(String.class, (pattern, channel, msg) -> consumer.accept(listener, (String)msg));
    }

    @Override
    public void removeListener(int listenerId) {
        this.commandExecutor.get(this.removeListenerAsync(listenerId));
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        PublishSubscribeService subscribeService = this.commandExecutor.getConnectionManager().getSubscribeService();
        CompletionStage<Void> f = subscribeService.removeFlushListenerAsync(listenerId);
        f = f.thenCompose(r -> this.removeListenerAsync(null, listenerId, "__keyevent@*:expired", "__keyevent@*:del", "__keyevent@*:set", "__keyevent@*:new"));
        return new CompletableFutureWrapper<Void>((CompletableFuture<Void>)f);
    }

    private RFuture<Void> removeListenerAsync(RFuture<Void> future, int listenerId, String ... names) {
        ArrayList futures = new ArrayList(names.length + 1);
        if (future != null) {
            futures.add(future.toCompletableFuture());
        }
        for (String name : names) {
            RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, name);
            RFuture<Void> f1 = topic.removeListenerAsync(listenerId);
            futures.add(f1.toCompletableFuture());
        }
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return new CompletableFutureWrapper<Void>(f);
    }
}

