/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.security;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.openspcoop2.web.lib.mvc.security.exception.ValidationException;
import org.slf4j.Logger;

public class SecurityWrappedHttpServletResponse
extends HttpServletResponseWrapper
implements HttpServletResponse {
    private Logger log;
    private Validatore validator;

    public SecurityWrappedHttpServletResponse(HttpServletResponse httpServletResponse, Logger log) {
        super(httpServletResponse);
        this.log = log;
        this.validator = Validatore.getInstance();
    }

    private HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)super.getResponse();
    }

    public void flushBuffer() throws IOException {
        this.getHttpServletResponse().flushBuffer();
    }

    public int getBufferSize() {
        return this.getHttpServletResponse().getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.getHttpServletResponse().getCharacterEncoding();
    }

    public String getContentType() {
        return this.getHttpServletResponse().getContentType();
    }

    public Locale getLocale() {
        return this.getHttpServletResponse().getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.getHttpServletResponse().getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.getHttpServletResponse().getWriter();
    }

    public boolean isCommitted() {
        return this.getHttpServletResponse().isCommitted();
    }

    public void reset() {
        this.getHttpServletResponse().reset();
    }

    public void resetBuffer() {
        this.getHttpServletResponse().resetBuffer();
    }

    public void setBufferSize(int arg0) {
        this.getHttpServletResponse().setBufferSize(arg0);
    }

    public void setCharacterEncoding(String arg0) {
        this.getHttpServletResponse().setCharacterEncoding(arg0);
    }

    public void setContentLength(int arg0) {
        this.getHttpServletResponse().setContentLength(arg0);
    }

    public void setContentType(String arg0) {
        this.getHttpServletResponse().setContentType(arg0);
    }

    public void setLocale(Locale arg0) {
        this.getHttpServletResponse().setLocale(arg0);
    }

    public void addCookie(Cookie cookie) {
        this.getHttpServletResponse().addCookie(cookie);
    }

    public void addDateHeader(String arg0, long arg1) {
        this.getHttpServletResponse().addDateHeader(arg0, arg1);
    }

    public void addHeader(String arg0, String arg1) {
        String strippedValue = SecurityWrappedHttpServletResponse.stripControls(arg1);
        String safeValue = null;
        try {
            safeValue = this.validator.validate("Il valore dell'Header [" + arg0 + "]:[" + arg1 + "]", strippedValue, null, false, "ResponseHTTPHeaderValue");
        }
        catch (ValidationException e) {
            this.log.warn("Impossibile impostare un header con il valore errato [" + arg0 + "]: " + e.getMessage(), (Throwable)e);
        }
        boolean validValue = SecurityWrappedHttpServletResponse.notNullOrEmpty(safeValue, true);
        if (validValue) {
            this.getHttpServletResponse().addHeader(arg0, safeValue);
        }
    }

    public void addIntHeader(String arg0, int arg1) {
        this.getHttpServletResponse().addIntHeader(arg0, arg1);
    }

    public boolean containsHeader(String arg0) {
        return this.getHttpServletResponse().containsHeader(arg0);
    }

    public String encodeRedirectURL(String arg0) {
        return this.getHttpServletResponse().encodeRedirectURL(arg0);
    }

    public String encodeRedirectUrl(String arg0) {
        return this.getHttpServletResponse().encodeRedirectURL(arg0);
    }

    public String encodeURL(String arg0) {
        return this.getHttpServletResponse().encodeURL(arg0);
    }

    public String encodeUrl(String arg0) {
        return this.getHttpServletResponse().encodeURL(arg0);
    }

    public void sendError(int arg0) throws IOException {
        this.getHttpServletResponse().sendError(arg0);
    }

    public void sendError(int arg0, String arg1) throws IOException {
        this.getHttpServletResponse().sendError(arg0, arg1);
    }

    public void sendRedirect(String arg0) throws IOException {
        this.getHttpServletResponse().sendRedirect(arg0);
    }

    public void setDateHeader(String arg0, long arg1) {
        this.getHttpServletResponse().setDateHeader(arg0, arg1);
    }

    public void setHeader(String arg0, String arg1) {
        String strippedValue = SecurityWrappedHttpServletResponse.stripControls(arg1);
        String safeValue = null;
        try {
            safeValue = this.validator.validate("Il valore dell'Header [" + arg0 + "]:[" + arg1 + "]", strippedValue, null, false, "ResponseHTTPHeaderValue");
        }
        catch (ValidationException e) {
            this.log.warn("Impossibile impostare un header con il valore errato [" + arg0 + "]: " + e.getMessage(), (Throwable)e);
        }
        boolean validValue = SecurityWrappedHttpServletResponse.notNullOrEmpty(safeValue, true);
        if (validValue) {
            this.getHttpServletResponse().setHeader(arg0, safeValue);
        }
    }

    public void setIntHeader(String arg0, int arg1) {
        this.getHttpServletResponse().setIntHeader(arg0, arg1);
    }

    public void setStatus(int arg0) {
        this.getHttpServletResponse().setStatus(arg0);
    }

    public void setStatus(int arg0, String arg1) {
        if (arg1 != null) {
            // empty if block
        }
        this.getHttpServletResponse().setStatus(arg0);
    }

    public void setContentLengthLong(long arg0) {
        this.getHttpServletResponse().setContentLengthLong(arg0);
    }

    public String getHeader(String arg0) {
        String value = this.getHttpServletResponse().getHeader(arg0);
        if (value != null) {
            try {
                return this.validator.validate("Il valore dell'Header [" + arg0 + "]:[" + value + "]", value, null, true, "ResponseHTTPHeaderValue");
            }
            catch (ValidationException e) {
                this.log.warn("Errore di validazione: " + e.getMessage(), (Throwable)e);
                return "";
            }
        }
        return null;
    }

    public Collection<String> getHeaderNames() {
        return this.getHttpServletResponse().getHeaderNames();
    }

    public Collection<String> getHeaders(String arg0) {
        ArrayList<String> v = new ArrayList<String>();
        Collection headers = this.getHttpServletResponse().getHeaders(arg0);
        ArrayList lst = new ArrayList();
        if (headers != null && !headers.isEmpty()) {
            lst.addAll(headers);
        }
        for (String value : lst) {
            try {
                v.add(this.validator.validate("Il valore dell'Header [" + arg0 + "]:[" + value + "]", value, null, true, "RequestHTTPHeaderValue"));
            }
            catch (ValidationException e) {
                this.log.warn("Errore di validazione: " + e.getMessage(), (Throwable)e);
            }
        }
        return v;
    }

    public int getStatus() {
        return this.getHttpServletResponse().getStatus();
    }

    public static String stripControls(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c > ' ' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public static boolean notNullOrEmpty(String str, boolean trim) {
        if (trim) {
            return str != null && !str.trim().equals("");
        }
        return str != null && !str.equals("");
    }
}

