/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.security;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.security.SecurityProperties;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.openspcoop2.web.lib.mvc.security.exception.ValidationException;
import org.slf4j.Logger;

public class SecurityWrappedHttpServletRequest
extends HttpServletRequestWrapper
implements HttpServletRequest {
    private Logger log;
    private SecurityProperties sc;
    private Validatore validator;
    private Integer headerNameMaxLength = 256;
    private Integer queryParamNameMaxLength = 256;
    private static String PREFIX_ERROR_PARAMETER = "Il valore del parametro [";

    public SecurityWrappedHttpServletRequest(HttpServletRequest httpServletRequest, Logger log) {
        super(httpServletRequest);
        this.log = log;
        this.sc = SecurityProperties.getInstance();
        this.validator = Validatore.getInstance();
        try {
            this.headerNameMaxLength = this.sc.getIntProp("request.headerNameMaxLength");
            this.queryParamNameMaxLength = this.sc.getIntProp("request.queryParamNameMaxLength");
        }
        catch (UtilsException e) {
            this.log.error("Errore durante la lettura delle properties: " + e.getMessage(), (Throwable)e);
        }
    }

    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    public int getContentLength() {
        return this.getHttpServletRequest().getContentLength();
    }

    public String getContentType() {
        return this.getHttpServletRequest().getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.getHttpServletRequest().getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.getHttpServletRequest().getReader();
    }

    public String getOriginalParameter(String key) {
        String value = this.getHttpServletRequest().getParameter(key);
        boolean usaValidazioneTextArea = ServletUtils.usaValidazioneTextArea(this.getHttpServletRequest(), key);
        return this.validator.getParametroSanificato(value, usaValidazioneTextArea);
    }

    public String getParameter(String key) {
        String val = this.getHttpServletRequest().getParameter(key);
        if (val != null) {
            try {
                boolean usaValidazioneTextArea = ServletUtils.usaValidazioneTextArea(this.getHttpServletRequest(), key);
                val = this.validator.getParametroSanificato(val, usaValidazioneTextArea);
                String pattern = usaValidazioneTextArea ? "HTTPParameterValueTextArea" : "HTTPParameterValue";
                return this.validator.validate(PREFIX_ERROR_PARAMETER + key + "]:[" + val + "]", val, null, true, !usaValidazioneTextArea, pattern);
            }
            catch (ValidationException e) {
                this.log.warn("Errore di validazione: {}", (Object)e.getMessage(), (Object)e);
                return "";
            }
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        Map map = this.getHttpServletRequest().getParameterMap();
        HashMap<String, String[]> cleanMap = new HashMap<String, String[]>();
        for (Map.Entry entry : map.entrySet()) {
            try {
                String name = (String)entry.getKey();
                boolean usaValidazioneTextArea = ServletUtils.usaValidazioneTextArea(this.getHttpServletRequest(), name);
                String pattern = usaValidazioneTextArea ? "HTTPParameterValueTextArea" : "HTTPParameterValue";
                String cleanName = this.validator.validate("Il nome del parametro [" + name + "]", name, this.queryParamNameMaxLength, true, "HTTPParameterName");
                String[] value = (String[])entry.getValue();
                String[] cleanValues = new String[value.length];
                for (int j = 0; j < value.length; ++j) {
                    String cleanValue;
                    String val = this.validator.getParametroSanificato(value[j], usaValidazioneTextArea);
                    cleanValues[j] = cleanValue = this.validator.validate(PREFIX_ERROR_PARAMETER + name + "]:[" + val + "]", val, null, true, !usaValidazioneTextArea, pattern);
                }
                cleanMap.put(cleanName, cleanValues);
            }
            catch (ValidationException e) {
                this.log.warn("Errore di validazione: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return cleanMap;
    }

    public Enumeration<String> getParameterNames() {
        ArrayList<String> v = new ArrayList<String>();
        Enumeration en = this.getHttpServletRequest().getParameterNames();
        while (en.hasMoreElements()) {
            try {
                String name = (String)en.nextElement();
                String clean = this.validator.validate("Il nome del parametro [" + name + "]", name, this.queryParamNameMaxLength, true, "HTTPParameterName");
                v.add(clean);
            }
            catch (ValidationException e) {
                this.log.warn("Errore di validazione: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return Collections.enumeration(v);
    }

    public String[] getParameterValues(String arg0) {
        String[] values = this.getHttpServletRequest().getParameterValues(arg0);
        if (values == null) {
            return values;
        }
        ArrayList<String> newValues = new ArrayList<String>();
        boolean usaValidazioneTextArea = ServletUtils.usaValidazioneTextArea(this.getHttpServletRequest(), arg0);
        String pattern = usaValidazioneTextArea ? "HTTPParameterValueTextArea" : "HTTPParameterValue";
        for (String value : values) {
            try {
                String val = this.validator.getParametroSanificato(value, usaValidazioneTextArea);
                newValues.add(this.validator.validate(PREFIX_ERROR_PARAMETER + arg0 + "]:[" + val + "]", val, null, true, !usaValidazioneTextArea, pattern));
            }
            catch (ValidationException e) {
                this.log.warn("Errore di validazione: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return newValues.toArray(new String[newValues.size()]);
    }

    public String getRequestURI() {
        return this.getHttpServletRequest().getRequestURI();
    }

    public String getContextPath() {
        return this.getHttpServletRequest().getContextPath();
    }

    public String getPathInfo() {
        return this.getHttpServletRequest().getPathInfo();
    }

    public String getPathTranslated() {
        return this.getHttpServletRequest().getPathTranslated();
    }

    public String getQueryString() {
        return this.getHttpServletRequest().getQueryString();
    }

    public StringBuffer getRequestURL() {
        return this.getHttpServletRequest().getRequestURL();
    }

    public String getServletPath() {
        return this.getHttpServletRequest().getServletPath();
    }

    public String getRealPath(String arg0) {
        if (arg0 != null) {
            return this.getHttpServletRequest().getContextPath();
        }
        return null;
    }

    public Object getAttribute(String arg0) {
        return this.getHttpServletRequest().getAttribute(arg0);
    }

    public Enumeration<String> getAttributeNames() {
        return this.getHttpServletRequest().getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.getHttpServletRequest().getCharacterEncoding();
    }

    public String getLocalAddr() {
        return this.getHttpServletRequest().getLocalAddr();
    }

    public String getLocalName() {
        return this.getHttpServletRequest().getLocalName();
    }

    public int getLocalPort() {
        return this.getHttpServletRequest().getLocalPort();
    }

    public Locale getLocale() {
        return this.getHttpServletRequest().getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.getHttpServletRequest().getLocales();
    }

    public String getProtocol() {
        return this.getHttpServletRequest().getProtocol();
    }

    public String getRemoteAddr() {
        return this.getHttpServletRequest().getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.getHttpServletRequest().getRemoteHost();
    }

    public int getRemotePort() {
        return this.getHttpServletRequest().getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return this.getHttpServletRequest().getRequestDispatcher(arg0);
    }

    public String getScheme() {
        return this.getHttpServletRequest().getScheme();
    }

    public String getServerName() {
        return this.getHttpServletRequest().getServerName();
    }

    public int getServerPort() {
        return this.getHttpServletRequest().getServerPort();
    }

    public boolean isSecure() {
        return this.getHttpServletRequest().isSecure();
    }

    public void removeAttribute(String arg0) {
        this.getHttpServletRequest().removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.getHttpServletRequest().setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.getHttpServletRequest().setCharacterEncoding(arg0);
    }

    public String getAuthType() {
        return this.getHttpServletRequest().getAuthType();
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies == null) {
            return new Cookie[0];
        }
        ArrayList<Cookie> newCookies = new ArrayList<Cookie>();
        for (Cookie c : cookies) {
            try {
                String name = this.validator.validate("Il nome del Cookie [" + c.getName() + "]", c.getName(), this.headerNameMaxLength, false, "HTTPCookieName");
                String value = this.validator.validate("Il valore del Cookie [" + c.getName() + "]:[" + c.getValue() + "]", c.getValue(), null, true, "HTTPCookieValue");
                int maxAge = c.getMaxAge();
                String domain = c.getDomain();
                String path = c.getPath();
                Cookie n = new Cookie(name, value);
                n.setMaxAge(maxAge);
                if (domain != null) {
                    n.setDomain(this.validator.validate("Il domain del Cookie [" + c.getName() + "]:[" + domain + "]", domain, null, false, "ResponseHTTPHeaderValue"));
                }
                if (path != null) {
                    n.setPath(this.validator.validate("Il path del Cookie [" + c.getName() + "]:[" + path + "]", path, null, false, "ResponseHTTPHeaderValue"));
                }
                newCookies.add(n);
            }
            catch (ValidationException e) {
                this.log.warn("Ignoro cookie malformato: {}={}", new Object[]{c.getName(), c.getValue(), e});
            }
        }
        return newCookies.toArray(new Cookie[newCookies.size()]);
    }

    public long getDateHeader(String arg0) {
        return this.getHttpServletRequest().getDateHeader(arg0);
    }

    public String getHeader(String name) {
        String value = this.getHttpServletRequest().getHeader(name);
        if (value != null) {
            try {
                value = this.validator.getParametroSanificato(value, false);
                return this.validator.validate("Il valore dell'Header [" + name + "]:[" + value + "]", value, null, true, "RequestHTTPHeaderValue");
            }
            catch (ValidationException e) {
                this.log.warn("Errore di validazione: {}", (Object)e.getMessage(), (Object)e);
                return "";
            }
        }
        return null;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList<String> v = new ArrayList<String>();
        Enumeration en = this.getHttpServletRequest().getHeaderNames();
        while (en.hasMoreElements()) {
            try {
                String name = (String)en.nextElement();
                String validValue = this.validator.validate("Il nome dell'Header [" + name + "]", name, null, true, "RequestHTTPHeaderName");
                v.add(validValue);
            }
            catch (ValidationException e) {
                this.log.warn("Errore di validazione: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return Collections.enumeration(v);
    }

    public Enumeration<String> getHeaders(String arg0) {
        ArrayList<String> v = new ArrayList<String>();
        Enumeration en = this.getHttpServletRequest().getHeaders(arg0);
        while (en.hasMoreElements()) {
            try {
                String value = (String)en.nextElement();
                value = this.validator.getParametroSanificato(value, false);
                v.add(this.validator.validate("Il valore dell'Header [" + arg0 + "]:[" + value + "]", value, null, true, "RequestHTTPHeaderValue"));
            }
            catch (ValidationException e) {
                this.log.warn("Errore di validazione: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return Collections.enumeration(v);
    }

    public int getIntHeader(String arg0) {
        return this.getHttpServletRequest().getIntHeader(arg0);
    }

    public String getMethod() {
        return this.getHttpServletRequest().getMethod();
    }

    public String getRemoteUser() {
        return this.getHttpServletRequest().getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.getHttpServletRequest().getRequestedSessionId();
    }

    public HttpSession getSession() {
        return this.getHttpServletRequest().getSession();
    }

    public HttpSession getSession(boolean arg0) {
        return this.getHttpServletRequest().getSession(arg0);
    }

    public Principal getUserPrincipal() {
        return this.getHttpServletRequest().getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getHttpServletRequest().isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getHttpServletRequest().isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.getHttpServletRequest().isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.getHttpServletRequest().isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String arg0) {
        return this.getHttpServletRequest().isUserInRole(arg0);
    }

    public AsyncContext getAsyncContext() {
        return this.getHttpServletRequest().getAsyncContext();
    }

    public long getContentLengthLong() {
        return this.getHttpServletRequest().getContentLengthLong();
    }

    public DispatcherType getDispatcherType() {
        return this.getHttpServletRequest().getDispatcherType();
    }

    public ServletContext getServletContext() {
        return this.getHttpServletRequest().getServletContext();
    }

    public boolean isAsyncStarted() {
        return this.getHttpServletRequest().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.getHttpServletRequest().isAsyncSupported();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.getHttpServletRequest().startAsync();
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        return this.getHttpServletRequest().startAsync(arg0, arg1);
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return this.getHttpServletRequest().authenticate(arg0);
    }

    public String changeSessionId() {
        return this.getHttpServletRequest().changeSessionId();
    }

    public Part getPart(String arg0) throws IOException, ServletException {
        return this.getHttpServletRequest().getPart(arg0);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.getHttpServletRequest().getParts();
    }

    public void login(String arg0, String arg1) throws ServletException {
        this.getHttpServletRequest().login(arg0, arg1);
    }

    public void logout() throws ServletException {
        this.getHttpServletRequest().logout();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        return (T)this.getHttpServletRequest().upgrade(arg0);
    }
}

