/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.properties.beans;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openspcoop2.core.mvc.properties.Conditions;
import org.openspcoop2.core.mvc.properties.Item;
import org.openspcoop2.core.mvc.properties.ItemValue;
import org.openspcoop2.core.mvc.properties.ItemValues;
import org.openspcoop2.core.mvc.properties.Property;
import org.openspcoop2.core.mvc.properties.constants.ItemType;
import org.openspcoop2.core.mvc.properties.provider.ExternalResources;
import org.openspcoop2.core.mvc.properties.provider.IProvider;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderInfo;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementInfo;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.byok.LockUtilities;
import org.openspcoop2.web.lib.mvc.properties.beans.BaseItemBean;
import org.openspcoop2.web.lib.mvc.properties.beans.ConfigBean;
import org.openspcoop2.web.lib.mvc.properties.exception.UserInputValidationException;

public class ItemBean
extends BaseItemBean<Item> {
    public ItemBean(Item item, String name, IProvider provider) {
        super(item, name, provider);
    }

    @Override
    public void init(String value, ExternalResources externalResources) throws ProviderException {
        if (value == null) {
            switch (((Item)this.getItem()).getType()) {
                case CHECKBOX: {
                    this.value = ((Item)this.getItem()).getDefaultSelected() ? "yes" : "no";
                    break;
                }
                case HIDDEN: 
                case LOCK_HIDDEN: {
                    this.value = ((Item)this.getItem()).getValue();
                    break;
                }
                default: {
                    if (StringUtils.isNotEmpty((CharSequence)((Item)this.getItem()).getDefault())) {
                        this.value = ((Item)this.getItem()).getDefault();
                        break;
                    }
                    if (this.provider != null) {
                        this.value = this.provider.getDefault(this.name, externalResources);
                        break;
                    }
                    this.value = null;
                    break;
                }
            }
        } else {
            switch (((Item)this.getItem()).getType()) {
                case CHECKBOX: {
                    this.value = this.getCheckBoxValue(value);
                    break;
                }
                default: {
                    this.value = value;
                }
            }
        }
    }

    @Override
    public DataElement toDataElement(ConfigBean config, Map<String, String> mapNameValue, ExternalResources externalResources, LockUtilities lockUtilities) throws ProviderException {
        if (this.provider != null) {
            this.value = this.provider.dynamicUpdate(config.getListaItemSDK(), mapNameValue, (Item)this.getItem(), this.value, externalResources);
        }
        mapNameValue.put(this.name, this.value);
        DataElement de = new DataElement();
        de.setName(this.getName());
        de.setLabel(((Item)this.getItem()).getLabel());
        de.setPostBack_viaPOST(true);
        de.setRequired(((Item)this.getItem()).isRequired());
        if (((Item)this.getItem()).getNote() != null && StringUtils.isNotEmpty((CharSequence)((Item)this.getItem()).getNote())) {
            de.setNote(((Item)this.getItem()).getNote());
        } else if (this.provider != null) {
            de.setNote(this.provider.getNote(this.name, this.value));
        }
        if (this.provider != null) {
            this.addProviderInfo(de);
        }
        switch (((Item)this.getItem()).getType()) {
            case CHECKBOX: {
                de.setSelected(this.value);
                de.setType(DataElementType.CHECKBOX);
                break;
            }
            case HIDDEN: {
                de.setValue(this.value);
                de.setType(DataElementType.HIDDEN);
                break;
            }
            case NUMBER: {
                de.setValue(this.value);
                de.setType(DataElementType.NUMBER);
                de.setMinValue(((Item)this.getItem()).getMin());
                de.setMaxValue(((Item)this.getItem()).getMax());
                break;
            }
            case SELECT: {
                this.processSelectElement(de, externalResources);
                break;
            }
            case TEXT: {
                de.setValue(this.value);
                de.setType(DataElementType.TEXT_EDIT);
                break;
            }
            case TEXTAREA: {
                de.setValue(this.value);
                de.setType(DataElementType.TEXT_AREA);
                if (((Item)this.getItem()).getMax() != null && ((Item)this.getItem()).getMax() > 0) {
                    de.setRows(((Item)this.getItem()).getMax());
                    break;
                }
                de.setRows(3);
                break;
            }
            case LOCK_HIDDEN: {
                try {
                    lockUtilities.lockHidden(de, this.value);
                    break;
                }
                catch (Exception e) {
                    throw new ProviderException(e.getMessage(), (Throwable)e);
                }
            }
            case LOCK: {
                try {
                    lockUtilities.lock(de, this.value);
                    break;
                }
                catch (Exception e) {
                    throw new ProviderException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return de;
    }

    private void addProviderInfo(DataElement de) throws ProviderException {
        ProviderInfo pInfo = this.provider.getProviderInfo(this.name);
        if (pInfo != null) {
            DataElementInfo dInfo = new DataElementInfo(pInfo.getHeaderFinestraModale() != null ? pInfo.getHeaderFinestraModale() : ((Item)this.getItem()).getLabel());
            dInfo.setBody(pInfo.getBody());
            dInfo.setHeaderBody(pInfo.getHeaderBody());
            dInfo.setListBody(pInfo.getListBody());
            de.setInfo(dInfo);
        }
    }

    private void processSelectElement(DataElement de, ExternalResources externalResources) throws ProviderException {
        de.setSelected(this.value);
        de.setType(DataElementType.SELECT);
        ArrayList<String> valuesList = new ArrayList<String>();
        ArrayList<String> labelsList = new ArrayList<String>();
        ItemValues values = ((Item)this.getItem()).getValues();
        if (values != null && values.sizeValueList() > 0) {
            for (ItemValue itemValue : values.getValueList()) {
                valuesList.add(itemValue.getValue());
                labelsList.add(itemValue.getLabel() != null ? itemValue.getLabel() : itemValue.getValue());
            }
        } else if (this.provider != null) {
            List tmp = this.provider.getValues(this.name, externalResources);
            if (tmp != null && !tmp.isEmpty()) {
                valuesList.addAll(tmp);
            }
            if ((tmp = this.provider.getLabels(this.name, externalResources)) != null && !tmp.isEmpty()) {
                labelsList.addAll(tmp);
            }
        }
        de.setValues(valuesList);
        de.setLabels(labelsList);
    }

    @Override
    public void setValueFromRequest(String parameterValue, ExternalResources externalResources, LockUtilities lockUtilities) throws ProviderException {
        if (parameterValue == null && !this.isOldVisible()) {
            this.setDefaultValueFromRequest(externalResources);
        } else {
            switch (((Item)this.getItem()).getType()) {
                case HIDDEN: 
                case LOCK_HIDDEN: {
                    this.value = parameterValue == null && this.getSaveProperty().isForce() ? ((Item)this.getItem()).getValue() : parameterValue;
                    break;
                }
                default: {
                    this.value = parameterValue;
                }
            }
        }
        if (ItemType.LOCK.equals((Object)((Item)this.getItem()).getType()) || ItemType.LOCK_HIDDEN.equals((Object)((Item)this.getItem()).getType())) {
            try {
                this.value = lockUtilities.getDriverBYOKUtilities().wrap(this.value);
            }
            catch (Exception e) {
                throw new ProviderException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void setDefaultValueFromRequest(ExternalResources externalResources) throws ProviderException {
        switch (((Item)this.getItem()).getType()) {
            case CHECKBOX: {
                this.value = ((Item)this.getItem()).getDefaultSelected() ? "yes" : "no";
                break;
            }
            case HIDDEN: 
            case LOCK_HIDDEN: {
                this.value = ((Item)this.getItem()).getValue();
                break;
            }
            default: {
                this.value = StringUtils.isNotEmpty((CharSequence)((Item)this.getItem()).getDefault()) ? ((Item)this.getItem()).getDefault() : (this.provider != null ? this.provider.getDefault(this.name, externalResources) : null);
            }
        }
    }

    @Override
    public Property getSaveProperty() {
        return ((Item)this.getItem()).getProperty();
    }

    @Override
    public String getPropertyValue() {
        switch (((Item)this.getItem()).getType()) {
            case CHECKBOX: {
                return this.getCheckboxPropertyValue();
            }
            case HIDDEN: 
            case LOCK_HIDDEN: {
                return this.getSaveProperty().isForce() ? ((Item)this.getItem()).getValue() : this.value;
            }
        }
        return this.value;
    }

    private String getCheckboxPropertyValue() {
        String valueToCheck = null;
        if (ServletUtils.isCheckBoxEnabled(this.value)) {
            valueToCheck = this.getSaveProperty().getSelectedValue() != null ? this.getSaveProperty().getSelectedValue() : null;
        } else {
            String string = valueToCheck = this.getSaveProperty().getUnselectedValue() != null ? this.getSaveProperty().getUnselectedValue() : null;
        }
        if (valueToCheck == null) {
            valueToCheck = ServletUtils.isCheckBoxEnabled(this.value) ? "true" : "false";
        }
        return valueToCheck;
    }

    public String getCheckBoxValue(String value) {
        String valueToCheck = null;
        if (((Item)this.getItem()).getProperty().getSelectedValue() != null && value.equals(this.getSaveProperty().getSelectedValue())) {
            valueToCheck = "yes";
        }
        if (valueToCheck == null && ((Item)this.getItem()).getProperty().getUnselectedValue() != null && value.equals(this.getSaveProperty().getUnselectedValue())) {
            valueToCheck = "no";
        }
        if (valueToCheck == null) {
            valueToCheck = ServletUtils.isCheckBoxEnabled(value) ? "yes" : "no";
        }
        return valueToCheck;
    }

    @Override
    public Conditions getConditions() {
        return ((Item)this.item).getConditions();
    }

    @Override
    public ItemType getItemType() {
        return ((Item)this.item).getType();
    }

    @Override
    public String getLabel() {
        return ((Item)this.item).getLabel();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void validate(ExternalResources externalResources) throws UserInputValidationException {
        block20: {
            itemValue = this.getPropertyValue();
            saveProperty = this.getSaveProperty();
            v0 = save = saveProperty != null && (saveProperty.isForce() != false || this.isVisible() != false);
            if (!save) break block20;
            prefixIlCampo = "Il Campo " + this.getLabel();
            if (((Item)this.getItem()).isRequired() && StringUtils.isEmpty((CharSequence)itemValue)) {
                throw new UserInputValidationException(prefixIlCampo + " &egrave; obbligatorio");
            }
            switch (1.$SwitchMap$org$openspcoop2$core$mvc$properties$constants$ItemType[((Item)this.getItem()).getType().ordinal()]) {
                case 4: {
                    if (!StringUtils.isNotEmpty((CharSequence)itemValue)) break;
                    numeric = NumberUtils.isParsable((String)itemValue);
                    if (!numeric) {
                        throw new UserInputValidationException(prefixIlCampo + " non contiene un valore di tipo numerico");
                    }
                    number = -1;
                    try {
                        number = Integer.valueOf(itemValue);
                    }
                    catch (Exception e) {
                        throw new UserInputValidationException(prefixIlCampo + " non contiene un valore di tipo numerico");
                    }
                    if (((Item)this.getItem()).getMin() != null && number < ((Item)this.getItem()).getMin()) {
                        throw new UserInputValidationException(prefixIlCampo + " deve contenere un valore >= " + ((Item)this.getItem()).getMin());
                    }
                    if (((Item)this.getItem()).getMax() == null || number <= ((Item)this.getItem()).getMax()) break;
                    throw new UserInputValidationException(prefixIlCampo + " deve contenere un valore <= " + ((Item)this.getItem()).getMax());
                }
                case 5: {
                    if (!StringUtils.isNotEmpty((CharSequence)itemValue)) break;
                    values = ((Item)this.getItem()).getValues();
                    found = false;
                    if (values == null || values.sizeValueList() <= 0) ** GOTO lbl34
                    for (ItemValue selectItemValue : values.getValueList()) {
                        if (!selectItemValue.getValue().equals(itemValue)) continue;
                        found = true;
                        ** GOTO lbl41
                    }
                    ** GOTO lbl41
lbl34:
                    // 1 sources

                    try {
                        tmp = this.provider.getValues(this.name, externalResources);
                        if (!tmp.contains(itemValue)) ** GOTO lbl41
                        found = true;
                    }
                    catch (Exception e) {
                        throw new UserInputValidationException("Errore durante la validazione del Campo " + this.getLabel() + ": " + e.getMessage(), e);
                    }
lbl41:
                    // 4 sources

                    if (found) break;
                    throw new UserInputValidationException(prefixIlCampo + " contiene un valore non previsto");
                }
                case 6: 
                case 7: {
                    if (itemValue != null && itemValue.length() > 4000) {
                        throw new UserInputValidationException(prefixIlCampo + " non deve contenere pi\u00f9 di 4000 caratteri");
                    }
                    if (itemValue != null && (itemValue.startsWith(" ") || itemValue.startsWith("\t"))) {
                        throw new UserInputValidationException("Il valore inserito nel Campo " + this.getLabel() + " non pu\u00f2 iniziare con uno spazio");
                    }
                    if (itemValue == null || !itemValue.endsWith(" ") && !itemValue.endsWith("\t")) break;
                    throw new UserInputValidationException("Il valore inserito nel Campo " + this.getLabel() + " non pu\u00f2 terminare con uno spazio");
                }
            }
            if (((Item)this.getItem()).getValidation() != null && StringUtils.isNotEmpty((CharSequence)itemValue)) {
                try {
                    match = RegularExpressionEngine.isMatch((String)itemValue, (String)((Item)this.getItem()).getValidation());
                    if (!match) {
                        throw new UserInputValidationException(prefixIlCampo + " non rispetta il pattern di validazione previsto (" + ((Item)this.getItem()).getValidation() + ")");
                    }
                }
                catch (UserInputValidationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new UserInputValidationException("Impossibile validare il campo " + this.getLabel() + " secondo il pattern previsto nella configurazione (" + ((Item)this.getItem()).getValidation() + ")", e);
                }
            }
        }
    }
}

