/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerBase;
import org.openspcoop2.monitor.engine.statistic.IStatisticsEngine;
import org.openspcoop2.monitor.engine.statistic.PdndGenerazioneTracciamento;
import org.openspcoop2.monitor.engine.statistic.PdndPublicazioneTracciamento;
import org.openspcoop2.monitor.engine.statistic.StatisticheGiornaliere;
import org.openspcoop2.monitor.engine.statistic.StatisticheMensili;
import org.openspcoop2.monitor.engine.statistic.StatisticheOrarie;
import org.openspcoop2.monitor.engine.statistic.StatisticheSettimanali;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;

public class StatisticsLibrary {
    private StatisticsConfig config;
    private org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM;
    private org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM;
    private org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM;
    private IServiceManager pluginsBaseSM;
    private org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM;
    private org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM;
    private static final String ERRORE = "Errore durante la generazione delle statistiche: ";

    public StatisticsLibrary(StatisticsConfig config, org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM, IServiceManager pluginsBaseSM, org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM, org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM) {
        this.config = config;
        this.statisticheSM = statisticheSM;
        this.transazioniSM = transazioniSM;
        this.pluginsStatisticheSM = pluginsStatisticheSM;
        this.pluginsBaseSM = pluginsBaseSM;
        this.utilsSM = utilsSM;
        this.pluginsTransazioniSM = pluginsTransazioniSM;
    }

    public void close() {
        if (this.statisticheSM instanceof JDBCServiceManagerBase) {
            this.closeEngine((JDBCServiceManagerBase)this.statisticheSM, "Statistiche");
        }
        if (this.transazioniSM instanceof JDBCServiceManagerBase) {
            this.closeEngine((JDBCServiceManagerBase)this.transazioniSM, "Transazioni");
        }
        if (this.utilsSM instanceof JDBCServiceManagerBase) {
            this.closeEngine((JDBCServiceManagerBase)this.utilsSM, "Utils");
        }
        if (this.pluginsBaseSM instanceof JDBCServiceManagerBase) {
            this.closeEngine((JDBCServiceManagerBase)this.pluginsBaseSM, "PluginBase");
        }
        if (this.pluginsStatisticheSM instanceof JDBCServiceManagerBase) {
            this.closeEngine((JDBCServiceManagerBase)this.pluginsStatisticheSM, "PluginStatistiche");
        }
        if (this.pluginsTransazioniSM instanceof JDBCServiceManagerBase) {
            this.closeEngine((JDBCServiceManagerBase)this.pluginsTransazioniSM, "PluginTransazioni");
        }
    }

    private void closeEngine(JDBCServiceManagerBase serviceManager, String tipo) {
        try {
            serviceManager.close();
        }
        catch (Exception t) {
            String msgError = "Rilascio connessione '" + tipo + "' fallita: " + t.getMessage();
            if (this.config.getLogSql() != null) {
                this.config.getLogSql().error(msgError, (Throwable)t);
            }
            if (this.config.getLogCore() != null) {
                this.config.getLogCore().error(msgError, (Throwable)t);
            }
            t.printStackTrace(System.err);
        }
    }

    public void generateStatistics(IStatisticsEngine engine, String name) {
        try {
            if (engine.isEnabled(this.config)) {
                if (this.config.isDebug()) {
                    this.config.getLogCore().debug("Esecuzione thread {} ....", (Object)name);
                }
                engine.init(this.config, this.statisticheSM, this.transazioniSM, this.pluginsStatisticheSM, this.pluginsBaseSM, this.utilsSM, this.pluginsTransazioniSM);
                if (this.config.isDebug()) {
                    this.config.getLogCore().debug("Esecuzione thread {} inizializzazione terminata", (Object)name);
                }
                engine.generate();
                if (this.config.isDebug()) {
                    this.config.getLogCore().debug("Esecuzione thread {} terminata", (Object)name);
                }
            } else if (this.config.isDebug()) {
                this.config.getLogCore().debug("Thread {} disabilitato", (Object)name);
            }
        }
        catch (Exception e) {
            String msg = ERRORE + e.getMessage();
            this.config.getLogCore().error("Esecuzione thread {} fallita: {}", new Object[]{name, msg, e});
        }
    }

    public void generateStatisticaOraria() {
        this.generateStatistics(new StatisticheOrarie(), "per generazione statistiche orarie");
    }

    public void generateStatisticaGiornaliera() {
        this.generateStatistics(new StatisticheGiornaliere(), "per generazione statistiche giornaliere");
    }

    public void generateStatisticaSettimanale() {
        this.generateStatistics(new StatisticheSettimanali(), "per generazione statistiche settimanali");
    }

    public void generateStatisticaMensile() {
        this.generateStatistics(new StatisticheMensili(), "per generazione statistiche mensili");
    }

    public void generatePdndGenerazioneTracciamento() {
        this.generateStatistics(new PdndGenerazioneTracciamento(), "generazione pdnd tracciamento");
    }

    public void generatePdndPubblicazioneTracciamento() {
        this.generateStatistics(new PdndPublicazioneTracciamento(), "pubblicazione pdnd tracciamento");
    }
}

