/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.Calendar;
import java.util.Date;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.statistiche.Statistica;
import org.openspcoop2.core.statistiche.StatisticaContenuti;
import org.openspcoop2.core.statistiche.StatisticaMensile;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.dao.IDBStatisticaMensileService;
import org.openspcoop2.core.statistiche.dao.IStatisticaMensileService;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.statistic.AbstractStatistiche;
import org.openspcoop2.monitor.engine.statistic.CustomStatisticsSdkGenerator;
import org.openspcoop2.monitor.engine.statistic.StatisticBean;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.StatisticException;
import org.openspcoop2.monitor.sdk.plugins.IStatisticProcessing;
import org.openspcoop2.monitor.sdk.statistic.IStatistic;

public class StatisticheMensili
extends AbstractStatistiche {
    public static StatisticheMensili getInstanceForUtils() {
        return new StatisticheMensili();
    }

    StatisticheMensili() {
    }

    @Override
    public void init(StatisticsConfig config, org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM, IServiceManager pluginsBaseSM, org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM, org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM) {
        super.init(config, statisticheSM, transazioniSM, pluginsStatisticheSM, pluginsBaseSM, utilsSM, pluginsTransazioniSM);
        try {
            if (statisticheSM == null) {
                throw new ServiceException("ServiceManager [" + org.openspcoop2.core.statistiche.dao.IServiceManager.class.getName() + "] non inizializzato");
            }
            this.model = StatisticaMensile.model().STATISTICA_BASE;
            this.statisticaServiceDAO = this.statisticheSM.getStatisticaMensileService();
            this.statisticaServiceSearchDAO = this.statisticheSM.getStatisticaMensileServiceSearch();
        }
        catch (NotImplementedException | ServiceException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private Calendar truncDate(Date date) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        cTmp.set(5, 1);
        cTmp.set(11, 0);
        cTmp.set(12, 0);
        cTmp.set(13, 0);
        cTmp.set(14, 0);
        return cTmp;
    }

    @Override
    public Date truncDate(Date date, boolean print) {
        Calendar cTmp = this.truncDate(date);
        if (print) {
            this.printCalendar(cTmp);
        }
        return cTmp.getTime();
    }

    @Override
    public String getIntervalloStatistica(Date date, boolean print) {
        Calendar cTmp = this.truncDate(date);
        StringBuilder bf = new StringBuilder();
        switch (cTmp.get(2)) {
            case 0: {
                bf.append("Gennaio");
                break;
            }
            case 1: {
                bf.append("Febbraio");
                break;
            }
            case 2: {
                bf.append("Marzo");
                break;
            }
            case 3: {
                bf.append("Aprile");
                break;
            }
            case 4: {
                bf.append("Maggio");
                break;
            }
            case 5: {
                bf.append("Giugno");
                break;
            }
            case 6: {
                bf.append("Luglio");
                break;
            }
            case 7: {
                bf.append("Agosto");
                break;
            }
            case 8: {
                bf.append("Settembre");
                break;
            }
            case 9: {
                bf.append("Ottobre");
                break;
            }
            case 10: {
                bf.append("Novembre");
                break;
            }
            case 11: {
                bf.append("Dicembre");
                break;
            }
            default: {
                bf.append("Non definito?");
            }
        }
        return bf.toString();
    }

    @Override
    public Date incrementDate(Date date, boolean print) {
        return this.operation(date, print, 1);
    }

    @Override
    public Date decrementDate(Date date, boolean print) {
        return this.operation(date, print, -1);
    }

    private Date operation(Date date, boolean print, int value) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        if (print) {
            this.logger.debug(">>> incrementDate >>>>");
            this.logger.debug("Before: ");
            this.printCalendar(cTmp);
        }
        int giorno = cTmp.get(5);
        int lastDayActualMonth = cTmp.getActualMaximum(5);
        cTmp.add(2, value);
        if (giorno == lastDayActualMonth) {
            int lastDayMonth = cTmp.getActualMaximum(5);
            cTmp.set(5, lastDayMonth);
        }
        if (print) {
            this.logger.debug("After: ");
            this.printCalendar(cTmp);
            this.logger.debug(">>> incrementDate end >>>>");
        }
        return cTmp.getTime();
    }

    @Override
    public TipoIntervalloStatistico getTipoStatistiche() {
        return TipoIntervalloStatistico.STATISTICHE_MENSILI;
    }

    @Override
    public void callStatisticPluginMethod(IStatisticProcessing statProcessing, StatisticBean stat) throws StatisticException {
        CustomStatisticsSdkGenerator statContext = new CustomStatisticsSdkGenerator(stat, StatisticType.MENSILE, this);
        statProcessing.createMonthlyStatisticData((IStatistic)statContext);
    }

    @Override
    public String getStatisticPluginMethodName() throws StatisticException {
        return "createMonthlyStatisticData";
    }

    @Override
    protected Long insertStatistica(Statistica statistica) throws StatisticException {
        try {
            StatisticaMensile stat = new StatisticaMensile();
            stat.setStatisticaBase(statistica);
            ((IStatisticaMensileService)this.statisticaServiceDAO).create((Object)stat);
            return stat.getId();
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void updateStatistica(long idStatistica, StatisticaContenuti ... statisticaContenuti) throws StatisticException {
        try {
            StatisticaMensile stat = (StatisticaMensile)((IDBStatisticaMensileService)this.statisticaServiceDAO).get(idStatistica);
            for (int i = 0; i < statisticaContenuti.length; ++i) {
                statisticaContenuti[i].setData(stat.getStatisticaBase().getData());
                stat.addStatisticaMensileContenuti(statisticaContenuti[i]);
            }
            ((IStatisticaMensileService)this.statisticaServiceDAO).update((Object)stat);
        }
        catch (Exception e) {
            throw new StatisticException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected boolean isGestioneUltimoIntervallo(StatisticsConfig config) {
        return config.isStatisticheMensiliGestioneUltimoIntervallo();
    }

    @Override
    public boolean isEnabled(StatisticsConfig config) {
        return config.isStatisticheMensili();
    }
}

