/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.io.File;
import java.sql.Connection;
import org.openspcoop2.core.commons.IDAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.dao.IServiceManager;
import org.openspcoop2.core.transazioni.utils.TransactionServerUtils;
import org.openspcoop2.core.transazioni.utils.serializer.JaxbDeserializer;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.fs_recovery.AbstractFSRecovery;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.slf4j.Logger;

public class FSRecoveryTransazioniApplicativoServerConsegnaTerminataImpl
extends AbstractFSRecovery {
    private IServiceManager transazioniSM;
    private DAOFactory daoFactory;
    private Logger daoFactoryLogger;
    private ServiceManagerProperties daoFactoryServiceManagerProperties;
    private long gestioneSerializableDBAttesaAttiva;
    private int gestioneSerializableDBCheckInterval;

    public FSRecoveryTransazioniApplicativoServerConsegnaTerminataImpl(Logger log, boolean debug, DAOFactory daoFactory, Logger daoFactoryLogger, ServiceManagerProperties daoFactoryServiceManagerProperties, long gestioneSerializableDBAttesaAttiva, int gestioneSerializableDBCheckInterval, IServiceManager transazioniSM, File directory, File directoryDLQ, int tentativi, long msAttesaProcessingFile, long maxFileProcessed) {
        super(log, debug, directory, directoryDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.transazioniSM = transazioniSM;
        this.daoFactory = daoFactory;
        this.daoFactoryLogger = daoFactoryLogger;
        this.daoFactoryServiceManagerProperties = daoFactoryServiceManagerProperties;
        this.gestioneSerializableDBAttesaAttiva = gestioneSerializableDBAttesaAttiva;
        this.gestioneSerializableDBCheckInterval = gestioneSerializableDBCheckInterval;
    }

    @Override
    public long process(Connection connection) {
        this.log.info("Recovery TransazioneServerApplicativo aggiornamento informazione di consegna terminata ...");
        long l = super.process(connection);
        this.log.info("Recovery TransazioneServerApplicativo aggiornamento informazione di consegna terminata completato");
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertObject(File file, Connection connection) throws UtilsException, UtilsMultiException {
        JaxbDeserializer deserializer = new JaxbDeserializer();
        TransazioneApplicativoServer transazioneApplicativoServer = null;
        try {
            transazioneApplicativoServer = deserializer.readTransazioneApplicativoServer(file);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        int esitoConsegnaMultipla = -1;
        int esitoConsegnaMultiplaInCorso = -1;
        int esitoConsegnaMultiplaFallita = -1;
        int esitoConsegnaMultiplaCompletata = -1;
        int ok = -1;
        int esitoIntegrationManagerSingolo = -1;
        boolean esitiLetti = false;
        try {
            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)transazioneApplicativoServer.getProtocollo());
            esitoConsegnaMultipla = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA);
            esitoConsegnaMultiplaInCorso = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_IN_CORSO);
            esitoConsegnaMultiplaFallita = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_FALLITA);
            esitoConsegnaMultiplaCompletata = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_COMPLETATA);
            ok = esitiProperties.convertoToCode(EsitoTransazioneName.OK);
            esitoIntegrationManagerSingolo = esitiProperties.convertoToCode(EsitoTransazioneName.MESSAGE_BOX);
            esitiLetti = true;
        }
        catch (Exception er) {
            String msg = "Errore durante l'aggiornamento delle transazione (informazione di consegna terminata) relativamente all'informazione del server '" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "': (readEsiti) " + er.getMessage();
            this.log.error("[" + transazioneApplicativoServer.getIdTransazione() + "] " + msg, (Throwable)er);
        }
        if (esitiLetti) {
            try {
                boolean autoCommit = false;
                try {
                    connection.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
                boolean possibileTerminazioneSingleIntegrationManagerMessage = false;
                boolean consegnaInErrore = false;
                if (!transazioneApplicativoServer.isConsegnaTerminata()) {
                    if (transazioneApplicativoServer.getDataEliminazioneIm() != null) {
                        possibileTerminazioneSingleIntegrationManagerMessage = true;
                    } else if (transazioneApplicativoServer.getDataMessaggioScaduto() != null) {
                        possibileTerminazioneSingleIntegrationManagerMessage = true;
                    } else if (transazioneApplicativoServer.isConsegnaTrasparente() && transazioneApplicativoServer.getNumeroTentativi() > 0) {
                        consegnaInErrore = true;
                    }
                }
                TransactionServerUtils.safeAggiornaInformazioneConsegnaTerminata((TransazioneApplicativoServer)transazioneApplicativoServer, (Connection)connection, (String)this.daoFactoryServiceManagerProperties.getDatabaseType(), (Logger)this.log, (IDAOFactory)this.daoFactory, (Logger)this.daoFactoryLogger, (ServiceManagerProperties)this.daoFactoryServiceManagerProperties, (boolean)this.debug, (int)esitoConsegnaMultipla, (int)esitoConsegnaMultiplaInCorso, (int)esitoConsegnaMultiplaFallita, (int)esitoConsegnaMultiplaCompletata, (int)ok, (int)esitoIntegrationManagerSingolo, (boolean)possibileTerminazioneSingleIntegrationManagerMessage, (boolean)consegnaInErrore, (long)this.gestioneSerializableDBAttesaAttiva, (int)this.gestioneSerializableDBCheckInterval, null);
            }
            finally {
                try {
                    connection.setAutoCommit(true);
                }
                catch (Exception exception) {}
            }
        }
    }
}

