/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.io.File;
import java.sql.Connection;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.eventi.dao.IServiceManager;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryConfig;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryEventi;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryObjectType;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryTransazioni;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class FSRecoveryLibrary {
    private FSRecoveryLibrary() {
    }

    public static void generate(FSRecoveryConfig config, DAOFactory daoFactory, Logger daoFactoryLogger, ServiceManagerProperties daoFactoryServiceManagerProperties, long gestioneSerializableDBAttesaAttiva, int gestioneSerializableDBCheckInterval, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, ITracciaProducer tracciamentoAppender, IDiagnosticProducer diagnosticoAppender, IDumpProducer dumpAppender, boolean transazioniRegistrazioneDumpHeadersCompactEnabled, IServiceManager pluginsEventiSM) {
        FSRecoveryLibrary.generate(config, daoFactory, daoFactoryLogger, daoFactoryServiceManagerProperties, gestioneSerializableDBAttesaAttiva, gestioneSerializableDBCheckInterval, transazioniSM, tracciamentoAppender, diagnosticoAppender, dumpAppender, transazioniRegistrazioneDumpHeadersCompactEnabled, pluginsEventiSM, null, null);
    }

    public static long generate(FSRecoveryConfig config, DAOFactory daoFactory, Logger daoFactoryLogger, ServiceManagerProperties daoFactoryServiceManagerProperties, long gestioneSerializableDBAttesaAttiva, int gestioneSerializableDBCheckInterval, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, ITracciaProducer tracciamentoAppender, IDiagnosticProducer diagnosticoAppender, IDumpProducer dumpAppender, boolean transazioniRegistrazioneDumpHeadersCompactEnabled, IServiceManager pluginsEventiSM, Connection connection, FSRecoveryObjectType objectType) {
        try {
            File dir = new File(config.getRepository());
            FSRecoveryLibrary.checkDir(dir, false, false);
            long l = 0L;
            if (config.isRipristinoEventi() && (objectType == null || objectType.isGestioneEventi())) {
                if (config.isDebug()) {
                    config.getLogCore().debug("Esecuzione thread per ripristino eventi ....");
                }
                File dirEventi = new File(dir, "eventi");
                FSRecoveryLibrary.checkDir(dirEventi, true, false);
                File dirEventiDLQ = new File(dirEventi, "dlq");
                FSRecoveryLibrary.checkDir(dirEventiDLQ, true, true);
                FSRecoveryEventi fs = new FSRecoveryEventi(config.getLogCore(), config.isDebug(), pluginsEventiSM, dirEventi, dirEventiDLQ, config.getTentativi(), config.getProcessingEventFileAfterMs(), config.getMaxFileLimit());
                long lInternal = fs.process(objectType);
                if (lInternal < 0L) {
                    return lInternal;
                }
                l += lInternal;
                if (config.isDebug()) {
                    config.getLogCore().debug("Esecuzione thread per ripristino eventi terminato");
                }
            } else if (config.isDebug()) {
                config.getLogCore().debug("Thread per ripristino eventi disabilitato");
            }
            if (config.isRipristinoTransazioni() && (objectType == null || objectType.isGestioneTransazionii())) {
                if (config.isDebug()) {
                    config.getLogCore().debug("Esecuzione thread per ripristino transazioni ....");
                }
                File dirDiagnostici = new File(dir, "diagnostici");
                FSRecoveryLibrary.checkDir(dirDiagnostici, true, false);
                File dirDiagnosticiDLQ = new File(dirDiagnostici, "dlq");
                FSRecoveryLibrary.checkDir(dirDiagnosticiDLQ, true, true);
                File dirTracce = new File(dir, "tracce");
                FSRecoveryLibrary.checkDir(dirTracce, true, false);
                File dirTracceDLQ = new File(dirTracce, "dlq");
                FSRecoveryLibrary.checkDir(dirTracceDLQ, true, true);
                File dirDump = new File(dir, "messaggi");
                FSRecoveryLibrary.checkDir(dirDump, true, false);
                File dirDumpDLQ = new File(dirDump, "dlq");
                FSRecoveryLibrary.checkDir(dirDumpDLQ, true, true);
                File dirTransazioniApplicativoServer = new File(dir, "transazioni_sa");
                FSRecoveryLibrary.checkDir(dirTransazioniApplicativoServer, true, false);
                File dirTransazioniApplicativoServerDLQ = new File(dirTransazioniApplicativoServer, "dlq");
                FSRecoveryLibrary.checkDir(dirTransazioniApplicativoServerDLQ, true, true);
                File dirTransazioniApplicativoServerConsegnaTerminata = new File(dir, "transazioni_sa_update_info");
                FSRecoveryLibrary.checkDir(dirTransazioniApplicativoServerConsegnaTerminata, true, false);
                File dirTransazioniApplicativoServerConsegnaTerminataDLQ = new File(dirTransazioniApplicativoServerConsegnaTerminata, "dlq");
                FSRecoveryLibrary.checkDir(dirTransazioniApplicativoServerConsegnaTerminataDLQ, true, true);
                File dirTransazioni = new File(dir, "transazioni");
                FSRecoveryLibrary.checkDir(dirTransazioni, true, false);
                File dirTransazioniDLQ = new File(dirTransazioni, "dlq");
                FSRecoveryLibrary.checkDir(dirTransazioniDLQ, true, true);
                FSRecoveryTransazioni fs = new FSRecoveryTransazioni(config.getLogCore(), config.isDebug(), daoFactory, daoFactoryLogger, daoFactoryServiceManagerProperties, gestioneSerializableDBAttesaAttiva, gestioneSerializableDBCheckInterval, transazioniSM, tracciamentoAppender, diagnosticoAppender, dumpAppender, transazioniRegistrazioneDumpHeadersCompactEnabled, dirDiagnostici, dirDiagnosticiDLQ, dirTracce, dirTracceDLQ, dirDump, dirDumpDLQ, dirTransazioniApplicativoServer, dirTransazioniApplicativoServerDLQ, dirTransazioniApplicativoServerConsegnaTerminata, dirTransazioniApplicativoServerConsegnaTerminataDLQ, dirTransazioni, dirTransazioniDLQ, config.getTentativi(), config.getProcessingTransactionFileAfterMs(), config.getMaxFileLimit());
                long lInternal = fs.process(objectType, connection);
                if (lInternal < 0L) {
                    return lInternal;
                }
                l += lInternal;
                if (config.isDebug()) {
                    config.getLogCore().debug("Esecuzione thread per ripristino transazioni terminato");
                }
            } else if (config.isDebug()) {
                config.getLogCore().debug("Thread per ripristino transazioni disabilitato");
            }
            return l;
        }
        catch (Exception e) {
            config.getLogCore().error("Errore durante il recovery da file system: " + e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    private static void checkDir(File dir, boolean checkWritable, boolean create) throws UtilsException {
        String prefix = "Directory [" + dir.getAbsolutePath() + "] ";
        if (!dir.exists()) {
            if (create) {
                if (!dir.mkdir()) {
                    throw new UtilsException(prefix + "non esistente e creazione non riuscita");
                }
            } else {
                throw new UtilsException(prefix + "non esistente");
            }
        }
        if (!dir.canRead()) {
            throw new UtilsException(prefix + "non accessibile in lettura");
        }
        if (checkWritable && !dir.canWrite()) {
            throw new UtilsException(prefix + "non accessibile in scrittura");
        }
    }
}

