/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class FSRecoveryFileUtils {
    public static final String ERROR_SUFFIX = ".error";

    private FSRecoveryFileUtils() {
    }

    public static String getDateFromFilename(String fileName) throws UtilsException {
        String[] split = fileName.split("_");
        if (split.length < 2) {
            throw new UtilsException("Impossibile ricavare la data dal nome file [" + fileName + "]");
        }
        return split[1];
    }

    public static String getNewFileNameFromFilename(String fileName) throws UtilsException {
        int tentativi = FSRecoveryFileUtils.getTentativiFromFilename(fileName);
        if (tentativi == 0) {
            return fileName + "_1.error";
        }
        String substring = fileName.substring(0, fileName.indexOf(ERROR_SUFFIX));
        String[] split = substring.split("_");
        if (split == null || split.length <= 0) {
            throw new UtilsException("Impossibile ricavare il nuovo nome file dal nome file [" + fileName + "]");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length - 1; ++i) {
            sb.append(split[i]).append("_");
        }
        int newErrorIndex = tentativi + 1;
        sb.append(newErrorIndex).append(ERROR_SUFFIX);
        return sb.toString();
    }

    public static int getTentativiFromFilename(String fileName) throws UtilsException {
        if (fileName.endsWith(".xml")) {
            return 0;
        }
        if (!fileName.endsWith(ERROR_SUFFIX)) {
            throw new UtilsException("Impossibile ricavare il numero di tentativi dal nome file [" + fileName + "]");
        }
        String substring = fileName.substring(0, fileName.indexOf(ERROR_SUFFIX));
        String[] split = substring.split("_");
        if (split == null || split.length <= 0) {
            throw new UtilsException("Impossibile ricavare il numero di tentativi dal nome file [" + fileName + "]");
        }
        return Integer.parseInt(split[split.length - 1].trim());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String renameToDLQ(File directoryDLQ, File file, Throwable e, Logger log) throws UtilsException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintWriter pw = new PrintWriter(baos);
            try {
                e.printStackTrace(pw);
                pw.flush();
                baos.flush();
                String string = FSRecoveryFileUtils.renameToDLQ(directoryDLQ, file, baos.toString(), log);
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception er) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String renameToDLQ(File directoryDLQ, File file, String error, Logger log) throws UtilsException {
        if (log != null) {
            // empty if block
        }
        String data = FSRecoveryFileUtils.getDateFromFilename(file.getName());
        File dir = new File(directoryDLQ, data + File.separator);
        File newFile = new File(dir, file.getName());
        dir.mkdirs();
        if (!file.renameTo(newFile)) {
            // empty if block
        }
        File readme = new File(dir, file.getName() + ".README");
        try (FileOutputStream fos = new FileOutputStream(readme);){
            fos.write(error.getBytes());
            fos.flush();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        return newFile.getAbsolutePath();
    }
}

