/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.io.File;
import java.sql.Connection;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.utils.serializer.JaxbDeserializer;
import org.openspcoop2.monitor.engine.fs_recovery.AbstractFSRecovery;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.slf4j.Logger;

public class FSRecoveryDumpImpl
extends AbstractFSRecovery {
    private IDumpProducer dumpAppender;
    private boolean transazioniRegistrazioneDumpHeadersCompactEnabled = false;

    public FSRecoveryDumpImpl(Logger log, boolean debug, IDumpProducer dumpAppender, File directory, File directoryDLQ, int tentativi, long msAttesaProcessingFile, long maxFileProcessed) {
        super(log, debug, directory, directoryDLQ, tentativi, msAttesaProcessingFile, maxFileProcessed);
        this.dumpAppender = dumpAppender;
    }

    public void setTransazioniRegistrazioneDumpHeadersCompactEnabled(boolean transazioniRegistrazioneDumpHeadersCompactEnabled) {
        this.transazioniRegistrazioneDumpHeadersCompactEnabled = transazioniRegistrazioneDumpHeadersCompactEnabled;
    }

    @Override
    public long process(Connection connection) {
        this.log.info("Recovery Dump ...");
        long l = super.process(connection);
        this.log.info("Recovery Dump completato");
        return l;
    }

    @Override
    public void insertObject(File file, Connection connection) throws UtilsException, UtilsMultiException {
        JaxbDeserializer deserializer = new JaxbDeserializer();
        DumpMessaggio dumpMessaggio = null;
        try {
            dumpMessaggio = deserializer.readDumpMessaggio(file);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        Messaggio messaggioOp2 = new Messaggio(dumpMessaggio);
        try {
            this.dumpAppender.dump(connection, messaggioOp2, this.transazioniRegistrazioneDumpHeadersCompactEnabled);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }
}

