/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.monitor.engine.config.MonitorProperties;
import org.openspcoop2.monitor.engine.exceptions.EngineException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class FSRecoveryConfig {
    private Logger logCore = null;
    private Logger logSql = null;
    private int tentativi;
    private boolean debug = false;
    private boolean ripristinoEventi = false;
    private boolean ripristinoTransazioni = false;
    private long processingTransactionFileAfterMs;
    private long processingEventFileAfterMs;
    private long maxFileLimit = -1L;
    private String repository = null;
    private String defaultProtocol = null;

    public FSRecoveryConfig(boolean readPropertiesFromFile) throws EngineException {
        try {
            if (readPropertiesFromFile) {
                this.logCore = LoggerWrapperFactory.getLogger((String)"org.openspcoop2.monitor.engine.fs_recovery");
                this.logSql = LoggerWrapperFactory.getLogger((String)"org.openspcoop2.monitor.engine.fs_recovery.sql");
                MonitorProperties props = MonitorProperties.getInstance(this.logCore);
                this.debug = "true".equals(props.getProperty("org.openspcoop2.monitor.fileSystemRecovery.debug", "false", true));
                this.repository = props.getProperty("org.openspcoop2.monitor.fileSystemRecovery.repository", true, true);
                this.ripristinoEventi = "true".equals(props.getProperty("org.openspcoop2.monitor.fileSystemRecovery.events.enabled", "false", true));
                this.ripristinoTransazioni = "true".equals(props.getProperty("org.openspcoop2.monitor.fileSystemRecovery.transaction.enabled", "true", true));
                this.tentativi = Integer.parseInt(props.getProperty("org.openspcoop2.monitor.fileSystemRecovery.maxAttempts", true, true));
                this.processingEventFileAfterMs = Long.parseLong(props.getProperty("org.openspcoop2.monitor.fileSystemRecovery.events.processingFileAfterMs", true, true));
                this.processingTransactionFileAfterMs = Long.parseLong(props.getProperty("org.openspcoop2.monitor.fileSystemRecovery.transaction.processingFileAfterMs", true, true));
                String max = props.getProperty("org.openspcoop2.monitor.fileSystemRecovery.maxFileLimit", false, true);
                if (max != null && StringUtils.isNotEmpty((CharSequence)max)) {
                    this.maxFileLimit = Long.parseLong(max);
                }
                this.defaultProtocol = props.getProperty("org.openspcoop2.monitor.defaultProtocol", false, true);
            }
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    public Logger getLogCore() {
        return this.logCore;
    }

    public void setLogCore(Logger logCore) {
        this.logCore = logCore;
    }

    public Logger getLogSql() {
        return this.logSql;
    }

    public void setLogSql(Logger logSql) {
        this.logSql = logSql;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isRipristinoEventi() {
        return this.ripristinoEventi;
    }

    public void setRipristinoEventi(boolean ripristinoEventi) {
        this.ripristinoEventi = ripristinoEventi;
    }

    public boolean isRipristinoTransazioni() {
        return this.ripristinoTransazioni;
    }

    public void setRipristinoTransazioni(boolean ripristinoTransazioni) {
        this.ripristinoTransazioni = ripristinoTransazioni;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public int getTentativi() {
        return this.tentativi;
    }

    public void setTentativi(int tentativi) {
        this.tentativi = tentativi;
    }

    public long getProcessingTransactionFileAfterMs() {
        return this.processingTransactionFileAfterMs;
    }

    public void setProcessingTransactionFileAfterMs(long processingTransactionFileAfterMs) {
        this.processingTransactionFileAfterMs = processingTransactionFileAfterMs;
    }

    public long getProcessingEventFileAfterMs() {
        return this.processingEventFileAfterMs;
    }

    public void setProcessingEventFileAfterMs(long processingEventFileAfterMs) {
        this.processingEventFileAfterMs = processingEventFileAfterMs;
    }

    public long getMaxFileLimit() {
        return this.maxFileLimit;
    }

    public void setMaxFileLimit(long maxFileLimit) {
        this.maxFileLimit = maxFileLimit;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String defaultProtocol) {
        this.defaultProtocol = defaultProtocol;
    }
}

