/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.dynamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPlugins;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.monitor.engine.dynamic.IRegistroPluginsReader;
import org.openspcoop2.monitor.engine.dynamic.Plugin;
import org.openspcoop2.monitor.engine.dynamic.PluginsImage;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class PluginManager {
    private IRegistroPluginsReader registroPluginsReader;
    private Date expireDate;
    private int expireSeconds;
    private final Semaphore lockExpire = new Semaphore("PluginManager-expire");
    private PluginsImage pluginsImage = new PluginsImage();
    private PluginsImage pluginsImageSwitchOld = null;
    private final Semaphore lockImage = new Semaphore("PluginManager-image");

    protected PluginManager(IRegistroPluginsReader registroPluginsReader, int expireSeconds) {
        this.registroPluginsReader = registroPluginsReader;
        this.expireSeconds = expireSeconds;
    }

    private void checkUpdate(Logger log) {
        try {
            Date nowDate = DateManager.getDate();
            if (this.expireDate == null || nowDate.after(this.expireDate)) {
                this.update(log, nowDate);
            }
        }
        catch (Exception t) {
            log.error("Update plugin image failed: " + t.getMessage(), (Throwable)t);
        }
    }

    public void updateFromConsoleConfig(Logger log) {
        try {
            if (this.expireDate != null) {
                Date expired = new Date(this.expireDate.getTime() + 1L);
                this.update(log, expired);
            }
        }
        catch (Exception t) {
            log.error("Update plugin image failed: " + t.getMessage(), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Logger log, Date nowDate) throws UtilsException, CoreException {
        boolean update = false;
        SemaphoreLock lock = this.lockExpire.acquire("updateExpireDate");
        try {
            if (this.expireDate == null || nowDate.after(this.expireDate)) {
                this.expireDate = new Date(nowDate.getTime() + (long)(this.expireSeconds * 1000));
                update = true;
            }
        }
        finally {
            this.lockExpire.release(lock, "updateExpireDate");
        }
        if (update) {
            RegistroPlugins registro = null;
            try {
                registro = this.registroPluginsReader.getRegistroPlugins();
            }
            catch (NotFoundException notFound) {
                log.debug(notFound.getMessage(), (Throwable)notFound);
            }
            this.update(log, registro);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Logger log, RegistroPlugins pluginsParam) throws UtilsException {
        SemaphoreLock lock = this.lockImage.acquire("update");
        try {
            RegistroPlugins plugins = null;
            plugins = pluginsParam != null ? pluginsParam : new RegistroPlugins();
            ArrayList<String> pluginDaEliminare = new ArrayList<String>();
            if (this.pluginsImage != null && !this.pluginsImage.plugins.isEmpty()) {
                for (String pluginName : this.pluginsImage.plugins.keySet()) {
                    boolean found = false;
                    if (plugins.sizePluginList() > 0) {
                        for (RegistroPlugin pluginNew : plugins.getPluginList()) {
                            if (!pluginNew.getNome().equals(pluginName)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    pluginDaEliminare.add(pluginName);
                }
            }
            PluginsImage newImage = null;
            if (plugins.sizePluginList() > 0) {
                newImage = new PluginsImage();
                HashMap<String, String> mapPosizioniToNomi = new HashMap<String, String>();
                for (RegistroPlugin pluginNew : plugins.getPluginList()) {
                    if (!StatoFunzionalita.ABILITATO.equals((Object)pluginNew.getStato()) || pluginNew.sizeArchivioList() <= 0) continue;
                    String posPad = StringUtils.leftPad((String)("" + pluginNew.getPosizione()), (int)10);
                    mapPosizioniToNomi.put(posPad, pluginNew.getNome());
                    if (this.pluginsImage != null && this.pluginsImage.plugins.containsKey(pluginNew.getNome())) {
                        Plugin active = this.pluginsImage.plugins.get(pluginNew.getNome());
                        if (pluginNew.getData().after(active.getDate())) {
                            pluginDaEliminare.add(pluginNew.getNome());
                            Plugin pluginNewInstance = null;
                            try {
                                pluginNewInstance = new Plugin(pluginNew);
                            }
                            catch (Exception e) {
                                log.error("Errore durante l'istanziazione del plugin '" + pluginNew.getNome() + "': " + e.getMessage(), (Throwable)e);
                            }
                            if (pluginNewInstance == null) continue;
                            newImage.plugins.put(pluginNew.getNome(), pluginNewInstance);
                            continue;
                        }
                        newImage.plugins.put(pluginNew.getNome(), active);
                        continue;
                    }
                    Plugin pluginNewInstance = null;
                    try {
                        pluginNewInstance = new Plugin(pluginNew);
                    }
                    catch (Exception e) {
                        log.error("Errore durante l'istanziazione del plugin '" + pluginNew.getNome() + "': " + e.getMessage(), (Throwable)e);
                    }
                    if (pluginNewInstance == null) continue;
                    newImage.plugins.put(pluginNew.getNome(), pluginNewInstance);
                }
                if (!mapPosizioniToNomi.isEmpty()) {
                    ArrayList posizioni = new ArrayList();
                    posizioni.addAll(mapPosizioniToNomi.keySet());
                    Collections.sort(posizioni);
                    for (String pos : posizioni) {
                        newImage.pluginsActiveOrdered.add((String)mapPosizioniToNomi.get(pos));
                    }
                }
            }
            this.pluginsImageSwitchOld = this.pluginsImage;
            this.pluginsImage = newImage;
            if (!pluginDaEliminare.isEmpty()) {
                for (String pluginName : pluginDaEliminare) {
                    try {
                        this.pluginsImageSwitchOld.plugins.get(pluginName).close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.pluginsImageSwitchOld = null;
        }
        finally {
            this.lockImage.release(lock, "update");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SemaphoreLock lock = this.lockImage.acquireThrowRuntime("close");
        try {
            if (this.pluginsImage != null && this.pluginsImage.plugins.size() > 0) {
                for (Plugin plugin : this.pluginsImage.plugins.values()) {
                    try {
                        plugin.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.pluginsImageSwitchOld != null && this.pluginsImageSwitchOld.plugins.size() > 0) {
                for (Plugin plugin : this.pluginsImageSwitchOld.plugins.values()) {
                    try {
                        plugin.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            this.lockImage.release(lock, "close");
        }
    }

    public Class<?> findClass(Logger log, TipoPlugin tipoClasseDaRicercare, String className) throws ClassNotFoundException {
        return this.findClassEngine(log, tipoClasseDaRicercare, null, className, true);
    }

    public Class<?> findClass(Logger log, TipoPlugin tipoClasseDaRicercare, String className, boolean searchDefaultClassLoader) throws ClassNotFoundException {
        return this.findClassEngine(log, tipoClasseDaRicercare, null, className, searchDefaultClassLoader);
    }

    public Class<?> findClass(Logger log, String tipoClasseDaRicercare, String className) throws ClassNotFoundException {
        return this.findClassEngine(log, null, tipoClasseDaRicercare, className, true);
    }

    public Class<?> findClass(Logger log, String tipoClasseDaRicercare, String className, boolean searchDefaultClassLoader) throws ClassNotFoundException {
        return this.findClassEngine(log, null, tipoClasseDaRicercare, className, searchDefaultClassLoader);
    }

    private Class<?> findClassEngine(Logger log, TipoPlugin tipoClasseDaRicercare, String tipoClasseCustomDaRicercare, String className, boolean searchDefaultClassLoader) throws ClassNotFoundException {
        this.checkUpdate(log);
        ClassNotFoundException notFound = null;
        if (searchDefaultClassLoader) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                notFound = e;
            }
        }
        if (this.pluginsImage != null) {
            Class<?> c;
            PluginsImage image = this.pluginsImage;
            if (!image.pluginsActiveOrdered.isEmpty() && (c = this.findClassEngine(image, tipoClasseDaRicercare, tipoClasseCustomDaRicercare, className)) != null) {
                return c;
            }
        }
        if (notFound != null) {
            throw notFound;
        }
        return null;
    }

    private Class<?> findClassEngine(PluginsImage image, TipoPlugin tipoClasseDaRicercare, String tipoClasseCustomDaRicercare, String className) {
        List<String> listPluginsActiveOrdered = image.pluginsActiveOrdered;
        for (String pluginName : listPluginsActiveOrdered) {
            Class<?> c;
            Plugin plugin = image.plugins.get(pluginName);
            if (plugin == null || (c = this.findClassEngineByPlugin(plugin, tipoClasseDaRicercare, tipoClasseCustomDaRicercare, className)) == null) continue;
            return c;
        }
        return null;
    }

    private Class<?> findClassEngineByPlugin(Plugin plugin, TipoPlugin tipoClasseDaRicercare, String tipoClasseCustomDaRicercare, String className) {
        ClassLoader classLoader = null;
        classLoader = tipoClasseDaRicercare != null ? plugin.getClassLoader(tipoClasseDaRicercare) : plugin.getClassLoader(tipoClasseCustomDaRicercare);
        if (classLoader != null) {
            Class<?> c = null;
            try {
                c = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c != null) {
                return c;
            }
        }
        return null;
    }
}

