/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.condition.test;

import org.apache.logging.log4j.Level;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.plugins.utils.FilterUtils;
import org.openspcoop2.core.statistiche.StatisticaGiornaliera;
import org.openspcoop2.core.statistiche.StatisticaMensile;
import org.openspcoop2.core.statistiche.StatisticaOraria;
import org.openspcoop2.core.statistiche.StatisticaSettimanale;
import org.openspcoop2.core.statistiche.dao.IStatisticaGiornalieraServiceSearch;
import org.openspcoop2.core.statistiche.dao.IStatisticaMensileServiceSearch;
import org.openspcoop2.core.statistiche.dao.IStatisticaOrariaServiceSearch;
import org.openspcoop2.core.statistiche.dao.IStatisticaSettimanaleServiceSearch;
import org.openspcoop2.core.statistiche.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.statistiche.dao.jdbc.converter.StatisticaGiornalieraFieldConverter;
import org.openspcoop2.core.statistiche.dao.jdbc.converter.StatisticaMensileFieldConverter;
import org.openspcoop2.core.statistiche.dao.jdbc.converter.StatisticaOrariaFieldConverter;
import org.openspcoop2.core.statistiche.dao.jdbc.converter.StatisticaSettimanaleFieldConverter;
import org.openspcoop2.core.statistiche.model.StatisticaContenutiModel;
import org.openspcoop2.core.statistiche.model.StatisticaModel;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.dao.ITransazioneServiceSearch;
import org.openspcoop2.core.transazioni.dao.jdbc.converter.TransazioneFieldConverter;
import org.openspcoop2.generic_project.beans.AliasTableComplexField;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.monitor.engine.condition.FilterImpl;
import org.openspcoop2.monitor.sdk.condition.FilterFactory;
import org.openspcoop2.monitor.sdk.condition.IFilter;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.FilterFactoryException;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.slf4j.Logger;

public class TestConditions {
    public static void main(String[] args) throws Exception {
        TipiDatabase tipiDatabase = TipiDatabase.POSTGRESQL;
        LoggerWrapperFactory.setDefaultConsoleLogConfiguration((Level)Level.ALL);
        System.out.println("----------------------------- Repository Transazioni ------------------------------------");
        TestConditions.test(null, tipiDatabase);
        System.out.println("----------------------------- Repository Transazioni ------------------------------------");
        System.out.println("\n\n\n----------------------------- Repository Statistiche ------------------------------------");
        TestConditions.test(StatisticType.MENSILE, tipiDatabase);
        System.out.println("----------------------------- Repository Statistiche ------------------------------------");
    }

    private static IFilter newFilter(StatisticType statisticType, TipiDatabase tipiDatabase) throws FilterFactoryException {
        if (statisticType != null) {
            return FilterFactory.newFilterStatisticRepository((TipiDatabase)tipiDatabase, (StatisticType)statisticType);
        }
        return FilterFactory.newFilterTransactionRepository((TipiDatabase)tipiDatabase);
    }

    private static IPaginatedExpression newExpression(StatisticType statisticType, TipiDatabase tipiDatabase) throws ExpressionException, ExpressionNotImplementedException {
        TransazioneFieldConverter fieldConverter = null;
        if (statisticType != null) {
            switch (statisticType) {
                case ORARIA: {
                    fieldConverter = new StatisticaOrariaFieldConverter(tipiDatabase);
                    break;
                }
                case GIORNALIERA: {
                    fieldConverter = new StatisticaGiornalieraFieldConverter(tipiDatabase);
                    break;
                }
                case SETTIMANALE: {
                    fieldConverter = new StatisticaSettimanaleFieldConverter(tipiDatabase);
                    break;
                }
                case MENSILE: {
                    fieldConverter = new StatisticaMensileFieldConverter(tipiDatabase);
                }
            }
        } else {
            fieldConverter = new TransazioneFieldConverter(tipiDatabase);
        }
        JDBCPaginatedExpression pagExpression = new JDBCPaginatedExpression((ISQLFieldConverter)fieldConverter);
        if (statisticType != null) {
            pagExpression.and();
            StatisticaModel model = null;
            StatisticaContenutiModel contenutiModel = null;
            switch (statisticType) {
                case ORARIA: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    contenutiModel = StatisticaOraria.model().STATISTICA_ORARIA_CONTENUTI;
                    break;
                }
                case GIORNALIERA: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    contenutiModel = StatisticaGiornaliera.model().STATISTICA_GIORNALIERA_CONTENUTI;
                    break;
                }
                case SETTIMANALE: {
                    model = StatisticaSettimanale.model().STATISTICA_BASE;
                    contenutiModel = StatisticaSettimanale.model().STATISTICA_SETTIMANALE_CONTENUTI;
                    break;
                }
                case MENSILE: {
                    model = StatisticaMensile.model().STATISTICA_BASE;
                    contenutiModel = StatisticaMensile.model().STATISTICA_MENSILE_CONTENUTI;
                }
            }
            if (model == null) {
                throw new ExpressionException("Model is null");
            }
            if (contenutiModel == null) {
                throw new ExpressionException("ContenutiModel is null");
            }
            pagExpression.equals(model.SERVIZIO, (Object)"ServizioTest");
            pagExpression.equals(model.AZIONE, (Object)"AzioneTest");
            pagExpression.limit(25);
            pagExpression.offset(10);
            pagExpression.sortOrder(SortOrder.ASC);
            pagExpression.addOrder(model.SERVIZIO);
            pagExpression.addGroupBy(model.SERVIZIO);
            pagExpression.addGroupBy(contenutiModel.RISORSA_NOME);
            AliasTableComplexField af = new AliasTableComplexField((ComplexField)contenutiModel.FILTRO_NOME_1, FilterUtils.getNextAliasStatisticsTable());
            AliasTableComplexField afValore = new AliasTableComplexField((ComplexField)contenutiModel.FILTRO_VALORE_1, af.getAliasTable());
            pagExpression.addGroupBy((IField)af);
            pagExpression.addGroupBy((IField)afValore);
            AliasTableComplexField af2 = new AliasTableComplexField((ComplexField)contenutiModel.FILTRO_NOME_2, FilterUtils.getNextAliasStatisticsTable());
            AliasTableComplexField afValore2 = new AliasTableComplexField((ComplexField)contenutiModel.FILTRO_VALORE_2, af2.getAliasTable());
            pagExpression.addGroupBy((IField)af2);
            pagExpression.addGroupBy((IField)afValore2);
        } else {
            pagExpression.and();
            pagExpression.equals(Transazione.model().NOME_SERVIZIO, (Object)"ServizioTest");
            pagExpression.equals(Transazione.model().AZIONE, (Object)"AzioneTest");
            pagExpression.limit(25);
            pagExpression.offset(10);
            pagExpression.sortOrder(SortOrder.ASC);
            pagExpression.addOrder(Transazione.model().NOME_SOGGETTO_FRUITORE);
            pagExpression.addGroupBy(Transazione.model().PDD_RUOLO);
            pagExpression.addGroupBy(Transazione.model().PDD_CODICE);
            pagExpression.addGroupBy(Transazione.model().TIPO_SOGGETTO_FRUITORE);
            pagExpression.addGroupBy(Transazione.model().NOME_SOGGETTO_FRUITORE);
            pagExpression.addGroupBy(Transazione.model().TIPO_SOGGETTO_EROGATORE);
            pagExpression.addGroupBy(Transazione.model().NOME_SOGGETTO_EROGATORE);
            pagExpression.addGroupBy(Transazione.model().TIPO_SERVIZIO);
            pagExpression.addGroupBy(Transazione.model().NOME_SERVIZIO);
            pagExpression.addGroupBy(Transazione.model().AZIONE);
            pagExpression.addGroupBy(Transazione.model().SERVIZIO_APPLICATIVO_FRUITORE);
            pagExpression.addGroupBy(Transazione.model().ESITO);
            pagExpression.addGroupBy(Transazione.model().DUMP_MESSAGGIO.CONTENUTO.NOME);
            pagExpression.addGroupBy(Transazione.model().DUMP_MESSAGGIO.CONTENUTO.VALORE);
            AliasTableComplexField af = new AliasTableComplexField((ComplexField)Transazione.model().DUMP_MESSAGGIO.CONTENUTO.NOME, FilterUtils.getNextAliasStatisticsTable());
            AliasTableComplexField afValore = new AliasTableComplexField((ComplexField)Transazione.model().DUMP_MESSAGGIO.CONTENUTO.VALORE, af.getAliasTable());
            pagExpression.addGroupBy((IField)af);
            pagExpression.addGroupBy((IField)afValore);
        }
        return pagExpression;
    }

    private static void useExpression(StatisticType statisticType, IPaginatedExpression expression) throws ExpressionException, DAOFactoryException, ServiceException, NotImplementedException, NotFoundException {
        FunctionField functionField = null;
        if (statisticType != null) {
            JDBCServiceManager serviceManager = (JDBCServiceManager)DAOFactory.getInstance((Logger)LoggerWrapperFactory.getLogger(TestConditions.class)).getServiceManager((IProjectInfo)ProjectInfo.getInstance());
            switch (statisticType) {
                case ORARIA: {
                    functionField = new FunctionField(StatisticaOraria.model().STATISTICA_ORARIA_CONTENUTI.NUMERO_TRANSAZIONI, Function.SUM, "somma");
                    IStatisticaOrariaServiceSearch statOrariaSearviceSearch = serviceManager.getStatisticaOrariaServiceSearch();
                    try {
                        statOrariaSearviceSearch.groupBy(expression, new FunctionField[]{functionField});
                    }
                    catch (NotFoundException notFoundException) {}
                    break;
                }
                case GIORNALIERA: {
                    functionField = new FunctionField(StatisticaGiornaliera.model().STATISTICA_GIORNALIERA_CONTENUTI.NUMERO_TRANSAZIONI, Function.SUM, "somma");
                    IStatisticaGiornalieraServiceSearch statGiornalieraSearviceSearch = serviceManager.getStatisticaGiornalieraServiceSearch();
                    try {
                        statGiornalieraSearviceSearch.groupBy(expression, new FunctionField[]{functionField});
                    }
                    catch (NotFoundException notFoundException) {}
                    break;
                }
                case SETTIMANALE: {
                    functionField = new FunctionField(StatisticaSettimanale.model().STATISTICA_SETTIMANALE_CONTENUTI.NUMERO_TRANSAZIONI, Function.SUM, "somma");
                    IStatisticaSettimanaleServiceSearch statSettimanaleSearviceSearch = serviceManager.getStatisticaSettimanaleServiceSearch();
                    try {
                        statSettimanaleSearviceSearch.groupBy(expression, new FunctionField[]{functionField});
                    }
                    catch (NotFoundException notFoundException) {}
                    break;
                }
                case MENSILE: {
                    functionField = new FunctionField(StatisticaMensile.model().STATISTICA_MENSILE_CONTENUTI.NUMERO_TRANSAZIONI, Function.SUM, "somma");
                    IStatisticaMensileServiceSearch statMensileSearviceSearch = serviceManager.getStatisticaMensileServiceSearch();
                    try {
                        statMensileSearviceSearch.groupBy(expression, new FunctionField[]{functionField});
                        break;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        } else {
            functionField = new FunctionField(Transazione.model().ID_TRANSAZIONE, Function.COUNT, "somma");
            org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager serviceManager = (org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager)DAOFactory.getInstance((Logger)LoggerWrapperFactory.getLogger(TestConditions.class)).getServiceManager((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance());
            ITransazioneServiceSearch transazioneSearviceSearch = serviceManager.getTransazioneServiceSearch();
            try {
                transazioneSearviceSearch.groupBy(expression, new FunctionField[]{functionField});
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    public static void test(StatisticType statisticType, TipiDatabase tipiDatabase) throws SearchException, FilterFactoryException, ExpressionException, ExpressionNotImplementedException, DAOFactoryException, ServiceException, NotImplementedException, NotFoundException {
        IPaginatedExpression expression = TestConditions.newExpression(statisticType, tipiDatabase);
        FilterImpl filtro = (FilterImpl)TestConditions.newFilter(statisticType, tipiDatabase).equals("Resourcetest", (Object)"ValoreTest");
        FilterImpl filtro2 = (FilterImpl)filtro.newFilter().notEquals("ResourcetestB", (Object)"ValoreTestB");
        expression.and(new IExpression[]{filtro.getExpression()});
        expression.and(new IExpression[]{filtro2.getExpression()});
        TestConditions.useExpression(statisticType, expression);
    }
}

