/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils.credenziali;

import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenziale;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;

public class CredenzialeTrasporto
extends AbstractCredenziale {
    private String tipoAutenticazione;
    private String credential;

    public CredenzialeTrasporto(String tipoAutenticazione, String credential) {
        super(TipoCredenzialeMittente.TRASPORTO);
        this.tipoAutenticazione = tipoAutenticazione;
        this.credential = credential;
    }

    @Override
    public String getTipo() {
        return CredenzialeTrasporto.getTipoTrasporto(this.tipo, this.tipoAutenticazione);
    }

    public static String getTipoTrasporto(TipoCredenzialeMittente tipo, String tipoAutenticazione) {
        return tipo.getRawValue() + "_" + tipoAutenticazione;
    }

    @Override
    public String getCredenziale() throws UtilsException {
        if (CredenzialeTrasporto.isSsl(this.tipoAutenticazione)) {
            return CertificateUtils.formatPrincipal((String)this.credential, (PrincipalType)PrincipalType.SUBJECT);
        }
        return this.credential;
    }

    public boolean isSsl() {
        return TipoAutenticazione.SSL.getValue().equalsIgnoreCase(this.tipoAutenticazione);
    }

    public static boolean isSsl(String tipoAutenticazione) {
        return TipoAutenticazione.SSL.getValue().equalsIgnoreCase(tipoAutenticazione);
    }

    @Override
    public void updateCredenziale(String newCredential) throws UtilsException {
        this.credential = newCredential;
    }
}

