/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils.credenziali;

import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenziale;
import org.openspcoop2.utils.UtilsException;

public class CredenzialeTokenClient
extends AbstractCredenziale {
    private String clientId;
    private IDServizioApplicativo applicativo;
    private static final String PREFIX_CLIENT_ID = "#C#";
    private static final String PREFIX_APPLICATION = "#A#";

    public CredenzialeTokenClient(String clientId, IDServizioApplicativo applicativo) {
        super(TipoCredenzialeMittente.TOKEN_CLIENT_ID);
        this.clientId = clientId;
        this.applicativo = applicativo;
    }

    @Override
    public String getCredenziale() throws UtilsException {
        boolean applicativoDefined;
        boolean clientIdDefined = this.clientId != null && !"".equals(this.clientId);
        boolean bl = applicativoDefined = this.applicativo != null;
        if (clientIdDefined && applicativoDefined) {
            return CredenzialeTokenClient.getClientIdDBValue(this.clientId) + " " + CredenzialeTokenClient.getApplicationDBValue(CredenzialeTokenClient.getApplicationAsString(this.applicativo));
        }
        if (clientIdDefined) {
            return CredenzialeTokenClient.getClientIdDBValue(this.clientId);
        }
        return CredenzialeTokenClient.getApplicationDBValue(CredenzialeTokenClient.getApplicationAsString(this.applicativo));
    }

    public static String getApplicationAsString(IDServizioApplicativo applicativo) {
        return applicativo.toFormatString();
    }

    public static IDServizioApplicativo getApplicationFromStringValue(String v) throws CoreException {
        try {
            return IDServizioApplicativo.toIDServizioApplicativo(v);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
    }

    public static String getClientIdDBValue(String clientId) {
        return CredenzialeTokenClient.getClientIdDBValue(clientId, true);
    }

    public static String getClientIdDBValue(String clientId, boolean ricercaEsatta) {
        if (ricercaEsatta) {
            return PREFIX_CLIENT_ID + clientId + PREFIX_CLIENT_ID;
        }
        return "#C#%" + clientId + "%#C#";
    }

    public static String getApplicationDBValue(String applicative) {
        return CredenzialeTokenClient.getApplicationDBValue(applicative, true);
    }

    public static String getApplicationDBValue(String applicative, boolean ricercaEsatta) {
        if (ricercaEsatta) {
            return PREFIX_APPLICATION + applicative + PREFIX_APPLICATION;
        }
        return "#A#%" + applicative + "%#A#";
    }

    public static boolean isClientIdDBValue(String clientId) {
        return clientId.contains(PREFIX_CLIENT_ID);
    }

    public static boolean isApplicationDBValue(String applicative) {
        return applicative.contains(PREFIX_APPLICATION);
    }

    public static String convertClientIdDBValueToOriginal(String id) {
        if (CredenzialeTokenClient.isClientIdDBValue(id)) {
            id = id.trim();
            String[] tmp = id.split(PREFIX_CLIENT_ID);
            for (int i = 0; i < tmp.length; ++i) {
                String s = tmp[i];
                if (s == null || "".equals(s = s.trim()) || CredenzialeTokenClient.isApplicationDBValue(s)) continue;
                return s;
            }
        }
        return id;
    }

    public static IDServizioApplicativo convertApplicationDBValueToOriginal(String id) throws CoreException {
        String s = CredenzialeTokenClient.convertApplicationDBValueToOriginalAsString(id);
        if (s != null) {
            return CredenzialeTokenClient.getApplicationFromStringValue(s);
        }
        return null;
    }

    public static String convertApplicationDBValueToOriginalAsString(String id) {
        if (CredenzialeTokenClient.isApplicationDBValue(id)) {
            id = id.trim();
            String[] tmp = id.split(PREFIX_APPLICATION);
            for (int i = 0; i < tmp.length; ++i) {
                String s = tmp[i];
                if (s == null || "".equals(s = s.trim()) || CredenzialeTokenClient.isClientIdDBValue(s)) continue;
                return s;
            }
        }
        return null;
    }

    @Override
    public void updateCredenziale(String newCredential) throws UtilsException {
        throw new UtilsException("Aggiornamento non supportato dal tipo di credenziale");
    }
}

