/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils;

import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.IDAOFactory;
import org.openspcoop2.core.transazioni.IdTransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.dao.ITransazioneApplicativoServerService;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCTransazioneApplicativoServerService;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCTransazioneService;
import org.openspcoop2.core.transazioni.dao.jdbc.converter.TransazioneFieldConverter;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.Case;
import org.openspcoop2.utils.sql.CastColumnType;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class TransactionServerUtils {
    private static Random rndInstance = null;

    private TransactionServerUtils() {
    }

    public static boolean recover(ITransazioneApplicativoServerService transazioneService, TransazioneApplicativoServer serverInfoParam) throws CoreException, ServiceException, NotImplementedException, NotFoundException, MultipleResultException {
        boolean firstEntry;
        String idTransazione = serverInfoParam.getIdTransazione();
        if (idTransazione == null) {
            throw new CoreException("IdTransazione non esistente nel contesto");
        }
        String servizioApplicativoErogatore = serverInfoParam.getServizioApplicativoErogatore();
        if (servizioApplicativoErogatore == null) {
            throw new CoreException("Id servizioApplicativoErogatore non esistente nel contesto");
        }
        boolean bl = firstEntry = serverInfoParam.getDataUscitaRichiesta() == null && serverInfoParam.getDataPrelievoIm() == null && serverInfoParam.getDataEliminazioneIm() == null;
        if (firstEntry) {
            return TransactionServerUtils.save(transazioneService, serverInfoParam, false, false, true, false, null);
        }
        IdTransazioneApplicativoServer idTransazioneApplicativoServer = new IdTransazioneApplicativoServer();
        idTransazioneApplicativoServer.setIdTransazione(idTransazione);
        idTransazioneApplicativoServer.setServizioApplicativoErogatore(servizioApplicativoErogatore);
        if (transazioneService.exists(idTransazioneApplicativoServer)) {
            TransazioneApplicativoServer transazioneApplicativoServer = (TransazioneApplicativoServer)transazioneService.get(idTransazioneApplicativoServer);
            if (!transazioneApplicativoServer.isConsegnaTerminata() && transazioneApplicativoServer.getDataEliminazioneIm() == null && transazioneApplicativoServer.getDataMessaggioScaduto() == null) {
                boolean useSelectForUpdate = true;
                return TransactionServerUtils.save(transazioneService, serverInfoParam, true, false, true, useSelectForUpdate, null);
            }
            return false;
        }
        throw new CoreException("In attesa della registrazione dell'informazione capostipite");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(ITransazioneApplicativoServerService transazioneService, TransazioneApplicativoServer serverInfoParam, boolean update, boolean throwNotFoundIfNotExists, boolean recover, boolean useSelectForUpdate, List<String> timeDetails) throws CoreException, ServiceException, NotImplementedException, NotFoundException, MultipleResultException {
        long timeProcess;
        long timeEnd;
        String idTransazione;
        if (recover) {
            // empty if block
        }
        if ((idTransazione = serverInfoParam.getIdTransazione()) == null) {
            throw new CoreException("IdTransazione non esistente nel contesto");
        }
        String servizioApplicativoErogatore = serverInfoParam.getServizioApplicativoErogatore();
        if (servizioApplicativoErogatore == null) {
            throw new CoreException("Id servizioApplicativoErogatore non esistente nel contesto");
        }
        String protocol = serverInfoParam.getProtocollo();
        if (protocol == null) {
            throw new CoreException("Protocollo non esistente nel contesto");
        }
        IdTransazioneApplicativoServer idTransazioneApplicativoServer = new IdTransazioneApplicativoServer();
        idTransazioneApplicativoServer.setIdTransazione(idTransazione);
        idTransazioneApplicativoServer.setServizioApplicativoErogatore(servizioApplicativoErogatore);
        if (update) {
            long timeProcess2;
            long timeStart = -1L;
            if (timeDetails != null) {
                timeStart = DateManager.getTimeMillis();
            }
            TransazioneApplicativoServer transazioneApplicativoServerReadFromDB = null;
            IdTransazioneApplicativoServer idTransazioneApplicativoServerReadFromDB = null;
            if (useSelectForUpdate) {
                JDBCTransazioneApplicativoServerService transazioneServiceSearch = (JDBCTransazioneApplicativoServerService)transazioneService;
                try {
                    transazioneServiceSearch.enableSelectForUpdate();
                    transazioneApplicativoServerReadFromDB = (TransazioneApplicativoServer)transazioneService.get(idTransazioneApplicativoServer);
                }
                finally {
                    transazioneServiceSearch.disableSelectForUpdate();
                }
                idTransazioneApplicativoServerReadFromDB = idTransazioneApplicativoServer;
            } else {
                transazioneApplicativoServerReadFromDB = (TransazioneApplicativoServer)transazioneService.get(idTransazioneApplicativoServer);
                idTransazioneApplicativoServerReadFromDB = new IdTransazioneApplicativoServer();
                idTransazioneApplicativoServerReadFromDB.setId(transazioneApplicativoServerReadFromDB.getId());
            }
            if (timeDetails != null) {
                long timeEnd2 = DateManager.getTimeMillis();
                timeProcess2 = timeEnd2 - timeStart;
                timeDetails.add("readFromDB:" + timeProcess2);
                timeStart = DateManager.getTimeMillis();
            }
            if (throwNotFoundIfNotExists) {
                // empty if block
            }
            serverInfoParam.setDataRegistrazione(transazioneApplicativoServerReadFromDB.getDataRegistrazione());
            if (serverInfoParam.getDataMessaggioScaduto() != null) {
                if (transazioneApplicativoServerReadFromDB.getDataMessaggioScaduto() != null) {
                    return false;
                }
                transazioneApplicativoServerReadFromDB.setDataMessaggioScaduto(serverInfoParam.getDataMessaggioScaduto());
            } else if (serverInfoParam.getDataEliminazioneIm() != null) {
                if (transazioneApplicativoServerReadFromDB.getDataEliminazioneIm() != null) {
                    return false;
                }
                transazioneApplicativoServerReadFromDB.setDataEliminazioneIm(serverInfoParam.getDataEliminazioneIm());
                transazioneApplicativoServerReadFromDB.setClusterIdEliminazioneIm(serverInfoParam.getClusterIdEliminazioneIm());
                transazioneApplicativoServerReadFromDB.setConsegnaTerminata(true);
            } else if (serverInfoParam.getDataPrelievoIm() != null) {
                if (transazioneApplicativoServerReadFromDB.getDataEliminazioneIm() != null) {
                    return false;
                }
                transazioneApplicativoServerReadFromDB.setDataPrelievoIm(serverInfoParam.getDataPrelievoIm());
                if (transazioneApplicativoServerReadFromDB.getDataPrimoPrelievoIm() == null && serverInfoParam.getDataPrelievoIm() != null) {
                    transazioneApplicativoServerReadFromDB.setDataPrimoPrelievoIm(serverInfoParam.getDataPrelievoIm());
                }
                transazioneApplicativoServerReadFromDB.setNumeroPrelieviIm(transazioneApplicativoServerReadFromDB.getNumeroPrelieviIm() + 1);
                transazioneApplicativoServerReadFromDB.setClusterIdPrelievoIm(serverInfoParam.getClusterIdPrelievoIm());
            } else {
                if (transazioneApplicativoServerReadFromDB.isConsegnaTerminata()) {
                    return false;
                }
                transazioneApplicativoServerReadFromDB.setConsegnaTerminata(serverInfoParam.isConsegnaTerminata());
                transazioneApplicativoServerReadFromDB.setDettaglioEsito(serverInfoParam.getDettaglioEsito());
                transazioneApplicativoServerReadFromDB.setDataAccettazioneRichiesta(serverInfoParam.getDataAccettazioneRichiesta());
                transazioneApplicativoServerReadFromDB.setDataUscitaRichiesta(serverInfoParam.getDataUscitaRichiesta());
                transazioneApplicativoServerReadFromDB.setDataUscitaRichiestaStream(serverInfoParam.getDataUscitaRichiestaStream());
                transazioneApplicativoServerReadFromDB.setDataAccettazioneRisposta(serverInfoParam.getDataAccettazioneRisposta());
                transazioneApplicativoServerReadFromDB.setDataIngressoRisposta(serverInfoParam.getDataIngressoRisposta());
                transazioneApplicativoServerReadFromDB.setDataIngressoRispostaStream(serverInfoParam.getDataIngressoRispostaStream());
                transazioneApplicativoServerReadFromDB.setRichiestaUscitaBytes(serverInfoParam.getRichiestaUscitaBytes());
                transazioneApplicativoServerReadFromDB.setRispostaIngressoBytes(serverInfoParam.getRispostaIngressoBytes());
                transazioneApplicativoServerReadFromDB.setLocationConnettore(serverInfoParam.getLocationConnettore());
                transazioneApplicativoServerReadFromDB.setCodiceRisposta(serverInfoParam.getCodiceRisposta());
                transazioneApplicativoServerReadFromDB.setFault(serverInfoParam.getFault());
                transazioneApplicativoServerReadFromDB.setFormatoFault(serverInfoParam.getFormatoFault());
                if (transazioneApplicativoServerReadFromDB.getDataPrimoTentativo() == null && serverInfoParam.getDataUscitaRichiesta() != null) {
                    transazioneApplicativoServerReadFromDB.setDataPrimoTentativo(serverInfoParam.getDataUscitaRichiesta());
                }
                transazioneApplicativoServerReadFromDB.setNumeroTentativi(transazioneApplicativoServerReadFromDB.getNumeroTentativi() + 1);
                transazioneApplicativoServerReadFromDB.setClusterIdConsegna(serverInfoParam.getClusterIdConsegna());
                if (!serverInfoParam.isConsegnaTerminata()) {
                    if (serverInfoParam.getDataUscitaRichiesta() != null) {
                        transazioneApplicativoServerReadFromDB.setDataUltimoErrore(serverInfoParam.getDataUscitaRichiesta());
                    } else {
                        transazioneApplicativoServerReadFromDB.setDataUltimoErrore(serverInfoParam.getDataAccettazioneRichiesta());
                    }
                    transazioneApplicativoServerReadFromDB.setDettaglioEsitoUltimoErrore(serverInfoParam.getDettaglioEsito());
                    transazioneApplicativoServerReadFromDB.setCodiceRispostaUltimoErrore(serverInfoParam.getCodiceRisposta());
                    transazioneApplicativoServerReadFromDB.setUltimoErrore(serverInfoParam.getUltimoErrore());
                    transazioneApplicativoServerReadFromDB.setLocationUltimoErrore(serverInfoParam.getLocationConnettore());
                    transazioneApplicativoServerReadFromDB.setClusterIdUltimoErrore(serverInfoParam.getClusterIdConsegna());
                    transazioneApplicativoServerReadFromDB.setFaultUltimoErrore(serverInfoParam.getFault());
                    transazioneApplicativoServerReadFromDB.setFormatoFaultUltimoErrore(serverInfoParam.getFormatoFault());
                }
            }
            if (timeDetails != null) {
                long timeEnd3 = DateManager.getTimeMillis();
                timeProcess2 = timeEnd3 - timeStart;
                timeDetails.add("prepareUpdate:" + timeProcess2);
                timeStart = DateManager.getTimeMillis();
            }
            transazioneService.update(idTransazioneApplicativoServerReadFromDB, transazioneApplicativoServerReadFromDB);
            if (timeDetails != null) {
                long timeEnd4 = DateManager.getTimeMillis();
                timeProcess2 = timeEnd4 - timeStart;
                timeDetails.add("update:" + timeProcess2);
            }
            return true;
        }
        long timeStart = -1L;
        if (timeDetails != null) {
            timeStart = DateManager.getTimeMillis();
        }
        TransazioneApplicativoServer transazioneApplicativoServer = serverInfoParam;
        transazioneApplicativoServer.setProtocollo(protocol);
        if (transazioneApplicativoServer.getDataRegistrazione() == null) {
            transazioneApplicativoServer.setDataRegistrazione(DateManager.getDate());
        }
        if (transazioneApplicativoServer.getDataUscitaRichiesta() != null) {
            transazioneApplicativoServer.setDataPrimoTentativo(transazioneApplicativoServer.getDataUscitaRichiesta());
        }
        if (transazioneApplicativoServer.getDataPrelievoIm() != null) {
            transazioneApplicativoServer.setDataPrimoPrelievoIm(transazioneApplicativoServer.getDataPrelievoIm());
        }
        transazioneApplicativoServer.setNumeroTentativi(0);
        transazioneApplicativoServer.setNumeroPrelieviIm(0);
        transazioneApplicativoServer.setClusterIdPresaInCarico(serverInfoParam.getClusterIdPresaInCarico());
        if (timeDetails != null) {
            timeEnd = DateManager.getTimeMillis();
            timeProcess = timeEnd - timeStart;
            timeDetails.add("prepareInsert:" + timeProcess);
            timeStart = DateManager.getTimeMillis();
        }
        transazioneService.create(transazioneApplicativoServer);
        if (timeDetails != null) {
            timeEnd = DateManager.getTimeMillis();
            timeProcess = timeEnd - timeStart;
            timeDetails.add("insert:" + timeProcess);
            timeStart = DateManager.getTimeMillis();
        }
        return true;
    }

    public static boolean safeAggiornaInformazioneConsegnaTerminata(TransazioneApplicativoServer transazioneApplicativoServer, Connection con, String tipoDatabase, Logger logCore, IDAOFactory daoFactory, Logger logFactory, ServiceManagerProperties smpFactory, boolean debug, int esitoConsegnaMultipla, int esitoConsegnaMultiplaInCorso, int esitoConsegnaMultiplaFallita, int esitoConsegnaMultiplaCompletata, int ok, int esitoIntegrationManagerSingolo, boolean possibileTerminazioneSingleIntegrationManagerMessage, boolean consegnaInErrore, long gestioneSerializableDBAttesaAttiva, int gestioneSerializableDBCheckInterval, List<String> timeDetails) {
        try {
            return TransactionServerUtils.aggiornaInformazioneConsegnaTerminata(transazioneApplicativoServer, con, tipoDatabase, logCore, daoFactory, logFactory, smpFactory, debug, esitoConsegnaMultipla, esitoConsegnaMultiplaInCorso, esitoConsegnaMultiplaFallita, esitoConsegnaMultiplaCompletata, ok, esitoIntegrationManagerSingolo, possibileTerminazioneSingleIntegrationManagerMessage, consegnaInErrore, gestioneSerializableDBAttesaAttiva, gestioneSerializableDBCheckInterval, timeDetails);
        }
        catch (Throwable e) {
            String msg = "Errore durante l'aggiornamento delle transazione relativamente all'informazione del server: " + e.getLocalizedMessage();
            logCore.error("[id:" + transazioneApplicativoServer.getIdTransazione() + "][sa:" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "][" + transazioneApplicativoServer.getConnettoreNome() + "] " + msg, e);
            return false;
        }
    }

    private static boolean aggiornaInformazioneConsegnaTerminata(TransazioneApplicativoServer transazioneApplicativoServer, Connection connectionDB, String tipoDatabase, Logger logCore, IDAOFactory daoFactory, Logger logFactory, ServiceManagerProperties smpFactory, boolean debug, int esitoConsegnaMultipla, int esitoConsegnaMultiplaInCorso, int esitoConsegnaMultiplaFallita, int esitoConsegnaMultiplaCompletata, int ok, int esitoIntegrationManagerSingolo, boolean possibileTerminazioneSingleIntegrationManagerMessage, boolean consegnaInErrore, long gestioneSerializableDBAttesaAttiva, int gestioneSerializableDBCheckInterval, List<String> timeDetails) throws CoreException {
        boolean consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda = false;
        if (possibileTerminazioneSingleIntegrationManagerMessage || consegnaInErrore) {
            int i = 0;
            if (transazioneApplicativoServer.getDataRegistrazione() == null) {
                i = 2;
            }
            int esitoTransazione = -1;
            while (i < 3) {
                long timeStart = -1L;
                if (timeDetails != null) {
                    timeStart = DateManager.getTimeMillis();
                }
                Timestamp leftValue = null;
                Timestamp rightValue = null;
                if (i == 0) {
                    leftValue = new Timestamp(transazioneApplicativoServer.getDataRegistrazione().getTime() - 300000L);
                    rightValue = new Timestamp(transazioneApplicativoServer.getDataRegistrazione().getTime() + 300000L);
                } else if (i == 1) {
                    leftValue = new Timestamp(transazioneApplicativoServer.getDataRegistrazione().getTime() - 3600000L);
                    rightValue = new Timestamp(transazioneApplicativoServer.getDataRegistrazione().getTime() + 3600000L);
                }
                esitoTransazione = TransactionServerUtils.getEsitoTransazione(transazioneApplicativoServer, connectionDB, tipoDatabase, logCore, leftValue, rightValue);
                if (timeDetails != null) {
                    long timeEnd = DateManager.getTimeMillis();
                    long timeProcess = timeEnd - timeStart;
                    timeDetails.add("getEsitoIM-" + i + ":" + timeProcess);
                }
                if (esitoTransazione >= 0) {
                    if (possibileTerminazioneSingleIntegrationManagerMessage && esitoIntegrationManagerSingolo == esitoTransazione) {
                        return true;
                    }
                    if (!consegnaInErrore) break;
                    if (esitoConsegnaMultipla == esitoTransazione) {
                        consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda = true;
                        break;
                    }
                    return true;
                }
                ++i;
            }
            if (esitoTransazione < 0) {
                String msgError = "[id:" + transazioneApplicativoServer.getIdTransazione() + "][sa:" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "][" + transazioneApplicativoServer.getConnettoreNome() + "] 'getEsitoTransazione' non riuscta. Tutti gli intervalli non hanno consentito di inviduare la transazione";
                logFactory.error(msgError);
                logCore.error(msgError);
            }
        }
        return TransactionServerUtils.aggiornaInformazioneConsegnaTerminataEngine(transazioneApplicativoServer, connectionDB, tipoDatabase, logCore, daoFactory, logFactory, smpFactory, debug, esitoConsegnaMultipla, esitoConsegnaMultiplaInCorso, esitoConsegnaMultiplaFallita, esitoConsegnaMultiplaCompletata, ok, consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda, gestioneSerializableDBAttesaAttiva, gestioneSerializableDBCheckInterval, timeDetails);
    }

    private static boolean aggiornaInformazioneConsegnaTerminataEngine(TransazioneApplicativoServer transazioneApplicativoServer, Connection connectionDB, String tipoDatabase, Logger logCore, IDAOFactory daoFactory, Logger logFactory, ServiceManagerProperties smpFactory, boolean debug, int esitoConsegnaMultipla, int esitoConsegnaMultiplaInCorso, int esitoConsegnaMultiplaFallita, int esitoConsegnaMultiplaCompletata, int ok, boolean consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda, long gestioneSerializableDBAttesaAttiva, int gestioneSerializableDBCheckInterval, List<String> timeDetails) throws CoreException {
        boolean useSerializableMode = false;
        if (useSerializableMode) {
            TransactionServerUtils.serializableModeAggiornaInformazioneConsegnaTerminataEngine(transazioneApplicativoServer, connectionDB, tipoDatabase, logCore, daoFactory, logFactory, smpFactory, debug, esitoConsegnaMultipla, esitoConsegnaMultiplaFallita, esitoConsegnaMultiplaCompletata, ok, consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda, gestioneSerializableDBAttesaAttiva, gestioneSerializableDBCheckInterval);
            return true;
        }
        boolean transazioneGiaModificata = false;
        int i = 0;
        if (transazioneApplicativoServer.getDataRegistrazione() == null) {
            i = 2;
        }
        int row = -1;
        while (i < 3) {
            long timeStart = -1L;
            if (timeDetails != null) {
                timeStart = DateManager.getTimeMillis();
            }
            Timestamp leftValue = null;
            Timestamp rightValue = null;
            if (i == 0) {
                leftValue = new Timestamp(transazioneApplicativoServer.getDataRegistrazione().getTime() - 300000L);
                rightValue = new Timestamp(transazioneApplicativoServer.getDataRegistrazione().getTime() + 300000L);
            } else if (i == 1) {
                leftValue = new Timestamp(transazioneApplicativoServer.getDataRegistrazione().getTime() - 3600000L);
                rightValue = new Timestamp(transazioneApplicativoServer.getDataRegistrazione().getTime() + 3600000L);
            }
            boolean useSERIALIZABLE = true;
            StringBuilder sbConflict = new StringBuilder();
            row = TransactionServerUtils.aggiornaInformazioneConsegnaTerminataEngine(transazioneApplicativoServer, connectionDB, tipoDatabase, logCore, logFactory, esitoConsegnaMultipla, esitoConsegnaMultiplaInCorso, esitoConsegnaMultiplaFallita, esitoConsegnaMultiplaCompletata, ok, consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda, leftValue, rightValue, useSERIALIZABLE, gestioneSerializableDBAttesaAttiva, gestioneSerializableDBCheckInterval, sbConflict);
            if (timeDetails != null) {
                long timeEnd = DateManager.getTimeMillis();
                long timeProcess = timeEnd - timeStart;
                Object c = "";
                if (useSERIALIZABLE && sbConflict.length() > 0) {
                    c = "/c" + sbConflict.toString();
                }
                timeDetails.add("updateInfo-" + i + ":" + timeProcess + (String)c);
            }
            if (row > 0 || consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda && (transazioneGiaModificata = TransactionServerUtils.existsTransazioneIniziataGestioneConsegnaAsincrona(transazioneApplicativoServer, connectionDB, tipoDatabase, logCore, esitoConsegnaMultiplaInCorso, esitoConsegnaMultiplaFallita, esitoConsegnaMultiplaCompletata, leftValue, rightValue))) break;
            ++i;
        }
        if (row <= 0 && !transazioneGiaModificata) {
            String msgError = "[id:" + transazioneApplicativoServer.getIdTransazione() + "][sa:" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "][" + transazioneApplicativoServer.getConnettoreNome() + "] 'aggiornaInformazioneConsegnaTerminata' non riuscta. Tutti gli intervalli di update non hanno comportato un aggiornamento della transazione";
            logFactory.error(msgError);
            logCore.error(msgError);
            return false;
        }
        return true;
    }

    private static synchronized void initRandom() {
        if (rndInstance == null) {
            rndInstance = new SecureRandom();
        }
    }

    protected static Random getRandom() {
        if (rndInstance == null) {
            TransactionServerUtils.initRandom();
        }
        return rndInstance;
    }

    private static int aggiornaInformazioneConsegnaTerminataEngine(TransazioneApplicativoServer transazioneApplicativoServer, Connection connectionDB, String tipoDatabase, Logger logCore, Logger logFactory, int esitoConsegnaMultipla, int esitoConsegnaMultiplaInCorso, int esitoConsegnaMultiplaFallita, int esitoConsegnaMultiplaCompletata, int ok, boolean consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda, Timestamp leftValue, Timestamp rightValue, boolean serializable, long gestioneSerializableDBAttesaAttiva, int gestioneSerializableDBCheckInterval, StringBuilder sbConflict) throws CoreException {
        if (serializable) {
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                JDBCUtilities.setTransactionIsolationSerializable((String)tipoDatabase, (Connection)connectionDB);
            }
            catch (Exception er) {
                throw new CoreException("(setIsolation) " + er.getMessage(), er);
            }
            boolean updateEffettuato = false;
            long scadenzaWhile = DateManager.getTimeMillis() + gestioneSerializableDBAttesaAttiva;
            int row = -1;
            Throwable lastT = null;
            int conflitti = 0;
            while (!updateEffettuato && DateManager.getTimeMillis() < scadenzaWhile) {
                try {
                    row = TransactionServerUtils.aggiornaInformazioneConsegnaTerminataEngine(transazioneApplicativoServer, connectionDB, tipoDatabase, logCore, esitoConsegnaMultipla, esitoConsegnaMultiplaInCorso, esitoConsegnaMultiplaFallita, esitoConsegnaMultiplaCompletata, ok, consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda, leftValue, rightValue);
                    updateEffettuato = true;
                }
                catch (Throwable e) {
                    lastT = e;
                }
                if (updateEffettuato) continue;
                try {
                    Utilities.sleep((long)TransactionServerUtils.getRandom().nextInt(gestioneSerializableDBCheckInterval));
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++conflitti;
            }
            sbConflict.append(conflitti + "/updated:" + updateEffettuato);
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
            }
            catch (Exception er) {
                throw new CoreException("(ripristinoIsolation) " + er.getMessage(), er);
            }
            if (lastT != null && !updateEffettuato) {
                String date = "";
                if (leftValue != null || rightValue != null) {
                    StringBuilder sb = new StringBuilder(" [");
                    if (leftValue != null) {
                        sb.append(DateUtils.getSimpleDateFormatMs().format(leftValue));
                        if (rightValue != null) {
                            sb.append(" - ");
                        }
                    }
                    if (rightValue != null) {
                        sb.append(DateUtils.getSimpleDateFormatMs().format(rightValue));
                    }
                    sb.append("]");
                    date = sb.toString();
                }
                String msgError = "[id:" + transazioneApplicativoServer.getIdTransazione() + "][sa:" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "][" + transazioneApplicativoServer.getConnettoreNome() + "] 'aggiornaInformazioneConsegnaTerminata'" + date + " failed: " + lastT.getMessage();
                logFactory.error(msgError, lastT);
                logCore.error(msgError, lastT);
            }
            return row;
        }
        return TransactionServerUtils.aggiornaInformazioneConsegnaTerminataEngine(transazioneApplicativoServer, connectionDB, tipoDatabase, logCore, esitoConsegnaMultipla, esitoConsegnaMultiplaInCorso, esitoConsegnaMultiplaFallita, esitoConsegnaMultiplaCompletata, ok, consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda, leftValue, rightValue);
    }

    private static int aggiornaInformazioneConsegnaTerminataEngine(TransazioneApplicativoServer transazioneApplicativoServer, Connection connectionDB, String tipoDatabase, Logger logCore, int esitoConsegnaMultipla, int esitoConsegnaMultiplaInCorso, int esitoConsegnaMultiplaFallita, int esitoConsegnaMultiplaCompletata, int ok, boolean consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda, Timestamp leftValue, Timestamp rightValue) throws CoreException {
        Statement pstmt = null;
        try {
            TransazioneFieldConverter transazioneFieldConverter = new TransazioneFieldConverter(tipoDatabase);
            String dataIngressoRichiestaColumn = transazioneFieldConverter.toColumn(Transazione.model().DATA_INGRESSO_RICHIESTA, false);
            String idTransazioneColumn = transazioneFieldConverter.toColumn(Transazione.model().ID_TRANSAZIONE, false);
            String esitoColumn = transazioneFieldConverter.toColumn(Transazione.model().ESITO, false);
            String consegneMultipleInCorsoColumn = transazioneFieldConverter.toColumn(Transazione.model().CONSEGNE_MULTIPLE_IN_CORSO, false);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addUpdateTable("transazioni");
            if (consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda) {
                sqlQueryObject.addUpdateField(esitoColumn, "?");
            } else {
                sqlQueryObject.addUpdateField(consegneMultipleInCorsoColumn, consegneMultipleInCorsoColumn + "-1");
                if (ok != transazioneApplicativoServer.getDettaglioEsito() || transazioneApplicativoServer.getDataMessaggioScaduto() != null) {
                    sqlQueryObject.addUpdateField(esitoColumn, "?");
                } else {
                    Case caseValue = new Case(CastColumnType.INT, esitoColumn);
                    caseValue.addCase(consegneMultipleInCorsoColumn + "<=? AND (" + esitoColumn + "=? OR " + esitoColumn + "=?)", "?");
                    caseValue.addCase(consegneMultipleInCorsoColumn + ">? AND " + esitoColumn + "=?", "?");
                    sqlQueryObject.addUpdateField(esitoColumn, caseValue);
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            if (leftValue != null && rightValue != null) {
                sqlQueryObject.addWhereBetweenCondition(dataIngressoRichiestaColumn, false, "?", "?");
            }
            sqlQueryObject.addWhereCondition(idTransazioneColumn + "=?");
            if (consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda) {
                sqlQueryObject.addWhereCondition(esitoColumn + "=?");
            } else {
                sqlQueryObject.addWhereCondition(false, new String[]{esitoColumn + "=?", esitoColumn + "=?", esitoColumn + "=?"});
            }
            String updateCommand = sqlQueryObject.createSQLUpdate();
            pstmt = connectionDB.prepareStatement(updateCommand);
            int index = 1;
            ArrayList<Object> params = new ArrayList<Object>();
            if (consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda) {
                pstmt.setInt(index++, esitoConsegnaMultiplaInCorso);
                params.add(esitoConsegnaMultiplaInCorso);
            } else if (ok != transazioneApplicativoServer.getDettaglioEsito() || transazioneApplicativoServer.getDataMessaggioScaduto() != null) {
                pstmt.setInt(index++, esitoConsegnaMultiplaFallita);
                params.add(esitoConsegnaMultiplaFallita);
            } else {
                pstmt.setInt(index++, 1);
                params.add(1);
                pstmt.setInt(index++, esitoConsegnaMultipla);
                params.add(esitoConsegnaMultipla);
                pstmt.setInt(index++, esitoConsegnaMultiplaInCorso);
                params.add(esitoConsegnaMultiplaInCorso);
                pstmt.setInt(index++, esitoConsegnaMultiplaCompletata);
                params.add(esitoConsegnaMultiplaCompletata);
                pstmt.setInt(index++, 1);
                params.add(1);
                pstmt.setInt(index++, esitoConsegnaMultipla);
                params.add(esitoConsegnaMultipla);
                pstmt.setInt(index++, esitoConsegnaMultiplaInCorso);
                params.add(esitoConsegnaMultiplaInCorso);
            }
            if (leftValue != null && rightValue != null) {
                pstmt.setTimestamp(index++, leftValue);
                params.add(DateUtils.getSimpleDateFormatMs().format(leftValue));
                pstmt.setTimestamp(index++, rightValue);
                params.add(DateUtils.getSimpleDateFormatMs().format(rightValue));
            }
            pstmt.setString(index++, transazioneApplicativoServer.getIdTransazione());
            params.add(transazioneApplicativoServer.getIdTransazione());
            if (consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda) {
                pstmt.setInt(index++, esitoConsegnaMultipla);
                params.add(esitoConsegnaMultipla);
            } else {
                pstmt.setInt(index++, esitoConsegnaMultipla);
                params.add(esitoConsegnaMultipla);
                pstmt.setInt(index++, esitoConsegnaMultiplaInCorso);
                params.add(esitoConsegnaMultiplaInCorso);
                pstmt.setInt(index++, esitoConsegnaMultiplaFallita);
                params.add(esitoConsegnaMultiplaFallita);
            }
            int row = pstmt.executeUpdate();
            if (row != 1 && logCore != null) {
                String comandoSql = DBUtils.formatSQLString(updateCommand, params.toArray());
                String prefix = "Trovata transazione con id '" + transazioneApplicativoServer.getIdTransazione() + "' ";
                if (row < 1) {
                    String msg = prefix + "per cui il comando di aggiornamento della transazione non ha comportato effetti: " + comandoSql;
                    logCore.debug(msg);
                } else {
                    throw new CoreException(prefix + "??");
                }
            }
            pstmt.close();
            pstmt = null;
            connectionDB.commit();
            int n = row;
            return n;
        }
        catch (Throwable e) {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                connectionDB.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CoreException(e.getMessage(), e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static boolean existsTransazioneIniziataGestioneConsegnaAsincrona(TransazioneApplicativoServer transazioneApplicativoServer, Connection connectionDB, String tipoDatabase, Logger logCore, int esitoConsegnaMultiplaInCorso, int esitoConsegnaMultiplaFallita, int esitoConsegnaMultiplaCompletata, Timestamp leftValue, Timestamp rightValue) throws CoreException {
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            TransazioneFieldConverter transazioneFieldConverter = new TransazioneFieldConverter(tipoDatabase);
            String dataIngressoRichiestaColumn = transazioneFieldConverter.toColumn(Transazione.model().DATA_INGRESSO_RICHIESTA, false);
            String idTransazioneColumn = transazioneFieldConverter.toColumn(Transazione.model().ID_TRANSAZIONE, false);
            String esitoColumn = transazioneFieldConverter.toColumn(Transazione.model().ESITO, false);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            String countAlias = "conteggio";
            sqlQueryObject.addSelectCountField(idTransazioneColumn, countAlias);
            sqlQueryObject.addFromTable("transazioni");
            sqlQueryObject.setANDLogicOperator(true);
            if (leftValue != null && rightValue != null) {
                sqlQueryObject.addWhereBetweenCondition(dataIngressoRichiestaColumn, false, "?", "?");
            }
            sqlQueryObject.addWhereCondition(idTransazioneColumn + "=?");
            sqlQueryObject.addWhereCondition(false, new String[]{esitoColumn + "=?", esitoColumn + "=?", esitoColumn + "=?"});
            String queryCommand = sqlQueryObject.createSQLQuery();
            pstmt = connectionDB.prepareStatement(queryCommand);
            int index = 1;
            ArrayList<Object> params = new ArrayList<Object>();
            if (leftValue != null && rightValue != null) {
                pstmt.setTimestamp(index++, leftValue);
                params.add(DateUtils.getSimpleDateFormatMs().format(leftValue));
                pstmt.setTimestamp(index++, rightValue);
                params.add(DateUtils.getSimpleDateFormatMs().format(rightValue));
            }
            pstmt.setString(index++, transazioneApplicativoServer.getIdTransazione());
            params.add(transazioneApplicativoServer.getIdTransazione());
            pstmt.setInt(index++, esitoConsegnaMultiplaInCorso);
            params.add(esitoConsegnaMultiplaInCorso);
            pstmt.setInt(index++, esitoConsegnaMultiplaFallita);
            params.add(esitoConsegnaMultiplaFallita);
            pstmt.setInt(index++, esitoConsegnaMultiplaCompletata);
            params.add(esitoConsegnaMultiplaCompletata);
            int count = 0;
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(countAlias);
            } else if (logCore != null) {
                String comandoSql = DBUtils.formatSQLString(queryCommand, params.toArray());
                if (count < 1) {
                    String msg = "Non trovata transazione con id '" + transazioneApplicativoServer.getIdTransazione() + "' gi\u00e0 in gestione: " + comandoSql;
                    logCore.debug(msg);
                } else {
                    throw new CoreException("Trovata pi\u00f9 di una transazione con id '" + transazioneApplicativoServer.getIdTransazione() + "' ??");
                }
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            boolean bl = count > 0;
            return bl;
        }
        catch (Throwable e) {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                connectionDB.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CoreException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static int getEsitoTransazione(TransazioneApplicativoServer transazioneApplicativoServer, Connection connectionDB, String tipoDatabase, Logger logCore, Timestamp leftValue, Timestamp rightValue) throws CoreException {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            TransazioneFieldConverter transazioneFieldConverter = new TransazioneFieldConverter(tipoDatabase);
            String dataIngressoRichiestaColumn = transazioneFieldConverter.toColumn(Transazione.model().DATA_INGRESSO_RICHIESTA, false);
            String idTransazioneColumn = transazioneFieldConverter.toColumn(Transazione.model().ID_TRANSAZIONE, false);
            String esitoColumn = transazioneFieldConverter.toColumn(Transazione.model().ESITO, false);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("transazioni");
            sqlQueryObject.addSelectField(esitoColumn);
            sqlQueryObject.setANDLogicOperator(true);
            if (leftValue != null && rightValue != null) {
                sqlQueryObject.addWhereBetweenCondition(dataIngressoRichiestaColumn, false, "?", "?");
            }
            sqlQueryObject.addWhereCondition(idTransazioneColumn + "=?");
            String select = sqlQueryObject.createSQLQuery();
            pstmt = connectionDB.prepareStatement(select);
            int index = 1;
            ArrayList<String> params = new ArrayList<String>();
            if (leftValue != null && rightValue != null) {
                pstmt.setTimestamp(index++, leftValue);
                params.add(DateUtils.getSimpleDateFormatMs().format(leftValue));
                pstmt.setTimestamp(index++, rightValue);
                params.add(DateUtils.getSimpleDateFormatMs().format(rightValue));
            }
            pstmt.setString(index++, transazioneApplicativoServer.getIdTransazione());
            params.add(transazioneApplicativoServer.getIdTransazione());
            rs = pstmt.executeQuery();
            int esitoReturn = -1;
            while (rs.next()) {
                int found = rs.getInt(esitoColumn);
                if (logCore == null) continue;
                String comandoSql = DBUtils.formatSQLString(select, params.toArray());
                if (esitoReturn < 0) {
                    esitoReturn = found;
                    continue;
                }
                rs.close();
                pstmt.close();
                throw new CoreException("Trovata pi\u00f9 di una transazione con id '" + transazioneApplicativoServer.getIdTransazione() + "' ?? (query: " + comandoSql + ")");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            connectionDB.commit();
            int n = esitoReturn;
            return n;
        }
        catch (Throwable e) {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                connectionDB.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CoreException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static boolean existsTransaction(String idTransaction, Connection connectionDB, String tipoDatabase, Logger logCore, boolean connectionDBCommit) throws CoreException {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            if (logCore != null) {
                // empty if block
            }
            TransazioneFieldConverter transazioneFieldConverter = new TransazioneFieldConverter(tipoDatabase);
            String idTransazioneColumn = transazioneFieldConverter.toColumn(Transazione.model().ID_TRANSAZIONE, false);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("transazioni");
            sqlQueryObject.addSelectField(idTransazioneColumn);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(idTransazioneColumn + "=?");
            String select = sqlQueryObject.createSQLQuery();
            pstmt = connectionDB.prepareStatement(select);
            int index = 1;
            ArrayList<String> params = new ArrayList<String>();
            pstmt.setString(index++, idTransaction);
            params.add(idTransaction);
            rs = pstmt.executeQuery();
            boolean esitoReturn = rs.next();
            rs.close();
            pstmt.close();
            pstmt = null;
            if (connectionDBCommit) {
                connectionDB.commit();
            }
            boolean bl = esitoReturn;
            return bl;
        }
        catch (Throwable e) {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                connectionDB.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CoreException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    @Deprecated
    private static void serializableModeAggiornaInformazioneConsegnaTerminataEngine(TransazioneApplicativoServer transazioneApplicativoServer, Connection connectionDB, String tipoDatabase, Logger logCore, IDAOFactory daoFactory, Logger logFactory, ServiceManagerProperties smpFactory, boolean debug, int esitoConsegnaMultipla, int esitoConsegnaMultiplaFallita, int esitoConsegnaMultiplaCompletata, int ok, boolean consegnaInErroreRilevatoEsitoTransazioneConsegnaInCoda, long gestioneSerializableDBAttesaAttiva, int gestioneSerializableDBCheckInterval) throws CoreException {
        int oldTransactionIsolation = -1;
        try {
            oldTransactionIsolation = connectionDB.getTransactionIsolation();
            JDBCUtilities.setTransactionIsolationSerializable((String)tipoDatabase, (Connection)connectionDB);
        }
        catch (Exception er) {
            throw new CoreException("(setIsolation) " + er.getMessage(), er);
        }
        Statement pstmt = null;
        ResultSet rs = null;
        boolean updateEffettuato = false;
        long scadenzaWhile = DateManager.getTimeMillis() + gestioneSerializableDBAttesaAttiva;
        CoreException coreException = null;
        while (!updateEffettuato && DateManager.getTimeMillis() < scadenzaWhile) {
            try {
                IDAOFactory daoF = daoFactory;
                Logger log = logFactory;
                ServiceManagerProperties smp = smpFactory;
                JDBCServiceManager jdbcServiceManager = (JDBCServiceManager)daoF.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), connectionDB, false, smp, log);
                jdbcServiceManager.getJdbcProperties().setShowSql(debug);
                JDBCTransazioneService transazioneService = (JDBCTransazioneService)jdbcServiceManager.getTransazioneService();
                transazioneService.enableSelectForUpdate();
                IPaginatedExpression pagExpression = transazioneService.newPaginatedExpression();
                pagExpression.equals(Transazione.model().ID_TRANSAZIONE, (Object)transazioneApplicativoServer.getIdTransazione());
                List<Map<String, Object>> l = null;
                try {
                    l = transazioneService.select(pagExpression, Transazione.model().ESITO, Transazione.model().CONSEGNE_MULTIPLE_IN_CORSO);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                if (l != null && !l.isEmpty()) {
                    if (l.size() > 1) {
                        coreException = new CoreException("Trovata pi\u00f9 di una transazione con id '" + transazioneApplicativoServer.getIdTransazione() + "'");
                    } else {
                        Object oEsito = ((Map)l.get(0)).get(Transazione.model().ESITO.getFieldName());
                        int esito = -1;
                        if (oEsito instanceof Integer) {
                            esito = (Integer)oEsito;
                        }
                        Object oConsegneMultiple = l.get(0).get(Transazione.model().CONSEGNE_MULTIPLE_IN_CORSO.getFieldName());
                        int consegneMultiple = -1;
                        if (oConsegneMultiple instanceof Integer) {
                            consegneMultiple = (Integer)oConsegneMultiple;
                        }
                        String prefix = "Trovata transazione con id '" + transazioneApplicativoServer.getIdTransazione() + "'";
                        if (esitoConsegnaMultipla == esito || esitoConsegnaMultiplaFallita == esito) {
                            int decrement = consegneMultiple - 1;
                            UpdateField uFieldConsegneMultipleInCorso = new UpdateField(Transazione.model().CONSEGNE_MULTIPLE_IN_CORSO, (Object)decrement);
                            UpdateField uFieldEsito = null;
                            if (esitoConsegnaMultipla == esito) {
                                if (ok != transazioneApplicativoServer.getDettaglioEsito() || transazioneApplicativoServer.getDataMessaggioScaduto() != null) {
                                    uFieldEsito = new UpdateField(Transazione.model().ESITO, (Object)esitoConsegnaMultiplaFallita);
                                } else if (decrement <= 0) {
                                    uFieldEsito = new UpdateField(Transazione.model().ESITO, (Object)esitoConsegnaMultiplaCompletata);
                                }
                            }
                            if (uFieldEsito != null) {
                                transazioneService.updateFields(transazioneApplicativoServer.getIdTransazione(), uFieldConsegneMultipleInCorso, uFieldEsito);
                            } else {
                                transazioneService.updateFields(transazioneApplicativoServer.getIdTransazione(), uFieldConsegneMultipleInCorso);
                            }
                        } else if (esitoConsegnaMultiplaCompletata == esito) {
                            if (logCore != null) {
                                String msg = prefix + ", con un esito '" + esito + "' (ConsegnaMultiplaCompletata) gi\u00e0 gestita da un altro nodo";
                                logCore.debug(msg);
                            }
                        } else {
                            coreException = new CoreException(prefix + ", con un esito '" + esito + "' non atteso");
                        }
                    }
                }
                transazioneService.disableSelectForUpdate();
                connectionDB.commit();
                updateEffettuato = true;
            }
            catch (Throwable e) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    connectionDB.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (updateEffettuato) continue;
            try {
                Utilities.sleep((long)TransactionServerUtils.getRandom().nextInt(gestioneSerializableDBCheckInterval));
            }
            catch (Exception e) {}
        }
        try {
            connectionDB.setTransactionIsolation(oldTransactionIsolation);
        }
        catch (Exception er) {
            throw new CoreException("(ripristinoIsolation) " + er.getMessage(), er);
        }
        if (coreException != null) {
            throw coreException;
        }
    }
}

