/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.dao.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderAllegato;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.DumpMultipartHeader;
import org.openspcoop2.core.transazioni.IdDumpMessaggio;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCDumpMessaggioStream;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.dao.jdbc.converter.DumpMessaggioFieldConverter;
import org.openspcoop2.core.transazioni.dao.jdbc.fetch.DumpMessaggioFetch;
import org.openspcoop2.core.transazioni.utils.DumpUtils;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.InUse;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.Utilities;
import org.openspcoop2.generic_project.utils.UtilsTemplate;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class JDBCDumpMessaggioServiceSearchImpl
implements IJDBCServiceSearchWithId<DumpMessaggio, IdDumpMessaggio, JDBCServiceManager> {
    private DumpMessaggioFieldConverter _dumpMessaggioFieldConverter = null;
    private DumpMessaggioFetch dumpMessaggioFetch = new DumpMessaggioFetch();
    private JDBCServiceManager jdbcServiceManager = null;

    public DumpMessaggioFieldConverter getDumpMessaggioFieldConverter() {
        if (this._dumpMessaggioFieldConverter == null) {
            this._dumpMessaggioFieldConverter = new DumpMessaggioFieldConverter(this.jdbcServiceManager.getJdbcProperties().getDatabaseType());
        }
        return this._dumpMessaggioFieldConverter;
    }

    public ISQLFieldConverter getFieldConverter() {
        return this.getDumpMessaggioFieldConverter();
    }

    public DumpMessaggioFetch getDumpMessaggioFetch() {
        return this.dumpMessaggioFetch;
    }

    public IJDBCFetch getFetch() {
        return this.getDumpMessaggioFetch();
    }

    public void setServiceManager(JDBCServiceManager serviceManager) throws ServiceException {
        this.jdbcServiceManager = serviceManager;
    }

    public JDBCServiceManager getServiceManager() throws ServiceException {
        return this.jdbcServiceManager;
    }

    public IdDumpMessaggio convertToId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, DumpMessaggio dumpMessaggio) throws NotImplementedException, ServiceException, Exception {
        IdDumpMessaggio idDumpMessaggio = new IdDumpMessaggio();
        idDumpMessaggio.setIdTransazione(dumpMessaggio.getIdTransazione());
        idDumpMessaggio.setTipoMessaggio(dumpMessaggio.getTipoMessaggio());
        idDumpMessaggio.setServizioApplicativoErogatore(dumpMessaggio.getServizioApplicativoErogatore());
        return idDumpMessaggio;
    }

    public DumpMessaggio get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdDumpMessaggio id, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_dumpMessaggio = id != null && id.getId() != null && id.getId() > 0L ? id.getId() : this.findIdDumpMessaggio(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, id_dumpMessaggio, idMappingResolutionBehaviour);
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdDumpMessaggio id) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_dumpMessaggio = this.findIdDumpMessaggio(jdbcProperties, log, connection, sqlQueryObject, id, false);
        return id_dumpMessaggio != null && id_dumpMessaggio > 0L;
    }

    public List<IdDumpMessaggio> findAllIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<IdDumpMessaggio> list = new ArrayList<IdDumpMessaggio>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        for (Long id : ids) {
            ISQLQueryObject sqlQueryObjectReadIds = sqlQueryObject.newSQLQueryObject();
            sqlQueryObjectReadIds.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model()));
            sqlQueryObjectReadIds.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ID_TRANSAZIONE, false));
            sqlQueryObjectReadIds.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().TIPO_MESSAGGIO, false));
            sqlQueryObjectReadIds.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, false));
            sqlQueryObjectReadIds.addWhereCondition("id=?");
            ArrayList<Class<String>> returnTypes = new ArrayList<Class<String>>();
            returnTypes.add(String.class);
            returnTypes.add(String.class);
            returnTypes.add(String.class);
            JDBCObject param = new JDBCObject((Object)id, Long.class);
            List result = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectReadIds.toString(), jdbcProperties.isShowSql(), returnTypes, new JDBCObject[]{param});
            IdDumpMessaggio idDumpMessaggio = new IdDumpMessaggio();
            idDumpMessaggio.setIdTransazione((String)result.get(0));
            idDumpMessaggio.setTipoMessaggio(TipoMessaggio.toEnumConstant((String)result.get(1)));
            Object sa = result.get(2);
            if (sa != null && sa instanceof String) {
                idDumpMessaggio.setServizioApplicativoErogatore((String)sa);
            }
            list.add(idDumpMessaggio);
        }
        return list;
    }

    public List<DumpMessaggio> findAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<DumpMessaggio> list = new ArrayList<DumpMessaggio>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            list.add(this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour));
        }
        return list;
    }

    public DumpMessaggio find(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        long id = this.findTableId(jdbcProperties, log, connection, sqlQueryObject, expression);
        if (id > 0L) {
            return this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
        }
        throw new NotFoundException("Entry with id[" + id + "] not found");
    }

    public JDBCDumpMessaggioStream getContentInputStream(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, JDBCServiceManager jdbcServiceManager, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotFoundException, ServiceException {
        long id = -1L;
        try {
            id = this.findTableId(jdbcProperties, log, connection, sqlQueryObject, expression);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        if (id > 0L) {
            try {
                return this.getContentInputStream(connection, jdbcServiceManager, sqlQueryObject, id);
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
        }
        throw new NotFoundException("Entry with id[" + id + "] not found");
    }

    private JDBCDumpMessaggioStream getContentInputStream(Connection connection, JDBCServiceManager jdbcServiceManager, ISQLQueryObject sqlQueryObject, long id) throws JDBCAdapterException, ExpressionException, SQLQueryObjectException, SQLException, UtilsException {
        IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((TipiDatabase)this.getDumpMessaggioFieldConverter().getDatabaseType());
        ISQLQueryObject sqlQueryObjectGetDumpMessaggio = this.buildSQLQueryObjectGetContentInputStream(sqlQueryObject);
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        String query = sqlQueryObjectGetDumpMessaggio.createSQLQuery();
        pstmt = connection.prepareStatement(query);
        pstmt.setLong(1, id);
        rs = pstmt.executeQuery();
        if (rs.next()) {
            InputStream is = jdbcAdapter.getBinaryStream(rs, "contentBodyStream");
            return new JDBCDumpMessaggioStream(is, rs, pstmt, connection, jdbcServiceManager);
        }
        return null;
    }

    private ISQLQueryObject buildSQLQueryObjectGetContentInputStream(ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException, ExpressionException {
        ISQLQueryObject sqlQueryObjectGetDumpMessaggio = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectGetDumpMessaggio.setANDLogicOperator(true);
        sqlQueryObjectGetDumpMessaggio.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model()));
        sqlQueryObjectGetDumpMessaggio.addSelectAliasField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().BODY, true), "contentBodyStream");
        sqlQueryObjectGetDumpMessaggio.addWhereCondition("id=?");
        return sqlQueryObjectGetDumpMessaggio;
    }

    public NonNegativeNumber count(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List listaQuery = GenericJDBCUtilities.prepareCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model());
        sqlQueryObject.addSelectCountField(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model()) + ".id", "tot", true);
        this.joinEngine((IExpression)expression, sqlQueryObject);
        return GenericJDBCUtilities.count((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model(), (List)listaQuery);
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdDumpMessaggio id) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long id_dumpMessaggio = this.findIdDumpMessaggio(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, id_dumpMessaggio);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List<Map<String, Object>> map = this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, distinct, new IField[]{field});
        return GenericJDBCUtilities.selectSingleObject(map);
    }

    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        try {
            ISQLQueryObject sqlQueryObjectDistinct = GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((boolean)distinct, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (Logger)log, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IField[])field);
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression, sqlQueryObjectDistinct);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        }
    }

    public Object aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        Map<String, Object> map = this.aggregate(jdbcProperties, log, connection, sqlQueryObject, expression, new FunctionField[]{functionField});
        return GenericJDBCUtilities.selectAggregateObject(map, (FunctionField)functionField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            Map<String, Object> map = list.get(0);
            return map;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (expression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (paginatedExpression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        }
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, expression, null);
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLQueryObject sqlQueryObjectDistinct) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        ArrayList listaQuery = new ArrayList();
        ArrayList listaParams = new ArrayList();
        List returnField = GenericJDBCUtilities.prepareSelect((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model(), listaQuery, listaParams);
        this.joinEngine(expression, sqlQueryObject);
        List list = GenericJDBCUtilities.select((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((ISQLQueryObject)sqlQueryObject, (ISQLQueryObject)sqlQueryObjectDistinct), (IExpression)expression, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model(), listaQuery, listaParams, (List)returnField);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public List<Map<String, Object>> union(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List list;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnion((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((list = GenericJDBCUtilities.union((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public NonNegativeNumber unionCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        NonNegativeNumber number;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((number = GenericJDBCUtilities.unionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && number.longValue() >= 0L) {
            return number;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public JDBCExpression newExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression((ISQLFieldConverter)this.getDumpMessaggioFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression newPaginatedExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression((ISQLFieldConverter)this.getDumpMessaggioFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCExpression toExpression(JDBCPaginatedExpression paginatedExpression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression(paginatedExpression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression toPaginatedExpression(JDBCExpression expression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression(expression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdDumpMessaggio id, DumpMessaggio obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, id, null));
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, DumpMessaggio obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, tableId, (IDMappingBehaviour)null));
    }

    private void _mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, DumpMessaggio obj, DumpMessaggio imgSaved) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        boolean objEqualsToImgSaved_;
        List<BaseBeanWithId> listImgSaved_;
        BaseBeanWithId itemAlreadySaved_;
        List<BaseBeanWithId> listObj_;
        if (imgSaved == null) {
            return;
        }
        obj.setId(imgSaved.getId());
        if (obj.getMultipartHeaderList() != null) {
            listObj_ = obj.getMultipartHeaderList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getMultipartHeaderList() != null) {
                    listImgSaved_ = imgSaved.getMultipartHeaderList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        objEqualsToImgSaved_ = false;
                        objEqualsToImgSaved_ = Utilities.equals((Object)itemObj_.getNome(), (Object)itemImgSaved_.getNome());
                        if (!objEqualsToImgSaved_) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
            }
        }
        if (obj.getHeaderTrasportoList() != null) {
            listObj_ = obj.getHeaderTrasportoList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getHeaderTrasportoList() != null) {
                    listImgSaved_ = imgSaved.getHeaderTrasportoList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        objEqualsToImgSaved_ = false;
                        objEqualsToImgSaved_ = Utilities.equals((Object)itemObj_.getNome(), (Object)itemImgSaved_.getNome());
                        if (!objEqualsToImgSaved_) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
            }
        }
        if (obj.getAllegatoList() != null) {
            listObj_ = obj.getAllegatoList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getAllegatoList() != null) {
                    listImgSaved_ = imgSaved.getAllegatoList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        boolean objEqualsToImgSaved_2 = false;
                        objEqualsToImgSaved_2 = Utilities.equals((Object)itemObj_.getContentId(), (Object)itemImgSaved_.getContentId());
                        if (!objEqualsToImgSaved_2) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
                if (itemObj_.getHeaderList() == null) continue;
                List<DumpHeaderAllegato> listObj_allegato = itemObj_.getHeaderList();
                for (DumpHeaderAllegato itemObj_allegato : listObj_allegato) {
                    DumpHeaderAllegato itemAlreadySaved_allegato = null;
                    if (itemAlreadySaved_.getHeaderList() != null) {
                        List<DumpHeaderAllegato> listImgSaved_allegato = itemAlreadySaved_.getHeaderList();
                        for (DumpHeaderAllegato itemImgSaved_allegato : listImgSaved_allegato) {
                            boolean objEqualsToImgSaved_allegato = false;
                            objEqualsToImgSaved_allegato = Utilities.equals((Object)itemObj_allegato.getNome(), (Object)itemImgSaved_allegato.getNome());
                            if (!objEqualsToImgSaved_allegato) continue;
                            itemAlreadySaved_allegato = itemImgSaved_allegato;
                            break;
                        }
                    }
                    if (itemAlreadySaved_allegato == null) continue;
                    itemObj_allegato.setId(itemAlreadySaved_allegato.getId());
                }
            }
        }
        if (obj.getContenutoList() != null) {
            listObj_ = obj.getContenutoList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getContenutoList() != null) {
                    listImgSaved_ = imgSaved.getContenutoList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        boolean objEqualsToImgSaved_3 = false;
                        objEqualsToImgSaved_3 = Utilities.equals((Object)itemObj_.getNome(), (Object)itemImgSaved_.getNome());
                        if (!objEqualsToImgSaved_3) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
            }
        }
    }

    public DumpMessaggio get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
    }

    protected DumpMessaggio getEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        DumpMessaggio dumpMessaggio = new DumpMessaggio();
        ArrayList<JDBCObject> listJDBCObject = new ArrayList<JDBCObject>();
        ISQLQueryObject sqlQueryObjectGet_dumpMessaggio = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_dumpMessaggio.setANDLogicOperator(true);
        sqlQueryObjectGet_dumpMessaggio.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model()));
        sqlQueryObjectGet_dumpMessaggio.addSelectField("id");
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ID_TRANSAZIONE, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().PROTOCOLLO, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().DATA_CONSEGNA_EROGATORE, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().TIPO_MESSAGGIO, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().FORMATO_MESSAGGIO, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().CONTENT_TYPE, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().CONTENT_LENGTH, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().MULTIPART_CONTENT_TYPE, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().MULTIPART_CONTENT_ID, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().MULTIPART_CONTENT_LOCATION, true));
        DumpUtils.selectContentByThreshold(sqlQueryObjectGet_dumpMessaggio, this.getDumpMessaggioFieldConverter(), listJDBCObject);
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().DUMP_TIMESTAMP, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().POST_PROCESS_HEADER, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().POST_PROCESS_FILENAME, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().POST_PROCESS_CONTENT, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().POST_PROCESS_CONFIG_ID, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().POST_PROCESS_TIMESTAMP, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().POST_PROCESSED, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().MULTIPART_HEADER_EXT, true));
        sqlQueryObjectGet_dumpMessaggio.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().HEADER_EXT, true));
        sqlQueryObjectGet_dumpMessaggio.addWhereCondition("id=?");
        listJDBCObject.add(new JDBCObject((Object)tableId, Long.class));
        dumpMessaggio = (DumpMessaggio)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_dumpMessaggio.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)DumpMessaggio.model(), (IJDBCFetch)this.getDumpMessaggioFetch(), listJDBCObject.toArray(new JDBCObject[1]));
        ISQLQueryObject sqlQueryObjectGet_dumpMessaggio_dumpMultipartHeader = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_dumpMessaggio_dumpMultipartHeader.setANDLogicOperator(true);
        sqlQueryObjectGet_dumpMessaggio_dumpMultipartHeader.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().MULTIPART_HEADER));
        sqlQueryObjectGet_dumpMessaggio_dumpMultipartHeader.addSelectField("id");
        sqlQueryObjectGet_dumpMessaggio_dumpMultipartHeader.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().MULTIPART_HEADER.NOME, true));
        sqlQueryObjectGet_dumpMessaggio_dumpMultipartHeader.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().MULTIPART_HEADER.VALORE, true));
        sqlQueryObjectGet_dumpMessaggio_dumpMultipartHeader.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().MULTIPART_HEADER.DUMP_TIMESTAMP, true));
        sqlQueryObjectGet_dumpMessaggio_dumpMultipartHeader.addWhereCondition("id_messaggio=?");
        List dumpMessaggio_dumpMultipartHeader_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_dumpMessaggio_dumpMultipartHeader.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)DumpMessaggio.model().MULTIPART_HEADER, (IJDBCFetch)this.getDumpMessaggioFetch(), new JDBCObject[]{new JDBCObject((Object)dumpMessaggio.getId(), Long.class)});
        if (dumpMessaggio_dumpMultipartHeader_list != null) {
            for (Object dumpMessaggio_dumpMultipartHeader_object : dumpMessaggio_dumpMultipartHeader_list) {
                DumpMultipartHeader dumpMessaggio_dumpMultipartHeader = (DumpMultipartHeader)dumpMessaggio_dumpMultipartHeader_object;
                if (dumpMessaggio_dumpMultipartHeader.getValore() == null) {
                    dumpMessaggio_dumpMultipartHeader.setValore("");
                }
                dumpMessaggio.addMultipartHeader(dumpMessaggio_dumpMultipartHeader);
            }
        }
        ISQLQueryObject sqlQueryObjectGet_dumpMessaggio_dumpHeaderTrasporto = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_dumpMessaggio_dumpHeaderTrasporto.setANDLogicOperator(true);
        sqlQueryObjectGet_dumpMessaggio_dumpHeaderTrasporto.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().HEADER_TRASPORTO));
        sqlQueryObjectGet_dumpMessaggio_dumpHeaderTrasporto.addSelectField("id");
        sqlQueryObjectGet_dumpMessaggio_dumpHeaderTrasporto.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().HEADER_TRASPORTO.NOME, true));
        sqlQueryObjectGet_dumpMessaggio_dumpHeaderTrasporto.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().HEADER_TRASPORTO.VALORE, true));
        sqlQueryObjectGet_dumpMessaggio_dumpHeaderTrasporto.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().HEADER_TRASPORTO.DUMP_TIMESTAMP, true));
        sqlQueryObjectGet_dumpMessaggio_dumpHeaderTrasporto.addWhereCondition("id_messaggio=?");
        List dumpMessaggio_dumpHeaderTrasporto_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_dumpMessaggio_dumpHeaderTrasporto.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)DumpMessaggio.model().HEADER_TRASPORTO, (IJDBCFetch)this.getDumpMessaggioFetch(), new JDBCObject[]{new JDBCObject((Object)dumpMessaggio.getId(), Long.class)});
        if (dumpMessaggio_dumpHeaderTrasporto_list != null) {
            for (Object dumpMessaggio_dumpHeaderTrasporto_object : dumpMessaggio_dumpHeaderTrasporto_list) {
                DumpHeaderTrasporto dumpMessaggio_dumpHeaderTrasporto = (DumpHeaderTrasporto)dumpMessaggio_dumpHeaderTrasporto_object;
                if (dumpMessaggio_dumpHeaderTrasporto.getValore() == null) {
                    dumpMessaggio_dumpHeaderTrasporto.setValore("");
                }
                dumpMessaggio.addHeaderTrasporto(dumpMessaggio_dumpHeaderTrasporto);
            }
        }
        ISQLQueryObject sqlQueryObjectGet_dumpMessaggio_dumpAllegato = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.setANDLogicOperator(true);
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().ALLEGATO));
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.addSelectField("id");
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ALLEGATO.CONTENT_TYPE, true));
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ALLEGATO.CONTENT_ID, true));
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ALLEGATO.CONTENT_LOCATION, true));
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ALLEGATO.ALLEGATO, true));
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ALLEGATO.DUMP_TIMESTAMP, true));
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ALLEGATO.HEADER_EXT, true));
        sqlQueryObjectGet_dumpMessaggio_dumpAllegato.addWhereCondition("id_messaggio=?");
        List dumpMessaggio_dumpAllegato_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_dumpMessaggio_dumpAllegato.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)DumpMessaggio.model().ALLEGATO, (IJDBCFetch)this.getDumpMessaggioFetch(), new JDBCObject[]{new JDBCObject((Object)dumpMessaggio.getId(), Long.class)});
        if (dumpMessaggio_dumpAllegato_list != null) {
            for (Object dumpMessaggio_dumpAllegato_object : dumpMessaggio_dumpAllegato_list) {
                DumpAllegato dumpMessaggio_dumpAllegato = (DumpAllegato)dumpMessaggio_dumpAllegato_object;
                ISQLQueryObject sqlQueryObjectGet_dumpMessaggio_dumpAllegato_dumpHeaderAllegato = sqlQueryObjectGet.newSQLQueryObject();
                sqlQueryObjectGet_dumpMessaggio_dumpAllegato_dumpHeaderAllegato.setANDLogicOperator(true);
                sqlQueryObjectGet_dumpMessaggio_dumpAllegato_dumpHeaderAllegato.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().ALLEGATO.HEADER));
                sqlQueryObjectGet_dumpMessaggio_dumpAllegato_dumpHeaderAllegato.addSelectField("id");
                sqlQueryObjectGet_dumpMessaggio_dumpAllegato_dumpHeaderAllegato.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ALLEGATO.HEADER.NOME, true));
                sqlQueryObjectGet_dumpMessaggio_dumpAllegato_dumpHeaderAllegato.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ALLEGATO.HEADER.VALORE, true));
                sqlQueryObjectGet_dumpMessaggio_dumpAllegato_dumpHeaderAllegato.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ALLEGATO.HEADER.DUMP_TIMESTAMP, true));
                sqlQueryObjectGet_dumpMessaggio_dumpAllegato_dumpHeaderAllegato.addWhereCondition("id_allegato=?");
                List dumpMessaggio_dumpAllegato_dumpHeaderAllegato_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_dumpMessaggio_dumpAllegato_dumpHeaderAllegato.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)DumpMessaggio.model().ALLEGATO.HEADER, (IJDBCFetch)this.getDumpMessaggioFetch(), new JDBCObject[]{new JDBCObject((Object)dumpMessaggio_dumpAllegato.getId(), Long.class)});
                if (dumpMessaggio_dumpAllegato_dumpHeaderAllegato_list != null) {
                    for (Object dumpMessaggio_dumpAllegato_dumpHeaderAllegato_object : dumpMessaggio_dumpAllegato_dumpHeaderAllegato_list) {
                        DumpHeaderAllegato dumpMessaggio_dumpAllegato_dumpHeaderAllegato = (DumpHeaderAllegato)dumpMessaggio_dumpAllegato_dumpHeaderAllegato_object;
                        if (dumpMessaggio_dumpAllegato_dumpHeaderAllegato.getValore() == null) {
                            dumpMessaggio_dumpAllegato_dumpHeaderAllegato.setValore("");
                        }
                        dumpMessaggio_dumpAllegato.addHeader(dumpMessaggio_dumpAllegato_dumpHeaderAllegato);
                    }
                }
                dumpMessaggio.addAllegato(dumpMessaggio_dumpAllegato);
            }
        }
        ISQLQueryObject sqlQueryObjectGet_dumpMessaggio_dumpContenuto = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_dumpMessaggio_dumpContenuto.setANDLogicOperator(true);
        sqlQueryObjectGet_dumpMessaggio_dumpContenuto.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().CONTENUTO));
        sqlQueryObjectGet_dumpMessaggio_dumpContenuto.addSelectField("id");
        sqlQueryObjectGet_dumpMessaggio_dumpContenuto.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().CONTENUTO.NOME, true));
        sqlQueryObjectGet_dumpMessaggio_dumpContenuto.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().CONTENUTO.VALORE, true));
        sqlQueryObjectGet_dumpMessaggio_dumpContenuto.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().CONTENUTO.VALORE_AS_BYTES, true));
        sqlQueryObjectGet_dumpMessaggio_dumpContenuto.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().CONTENUTO.DUMP_TIMESTAMP, true));
        sqlQueryObjectGet_dumpMessaggio_dumpContenuto.addWhereCondition("id_messaggio=?");
        List dumpMessaggio_dumpContenuto_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_dumpMessaggio_dumpContenuto.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)DumpMessaggio.model().CONTENUTO, (IJDBCFetch)this.getDumpMessaggioFetch(), new JDBCObject[]{new JDBCObject((Object)dumpMessaggio.getId(), Long.class)});
        if (dumpMessaggio_dumpContenuto_list != null) {
            for (Object dumpMessaggio_dumpContenuto_object : dumpMessaggio_dumpContenuto_list) {
                DumpContenuto dumpMessaggio_dumpContenuto = (DumpContenuto)dumpMessaggio_dumpContenuto_object;
                dumpMessaggio.addContenuto(dumpMessaggio_dumpContenuto);
            }
        }
        return dumpMessaggio;
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this._exists(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private boolean _exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        boolean existsDumpMessaggio = false;
        sqlQueryObject = sqlQueryObject.newSQLQueryObject();
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model()));
        sqlQueryObject.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ID_TRANSAZIONE, true));
        sqlQueryObject.addWhereCondition("id=?");
        existsDumpMessaggio = jdbcUtilities.exists(sqlQueryObject.createSQLQuery(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        return existsDumpMessaggio;
    }

    private void joinEngine(IExpression expression, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        String tableName2;
        String tableName1;
        if (expression.inUseModel((IModel)DumpMessaggio.model().ALLEGATO, false)) {
            tableName1 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().ALLEGATO);
            tableName2 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model());
            sqlQueryObject.addWhereCondition(tableName1 + ".id_messaggio=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)DumpMessaggio.model().ALLEGATO.HEADER, false)) {
            tableName1 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().ALLEGATO.HEADER);
            tableName2 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().ALLEGATO);
            sqlQueryObject.addWhereCondition(tableName1 + ".id_allegato=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)DumpMessaggio.model().CONTENUTO, false)) {
            tableName1 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().CONTENUTO);
            tableName2 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model());
            sqlQueryObject.addWhereCondition(tableName1 + ".id_messaggio=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)DumpMessaggio.model().HEADER_TRASPORTO, false)) {
            tableName1 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().HEADER_TRASPORTO);
            tableName2 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model());
            sqlQueryObject.addWhereCondition(tableName1 + ".id_messaggio=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)DumpMessaggio.model().MULTIPART_HEADER, false)) {
            tableName1 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().MULTIPART_HEADER);
            tableName2 = this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model());
            sqlQueryObject.addWhereCondition(tableName1 + ".id_messaggio=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)DumpMessaggio.model().ALLEGATO.HEADER, false) && !expression.inUseModel((IModel)DumpMessaggio.model().ALLEGATO, false)) {
            sqlQueryObject.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model().ALLEGATO));
        }
    }

    protected List<Object> getRootTablePrimaryKeyValuesEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdDumpMessaggio id) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        ArrayList<Object> rootTableIdValues = new ArrayList<Object>();
        Long longId = this.findIdDumpMessaggio(jdbcProperties, log, connection, sqlQueryObject.newSQLQueryObject(), id, true);
        rootTableIdValues.add(longId);
        return rootTableIdValues;
    }

    protected Map<String, List<IField>> getMapTableToPKColumnEngine() throws NotImplementedException, Exception {
        DumpMessaggioFieldConverter converter = this.getDumpMessaggioFieldConverter();
        HashMap<String, List<IField>> mapTableToPKColumn = new HashMap<String, List<IField>>();
        UtilsTemplate utilities = new UtilsTemplate();
        mapTableToPKColumn.put(converter.toTable((IModel)DumpMessaggio.model()), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)DumpMessaggio.model()))}));
        mapTableToPKColumn.put(converter.toTable((IModel)DumpMessaggio.model().ALLEGATO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)DumpMessaggio.model().ALLEGATO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)DumpMessaggio.model().CONTENUTO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)DumpMessaggio.model().CONTENUTO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)DumpMessaggio.model().HEADER_TRASPORTO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)DumpMessaggio.model().HEADER_TRASPORTO))}));
        return mapTableToPKColumn;
    }

    public List<Long> findAllTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression) throws ServiceException, NotImplementedException, Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFindAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model());
        this.joinEngine((IExpression)paginatedExpression, sqlQueryObject);
        List listObjects = GenericJDBCUtilities.findAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model(), objectIdClass, (List)listaQuery);
        for (Object object : listObjects) {
            list.add((Long)object);
        }
        return list;
    }

    public long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, Exception {
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFind((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model());
        this.joinEngine((IExpression)expression, sqlQueryObject);
        Object res = GenericJDBCUtilities.find((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getDumpMessaggioFieldConverter(), (IModel)DumpMessaggio.model(), objectIdClass, (List)listaQuery);
        if (res != null && (Long)res > 0L) {
            return (Long)res;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private InUse inUseEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        InUse inUse = new InUse();
        inUse.setInUse(false);
        boolean throwNotImplemented = true;
        if (throwNotImplemented) {
            throw new NotImplementedException("NotImplemented");
        }
        return inUse;
    }

    public IdDumpMessaggio findId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectGet.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model()));
        sqlQueryObjectGet.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ID_TRANSAZIONE, true));
        sqlQueryObjectGet.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().TIPO_MESSAGGIO, true));
        sqlQueryObjectGet.addSelectField(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, true));
        sqlQueryObjectGet.setANDLogicOperator(true);
        sqlQueryObjectGet.addWhereCondition("id=?");
        JDBCObject[] searchParams_dumpMessaggio = new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)};
        ArrayList<Class<String>> listaFieldIdReturnType_dumpMessaggio = new ArrayList<Class<String>>();
        listaFieldIdReturnType_dumpMessaggio.add(String.class);
        listaFieldIdReturnType_dumpMessaggio.add(String.class);
        listaFieldIdReturnType_dumpMessaggio.add(String.class);
        IdDumpMessaggio id_dumpMessaggio = null;
        List listaFieldId_dumpMessaggio = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_dumpMessaggio, searchParams_dumpMessaggio);
        if (listaFieldId_dumpMessaggio == null || listaFieldId_dumpMessaggio.size() <= 0) {
            if (throwNotFound) {
                throw GenericJDBCUtilities.newNotFoundException();
            }
        } else {
            id_dumpMessaggio = new IdDumpMessaggio();
            id_dumpMessaggio.setIdTransazione((String)listaFieldId_dumpMessaggio.get(0));
            id_dumpMessaggio.setTipoMessaggio(TipoMessaggio.toEnumConstant((String)listaFieldId_dumpMessaggio.get(1)));
            Object sa = listaFieldId_dumpMessaggio.get(2);
            if (sa != null && sa instanceof String) {
                id_dumpMessaggio.setServizioApplicativoErogatore((String)sa);
            }
        }
        return id_dumpMessaggio;
    }

    public Long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdDumpMessaggio id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        return this.findIdDumpMessaggio(jdbcProperties, log, connection, sqlQueryObject, id, throwNotFound);
    }

    public List<List<Object>> nativeQuery(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String sql, List<Class<?>> returnClassTypes, Object ... param) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeQuery((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)sql, returnClassTypes, (Object[])param);
    }

    protected Long findIdDumpMessaggio(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdDumpMessaggio id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        Long idDumpMessaggio;
        block9: {
            if (jdbcProperties == null) {
                throw new ServiceException("jdbcProperties parameter is null");
            }
            if (sqlQueryObject == null) {
                throw new ServiceException("sqlQueryObject parameter is null");
            }
            if (id == null) {
                throw new ServiceException("id parameter is null");
            }
            JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
            ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
            sqlQueryObjectGet.addFromTable(this.getDumpMessaggioFieldConverter().toTable((IModel)DumpMessaggio.model()));
            sqlQueryObjectGet.addSelectField("id");
            sqlQueryObjectGet.setANDLogicOperator(true);
            sqlQueryObjectGet.setSelectDistinct(true);
            sqlQueryObjectGet.addWhereCondition(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().ID_TRANSAZIONE, true) + "=?");
            sqlQueryObjectGet.addWhereCondition(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().TIPO_MESSAGGIO, true) + "=?");
            if (id.getServizioApplicativoErogatore() == null) {
                sqlQueryObjectGet.addWhereIsNotNullCondition(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, true));
            } else {
                sqlQueryObjectGet.addWhereCondition(this.getDumpMessaggioFieldConverter().toColumn(DumpMessaggio.model().SERVIZIO_APPLICATIVO_EROGATORE, true) + "=?");
            }
            ArrayList<JDBCObject> searchParamsDumpMessaggioList = new ArrayList<JDBCObject>();
            searchParamsDumpMessaggioList.add(new JDBCObject((Object)id.getIdTransazione(), String.class));
            searchParamsDumpMessaggioList.add(new JDBCObject((Object)id.getTipoMessaggioRawEnumValue(), String.class));
            if (id.getServizioApplicativoErogatore() != null) {
                searchParamsDumpMessaggioList.add(new JDBCObject((Object)id.getServizioApplicativoErogatore(), String.class));
            }
            JDBCObject[] searchParamsDumpMessaggio = searchParamsDumpMessaggioList.toArray(new JDBCObject[1]);
            idDumpMessaggio = null;
            try {
                idDumpMessaggio = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, searchParamsDumpMessaggio);
            }
            catch (NotFoundException notFound) {
                if (!throwNotFound) break block9;
                throw new NotFoundException((Throwable)notFound);
            }
        }
        if ((idDumpMessaggio == null || idDumpMessaggio <= 0L) && throwNotFound) {
            throw GenericJDBCUtilities.newNotFoundException();
        }
        return idDumpMessaggio;
    }
}

