/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.utils;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistroServiziUtils {
    public static final String PROPERTY_SEPARATOR = " -- ";

    public static boolean isRegistroServizi(byte[] doc) {
        return RegistroServiziUtils.isRegistroServizi(doc, "registro-servizi");
    }

    public static boolean isRegistroServizi(byte[] doc, String localName) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return RegistroServiziUtils.isRegistroServiziEngine(elemXML, localName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isRegistroServizi(Document docXML) {
        return RegistroServiziUtils.isRegistroServizi(docXML, "registro-servizi");
    }

    public static boolean isRegistroServizi(Document docXML, String localName) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return RegistroServiziUtils.isRegistroServiziEngine(elemXML, localName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isRegistroServizi(Element elemXML, String localName) {
        return RegistroServiziUtils.isRegistroServiziEngine(elemXML, localName);
    }

    public static boolean isRegistroServizi(Node nodeXml, String localName) {
        return RegistroServiziUtils.isRegistroServiziEngine(nodeXml, localName);
    }

    private static boolean isRegistroServiziEngine(Node nodeXml, String localName) {
        try {
            return localName.equals(nodeXml.getLocalName()) && "http://www.openspcoop2.org/core/registry".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    public org.openspcoop2.core.registry.constants.ServiceBinding convertToRegistry(ServiceBinding serviceBinding) {
        if (serviceBinding == null) {
            return null;
        }
        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
            return org.openspcoop2.core.registry.constants.ServiceBinding.REST;
        }
        if (ServiceBinding.SOAP.equals((Object)serviceBinding)) {
            return org.openspcoop2.core.registry.constants.ServiceBinding.SOAP;
        }
        return null;
    }

    public static ServiceBinding convertToMessage(org.openspcoop2.core.registry.constants.ServiceBinding serviceBinding) {
        if (serviceBinding == null) {
            return null;
        }
        if (org.openspcoop2.core.registry.constants.ServiceBinding.REST.equals(serviceBinding)) {
            return ServiceBinding.REST;
        }
        if (org.openspcoop2.core.registry.constants.ServiceBinding.SOAP.equals(serviceBinding)) {
            return ServiceBinding.SOAP;
        }
        return null;
    }

    private static String getBooleanValueAsString(ProtocolProperty pp) {
        return pp.getBooleanValue() != null ? pp.getBooleanValue().toString() : "false";
    }

    public static List<String> fillPropertyProtocollo(String propertyName, AccordoServizioParteComune api, String portType, boolean booleanValue) {
        return RegistroServiziUtils.fillPropertyProtocollo(propertyName, null, api, portType, booleanValue);
    }

    public static List<String> splitPropertyProtocolloResult(String value) {
        ArrayList<String> l = new ArrayList<String>();
        if (value.contains(PROPERTY_SEPARATOR)) {
            String[] tmp = value.split(PROPERTY_SEPARATOR);
            if (tmp != null && tmp.length > 0) {
                for (String s : tmp) {
                    l.add(s.trim());
                }
            }
        } else {
            l.add(value);
        }
        return l;
    }

    private static void addPropertyProtocolloResult(String propertyName, String propertyName2, String apiValue, String apiValue2, List<String> apiValues) {
        String insertValue;
        if ("modipaSecurityMessageSorgenteToken".equals(propertyName) && apiValue == null) {
            apiValue = "locale";
        }
        if ("modipaSecurityMessageSorgenteToken".equals(propertyName2) && apiValue2 == null) {
            apiValue2 = "locale";
        }
        String string = insertValue = apiValue2 != null ? apiValue + PROPERTY_SEPARATOR + apiValue2 : apiValue;
        if (insertValue != null && !apiValues.contains(insertValue)) {
            apiValues.add(insertValue);
        }
    }

    public static List<String> fillPropertyProtocollo(String propertyName, String propertyName2, AccordoServizioParteComune api, String portType, boolean booleanValue) {
        ArrayList<String> apiValues = new ArrayList<String>();
        for (ProtocolProperty pp : api.getProtocolPropertyList()) {
            if (!propertyName.equals(pp.getName())) continue;
            String apiValue = booleanValue ? RegistroServiziUtils.getBooleanValueAsString(pp) : pp.getValue();
            String apiValue2 = RegistroServiziUtils.getPropertyProtocolloValue(propertyName2, booleanValue, api.getProtocolPropertyList());
            RegistroServiziUtils.addPropertyProtocolloResult(propertyName, propertyName2, apiValue, apiValue2, apiValues);
            break;
        }
        RegistroServiziUtils.fillPropertyProtocollo(propertyName, propertyName2, api, portType, booleanValue, apiValues);
        return apiValues;
    }

    private static String getPropertyProtocolloValue(String propertyName2, boolean booleanValue, List<ProtocolProperty> properties) {
        String apiValue2 = null;
        if (propertyName2 != null) {
            for (ProtocolProperty pp2 : properties) {
                if (!propertyName2.equals(pp2.getName())) continue;
                apiValue2 = booleanValue ? RegistroServiziUtils.getBooleanValueAsString(pp2) : pp2.getValue();
                break;
            }
        }
        return apiValue2;
    }

    private static void fillPropertyProtocollo(String propertyName, String propertyName2, AccordoServizioParteComune api, String portType, boolean booleanValue, List<String> apiValues) {
        if (org.openspcoop2.core.registry.constants.ServiceBinding.REST.equals(api.getServiceBinding())) {
            RegistroServiziUtils.fillPropertyProtocolloREST(propertyName, propertyName2, api, booleanValue, apiValues);
        } else {
            RegistroServiziUtils.fillPropertyProtocolloSOAP(propertyName, propertyName2, api, portType, booleanValue, apiValues);
        }
    }

    private static boolean isRidefinito(List<ProtocolProperty> properties) {
        boolean ridefinito = false;
        for (ProtocolProperty pp : properties) {
            if (!"modipaSecurityMessageProfileActionMode".equals(pp.getName())) continue;
            String v = pp.getValue();
            ridefinito = "ridefinisci".equals(v);
            break;
        }
        return ridefinito;
    }

    private static void fillPropertyProtocolloREST(String propertyName, String propertyName2, AccordoServizioParteComune api, boolean booleanValue, List<String> apiValues) {
        for (Resource resource : api.getResourceList()) {
            boolean ridefinito;
            if (resource.sizeProtocolPropertyList() <= 0 || !(ridefinito = RegistroServiziUtils.isRidefinito(resource.getProtocolPropertyList()))) continue;
            RegistroServiziUtils.fillPropertyProtocolloREST(propertyName, propertyName2, booleanValue, apiValues, resource);
        }
    }

    private static void fillPropertyProtocolloREST(String propertyName, String propertyName2, boolean booleanValue, List<String> apiValues, Resource resource) {
        for (ProtocolProperty pp : resource.getProtocolPropertyList()) {
            if (!propertyName.equals(pp.getName())) continue;
            String apiValue = booleanValue ? RegistroServiziUtils.getBooleanValueAsString(pp) : pp.getValue();
            String apiValue2 = RegistroServiziUtils.getPropertyProtocolloValue(propertyName2, booleanValue, resource.getProtocolPropertyList());
            RegistroServiziUtils.addPropertyProtocolloResult(propertyName, propertyName2, apiValue, apiValue2, apiValues);
            break;
        }
    }

    private static void fillPropertyProtocolloSOAP(String propertyName, String propertyName2, AccordoServizioParteComune api, String portType, boolean booleanValue, List<String> apiValues) {
        for (PortType pt : api.getPortTypeList()) {
            if (!pt.getNome().equals(portType)) continue;
            for (Operation op : pt.getAzioneList()) {
                boolean ridefinito;
                if (op.sizeProtocolPropertyList() <= 0 || !(ridefinito = RegistroServiziUtils.isRidefinito(op.getProtocolPropertyList()))) continue;
                RegistroServiziUtils.fillPropertyProtocolloSOAP(propertyName, propertyName2, booleanValue, apiValues, op);
            }
        }
    }

    private static void fillPropertyProtocolloSOAP(String propertyName, String propertyName2, boolean booleanValue, List<String> apiValues, Operation op) {
        for (ProtocolProperty pp : op.getProtocolPropertyList()) {
            if (!propertyName.equals(pp.getName())) continue;
            String apiValue = booleanValue ? RegistroServiziUtils.getBooleanValueAsString(pp) : pp.getValue();
            String apiValue2 = RegistroServiziUtils.getPropertyProtocolloValue(propertyName2, booleanValue, op.getProtocolPropertyList());
            RegistroServiziUtils.addPropertyProtocolloResult(propertyName, propertyName2, apiValue, apiValue2, apiValues);
            break;
        }
    }
}

