/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.openspcoop2.core.commons.ProtocolFactoryReflectionUtils;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.ConfigurazioneServizio;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.utils.PdDConfig;
import org.openspcoop2.core.registry.driver.xml.DriverRegistroServiziXML;
import org.openspcoop2.core.registry.utils.serializer.JaxbDeserializer;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class XMLDataConverter {
    private IDriverRegistroServiziCRUD gestoreCRUD = null;
    private RegistroServizi sorgenteRegistro;
    private Logger log = null;
    private Logger logDriver = null;
    private String superUser = null;
    private String tipoBEDestinazione;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private IDServizioFactory idServizioFactory = IDServizioFactory.getInstance();
    private File parentFile = null;

    public XMLDataConverter(String sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(RegistroServizi sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(RegistroServizi sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(RegistroServizi sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        block24: {
            this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
            this.logDriver = logDriver;
            if (destinazione == null) {
                throw new DriverRegistroServiziException("GestoreCRUD non definito");
            }
            this.tipoBEDestinazione = destinazione.getTipo().toString();
            this.superUser = superUser;
            try {
                File f2;
                if (sorgente instanceof RegistroServizi) {
                    this.sorgenteRegistro = (RegistroServizi)sorgente;
                    break block24;
                }
                if (sorgente instanceof String) {
                    this.createSorgente((String)sorgente);
                    try {
                        f2 = new File((String)sorgente);
                        if (f2.getParentFile() != null) {
                            this.parentFile = f2.getParentFile();
                        }
                        break block24;
                    }
                    catch (Exception f2) {}
                    break block24;
                }
                if (sorgente instanceof byte[]) {
                    this.createSorgente((byte[])sorgente);
                    break block24;
                }
                if (sorgente instanceof InputStream) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    InputStream is = (InputStream)sorgente;
                    CopyStream.copy((InputStream)is, (OutputStream)bout);
                    bout.flush();
                    bout.close();
                    this.createSorgente(bout.toByteArray());
                    break block24;
                }
                if (!(sorgente instanceof File)) break block24;
                this.createSorgente(((File)sorgente).getAbsolutePath());
                try {
                    f2 = (File)sorgente;
                    if (f2.getParentFile() != null) {
                        this.parentFile = f2.getParentFile();
                    }
                }
                catch (Exception f3) {}
            }
            catch (DriverRegistroServiziException d) {
                throw d;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            if (CostantiConfigurazione.REGISTRO_DB.equals(destinazione.getTipo())) {
                if (destinazione.getLocation() == null) {
                    throw new Exception("Location (DataSource) non definita");
                }
                if (destinazione.getTipoDatabase() == null) {
                    throw new Exception("TipoDatabase (DataSource) non definita");
                }
                if (destinazione.getGenericPropertiesMap() == null) {
                    throw new Exception("Contesto di localizzazione del datasource non definito in GenericProperties");
                }
                Properties properties = new Properties();
                properties.putAll(destinazione.getGenericPropertiesMap());
                this.gestoreCRUD = new DriverRegistroServiziDB(destinazione.getLocation(), properties, this.logDriver, destinazione.getTipoDatabase());
                if (!((DriverRegistroServiziDB)this.gestoreCRUD).create) {
                    throw new Exception("RegistroServizi DB non inizializzato");
                }
            } else {
                throw new Exception("Tipo di registro CRUD non gestito: " + String.valueOf(destinazione.getTipo()));
            }
            this.log.info("Inizializzato Registro dei Servizi DB");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
        try {
            ProtocolFactoryReflectionUtils.initializeProtocolManager(protocolloDefault, this.log);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    public XMLDataConverter(String sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(RegistroServizi sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(RegistroServizi sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(RegistroServizi sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, IDriverRegistroServiziCRUD gestoreCRUD, String tipoDestinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        block16: {
            this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
            this.logDriver = logDriver;
            if (gestoreCRUD == null) {
                throw new DriverRegistroServiziException("GestoreCRUD non definito");
            }
            this.tipoBEDestinazione = tipoDestinazione;
            this.superUser = superUser;
            try {
                File f2;
                if (sorgente instanceof RegistroServizi) {
                    this.sorgenteRegistro = (RegistroServizi)sorgente;
                    break block16;
                }
                if (sorgente instanceof String) {
                    this.createSorgente((String)sorgente);
                    try {
                        f2 = new File((String)sorgente);
                        if (f2.getParentFile() != null) {
                            this.parentFile = f2.getParentFile();
                        }
                        break block16;
                    }
                    catch (Exception f2) {}
                    break block16;
                }
                if (sorgente instanceof byte[]) {
                    this.createSorgente((byte[])sorgente);
                    break block16;
                }
                if (sorgente instanceof InputStream) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    InputStream is = (InputStream)sorgente;
                    CopyStream.copy((InputStream)is, (OutputStream)bout);
                    bout.flush();
                    bout.close();
                    this.createSorgente(bout.toByteArray());
                    break block16;
                }
                if (!(sorgente instanceof File)) break block16;
                this.createSorgente(((File)sorgente).getAbsolutePath());
                try {
                    f2 = (File)sorgente;
                    if (f2.getParentFile() != null) {
                        this.parentFile = f2.getParentFile();
                    }
                }
                catch (Exception f3) {}
            }
            catch (DriverRegistroServiziException d) {
                throw d;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
            }
        }
        this.gestoreCRUD = gestoreCRUD;
        try {
            ProtocolFactoryReflectionUtils.initializeProtocolManager(protocolloDefault, this.log);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(RegistroServizi sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(RegistroServizi sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(RegistroServizi sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        block18: {
            this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
            this.logDriver = logDriver;
            this.superUser = superUser;
            this.tipoBEDestinazione = CostantiConfigurazione.REGISTRO_DB.toString();
            try {
                File f2;
                if (sorgente instanceof RegistroServizi) {
                    this.sorgenteRegistro = (RegistroServizi)sorgente;
                    break block18;
                }
                if (sorgente instanceof String) {
                    this.createSorgente((String)sorgente);
                    try {
                        f2 = new File((String)sorgente);
                        if (f2.getParentFile() != null) {
                            this.parentFile = f2.getParentFile();
                        }
                        break block18;
                    }
                    catch (Exception f2) {}
                    break block18;
                }
                if (sorgente instanceof byte[]) {
                    this.createSorgente((byte[])sorgente);
                    break block18;
                }
                if (sorgente instanceof InputStream) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    InputStream is = (InputStream)sorgente;
                    CopyStream.copy((InputStream)is, (OutputStream)bout);
                    bout.flush();
                    bout.close();
                    this.createSorgente(bout.toByteArray());
                    break block18;
                }
                if (!(sorgente instanceof File)) break block18;
                this.createSorgente(((File)sorgente).getAbsolutePath());
                try {
                    f2 = (File)sorgente;
                    if (f2.getParentFile() != null) {
                        this.parentFile = f2.getParentFile();
                    }
                }
                catch (Exception f3) {}
            }
            catch (DriverRegistroServiziException d) {
                throw d;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            this.gestoreCRUD = new DriverRegistroServiziDB(connection, this.logDriver, tipoDatabase);
            if (!((DriverRegistroServiziDB)this.gestoreCRUD).create) {
                throw new Exception("Configurazione DB non inizializzato");
            }
            this.log.info("Inizializzato Configurazione DB");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
        try {
            ProtocolFactoryReflectionUtils.initializeProtocolManager(protocolloDefault, this.log);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    private void createSorgente(String sorgente) throws DriverRegistroServiziException {
        if (sorgente == null) {
            throw new DriverRegistroServiziException("Sorgente non definita");
        }
        ValidatoreXSD validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), this.log, DriverRegistroServiziXML.class.getResourceAsStream("/registroServizi.xsd"));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage());
        }
        FileInputStream fXML = null;
        try {
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                validatoreRegistro.valida(sorgente);
            } else {
                fXML = new FileInputStream(sorgente);
                validatoreRegistro.valida((InputStream)fXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage());
        }
        finally {
            if (fXML != null) {
                try {
                    fXML.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            InputStream iStream = null;
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                try {
                    HttpResponse response = HttpUtilities.getHTTPResponse((String)sorgente);
                    if (response == null) {
                        throw new UtilsException("Response null");
                    }
                    if (response.getContentStream() != null) {
                        iStream = response.getContentStream();
                    }
                    if (response.getContent() != null && response.getContent().length > 0) {
                        iStream = new ByteArrayInputStream(response.getContent());
                    }
                    throw new UtilsException("Response empty");
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
                }
            } else {
                try {
                    iStream = new FileInputStream(sorgente);
                }
                catch (FileNotFoundException e) {
                    throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
                }
            }
            try {
                JaxbDeserializer deserializer = new JaxbDeserializer();
                this.sorgenteRegistro = deserializer.readRegistroServizi(iStream);
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    private void createSorgente(byte[] sorgente) throws DriverRegistroServiziException {
        if (sorgente == null) {
            throw new DriverRegistroServiziException("Sorgente non definita");
        }
        ValidatoreXSD validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), this.log, DriverRegistroServiziXML.class.getResourceAsStream("/registroServizi.xsd"));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage());
        }
        try {
            validatoreRegistro.valida((InputStream)new ByteArrayInputStream(sorgente));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage());
        }
        try {
            ByteArrayInputStream iStream = null;
            try {
                iStream = new ByteArrayInputStream(sorgente);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStreamReader del registro dei servizi : \n\n" + e.getMessage());
            }
            try {
                JaxbDeserializer deserializer = new JaxbDeserializer();
                this.sorgenteRegistro = deserializer.readRegistroServizi(iStream);
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        ((InputStream)iStream).close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    ((InputStream)iStream).close();
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    public void convertXML(boolean reset, boolean mantieniFruitoriEsistenti, boolean aggiornamentoSoggetti, StatiAccordo statoAccordo) throws DriverRegistroServiziException {
        this.convertXML(reset, new PdDConfig(), mantieniFruitoriEsistenti, aggiornamentoSoggetti, statoAccordo);
    }

    public void convertXML(boolean reset, boolean mantieniFruitoriEsistenti, boolean aggiornamentoSoggetti, StatiAccordo statoAccordo, boolean updateEnabled) throws DriverRegistroServiziException {
        this.convertXML(reset, new PdDConfig(), mantieniFruitoriEsistenti, aggiornamentoSoggetti, statoAccordo, updateEnabled);
    }

    public void convertXML(boolean reset, PdDConfig pddConfig, boolean mantieniFruitoriEsistenti, boolean aggiornamentoSoggetti, StatiAccordo statoAccordo) throws DriverRegistroServiziException {
        this.convertXML(reset, pddConfig, mantieniFruitoriEsistenti, aggiornamentoSoggetti, statoAccordo, true);
    }

    public void convertXML(boolean reset, PdDConfig pddConfig, boolean mantieniFruitoriEsistenti, boolean aggiornamentoSoggetti, StatiAccordo statoAccordo, boolean updateEnabled) throws DriverRegistroServiziException {
        Soggetto soggetto;
        int i;
        if (reset) {
            try {
                this.log.info("RegistroServizi, reset in corso...");
                this.gestoreCRUD.reset();
                this.log.info("RegistroServizi, reset effettuato.");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverRegistroServiziException("Reset del RegistroServizi non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizePortaDominioList(); ++i) {
                PortaDominio pdd = this.sorgenteRegistro.getPortaDominio(i);
                pdd.setSuperUser(this.superUser);
                XMLDataConverter.impostaInformazioniRegistroDB_PortaDominio(pdd);
                if (!reset && this.gestoreCRUD.existsPortaDominio(pdd.getNome())) {
                    if (updateEnabled) {
                        this.log.info("Porta di Dominio " + pdd.getNome() + " aggiornamento in corso...");
                        this.gestoreCRUD.updatePortaDominio(pdd);
                        this.log.info("Porta di Dominio " + pdd.getNome() + " aggiornata.");
                    } else {
                        this.log.info("Porta di Dominio " + pdd.getNome() + " non aggiornata (aggiornamento disabilitato).");
                    }
                } else {
                    this.log.info("Porta di Dominio " + pdd.getNome() + " creazione in corso...");
                    this.gestoreCRUD.createPortaDominio(pdd);
                    this.log.info("Porta di Dominio " + pdd.getNome() + " creata.");
                }
                if (!CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione) || pddConfig.getPddOperativaCtrlstatSinglePdd() == null) continue;
                XMLDataConverter.impostaInformazioniRegistroDB_PortaDominio_update(pdd, pddConfig.getPddOperativaCtrlstatSinglePdd(), this.log, (DriverRegistroServiziDB)this.gestoreCRUD, pddConfig.getTipoPdd());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML delle porte di dominio: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeGruppoList(); ++i) {
                Gruppo gruppo = this.sorgenteRegistro.getGruppo(i);
                gruppo.setSuperUser(this.superUser);
                XMLDataConverter.impostaInformazioniRegistroDB_Gruppo(gruppo);
                IDGruppo idGruppo = new IDGruppo(gruppo.getNome());
                if (!reset && this.gestoreCRUD.existsGruppo(idGruppo)) {
                    if (updateEnabled) {
                        this.log.info("Gruppo " + gruppo.getNome() + " aggiornamento in corso...");
                        this.gestoreCRUD.updateGruppo(gruppo);
                        this.log.info("Gruppo " + gruppo.getNome() + " aggiornato.");
                        continue;
                    }
                    this.log.info("Gruppo " + gruppo.getNome() + " non aggiornato (aggiornamento disabilitato).");
                    continue;
                }
                this.log.info("Gruppo " + gruppo.getNome() + " creazione in corso...");
                this.gestoreCRUD.createGruppo(gruppo);
                this.log.info("Gruppo " + gruppo.getNome() + " creato.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei gruppi: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeRuoloList(); ++i) {
                Ruolo ruolo = this.sorgenteRegistro.getRuolo(i);
                ruolo.setSuperUser(this.superUser);
                XMLDataConverter.impostaInformazioniRegistroDB_Ruolo(ruolo);
                IDRuolo idRuolo = new IDRuolo(ruolo.getNome());
                if (!reset && this.gestoreCRUD.existsRuolo(idRuolo)) {
                    if (updateEnabled) {
                        this.log.info("Ruolo " + ruolo.getNome() + " aggiornamento in corso...");
                        this.gestoreCRUD.updateRuolo(ruolo);
                        this.log.info("Ruolo " + ruolo.getNome() + " aggiornato.");
                        continue;
                    }
                    this.log.info("Ruolo " + ruolo.getNome() + " non aggiornato (aggiornamento disabilitato).");
                    continue;
                }
                this.log.info("Ruolo " + ruolo.getNome() + " creazione in corso...");
                this.gestoreCRUD.createRuolo(ruolo);
                this.log.info("Ruolo " + ruolo.getNome() + " creato.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei ruoli: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeScopeList(); ++i) {
                Scope scope = this.sorgenteRegistro.getScope(i);
                scope.setSuperUser(this.superUser);
                XMLDataConverter.impostaInformazioniRegistroDB_Scope(scope);
                IDScope idScope = new IDScope(scope.getNome());
                if (!reset && this.gestoreCRUD.existsScope(idScope)) {
                    if (updateEnabled) {
                        this.log.info("Scope " + scope.getNome() + " aggiornamento in corso...");
                        this.gestoreCRUD.updateScope(scope);
                        this.log.info("Scope " + scope.getNome() + " aggiornato.");
                        continue;
                    }
                    this.log.info("Scope " + scope.getNome() + " non aggiornato (aggiornamento disabilitato).");
                    continue;
                }
                this.log.info("Scope " + scope.getNome() + " creazione in corso...");
                this.gestoreCRUD.createScope(scope);
                this.log.info("Scope " + scope.getNome() + " creato.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli scope: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeSoggettoList(); ++i) {
                Soggetto soggetto2 = this.sorgenteRegistro.getSoggetto(i);
                this.gestioneSoggetto(soggetto2, reset, aggiornamentoSoggetti, pddConfig.getPddOperativaCtrlstatSinglePdd(), updateEnabled);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei soggetti: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeAccordoCooperazioneList(); ++i) {
                AccordoCooperazione ac = this.sorgenteRegistro.getAccordoCooperazione(i);
                if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                    ac.setStatoPackage(statoAccordo.toString());
                }
                this.gestioneAccordoCooperazione(ac, reset, updateEnabled);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli accordi di cooperazione: " + e.getMessage(), e);
        }
        ArrayList<AccordoServizioParteComune> accordiServizioComposti = new ArrayList<AccordoServizioParteComune>();
        ArrayList<String> accordiServizioCompostiID = new ArrayList<String>();
        try {
            for (int i2 = 0; i2 < this.sorgenteRegistro.sizeAccordoServizioParteComuneList(); ++i2) {
                AccordoServizioParteComune as = this.sorgenteRegistro.getAccordoServizioParteComune(i2);
                if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                    as.setStatoPackage(statoAccordo.toString());
                }
                if (as.getServizioComposto() == null) {
                    this.gestioneAccordoServizioParteComune(as, reset, updateEnabled);
                    continue;
                }
                String idAccordoServizioComposto = this.idAccordoFactory.getUriFromAccordo(as);
                this.log.debug("AccordoServizio [" + idAccordoServizioComposto + "] e' un accordo di servizio composto, verra posticipata la gestione dopo la creazione dei servizi");
                accordiServizioComposti.add(as);
                accordiServizioCompostiID.add(idAccordoServizioComposto);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli accordi: " + e.getMessage(), e);
        }
        ArrayList<AccordoServizioParteSpecifica> servizioComposti = new ArrayList<AccordoServizioParteSpecifica>();
        ArrayList<Soggetto> servizioComposti_Soggetti = new ArrayList<Soggetto>();
        try {
            for (int i3 = 0; i3 < this.sorgenteRegistro.sizeSoggettoList(); ++i3) {
                soggetto = this.sorgenteRegistro.getSoggetto(i3);
                for (int j = 0; j < soggetto.sizeAccordoServizioParteSpecificaList(); ++j) {
                    boolean servizioComposto;
                    AccordoServizioParteSpecifica servizio = soggetto.getAccordoServizioParteSpecifica(j);
                    if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                        servizio.setStatoPackage(statoAccordo.toString());
                    }
                    if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione) && servizio.getVersione() == null) {
                        servizio.setVersione(1);
                    }
                    if (!(servizioComposto = accordiServizioCompostiID.contains(servizio.getAccordoServizioParteComune()))) {
                        this.gestioneServizio(servizio, soggetto, reset, mantieniFruitoriEsistenti, statoAccordo, updateEnabled);
                        continue;
                    }
                    String uri = this.idServizioFactory.getUriFromAccordo(servizio);
                    this.log.debug("Servizio [" + uri + "] e' un servizio composto, verra posticipata la gestione dopo la creazione degli accordi di servizio composti");
                    servizioComposti.add(servizio);
                    servizioComposti_Soggetti.add(soggetto);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei servizi: " + e.getMessage(), e);
        }
        try {
            while (accordiServizioComposti.size() > 0) {
                AccordoServizioParteComune as = (AccordoServizioParteComune)accordiServizioComposti.remove(0);
                this.gestioneAccordoServizioParteComune(as, reset, updateEnabled);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli accordi di servizio composti: " + e.getMessage(), e);
        }
        try {
            while (servizioComposti.size() > 0) {
                AccordoServizioParteSpecifica servizio = (AccordoServizioParteSpecifica)servizioComposti.remove(0);
                soggetto = (Soggetto)servizioComposti_Soggetti.remove(0);
                this.gestioneServizio(servizio, soggetto, reset, mantieniFruitoriEsistenti, statoAccordo, updateEnabled);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei servizi degli accordi di servizio composti: " + e.getMessage(), e);
        }
    }

    public static void impostaInformazioniRegistroDB_PortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd.getImplementazione() == null) {
            pdd.setImplementazione("standard");
        }
    }

    public static void impostaInformazioniRegistroDB_PortaDominio_update(PortaDominio pdd, String nomePddOperativaCtrlstatSinglePdD, Logger log, DriverRegistroServiziDB driverRegistroServiziDB, String tipoPdd) throws DriverRegistroServiziException {
        if (pdd.getNome().equals(nomePddOperativaCtrlstatSinglePdD)) {
            log.info("Porta di Dominio " + pdd.getNome() + " aggiornamento tipo[" + PddTipologia.OPERATIVO.toString() + "] in corso...");
            driverRegistroServiziDB.updateTipoPortaDominio(pdd.getNome(), PddTipologia.OPERATIVO.toString());
            log.info("Porta di Dominio " + pdd.getNome() + " aggiornata con tipo " + PddTipologia.OPERATIVO.toString() + ".");
        } else {
            log.info("Porta di Dominio " + pdd.getNome() + " aggiornamento tipo[" + PddTipologia.ESTERNO.toString() + "] in corso...");
            driverRegistroServiziDB.updateTipoPortaDominio(pdd.getNome(), tipoPdd);
            log.info("Porta di Dominio " + pdd.getNome() + " aggiornata con tipo " + PddTipologia.ESTERNO.toString() + ".");
        }
    }

    public static void impostaInformazioniRegistroDB_Gruppo(Gruppo gruppo) throws DriverRegistroServiziException {
    }

    public static void impostaInformazioniRegistroDB_Ruolo(Ruolo ruolo) throws DriverRegistroServiziException {
    }

    public static void impostaInformazioniRegistroDB_Scope(Scope scope) throws DriverRegistroServiziException {
    }

    private static void mantieniFruitori(AccordoServizioParteSpecifica old, AccordoServizioParteSpecifica servizio) {
        for (int fr = 0; fr < old.sizeFruitoreList(); ++fr) {
            boolean find = false;
            for (int frNew = 0; frNew < servizio.sizeFruitoreList(); ++frNew) {
                if (!servizio.getFruitore(frNew).getTipo().equals(old.getFruitore(fr).getTipo()) || !servizio.getFruitore(frNew).getNome().equals(old.getFruitore(fr).getNome())) continue;
                find = true;
                break;
            }
            if (find) continue;
            servizio.addFruitore(old.getFruitore(fr));
        }
    }

    public static void aggiornatoStatoFruitori(AccordoServizioParteSpecifica servizio, StatiAccordo statoAccordo) {
        for (int i = 0; i < servizio.sizeFruitoreList(); ++i) {
            servizio.getFruitore(i).setStatoPackage(statoAccordo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean deleteSoggetti, boolean deleteMappingErogazioneFruizione) throws DriverRegistroServiziException {
        int i;
        try {
            for (int i2 = 0; i2 < this.sorgenteRegistro.sizeSoggettoList(); ++i2) {
                Soggetto soggetto = this.sorgenteRegistro.getSoggetto(i2);
                for (int j = 0; j < soggetto.sizeAccordoServizioParteSpecificaList(); ++j) {
                    AccordoServizioParteSpecifica servizio = soggetto.getAccordoServizioParteSpecifica(j);
                    servizio.setTipoSoggettoErogatore(soggetto.getTipo());
                    servizio.setNomeSoggettoErogatore(soggetto.getNome());
                    IDServizio idServizio = this.idServizioFactory.getIDServizioFromAccordo(servizio);
                    String uri = this.idServizioFactory.getUriFromAccordo(servizio);
                    if (deleteMappingErogazioneFruizione && this.gestoreCRUD instanceof DriverRegistroServiziDB) {
                        DriverRegistroServiziDB driver = (DriverRegistroServiziDB)this.gestoreCRUD;
                        Connection con = null;
                        try {
                            con = driver.getConnection("XMLDataConverter.mappingErogazioneFruizione");
                            if (con.getAutoCommit()) {
                                con.setAutoCommit(false);
                            }
                            this.log.info("Servizio " + uri + " (mappingErogazione) eliminazione in corso...");
                            if (this.gestoreCRUD.existsAccordoServizioParteSpecifica(idServizio)) {
                                AccordoServizioParteSpecifica dbImage = driver.getAccordoServizioParteSpecifica(idServizio);
                                for (Fruitore fruitore : dbImage.getFruitoreList()) {
                                    IDSoggetto idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                                    if (!DBMappingUtils.existsIDPorteDelegateAssociate(idServizio, idFruitore, con, driver.getTipoDB())) continue;
                                    DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, true, con, driver.getTipoDB());
                                }
                            }
                            if (DBMappingUtils.existsIDPorteApplicativeAssociate(idServizio, con, driver.getTipoDB())) {
                                DBMappingUtils.deleteMappingErogazione(idServizio, true, con, driver.getTipoDB());
                            }
                            this.log.info("Servizio " + uri + " (mappingErogazione) eliminazione completata");
                        }
                        finally {
                            try {
                                if (con != null) {
                                    con.commit();
                                }
                            }
                            catch (Exception exception) {}
                            try {
                                if (con != null) {
                                    con.setAutoCommit(true);
                                }
                            }
                            catch (Exception exception) {}
                            driver.releaseConnection(con);
                        }
                    }
                    this.log.info("Servizio " + uri + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsAccordoServizioParteSpecifica(idServizio)) {
                        this.gestoreCRUD.deleteAccordoServizioParteSpecifica(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizioParteSpecifica(idServizio));
                    }
                    this.log.info("Servizio " + uri + " eliminato.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante l'eliminazione dei servizi: " + e.getMessage(), e);
        }
        ArrayList<AccordoServizioParteComune> asServiziNonComposti = new ArrayList<AccordoServizioParteComune>();
        try {
            for (int i3 = 0; i3 < this.sorgenteRegistro.sizeAccordoServizioParteComuneList(); ++i3) {
                AccordoServizioParteComune as = this.sorgenteRegistro.getAccordoServizioParteComune(i3);
                if (as.getServizioComposto() == null) {
                    asServiziNonComposti.add(as);
                    continue;
                }
                this.log.info("Accordo di Servizio Composto " + this.idAccordoFactory.getUriFromAccordo(as) + " eliminazione in corso...");
                if (this.gestoreCRUD.existsAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromAccordo(as))) {
                    this.gestoreCRUD.deleteAccordoServizioParteComune(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromAccordo(as)));
                }
                this.log.info("Accordo di Servizio Composto " + this.idAccordoFactory.getUriFromAccordo(as) + " eliminato");
            }
            while (asServiziNonComposti.size() > 0) {
                AccordoServizioParteComune as = (AccordoServizioParteComune)asServiziNonComposti.remove(0);
                this.log.info("Accordo di Servizio " + this.idAccordoFactory.getUriFromAccordo(as) + " eliminazione in corso...");
                if (this.gestoreCRUD.existsAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromAccordo(as))) {
                    this.gestoreCRUD.deleteAccordoServizioParteComune(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromAccordo(as)));
                }
                this.log.info("Accordo di Servizio " + this.idAccordoFactory.getUriFromAccordo(as) + " eliminato");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante l'eliminazione degli accordi: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeAccordoCooperazioneList(); ++i) {
                AccordoCooperazione ac = this.sorgenteRegistro.getAccordoCooperazione(i);
                this.log.info("Accordo di Cooperazione " + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + " eliminazione in corso...");
                if (this.gestoreCRUD.existsAccordoCooperazione(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac))) {
                    this.gestoreCRUD.deleteAccordoCooperazione(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoCooperazione(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac)));
                }
                this.log.info("Accordo di Cooperazione " + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + " eliminato");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverRegistroServiziException("Errore durante l'eliminazione degli accordi di cooperazione: " + e.getMessage(), e);
        }
        if (deleteSoggetti) {
            try {
                for (i = 0; i < this.sorgenteRegistro.sizeSoggettoList(); ++i) {
                    Soggetto soggetto = this.sorgenteRegistro.getSoggetto(i);
                    IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsSoggetto(idSoggetto)) {
                        this.gestoreCRUD.deleteSoggetto(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getSoggetto(idSoggetto));
                    }
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminato.");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverRegistroServiziException("Errore durante l'eliminazione dei soggetti: " + e.getMessage(), e);
            }
            try {
                for (i = 0; i < this.sorgenteRegistro.sizePortaDominioList(); ++i) {
                    PortaDominio pdd = this.sorgenteRegistro.getPortaDominio(i);
                    this.log.info("Porta di Dominio " + pdd.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsPortaDominio(pdd.getNome())) {
                        this.gestoreCRUD.deletePortaDominio(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getPortaDominio(pdd.getNome()));
                    }
                    this.log.info("Porta di Dominio " + pdd.getNome() + " eliminata.");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverRegistroServiziException("Errore durante l'eliminazione delle porte di dominio: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gestioneBytesDocumenti_Wsdl_Wsbl(String documento) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (documento != null && !documento.equals("http://undefined")) {
            if (documento.startsWith("http://") || documento.startsWith("file://")) {
                byte[] file = HttpUtilities.requestHTTPFile((String)documento);
                if (file == null) {
                    throw new Exception("byte[] is null");
                }
                bout.write(file);
            } else {
                File f = new File(documento);
                if (f.exists()) {
                    FileInputStream file = null;
                    try {
                        file = new FileInputStream(f);
                        CopyStream.copy((InputStream)file, (OutputStream)bout);
                    }
                    finally {
                        try {
                            if (file != null) {
                                file.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                if (this.parentFile != null) {
                    File fWithParent = new File(this.parentFile, documento);
                    if (fWithParent.exists()) {
                        FileInputStream file = null;
                        try {
                            file = new FileInputStream(fWithParent);
                            CopyStream.copy((InputStream)file, (OutputStream)bout);
                        }
                        finally {
                            try {
                                if (file != null) {
                                    file.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    throw new Exception("File [" + documento + "] non esistente");
                }
            }
            bout.flush();
            bout.close();
            if (bout.size() > 0) {
                return bout.toByteArray();
            }
        }
        return null;
    }

    private void initializeWSDLBytes(AccordoServizioParteComune as) throws DriverRegistroServiziException {
        String uriAS = this.idAccordoFactory.getUriFromAccordo(as);
        if (as.getWsdlDefinitorio() != null) {
            try {
                as.setByteWsdlDefinitorio(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlDefinitorio()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura wsdl definitorio [" + as.getWsdlDefinitorio() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getWsdlConcettuale() != null) {
            try {
                as.setByteWsdlConcettuale(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlConcettuale()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura wsdl concettuale [" + as.getWsdlConcettuale() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getWsdlLogicoErogatore() != null) {
            try {
                as.setByteWsdlLogicoErogatore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlLogicoErogatore()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura wsdl logico erogatore [" + as.getWsdlLogicoErogatore() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getWsdlLogicoFruitore() != null) {
            try {
                as.setByteWsdlLogicoFruitore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlLogicoFruitore()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura wsdl logico fruitore [" + as.getWsdlLogicoFruitore() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getSpecificaConversazioneConcettuale() != null) {
            try {
                as.setByteSpecificaConversazioneConcettuale(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getSpecificaConversazioneConcettuale()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura specifica conversazione concettuale [" + as.getSpecificaConversazioneConcettuale() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getSpecificaConversazioneErogatore() != null) {
            try {
                as.setByteSpecificaConversazioneErogatore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getSpecificaConversazioneErogatore()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura specifica conversazione erogatore [" + as.getSpecificaConversazioneErogatore() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getSpecificaConversazioneFruitore() != null) {
            try {
                as.setByteSpecificaConversazioneFruitore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getSpecificaConversazioneFruitore()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura specifica conversazione fruitore [" + as.getSpecificaConversazioneFruitore() + "] non riuscita:", (Throwable)e);
            }
        }
    }

    private void initializeWSDLBytes(AccordoServizioParteSpecifica s) {
        String uri;
        if (s.getWsdlImplementativoErogatore() != null) {
            try {
                s.setByteWsdlImplementativoErogatore(this.gestioneBytesDocumenti_Wsdl_Wsbl(s.getWsdlImplementativoErogatore()));
            }
            catch (Exception e) {
                uri = null;
                try {
                    uri = this.idServizioFactory.getUriFromAccordo(s);
                }
                catch (Exception eInternal) {
                    throw new RuntimeException(eInternal);
                }
                this.log.warn("Servizio " + uri + ", lettura wsdl implementativo erogatore [" + s.getWsdlImplementativoErogatore() + "] non riuscita:", (Throwable)e);
            }
        }
        if (s.getWsdlImplementativoFruitore() != null) {
            try {
                s.setByteWsdlImplementativoFruitore(this.gestioneBytesDocumenti_Wsdl_Wsbl(s.getWsdlImplementativoFruitore()));
            }
            catch (Exception e) {
                uri = null;
                try {
                    uri = this.idServizioFactory.getUriFromAccordo(s);
                }
                catch (Exception eInternal) {
                    throw new RuntimeException(eInternal);
                }
                this.log.warn("Servizio " + uri + ", lettura wsdl implementativo fruitore [" + s.getWsdlImplementativoFruitore() + "] non riuscita:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readDocumento(String fileName) throws DriverRegistroServiziException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            if (fileName.startsWith("http://") || fileName.startsWith("file://")) {
                byte[] file = HttpUtilities.requestHTTPFile((String)fileName);
                if (file == null) {
                    throw new Exception("byte[] is null");
                }
                bout.write(file);
            } else {
                File f = new File(fileName);
                if (f.exists()) {
                    FileInputStream file = null;
                    try {
                        file = new FileInputStream(f);
                        CopyStream.copy((InputStream)file, (OutputStream)bout);
                    }
                    finally {
                        try {
                            if (file != null) {
                                file.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                if (this.parentFile != null) {
                    File fWithParent = new File(this.parentFile, fileName);
                    if (fWithParent.exists()) {
                        FileInputStream file = null;
                        try {
                            file = new FileInputStream(fWithParent);
                            CopyStream.copy((InputStream)file, (OutputStream)bout);
                        }
                        finally {
                            try {
                                if (file != null) {
                                    file.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    throw new Exception("File [" + fileName + "] non esistente");
                }
            }
            bout.flush();
            bout.close();
            if (bout.size() > 0) {
                return bout.toByteArray();
            }
        }
        catch (Exception e) {
            this.log.warn("File " + fileName + ", lettura documento non riuscita:", (Throwable)e);
        }
        throw new DriverRegistroServiziException("Contenuto non letto?? File [" + fileName + "]");
    }

    private String getNomeFile(String fileName) {
        String name = null;
        if (fileName.startsWith("http://")) {
            int index = fileName.lastIndexOf("/");
            name = fileName.substring(index + 1, fileName.length());
        } else {
            File f = new File(fileName);
            name = f.getName();
        }
        return name;
    }

    private static void gestioneDefaultConnettoreHTTP(Connettore connettore) {
        if (connettore.getProperties() != null) {
            Property cp;
            if (!connettore.getProperties().containsKey("trustStoreType")) {
                cp = new Property();
                cp.setNome("trustStoreType");
                cp.setValore(KeystoreType.JKS.getNome());
                connettore.addProperty(cp);
            }
            if (!connettore.getProperties().containsKey("trustManagementAlgorithm")) {
                cp = new Property();
                cp.setNome("trustManagementAlgorithm");
                cp.setValore(TrustManagerFactory.getDefaultAlgorithm());
                connettore.addProperty(cp);
            }
            if (connettore.getProperties().containsKey("keyStoreLocation")) {
                if (!connettore.getProperties().containsKey("keyStoreType")) {
                    cp = new Property();
                    cp.setNome("keyStoreType");
                    cp.setValore(KeystoreType.JKS.getNome());
                    connettore.addProperty(cp);
                }
                if (!connettore.getProperties().containsKey("keyManagementAlgorithm")) {
                    cp = new Property();
                    cp.setNome("keyManagementAlgorithm");
                    cp.setValore(KeyManagerFactory.getDefaultAlgorithm());
                    connettore.addProperty(cp);
                }
            }
        }
    }

    public static void impostaInformazioniRegistroDB_Soggetto(Soggetto soggetto, String pddOperativaCtrlstatSinglePdd) throws DriverRegistroServiziException {
        if (soggetto.getConnettore() != null) {
            soggetto.getConnettore().setNome(null);
            String tipoConnettore = soggetto.getConnettore().getTipo();
            if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                soggetto.getConnettore().setCustom(true);
            }
            if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                XMLDataConverter.gestioneDefaultConnettoreHTTP(soggetto.getConnettore());
            }
        }
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
            try {
                soggetto.setIdentificativoPorta(ProtocolFactoryReflectionUtils.getIdentificativoPortaDefault(idSoggetto));
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        }
        if (soggetto.getCodiceIpa() == null || "".equals(soggetto.getCodiceIpa())) {
            try {
                soggetto.setCodiceIpa(ProtocolFactoryReflectionUtils.getCodiceIPADefault(idSoggetto));
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        }
        if (pddOperativaCtrlstatSinglePdd != null && soggetto.getPortaDominio() == null) {
            soggetto.setPortaDominio(pddOperativaCtrlstatSinglePdd);
        }
    }

    public static void impostaInformazioniRegistroDB_Soggetto_update(Soggetto soggetto, Soggetto old) {
        soggetto.setId(old.getId());
        if (soggetto.getConnettore() == null) {
            soggetto.setConnettore(old.getConnettore());
        } else {
            soggetto.getConnettore().setId(old.getConnettore().getId());
            soggetto.getConnettore().setNome(old.getConnettore().getNome());
        }
    }

    private void gestioneSoggetto(Soggetto soggetto, boolean reset, boolean aggiornamentoSoggetti, String pddOperativaCtrlstatSinglePdd, boolean updateEnabled) throws Exception {
        soggetto.setSuperUser(this.superUser);
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
            XMLDataConverter.impostaInformazioniRegistroDB_Soggetto(soggetto, pddOperativaCtrlstatSinglePdd);
        }
        if (soggetto.sizeProtocolPropertyList() > 0) {
            for (ProtocolProperty pp : soggetto.getProtocolPropertyList()) {
                if (pp.getFile() == null) continue;
                pp.setByteFile(this.readDocumento(pp.getFile()));
            }
        }
        if (!reset && this.gestoreCRUD.existsSoggetto(idSoggetto)) {
            if (aggiornamentoSoggetti) {
                if (updateEnabled) {
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso...");
                    Soggetto old = ((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getSoggetto(idSoggetto);
                    XMLDataConverter.impostaInformazioniRegistroDB_Soggetto_update(soggetto, old);
                    this.gestoreCRUD.updateSoggetto(soggetto);
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato.");
                } else {
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non aggiornato (aggiornamento disabilitato).");
                }
            }
        } else {
            this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso...");
            this.gestoreCRUD.createSoggetto(soggetto);
            this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato.");
        }
    }

    private void gestioneAccordoCooperazione(AccordoCooperazione ac, boolean reset, boolean updateEnabled) throws Exception {
        String name;
        String fileName;
        int k;
        ac.setSuperUser(this.superUser);
        for (k = 0; k < ac.sizeAllegatoList(); ++k) {
            fileName = ac.getAllegato(k).getFile();
            name = this.getNomeFile(fileName);
            ac.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            ac.getAllegato(k).setFile(name);
            ac.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            ac.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
        }
        for (k = 0; k < ac.sizeSpecificaSemiformaleList(); ++k) {
            fileName = ac.getSpecificaSemiformale(k).getFile();
            name = this.getNomeFile(fileName);
            ac.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            ac.getSpecificaSemiformale(k).setFile(name);
            ac.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            ac.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
        }
        if (ac.sizeProtocolPropertyList() > 0) {
            for (ProtocolProperty pp : ac.getProtocolPropertyList()) {
                if (pp.getFile() == null) continue;
                pp.setByteFile(this.readDocumento(pp.getFile()));
            }
        }
        IDAccordoCooperazione idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac);
        String uriAC = this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordo);
        if (!reset && this.gestoreCRUD.existsAccordoCooperazione(idAccordo)) {
            if (updateEnabled) {
                this.log.info("Accordo di Cooperazione " + uriAC + " aggiornamento in corso...");
                this.gestoreCRUD.updateAccordoCooperazione(ac);
                this.log.info("Accordo di Cooperazione " + uriAC + " aggiornato.");
            } else {
                this.log.info("Accordo di Cooperazione " + uriAC + " non aggiornato (aggiornamento disabilitato).");
            }
        } else {
            this.log.info("Accordo di Cooperazione " + uriAC + " creazione in corso...");
            this.gestoreCRUD.createAccordoCooperazione(ac);
            this.log.info("Accordo di Cooperazione " + uriAC + " creato.");
        }
    }

    public static boolean equals(StatoFunzionalita arg1, StatoFunzionalita arg2) {
        if (arg1 == null) {
            return arg2 == null;
        }
        return arg1.equals(arg2);
    }

    public static void impostaInformazioniRegistroDB_AccordoServizioParteComune(AccordoServizioParteComune as) {
        int k;
        for (k = 0; k < as.sizeAzioneList(); ++k) {
            if (!((as.getAzione(k).getProfiloCollaborazione() == null || as.getAzione(k).getProfiloCollaborazione().equals(as.getProfiloCollaborazione())) && XMLDataConverter.equals(as.getAzione(k).getConfermaRicezione(), as.getConfermaRicezione()) && XMLDataConverter.equals(as.getAzione(k).getConsegnaInOrdine(), as.getConsegnaInOrdine()) && XMLDataConverter.equals(as.getAzione(k).getFiltroDuplicati(), as.getFiltroDuplicati()) && XMLDataConverter.equals(as.getAzione(k).getIdCollaborazione(), as.getIdCollaborazione()) && XMLDataConverter.equals(as.getAzione(k).getIdRiferimentoRichiesta(), as.getIdRiferimentoRichiesta()) && (as.getAzione(k).getScadenza() == null || as.getAzione(k).getScadenza().equals(as.getScadenza())))) {
                as.getAzione(k).setProfAzione("ridefinito");
                continue;
            }
            as.getAzione(k).setProfAzione("default");
            as.getAzione(k).setProfiloCollaborazione(as.getProfiloCollaborazione());
            as.getAzione(k).setConfermaRicezione(as.getConfermaRicezione());
            as.getAzione(k).setConsegnaInOrdine(as.getConsegnaInOrdine());
            as.getAzione(k).setFiltroDuplicati(as.getFiltroDuplicati());
            as.getAzione(k).setIdCollaborazione(as.getIdCollaborazione());
            as.getAzione(k).setIdRiferimentoRichiesta(as.getIdRiferimentoRichiesta());
            as.getAzione(k).setScadenza(as.getScadenza());
        }
        for (k = 0; k < as.sizePortTypeList(); ++k) {
            PortType pt = as.getPortType(k);
            if (!((pt.getProfiloCollaborazione() == null || pt.getProfiloCollaborazione().equals(as.getProfiloCollaborazione())) && XMLDataConverter.equals(pt.getConfermaRicezione(), as.getConfermaRicezione()) && XMLDataConverter.equals(pt.getConsegnaInOrdine(), as.getConsegnaInOrdine()) && XMLDataConverter.equals(pt.getFiltroDuplicati(), as.getFiltroDuplicati()) && XMLDataConverter.equals(pt.getIdCollaborazione(), as.getIdCollaborazione()) && XMLDataConverter.equals(pt.getIdRiferimentoRichiesta(), as.getIdRiferimentoRichiesta()) && (pt.getScadenza() == null || pt.getScadenza().equals(as.getScadenza())))) {
                pt.setProfiloPT("ridefinito");
            } else {
                pt.setProfiloPT("default");
                pt.setProfiloCollaborazione(as.getProfiloCollaborazione());
                pt.setConfermaRicezione(as.getConfermaRicezione());
                pt.setConsegnaInOrdine(as.getConsegnaInOrdine());
                pt.setFiltroDuplicati(as.getFiltroDuplicati());
                pt.setIdCollaborazione(as.getIdCollaborazione());
                pt.setIdRiferimentoRichiesta(as.getIdRiferimentoRichiesta());
                pt.setScadenza(as.getScadenza());
            }
            for (int l = 0; l < pt.sizeAzioneList(); ++l) {
                Operation op = pt.getAzione(l);
                boolean ridefinitoProfiloAzioneParametri = false;
                ProfiloCollaborazione profiloDefault = null;
                String scadenzaDefault = null;
                if ("ridefinito".equals(pt.getProfiloPT())) {
                    ridefinitoProfiloAzioneParametri = !XMLDataConverter.equals(op.getConfermaRicezione(), pt.getConfermaRicezione()) || !XMLDataConverter.equals(op.getConsegnaInOrdine(), pt.getConsegnaInOrdine()) || !XMLDataConverter.equals(op.getFiltroDuplicati(), pt.getFiltroDuplicati()) || !XMLDataConverter.equals(op.getIdCollaborazione(), pt.getIdCollaborazione()) || !XMLDataConverter.equals(op.getIdRiferimentoRichiesta(), pt.getIdRiferimentoRichiesta());
                    profiloDefault = pt.getProfiloCollaborazione();
                    scadenzaDefault = pt.getScadenza();
                } else {
                    ridefinitoProfiloAzioneParametri = !XMLDataConverter.equals(op.getConfermaRicezione(), as.getConfermaRicezione()) || !XMLDataConverter.equals(op.getConsegnaInOrdine(), as.getConsegnaInOrdine()) || !XMLDataConverter.equals(op.getFiltroDuplicati(), as.getFiltroDuplicati()) || !XMLDataConverter.equals(op.getIdCollaborazione(), as.getIdCollaborazione()) || !XMLDataConverter.equals(op.getIdRiferimentoRichiesta(), as.getIdRiferimentoRichiesta());
                    profiloDefault = as.getProfiloCollaborazione();
                    scadenzaDefault = as.getScadenza();
                }
                if (op.getProfiloCollaborazione() != null && !op.getProfiloCollaborazione().equals(profiloDefault) || ridefinitoProfiloAzioneParametri || op.getScadenza() != null && !op.getScadenza().equals(scadenzaDefault)) {
                    op.setProfAzione("ridefinito");
                    continue;
                }
                op.setProfAzione("default");
                if ("ridefinito".equals(pt.getProfiloPT())) {
                    op.setProfiloCollaborazione(pt.getProfiloCollaborazione());
                    op.setConfermaRicezione(pt.getConfermaRicezione());
                    op.setConsegnaInOrdine(pt.getConsegnaInOrdine());
                    op.setFiltroDuplicati(pt.getFiltroDuplicati());
                    op.setIdCollaborazione(pt.getIdCollaborazione());
                    op.setIdRiferimentoRichiesta(pt.getIdRiferimentoRichiesta());
                    op.setScadenza(pt.getScadenza());
                    continue;
                }
                op.setProfiloCollaborazione(as.getProfiloCollaborazione());
                op.setConfermaRicezione(as.getConfermaRicezione());
                op.setConsegnaInOrdine(as.getConsegnaInOrdine());
                op.setFiltroDuplicati(as.getFiltroDuplicati());
                op.setIdCollaborazione(as.getIdCollaborazione());
                op.setIdRiferimentoRichiesta(as.getIdRiferimentoRichiesta());
                op.setScadenza(as.getScadenza());
            }
        }
        for (k = 0; k < as.sizeResourceList(); ++k) {
            if (!(XMLDataConverter.equals(as.getResource(k).getConfermaRicezione(), as.getConfermaRicezione()) && XMLDataConverter.equals(as.getResource(k).getConsegnaInOrdine(), as.getConsegnaInOrdine()) && XMLDataConverter.equals(as.getResource(k).getFiltroDuplicati(), as.getFiltroDuplicati()) && XMLDataConverter.equals(as.getResource(k).getIdCollaborazione(), as.getIdCollaborazione()) && XMLDataConverter.equals(as.getResource(k).getIdRiferimentoRichiesta(), as.getIdRiferimentoRichiesta()) && (as.getResource(k).getScadenza() == null || as.getResource(k).getScadenza().equals(as.getScadenza())))) {
                as.getResource(k).setProfAzione("ridefinito");
                continue;
            }
            as.getResource(k).setProfAzione("default");
            as.getResource(k).setConfermaRicezione(as.getConfermaRicezione());
            as.getResource(k).setConsegnaInOrdine(as.getConsegnaInOrdine());
            as.getResource(k).setFiltroDuplicati(as.getFiltroDuplicati());
            as.getResource(k).setIdCollaborazione(as.getIdCollaborazione());
            as.getResource(k).setIdRiferimentoRichiesta(as.getIdRiferimentoRichiesta());
            as.getResource(k).setScadenza(as.getScadenza());
        }
    }

    private void gestioneAccordoServizioParteComune(AccordoServizioParteComune as, boolean reset, boolean updateEnabled) throws Exception {
        Iterator<BaseBeanWithId> name;
        String fileName;
        int k;
        as.setSuperUser(this.superUser);
        if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteComune(as);
        }
        this.initializeWSDLBytes(as);
        for (k = 0; k < as.sizeAllegatoList(); ++k) {
            fileName = as.getAllegato(k).getFile();
            name = this.getNomeFile(fileName);
            as.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            as.getAllegato(k).setFile((String)((Object)name));
            as.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            as.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
        }
        for (k = 0; k < as.sizeSpecificaSemiformaleList(); ++k) {
            fileName = as.getSpecificaSemiformale(k).getFile();
            name = this.getNomeFile(fileName);
            as.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            as.getSpecificaSemiformale(k).setFile((String)((Object)name));
            as.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            as.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
        }
        if (as.getServizioComposto() != null) {
            for (k = 0; k < as.getServizioComposto().sizeSpecificaCoordinamentoList(); ++k) {
                fileName = as.getServizioComposto().getSpecificaCoordinamento(k).getFile();
                name = this.getNomeFile(fileName);
                as.getServizioComposto().getSpecificaCoordinamento(k).setByteContenuto(this.readDocumento(fileName));
                as.getServizioComposto().getSpecificaCoordinamento(k).setFile((String)((Object)name));
                as.getServizioComposto().getSpecificaCoordinamento(k).setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                as.getServizioComposto().getSpecificaCoordinamento(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
        }
        if (as.sizeProtocolPropertyList() > 0) {
            for (ProtocolProperty pp : as.getProtocolPropertyList()) {
                if (pp.getFile() == null) continue;
                pp.setByteFile(this.readDocumento(pp.getFile()));
            }
            if (as.sizeAzioneList() > 0) {
                for (Azione azione : as.getAzioneList()) {
                    for (ProtocolProperty pp : azione.getProtocolPropertyList()) {
                        if (pp.getFile() == null) continue;
                        pp.setByteFile(this.readDocumento(pp.getFile()));
                    }
                }
            }
            if (as.sizePortTypeList() > 0) {
                for (PortType pt : as.getPortTypeList()) {
                    for (ProtocolProperty pp : pt.getProtocolPropertyList()) {
                        if (pp.getFile() == null) continue;
                        pp.setByteFile(this.readDocumento(pp.getFile()));
                    }
                    if (pt.sizeAzioneList() <= 0) continue;
                    for (Operation azione : pt.getAzioneList()) {
                        for (ProtocolProperty pp : azione.getProtocolPropertyList()) {
                            if (pp.getFile() == null) continue;
                            pp.setByteFile(this.readDocumento(pp.getFile()));
                        }
                    }
                }
            }
            if (as.sizeResourceList() > 0) {
                for (Resource resource : as.getResourceList()) {
                    if (resource.getPath() != null && !"".equals(resource.getPath())) {
                        Object pathNormalizzato = null;
                        pathNormalizzato = resource.getPath().trim();
                        if (!((String)pathNormalizzato).startsWith("/")) {
                            pathNormalizzato = "/" + (String)pathNormalizzato;
                        }
                        resource.setPath((String)pathNormalizzato);
                    }
                    for (ProtocolProperty pp : resource.getProtocolPropertyList()) {
                        if (pp.getFile() == null) continue;
                        pp.setByteFile(this.readDocumento(pp.getFile()));
                    }
                }
            }
        }
        if (ServiceBinding.SOAP.equals(as.getServiceBinding())) {
            if (as.getFormatoSpecifica() == null) {
                as.setFormatoSpecifica(CostantiRegistroServizi.DEFAULT_VALUE_INTERFACE_TYPE_SOAP);
            }
        } else if (as.getFormatoSpecifica() == null) {
            as.setFormatoSpecifica(CostantiRegistroServizi.DEFAULT_VALUE_INTERFACE_TYPE_REST);
        }
        IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID(as.getSoggettoReferente()), as.getVersione());
        String uriAS = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
        if (!reset && this.gestoreCRUD.existsAccordoServizioParteComune(idAccordo)) {
            if (updateEnabled) {
                this.log.info("Accordo di Servizio " + uriAS + " aggiornamento in corso...");
                this.gestoreCRUD.updateAccordoServizioParteComune(as);
                this.log.info("Accordo di Servizio " + uriAS + " aggiornato.");
            } else {
                this.log.info("Accordo di Servizio " + uriAS + " non aggiornato (aggiornamento disabilitato).");
            }
        } else {
            this.log.info("Accordo di Servizio " + uriAS + " creazione in corso...");
            this.gestoreCRUD.createAccordoServizioParteComune(as);
            this.log.info("Accordo di Servizio " + uriAS + " creato.");
        }
    }

    public static void impostaInformazioniRegistroDB_AccordoServizioParteSpecifica_Fruitore(Fruitore fruitore) {
        if (fruitore.getConnettore() != null) {
            fruitore.getConnettore().setNome(null);
            String tipoConnettore = fruitore.getConnettore().getTipo();
            if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                fruitore.getConnettore().setCustom(true);
            }
            if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                XMLDataConverter.gestioneDefaultConnettoreHTTP(fruitore.getConnettore());
            }
        }
        if (fruitore.getConfigurazioneAzioneList() != null && fruitore.sizeConfigurazioneAzioneList() > 0) {
            for (int i = 0; i < fruitore.sizeConfigurazioneAzioneList(); ++i) {
                if (fruitore.getConfigurazioneAzione(i).getConnettore() == null) continue;
                fruitore.getConfigurazioneAzione(i).getConnettore().setNome(null);
                String tipoConnettore = fruitore.getConfigurazioneAzione(i).getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    fruitore.getConfigurazioneAzione(i).getConnettore().setCustom(true);
                }
                if (!TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) continue;
                XMLDataConverter.gestioneDefaultConnettoreHTTP(fruitore.getConfigurazioneAzione(i).getConnettore());
            }
        }
    }

    public static void impostaInformazioniRegistroDB_AccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) {
        int k;
        if (servizio.getConfigurazioneServizio() != null && servizio.getConfigurazioneServizio().getConnettore() != null) {
            servizio.getConfigurazioneServizio().getConnettore().setNome(null);
            String tipoConnettore = servizio.getConfigurazioneServizio().getConnettore().getTipo();
            if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                servizio.getConfigurazioneServizio().getConnettore().setCustom(true);
            }
            if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                XMLDataConverter.gestioneDefaultConnettoreHTTP(servizio.getConfigurazioneServizio().getConnettore());
            }
        }
        for (k = 0; k < servizio.sizeFruitoreList(); ++k) {
            if (servizio.getFruitore(k).getConnettore() == null) continue;
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteSpecifica_Fruitore(servizio.getFruitore(k));
        }
        if (servizio.getConfigurazioneServizio() != null) {
            for (k = 0; k < servizio.getConfigurazioneServizio().sizeConfigurazioneAzioneList(); ++k) {
                if (servizio.getConfigurazioneServizio().getConfigurazioneAzione(k).getConnettore() == null) continue;
                servizio.getConfigurazioneServizio().getConfigurazioneAzione(k).getConnettore().setNome(null);
                String tipoConnettore = servizio.getConfigurazioneServizio().getConfigurazioneAzione(k).getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizio.getConfigurazioneServizio().getConfigurazioneAzione(k).getConnettore().setCustom(true);
                }
                if (!TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) continue;
                XMLDataConverter.gestioneDefaultConnettoreHTTP(servizio.getConfigurazioneServizio().getConfigurazioneAzione(k).getConnettore());
            }
        }
    }

    public static void impostaInformazioniRegistro_AccordoServizioParteSpecifica_update(AccordoServizioParteSpecifica servizio, AccordoServizioParteSpecifica old, boolean mantieniFruitoriEsistenti) {
        if (old.getConfigurazioneServizio() != null && old.getConfigurazioneServizio().getConnettore() != null) {
            if (servizio.getConfigurazioneServizio() == null || servizio.getConfigurazioneServizio().getConnettore() == null) {
                if (servizio.getConfigurazioneServizio() == null) {
                    servizio.setConfigurazioneServizio(new ConfigurazioneServizio());
                }
                servizio.getConfigurazioneServizio().setConnettore(old.getConfigurazioneServizio().getConnettore());
            } else {
                servizio.getConfigurazioneServizio().getConnettore().setId(old.getConfigurazioneServizio().getConnettore().getId());
                servizio.getConfigurazioneServizio().getConnettore().setNome(old.getConfigurazioneServizio().getConnettore().getNome());
            }
        }
        if (mantieniFruitoriEsistenti) {
            XMLDataConverter.mantieniFruitori(old, servizio);
        }
        if (servizio.sizeFruitoreList() > 0) {
            for (int i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore fruitore = servizio.getFruitore(i);
                for (int j = 0; j < old.sizeFruitoreList(); ++j) {
                    Fruitore oldFruitore = old.getFruitore(j);
                    if (!oldFruitore.getTipo().equals(fruitore.getTipo()) || !oldFruitore.getNome().equals(fruitore.getNome())) continue;
                    if (fruitore.getConnettore() == null) {
                        fruitore.setConnettore(oldFruitore.getConnettore());
                        continue;
                    }
                    fruitore.getConnettore().setId(oldFruitore.getConnettore().getId());
                    fruitore.getConnettore().setNome(oldFruitore.getConnettore().getNome());
                }
            }
        }
    }

    private void gestioneServizio(AccordoServizioParteSpecifica servizio, Soggetto soggetto, boolean reset, boolean mantieniFruitoriEsistenti, StatiAccordo statoAccordo, boolean updateEnabled) throws Exception {
        Object name;
        String fileName;
        int k;
        servizio.setSuperUser(this.superUser);
        servizio.setTipoSoggettoErogatore(soggetto.getTipo());
        servizio.setNomeSoggettoErogatore(soggetto.getNome());
        if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteSpecifica(servizio);
        }
        this.initializeWSDLBytes(servizio);
        for (k = 0; k < servizio.sizeAllegatoList(); ++k) {
            fileName = servizio.getAllegato(k).getFile();
            name = this.getNomeFile(fileName);
            servizio.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getAllegato(k).setFile((String)name);
            servizio.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            servizio.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaSemiformaleList(); ++k) {
            fileName = servizio.getSpecificaSemiformale(k).getFile();
            name = this.getNomeFile(fileName);
            servizio.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaSemiformale(k).setFile((String)name);
            servizio.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            servizio.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaLivelloServizioList(); ++k) {
            fileName = servizio.getSpecificaLivelloServizio(k).getFile();
            name = this.getNomeFile(fileName);
            servizio.getSpecificaLivelloServizio(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaLivelloServizio(k).setFile((String)name);
            servizio.getSpecificaLivelloServizio(k).setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
            servizio.getSpecificaLivelloServizio(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaSicurezzaList(); ++k) {
            fileName = servizio.getSpecificaSicurezza(k).getFile();
            name = this.getNomeFile(fileName);
            servizio.getSpecificaSicurezza(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaSicurezza(k).setFile((String)name);
            servizio.getSpecificaSicurezza(k).setRuolo(RuoliDocumento.specificaSicurezza.toString());
            servizio.getSpecificaSicurezza(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        if (servizio.sizeProtocolPropertyList() > 0) {
            for (ProtocolProperty pp : servizio.getProtocolPropertyList()) {
                if (pp.getFile() == null) continue;
                pp.setByteFile(this.readDocumento(pp.getFile()));
            }
            if (servizio.sizeFruitoreList() > 0) {
                for (Fruitore fruitore : servizio.getFruitoreList()) {
                    if (fruitore.sizeProtocolPropertyList() <= 0) continue;
                    for (ProtocolProperty pp : fruitore.getProtocolPropertyList()) {
                        if (pp.getFile() == null) continue;
                        pp.setByteFile(this.readDocumento(pp.getFile()));
                    }
                }
            }
        }
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        IDServizio idServizio = this.idServizioFactory.getIDServizioFromValues(servizio.getTipo(), servizio.getNome(), idSoggetto, servizio.getVersione());
        String uri = this.idServizioFactory.getUriFromIDServizio(idServizio);
        if (!reset && this.gestoreCRUD.existsAccordoServizioParteSpecifica(idServizio)) {
            if (updateEnabled) {
                this.log.info("Servizio " + uri + " aggiornamento in corso...");
                AccordoServizioParteSpecifica old = ((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizioParteSpecifica(idServizio);
                XMLDataConverter.impostaInformazioniRegistro_AccordoServizioParteSpecifica_update(servizio, old, mantieniFruitoriEsistenti);
                if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                    XMLDataConverter.aggiornatoStatoFruitori(servizio, statoAccordo);
                }
                this.gestoreCRUD.updateAccordoServizioParteSpecifica(servizio);
                this.log.info("Servizio " + uri + " aggiornato.");
            } else {
                this.log.info("Servizio " + uri + " non aggiornato (aggiornamento disabilitato).");
            }
        } else {
            this.log.info("Servizio " + uri + " creazione in corso...");
            if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                XMLDataConverter.aggiornatoStatoFruitori(servizio, statoAccordo);
            }
            this.gestoreCRUD.createAccordoServizioParteSpecifica(servizio);
            this.log.info("Servizio " + uri + " creato.");
        }
    }
}

