/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class DriverRegistroServiziDB_soggettiSearchDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_soggettiSearchDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    protected List<String> soggettiRuoliList(long idSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiRuoliList";
        int idLista = Liste.SOGGETTI_RUOLI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("soggettiRuoliList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<String> listIdRuoli = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                sqlQueryObject.addWhereLikeCondition("ruoli.nome", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectField("ruoli.nome");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                sqlQueryObject.addWhereLikeCondition("ruoli.nome", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("ruoli.nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectField("ruoli.nome");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("ruoli.nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<String>();
            while (risultato.next()) {
                listIdRuoli.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return listIdRuoli;
    }

    protected List<Proprieta> soggettiProprietaList(long idSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiRuoliList";
        int idLista = Liste.SOGGETTI_PROP;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("soggettiRuoliList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<Proprieta> lista = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_properties.id_soggetto");
                sqlQueryObject.addWhereLikeCondition("soggetti_properties.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_properties.id_soggetto");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_properties");
                sqlQueryObject.addSelectField("soggetti_properties.id");
                sqlQueryObject.addSelectField("soggetti_properties.nome");
                sqlQueryObject.addSelectField("soggetti_properties.valore");
                sqlQueryObject.addSelectField("soggetti_properties.enc_value");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_properties.id_soggetto");
                sqlQueryObject.addWhereLikeCondition("soggetti_properties.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti_properties.nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_properties");
                sqlQueryObject.addSelectField("soggetti_properties.id");
                sqlQueryObject.addSelectField("soggetti_properties.nome");
                sqlQueryObject.addSelectField("soggetti_properties.valore");
                sqlQueryObject.addSelectField("soggetti_properties.enc_value");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_properties.id_soggetto");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti_properties.nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Proprieta>();
            while (risultato.next()) {
                Proprieta proprieta = new Proprieta();
                proprieta.setId(risultato.getLong("id"));
                proprieta.setNome(risultato.getString("nome"));
                proprieta.setValore(risultato.getString("valore"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    proprieta.setValore(encValue);
                } else {
                    proprieta.setValore(plainValue);
                }
                lista.add(proprieta);
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected List<Soggetto> soggettiRegistroListByTipo(String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soggettiRegistroList("", tipoSoggetto, ricerca);
    }

    protected List<Soggetto> soggettiRegistroList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soggettiRegistroList(superuser, null, ricerca);
    }

    private List<Soggetto> soggettiRegistroList(String superuser, String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Soggetto> arrayList;
        String nomeMetodo = "soggettiRegistroList";
        int idLista = Liste.SOGGETTI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        String filterDominio = SearchUtils.getFilter(ricerca, idLista, "filtroDominio");
        PddTipologia pddTipologia = null;
        if (filterDominio != null && !"".equals(filterDominio)) {
            pddTipologia = PddTipologia.toPddTipologia(filterDominio);
        }
        String filterSoggettoDefaultTmp = SearchUtils.getFilter(ricerca, idLista, "filtroSoggettoDefault");
        boolean filterSoggettoDefault = false;
        if (filterSoggettoDefaultTmp != null) {
            filterSoggettoDefault = "true".equalsIgnoreCase(filterSoggettoDefaultTmp.trim());
        }
        String filterTipoCredenziali = SearchUtils.getFilter(ricerca, idLista, "filtroTipoCredenziali");
        String filterCredenziale = SearchUtils.getFilter(ricerca, idLista, "filtroCredenziale");
        String filterCredenzialeIssuer = SearchUtils.getFilter(ricerca, idLista, "filtroCredenzialeIssuer");
        if (filterCredenzialeIssuer != null && "".equals(filterCredenzialeIssuer)) {
            filterCredenzialeIssuer = null;
        }
        if (filterCredenzialeIssuer != null && !"ssl".equals(filterTipoCredenziali)) {
            filterCredenzialeIssuer = null;
        }
        String filterRuolo = SearchUtils.getFilter(ricerca, idLista, "filtroRuolo");
        boolean isFilterTipologiaErogatore = true;
        boolean isFilterTipologiaFruitore = true;
        String filterTipologia = SearchUtils.getFilter(ricerca, idLista, "filtroTipoSoggetto");
        if (filterTipologia != null && !"".equals(filterTipologia)) {
            if ("Erogatore".equals(filterTipologia)) {
                isFilterTipologiaFruitore = false;
            } else if ("Fruitore".equals(filterTipologia)) {
                isFilterTipologiaErogatore = false;
            }
        }
        boolean isFilterGruppoErogazione = false;
        boolean isFilterGruppoFruizione = false;
        String filterGruppo = SearchUtils.getFilter(ricerca, idLista, "filtroGruppo");
        if (filterGruppo != null && !"".equals(filterGruppo)) {
            isFilterGruppoErogazione = true;
            isFilterGruppoFruizione = true;
        }
        TipoPdD apiContesto = null;
        String filterApiContesto = SearchUtils.getFilter(ricerca, idLista, "filtroApiContesto");
        if (filterApiContesto != null && !"".equals(filterApiContesto)) {
            apiContesto = TipoPdD.toTipoPdD(filterApiContesto);
            if (TipoPdD.APPLICATIVA.equals(apiContesto)) {
                isFilterGruppoFruizione = false;
            } else if (TipoPdD.DELEGATA.equals(apiContesto)) {
                isFilterGruppoErogazione = false;
            } else {
                apiContesto = null;
            }
        }
        String filterApiImplementazione = SearchUtils.getFilter(ricerca, idLista, "filtroApiImpl");
        IDServizio apiImplementazioneErogazione = null;
        IDFruizione apiImplementazioneFruizione = null;
        if (filterApiImplementazione != null && !"".equals(filterApiImplementazione)) {
            if (TipoPdD.APPLICATIVA.equals(apiContesto)) {
                try {
                    apiImplementazioneErogazione = IDServizio.toIDServizio(filterApiImplementazione);
                    isFilterGruppoErogazione = false;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Filtro API Implementazione '" + filterApiImplementazione + "' non valido: " + e.getMessage(), e);
                }
            }
            if (TipoPdD.DELEGATA.equals(apiContesto)) {
                try {
                    apiImplementazioneFruizione = IDFruizione.toIDFruizione(filterApiImplementazione);
                    isFilterGruppoFruizione = false;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Filtro API Implementazione '" + filterApiImplementazione + "' non valido: " + e.getMessage(), e);
                }
            }
        }
        String filtroProprietaNome = SearchUtils.getFilter(ricerca, idLista, "filtroPropNome");
        String filtroProprietaValore = SearchUtils.getFilter(ricerca, idLista, "filtroPropValore");
        if (filtroProprietaNome != null && "".equals(filtroProprietaNome)) {
            filtroProprietaNome = null;
        }
        if (filtroProprietaValore != null && "".equals(filtroProprietaValore)) {
            filtroProprietaValore = null;
        }
        boolean filtroProprieta = filtroProprietaNome != null || filtroProprietaValore != null;
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filterDominio : " + filterDominio);
        this.driver.logDebug("filterSoggettoDefault : " + filterSoggettoDefault);
        this.driver.logDebug("filterRuolo : " + filterRuolo);
        this.driver.logDebug("filterTipoCredenziali : " + filterTipoCredenziali);
        this.driver.logDebug("filterCredenziale : " + filterCredenziale);
        this.driver.logDebug("filterCredenzialeIssuer : " + filterCredenzialeIssuer);
        this.driver.logDebug("filterTipologiaSoggetto : " + filterTipologia);
        this.driver.logDebug("filterGruppo : " + filterGruppo);
        this.driver.logDebug("filterApiContesto : " + filterApiContesto);
        this.driver.logDebug("filterApiImplementazione : " + filterApiImplementazione);
        this.driver.logDebug("filtroProprietaNome : " + filtroProprietaNome);
        this.driver.logDebug("filtroProprietaValore : " + filtroProprietaValore);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("soggettiRegistroList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObjectPdd = null;
            if (pddTipologia != null && PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                ISQLQueryObject sqlQueryObjectExistsPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExistsPdd.addSelectField("pdd.nome");
                sqlQueryObjectExistsPdd.addFromTable("pdd");
                sqlQueryObjectExistsPdd.setANDLogicOperator(true);
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.nome=soggetti.server");
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.tipo=?");
                sqlQueryObjectPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectPdd.setANDLogicOperator(false);
                sqlQueryObjectPdd.addWhereIsNullCondition("soggetti.server");
                sqlQueryObjectPdd.addWhereExistsCondition(false, sqlQueryObjectExistsPdd);
            }
            ArrayList<String> existsConditions = new ArrayList<String>();
            ArrayList<Object> existsParameters = new ArrayList<Object>();
            String alias_CT = "ct";
            String alias_ALLARMI = "alarm";
            String alias_PD = "pd";
            String alias_PA_SOGGETTI = "pasog";
            String alias_PA = "pa";
            String alias_PA_TRASFORMAZIONI_SOGGETTI = "patsog";
            String alias_PA_TRASFORMAZIONI = "pat";
            String alias_SERVIZI = "s";
            String alias_ACCORDI = "a";
            String alias_ACCORDI_GRUPPI = "ag";
            String alias_GRUPPI = "g";
            String alias_SOGGETTI = "sProprietario";
            if (isFilterTipologiaErogatore) {
                if (apiContesto == null) {
                    if (!isFilterTipologiaFruitore || isFilterGruppoFruizione || isFilterGruppoErogazione) {
                        ISQLQueryObject sqlQueryObjectErogatore = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                        sqlQueryObjectErogatore.addFromTable("servizi", alias_SERVIZI);
                        if (isFilterGruppoFruizione) {
                            sqlQueryObjectErogatore.addFromTable("accordi", alias_ACCORDI);
                            sqlQueryObjectErogatore.addFromTable("accordi_gruppi", alias_ACCORDI_GRUPPI);
                            sqlQueryObjectErogatore.addFromTable("gruppi", alias_GRUPPI);
                        }
                        sqlQueryObjectErogatore.addSelectAliasField(alias_SERVIZI, "id", alias_SERVIZI + "id");
                        sqlQueryObjectErogatore.setANDLogicOperator(true);
                        sqlQueryObjectErogatore.addWhereCondition(alias_SERVIZI + ".id_soggetto = soggetti.id");
                        if (isFilterGruppoFruizione) {
                            sqlQueryObjectErogatore.addWhereCondition(alias_SERVIZI + ".id_accordo = " + alias_ACCORDI + ".id");
                            sqlQueryObjectErogatore.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_accordo = " + alias_ACCORDI + ".id");
                            sqlQueryObjectErogatore.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_gruppo = " + alias_GRUPPI + ".id");
                            sqlQueryObjectErogatore.addWhereCondition(alias_GRUPPI + ".nome = ?");
                            existsParameters.add(filterGruppo);
                        }
                        existsConditions.add(sqlQueryObjectErogatore.getWhereExistsCondition(false, sqlQueryObjectErogatore));
                    }
                } else if (TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                    ISQLQueryObject sqlQueryObjectErogatorePorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectErogatorePorteDelegate.addFromTable("servizi", alias_SERVIZI);
                    if (isFilterGruppoFruizione) {
                        sqlQueryObjectErogatorePorteDelegate.addFromTable("accordi", alias_ACCORDI);
                        sqlQueryObjectErogatorePorteDelegate.addFromTable("accordi_gruppi", alias_ACCORDI_GRUPPI);
                        sqlQueryObjectErogatorePorteDelegate.addFromTable("gruppi", alias_GRUPPI);
                    }
                    if (TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                        sqlQueryObjectErogatorePorteDelegate.addFromTable("porte_delegate", alias_PD);
                        if (apiImplementazioneFruizione != null) {
                            sqlQueryObjectErogatorePorteDelegate.addFromTable("soggetti", alias_SOGGETTI);
                        }
                    }
                    sqlQueryObjectErogatorePorteDelegate.addSelectAliasField(alias_SERVIZI, "id", alias_SERVIZI + "id");
                    sqlQueryObjectErogatorePorteDelegate.setANDLogicOperator(true);
                    sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_SERVIZI + ".id_soggetto = soggetti.id");
                    if (isFilterGruppoFruizione) {
                        sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_SERVIZI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_gruppo = " + alias_GRUPPI + ".id");
                        sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_GRUPPI + ".nome = ?");
                        existsParameters.add(filterGruppo);
                    }
                    if (TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                        sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_PD + ".id_servizio = " + alias_SERVIZI + ".id");
                        if (apiImplementazioneFruizione != null) {
                            sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_PD + ".id_soggetto = " + alias_SOGGETTI + ".id");
                            sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_SOGGETTI + ".tipo_soggetto = ?");
                            sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_SOGGETTI + ".nome_soggetto = ?");
                            sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_PD + ".tipo_soggetto_erogatore = ?");
                            sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_PD + ".nome_soggetto_erogatore = ?");
                            sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_PD + ".tipo_servizio = ?");
                            sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_PD + ".nome_servizio = ?");
                            sqlQueryObjectErogatorePorteDelegate.addWhereCondition(alias_PD + ".versione_servizio = ?");
                            existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                            existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
                        }
                    }
                    existsConditions.add(sqlQueryObjectErogatorePorteDelegate.getWhereExistsCondition(false, sqlQueryObjectErogatorePorteDelegate));
                } else if (TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                    ISQLQueryObject sqlQueryObjectErogatorePorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectErogatorePorteApplicative.addFromTable("servizi", alias_SERVIZI);
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectErogatorePorteApplicative.addFromTable("accordi", alias_ACCORDI);
                        sqlQueryObjectErogatorePorteApplicative.addFromTable("accordi_gruppi", alias_ACCORDI_GRUPPI);
                        sqlQueryObjectErogatorePorteApplicative.addFromTable("gruppi", alias_GRUPPI);
                    }
                    if (TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                        sqlQueryObjectErogatorePorteApplicative.addFromTable("porte_applicative", alias_PA);
                    }
                    sqlQueryObjectErogatorePorteApplicative.addSelectAliasField(alias_SERVIZI, "id", alias_SERVIZI + "id");
                    sqlQueryObjectErogatorePorteApplicative.setANDLogicOperator(true);
                    sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_SERVIZI + ".id_soggetto = soggetti.id");
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_SERVIZI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_gruppo = " + alias_GRUPPI + ".id");
                        sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_GRUPPI + ".nome = ?");
                        existsParameters.add(filterGruppo);
                    }
                    if (TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                        sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_PA + ".id_servizio = " + alias_SERVIZI + ".id");
                        if (apiImplementazioneErogazione != null) {
                            sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_PA + ".id_soggetto = soggetti.id");
                            sqlQueryObjectErogatorePorteApplicative.addWhereCondition("soggetti.tipo_soggetto = ?");
                            sqlQueryObjectErogatorePorteApplicative.addWhereCondition("soggetti.nome_soggetto = ?");
                            sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_PA + ".tipo_servizio = ?");
                            sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_PA + ".servizio = ?");
                            sqlQueryObjectErogatorePorteApplicative.addWhereCondition(alias_PA + ".versione_servizio = ?");
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                            existsParameters.add(apiImplementazioneErogazione.getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getNome());
                            existsParameters.add(apiImplementazioneErogazione.getVersione());
                        }
                    }
                    existsConditions.add(sqlQueryObjectErogatorePorteApplicative.getWhereExistsCondition(false, sqlQueryObjectErogatorePorteApplicative));
                }
            }
            if (isFilterTipologiaFruitore) {
                if (!isFilterTipologiaErogatore && apiContesto == null || isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                    ISQLQueryObject sqlQueryObjectProprietrioPorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectProprietrioPorteDelegate.addFromTable("porte_delegate", alias_PD);
                    if (isFilterGruppoFruizione) {
                        sqlQueryObjectProprietrioPorteDelegate.addFromTable("servizi", alias_SERVIZI);
                        sqlQueryObjectProprietrioPorteDelegate.addFromTable("accordi", alias_ACCORDI);
                        sqlQueryObjectProprietrioPorteDelegate.addFromTable("accordi_gruppi", alias_ACCORDI_GRUPPI);
                        sqlQueryObjectProprietrioPorteDelegate.addFromTable("gruppi", alias_GRUPPI);
                    }
                    if (apiImplementazioneFruizione != null) {
                        sqlQueryObjectProprietrioPorteDelegate.addFromTable("soggetti", alias_SOGGETTI);
                    }
                    sqlQueryObjectProprietrioPorteDelegate.addSelectAliasField(alias_PD, "id", alias_PD + "id");
                    sqlQueryObjectProprietrioPorteDelegate.setANDLogicOperator(true);
                    sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_PD + ".id_soggetto = soggetti.id");
                    if (isFilterGruppoFruizione) {
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_PD + ".id_servizio = " + alias_SERVIZI + ".id");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_SERVIZI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_gruppo = " + alias_GRUPPI + ".id");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_GRUPPI + ".nome = ?");
                        existsParameters.add(filterGruppo);
                    }
                    if (apiImplementazioneFruizione != null) {
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition("soggetti.tipo_soggetto = ?");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition("soggetti.nome_soggetto = ?");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_PD + ".tipo_soggetto_erogatore = ?");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_PD + ".nome_soggetto_erogatore = ?");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_PD + ".tipo_servizio = ?");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_PD + ".nome_servizio = ?");
                        sqlQueryObjectProprietrioPorteDelegate.addWhereCondition(alias_PD + ".versione_servizio = ?");
                        existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                        existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
                    }
                    existsConditions.add(sqlQueryObjectProprietrioPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectProprietrioPorteDelegate));
                }
                if (!isFilterTipologiaErogatore && apiContesto == null || isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                    ISQLQueryObject sqlQueryObjectAutorizzazioniPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("pa_soggetti", alias_PA_SOGGETTI);
                    sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("porte_applicative", alias_PA);
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("servizi", alias_SERVIZI);
                        sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("accordi", alias_ACCORDI);
                        sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("accordi_gruppi", alias_ACCORDI_GRUPPI);
                        sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("gruppi", alias_GRUPPI);
                    }
                    if (apiImplementazioneErogazione != null) {
                        sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("soggetti", alias_SOGGETTI);
                    }
                    sqlQueryObjectAutorizzazioniPorteApplicative.addSelectAliasField(alias_PA_SOGGETTI, "id", alias_PA_SOGGETTI + "id");
                    sqlQueryObjectAutorizzazioniPorteApplicative.setANDLogicOperator(true);
                    sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_PA_SOGGETTI + ".tipo_soggetto = soggetti.tipo_soggetto");
                    sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_PA_SOGGETTI + ".nome_soggetto = soggetti.nome_soggetto");
                    sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_PA_SOGGETTI + ".id_porta = " + alias_PA + ".id");
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_PA + ".id_servizio = " + alias_SERVIZI + ".id");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_SERVIZI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_gruppo = " + alias_GRUPPI + ".id");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_GRUPPI + ".nome = ?");
                        existsParameters.add(filterGruppo);
                    }
                    if (apiImplementazioneErogazione != null) {
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_PA + ".id_soggetto = " + alias_SOGGETTI + ".id");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_SOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_SOGGETTI + ".nome_soggetto = ?");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_PA + ".tipo_servizio = ?");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_PA + ".servizio = ?");
                        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(alias_PA + ".versione_servizio = ?");
                        existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                        existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                        existsParameters.add(apiImplementazioneErogazione.getTipo());
                        existsParameters.add(apiImplementazioneErogazione.getNome());
                        existsParameters.add(apiImplementazioneErogazione.getVersione());
                    }
                    existsConditions.add(sqlQueryObjectAutorizzazioniPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteApplicative));
                }
                if (!isFilterTipologiaErogatore && apiContesto == null || isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                    ISQLQueryObject sqlQueryObjectControlloTrafficoPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("ct_active_policy", alias_CT);
                    if (isFilterGruppoErogazione || apiImplementazioneErogazione != null) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("porte_applicative", alias_PA);
                        if (isFilterGruppoErogazione) {
                            sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("servizi", alias_SERVIZI);
                            sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("accordi", alias_ACCORDI);
                            sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("accordi_gruppi", alias_ACCORDI_GRUPPI);
                            sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("gruppi", alias_GRUPPI);
                        }
                        if (apiImplementazioneErogazione != null) {
                            sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("soggetti", alias_SOGGETTI);
                        }
                    }
                    sqlQueryObjectControlloTrafficoPorteApplicative.addSelectAliasField(alias_CT, "id", alias_CT + "id");
                    sqlQueryObjectControlloTrafficoPorteApplicative.setANDLogicOperator(true);
                    sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_CT + ".filtro_tipo_fruitore = soggetti.tipo_soggetto");
                    sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_CT + ".filtro_nome_fruitore = soggetti.nome_soggetto");
                    sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_CT + ".filtro_ruolo = 'applicativa'");
                    if (isFilterGruppoErogazione || apiImplementazioneErogazione != null) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_CT + ".filtro_porta = " + alias_PA + ".nome_porta");
                        if (isFilterGruppoErogazione) {
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_PA + ".id_servizio = " + alias_SERVIZI + ".id");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_SERVIZI + ".id_accordo = " + alias_ACCORDI + ".id");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_accordo = " + alias_ACCORDI + ".id");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_gruppo = " + alias_GRUPPI + ".id");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_GRUPPI + ".nome = ?");
                            existsParameters.add(filterGruppo);
                        }
                        if (apiImplementazioneErogazione != null) {
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_PA + ".id_soggetto = " + alias_SOGGETTI + ".id");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_SOGGETTI + ".tipo_soggetto = ?");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_SOGGETTI + ".nome_soggetto = ?");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_PA + ".tipo_servizio = ?");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_PA + ".servizio = ?");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(alias_PA + ".versione_servizio = ?");
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                            existsParameters.add(apiImplementazioneErogazione.getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getNome());
                            existsParameters.add(apiImplementazioneErogazione.getVersione());
                        }
                    }
                    existsConditions.add(sqlQueryObjectControlloTrafficoPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectControlloTrafficoPorteApplicative));
                }
                if (CostantiDB.isAllarmiEnabled() && (!isFilterTipologiaErogatore && apiContesto == null || isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null)) {
                    ISQLQueryObject sqlQueryObjectPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectPorteApplicative.addFromTable("allarmi", alias_ALLARMI);
                    if (isFilterGruppoErogazione || apiImplementazioneErogazione != null) {
                        sqlQueryObjectPorteApplicative.addFromTable("porte_applicative", alias_PA);
                        if (isFilterGruppoErogazione) {
                            sqlQueryObjectPorteApplicative.addFromTable("servizi", alias_SERVIZI);
                            sqlQueryObjectPorteApplicative.addFromTable("accordi", alias_ACCORDI);
                            sqlQueryObjectPorteApplicative.addFromTable("accordi_gruppi", alias_ACCORDI_GRUPPI);
                            sqlQueryObjectPorteApplicative.addFromTable("gruppi", alias_GRUPPI);
                        }
                        if (apiImplementazioneErogazione != null) {
                            sqlQueryObjectPorteApplicative.addFromTable("soggetti", alias_SOGGETTI);
                        }
                    }
                    sqlQueryObjectPorteApplicative.addSelectAliasField(alias_ALLARMI, "id", alias_ALLARMI + "id");
                    sqlQueryObjectPorteApplicative.setANDLogicOperator(true);
                    sqlQueryObjectPorteApplicative.addWhereCondition(alias_ALLARMI + ".filtro_tipo_fruitore = soggetti.tipo_soggetto");
                    sqlQueryObjectPorteApplicative.addWhereCondition(alias_ALLARMI + ".filtro_nome_fruitore = soggetti.nome_soggetto");
                    sqlQueryObjectPorteApplicative.addWhereCondition(alias_ALLARMI + ".filtro_ruolo = 'applicativa'");
                    if (isFilterGruppoErogazione || apiImplementazioneErogazione != null) {
                        sqlQueryObjectPorteApplicative.addWhereCondition(alias_ALLARMI + ".filtro_porta = " + alias_PA + ".nome_porta");
                        if (isFilterGruppoErogazione) {
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_PA + ".id_servizio = " + alias_SERVIZI + ".id");
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_SERVIZI + ".id_accordo = " + alias_ACCORDI + ".id");
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_accordo = " + alias_ACCORDI + ".id");
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_gruppo = " + alias_GRUPPI + ".id");
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_GRUPPI + ".nome = ?");
                            existsParameters.add(filterGruppo);
                        }
                        if (apiImplementazioneErogazione != null) {
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_PA + ".id_soggetto = " + alias_SOGGETTI + ".id");
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_SOGGETTI + ".tipo_soggetto = ?");
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_SOGGETTI + ".nome_soggetto = ?");
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_PA + ".tipo_servizio = ?");
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_PA + ".servizio = ?");
                            sqlQueryObjectPorteApplicative.addWhereCondition(alias_PA + ".versione_servizio = ?");
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                            existsParameters.add(apiImplementazioneErogazione.getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getNome());
                            existsParameters.add(apiImplementazioneErogazione.getVersione());
                        }
                    }
                    existsConditions.add(sqlQueryObjectPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectPorteApplicative));
                }
                if (!isFilterTipologiaErogatore && apiContesto == null || isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                    ISQLQueryObject sqlQueryObjectTrasformazioniPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("pa_transform_soggetti", alias_PA_TRASFORMAZIONI_SOGGETTI);
                    sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("pa_transform", alias_PA_TRASFORMAZIONI);
                    sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("porte_applicative", alias_PA);
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("servizi", alias_SERVIZI);
                        sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("accordi", alias_ACCORDI);
                        sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("accordi_gruppi", alias_ACCORDI_GRUPPI);
                        sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("gruppi", alias_GRUPPI);
                    }
                    if (apiImplementazioneErogazione != null) {
                        sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("soggetti", alias_SOGGETTI);
                    }
                    sqlQueryObjectTrasformazioniPorteApplicative.addSelectAliasField(alias_PA_TRASFORMAZIONI_SOGGETTI, "id", alias_PA_TRASFORMAZIONI_SOGGETTI + "id");
                    sqlQueryObjectTrasformazioniPorteApplicative.setANDLogicOperator(true);
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_PA_TRASFORMAZIONI_SOGGETTI + ".tipo_soggetto = soggetti.tipo_soggetto");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_PA_TRASFORMAZIONI_SOGGETTI + ".nome_soggetto = soggetti.nome_soggetto");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_PA_TRASFORMAZIONI_SOGGETTI + ".id_trasformazione = " + alias_PA_TRASFORMAZIONI + ".id");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_PA_TRASFORMAZIONI + ".id_porta = " + alias_PA + ".id");
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_PA + ".id_servizio = " + alias_SERVIZI + ".id");
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_SERVIZI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_accordo = " + alias_ACCORDI + ".id");
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_ACCORDI_GRUPPI + ".id_gruppo = " + alias_GRUPPI + ".id");
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_GRUPPI + ".nome = ?");
                        existsParameters.add(filterGruppo);
                    }
                    if (apiImplementazioneErogazione != null) {
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_PA + ".id_soggetto = " + alias_SOGGETTI + ".id");
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_SOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_SOGGETTI + ".nome_soggetto = ?");
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_PA + ".tipo_servizio = ?");
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_PA + ".servizio = ?");
                        sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(alias_PA + ".versione_servizio = ?");
                        existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                        existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                        existsParameters.add(apiImplementazioneErogazione.getTipo());
                        existsParameters.add(apiImplementazioneErogazione.getNome());
                        existsParameters.add(apiImplementazioneErogazione.getVersione());
                    }
                    existsConditions.add(sqlQueryObjectTrasformazioniPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectTrasformazioniPorteApplicative));
                }
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (filterSoggettoDefault) {
                    sqlQueryObject.addWhereCondition("is_default = ?");
                }
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
                } else {
                    sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true)});
                }
                if (tipoSoggetto == null && tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject.addFromTable("pdd");
                        sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (filterRuolo != null && !"".equals(filterRuolo)) {
                    sqlQueryObject.addFromTable("soggetti_ruoli");
                    sqlQueryObject.addFromTable("ruoli");
                    sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                    sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                    sqlQueryObject.addWhereCondition("ruoli.nome=?");
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    sqlQueryObject.addWhereCondition("soggetti.tipoauth = ?");
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("soggetti.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereLikeCondition("soggetti.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("soggetti.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaSoggetto(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (filterSoggettoDefault) {
                    sqlQueryObject.addWhereCondition("is_default = ?");
                }
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                }
                if (tipoSoggetto == null && tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject.addFromTable("pdd");
                        sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (filterRuolo != null && !"".equals(filterRuolo)) {
                    sqlQueryObject.addFromTable("soggetti_ruoli");
                    sqlQueryObject.addFromTable("ruoli");
                    sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                    sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                    sqlQueryObject.addWhereCondition("ruoli.nome=?");
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    sqlQueryObject.addWhereCondition("soggetti.tipoauth = ?");
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("soggetti.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereLikeCondition("soggetti.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("soggetti.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaSoggetto(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (filterSoggettoDefault) {
                stmt.setInt(index++, 1);
            }
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (!search.equals("")) {
                if (tipoSoggetto != null) {
                    stmt.setString(index++, tipoSoggetto);
                }
            } else if (tipoSoggetto != null) {
                stmt.setString(index++, tipoSoggetto);
            }
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            if (filterRuolo != null && !"".equals(filterRuolo)) {
                stmt.setString(index++, filterRuolo);
            }
            if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                stmt.setString(index++, filterTipoCredenziali);
            }
            if (existsParameters != null && !existsParameters.isEmpty()) {
                for (Object e : existsParameters) {
                    if (e instanceof String) {
                        stmt.setString(index++, (String)e);
                        continue;
                    }
                    stmt.setInt(index++, (Integer)e);
                }
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("soggetti", "id", "identificativoSoggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectAliasField("soggetti", "descrizione", "descrizioneSoggetto");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id_connettore");
                sqlQueryObject.addSelectField("codice_ipa");
                sqlQueryObject.addSelectField("tipoauth");
                if (filterSoggettoDefault) {
                    sqlQueryObject.addWhereCondition("is_default = ?");
                }
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
                } else {
                    sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true)});
                }
                if (tipoSoggetto == null && tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject.addFromTable("pdd");
                        sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (filterRuolo != null && !"".equals(filterRuolo)) {
                    sqlQueryObject.addFromTable("soggetti_ruoli");
                    sqlQueryObject.addFromTable("ruoli");
                    sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                    sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                    sqlQueryObject.addWhereCondition("ruoli.nome=?");
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    sqlQueryObject.addWhereCondition("soggetti.tipoauth = ?");
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("soggetti.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereLikeCondition("soggetti.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("soggetti.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaSoggetto((ISQLQueryObject)sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("soggetti", "id", "identificativoSoggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectAliasField("soggetti", "descrizione", "descrizioneSoggetto");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id_connettore");
                sqlQueryObject.addSelectField("codice_ipa");
                sqlQueryObject.addSelectField("tipoauth");
                if (filterSoggettoDefault) {
                    sqlQueryObject.addWhereCondition("is_default = ?");
                }
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                }
                if (tipoSoggetto == null && tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject.addFromTable("pdd");
                        sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (filterRuolo != null && !"".equals(filterRuolo)) {
                    sqlQueryObject.addFromTable("soggetti_ruoli");
                    sqlQueryObject.addFromTable("ruoli");
                    sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                    sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                    sqlQueryObject.addWhereCondition("ruoli.nome=?");
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    sqlQueryObject.addWhereCondition("soggetti.tipoauth = ?");
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("soggetti.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereLikeCondition("soggetti.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("soggetti.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaSoggetto((ISQLQueryObject)sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (filterSoggettoDefault) {
                stmt.setInt(index++, 1);
            }
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (!search.equals("")) {
                if (tipoSoggetto != null) {
                    stmt.setString(index++, tipoSoggetto);
                }
            } else if (tipoSoggetto != null) {
                stmt.setString(index++, tipoSoggetto);
            }
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            if (filterRuolo != null && !"".equals(filterRuolo)) {
                stmt.setString(index++, filterRuolo);
            }
            if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                stmt.setString(index++, filterTipoCredenziali);
            }
            if (existsParameters != null && !existsParameters.isEmpty()) {
                for (Object arrayList2 : existsParameters) {
                    if (arrayList2 instanceof String) {
                        stmt.setString(index++, (String)arrayList2);
                        continue;
                    }
                    stmt.setInt(index++, (Integer)arrayList2);
                }
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto sog = new Soggetto();
                sog.setId(risultato.getLong("identificativoSoggetto"));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                sog.setDescrizione(risultato.getString("descrizioneSoggetto"));
                sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                sog.setPortaDominio(risultato.getString("server"));
                sog.setCodiceIpa(risultato.getString("codice_ipa"));
                long l = risultato.getLong("id_connettore");
                sog.setConnettore(this.driver.getConnettore(l, con));
                String tipoAuth = risultato.getString("tipoauth");
                if (tipoAuth != null && !tipoAuth.equals("")) {
                    CredenzialiSoggetto credenziali = new CredenzialiSoggetto();
                    credenziali.setTipo(DriverRegistroServiziDB_LIB.getEnumCredenzialeTipo(tipoAuth));
                    sog.addCredenziali(credenziali);
                }
                lista.add(sog);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<IDSoggetto> idSoggettiRegistroListByTipo(String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        return this.idSoggettiRegistroList("", tipoSoggetto, ricerca);
    }

    protected List<IDSoggetto> idSoggettiRegistroList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.idSoggettiRegistroList(superuser, null, ricerca);
    }

    private List<IDSoggetto> idSoggettiRegistroList(String superuser, String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<IDSoggetto> arrayList;
        String nomeMetodo = "idSoggettiRegistroList";
        int idLista = Liste.SOGGETTI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        String filterDominio = SearchUtils.getFilter(ricerca, idLista, "filtroDominio");
        PddTipologia pddTipologia = null;
        if (filterDominio != null && !"".equals(filterDominio)) {
            pddTipologia = PddTipologia.toPddTipologia(filterDominio);
        }
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDSoggetto> lista = new ArrayList<IDSoggetto>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObjectPdd = null;
            if (pddTipologia != null && PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                ISQLQueryObject sqlQueryObjectExistsPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExistsPdd.addSelectField("pdd.nome");
                sqlQueryObjectExistsPdd.addFromTable("pdd");
                sqlQueryObjectExistsPdd.setANDLogicOperator(true);
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.nome=soggetti.server");
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.tipo=?");
                sqlQueryObjectPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectPdd.setANDLogicOperator(false);
                sqlQueryObjectPdd.addWhereIsNullCondition("soggetti.server");
                sqlQueryObjectPdd.addWhereExistsCondition(false, sqlQueryObjectExistsPdd);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectCountField("*", "cont");
            this.impostaFiltriRicercaSqlQueryObjectIdSoggettiList(superuser, tipoSoggetto, search, tipoSoggettiProtocollo, sqlQueryObject, pddTipologia, sqlQueryObjectPdd);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            this.setParametersIdSoggettiList(superuser, tipoSoggetto, search, pddTipologia, stmt);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            this.impostaFiltriRicercaSqlQueryObjectIdSoggettiList(superuser, tipoSoggetto, search, tipoSoggettiProtocollo, sqlQueryObject, pddTipologia, sqlQueryObjectPdd);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            this.setParametersIdSoggettiList(superuser, tipoSoggetto, search, pddTipologia, stmt);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                IDSoggetto sog = new IDSoggetto();
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(sog);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    private void setParametersIdSoggettiList(String superuser, String tipoSoggetto, String search, PddTipologia pddTipologia, PreparedStatement stmt) throws SQLException {
        int index = 1;
        if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
            stmt.setString(index++, superuser);
        }
        if (pddTipologia != null && !PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
            stmt.setString(index++, pddTipologia.toString());
        }
        if (!search.equals("")) {
            if (tipoSoggetto != null) {
                stmt.setString(index, tipoSoggetto);
            }
        } else if (tipoSoggetto != null) {
            stmt.setString(index, tipoSoggetto);
        }
    }

    private void impostaFiltriRicercaSqlQueryObjectIdSoggettiList(String superuser, String tipoSoggetto, String search, List<String> tipoSoggettiProtocollo, ISQLQueryObject sqlQueryObject, PddTipologia pddTipologia, ISQLQueryObject sqlQueryObjectPdd) throws SQLQueryObjectException {
        if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
            sqlQueryObject.addWhereCondition("superuser = ?");
        }
        if (tipoSoggetto == null && tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
            sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
        }
        if (pddTipologia != null) {
            if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
            } else {
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
            }
        }
        if (!search.equals("")) {
            if (tipoSoggetto != null) {
                sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
            } else {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true)});
            }
        } else if (tipoSoggetto != null) {
            sqlQueryObject.addWhereCondition("tipo_soggetto=?");
        }
    }
}

