/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_connettoriLIB {
    public static long CRUDConnettore(int type, Connettore connettore, Connection connection, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        PreparedStatement stm = null;
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] L'oggetto Connettore non puo essere NULL.");
        }
        if (type != 3 && (connettore.getNome() == null || connettore.getNome().trim().equals(""))) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] il nome connettore non puo essere NULL.");
        }
        String nomeConnettore = null;
        String endpointtype = null;
        boolean debug = false;
        String url = null;
        String nome = null;
        String tipo = null;
        String utente = null;
        String password = null;
        String initcont = null;
        String urlpkg = null;
        String provurl = null;
        String connectionfactory = null;
        String sendas = null;
        String transferMode = null;
        Integer transferModeChunkSize = null;
        boolean proxy = false;
        String proxyType = null;
        String proxyHostname = null;
        String proxyPort = null;
        String proxyUsername = null;
        String proxyPassword = null;
        Integer tempiRispostaConnectionTimeout = null;
        Integer tempiRispostaReadTimeout = null;
        Integer tempiRispostaAvgResponseTime = null;
        String redirectMode = null;
        Integer redirectMaxHop = null;
        String httpImpl = null;
        String tokenPolicy = null;
        String apiKey = null;
        String apiKeyHeader = null;
        String appId = null;
        String appIdHeader = null;
        String nomeProperty = null;
        String valoreProperty = null;
        boolean isAbilitato = false;
        nomeConnettore = connettore.getNome();
        endpointtype = connettore.getTipo();
        if (endpointtype == null || endpointtype.trim().equals("")) {
            endpointtype = TipiConnettore.DISABILITATO.getNome();
        }
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<String> propertiesGestiteAttraversoColonneAdHoc = new ArrayList<String>();
        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
            nomeProperty = connettore.getProperty(i).getNome();
            valoreProperty = connettore.getProperty(i).getValore();
            if (valoreProperty != null && valoreProperty.equals("")) {
                valoreProperty = null;
            }
            if (nomeProperty.equals("debug") && "true".equals(valoreProperty)) {
                debug = true;
            }
            if (nomeProperty.equals("proxyType")) {
                proxy = true;
                proxyType = valoreProperty;
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                for (Property propertyCheck : connettore.getPropertyList()) {
                    if (propertyCheck.getNome().equals("proxyHostname")) {
                        propertiesGestiteAttraversoColonneAdHoc.add(propertyCheck.getNome());
                        proxyHostname = propertyCheck.getValore();
                    }
                    if (propertyCheck.getNome().equals("proxyPort")) {
                        propertiesGestiteAttraversoColonneAdHoc.add(propertyCheck.getNome());
                        proxyPort = propertyCheck.getValore();
                    }
                    if (propertyCheck.getNome().equals("proxyUsername")) {
                        propertiesGestiteAttraversoColonneAdHoc.add(propertyCheck.getNome());
                        proxyUsername = propertyCheck.getValore();
                    }
                    if (!propertyCheck.getNome().equals("proxyPassword")) continue;
                    propertiesGestiteAttraversoColonneAdHoc.add(propertyCheck.getNome());
                    proxyPassword = propertyCheck.getValore();
                }
            }
            if (nomeProperty.equals("connectionTimeout")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                tempiRispostaConnectionTimeout = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("readConnectionTimeout")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                tempiRispostaReadTimeout = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("avgResponseTime")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                tempiRispostaAvgResponseTime = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("dataTransferMode")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                transferMode = valoreProperty;
            }
            if (nomeProperty.equals("transferChunkSize")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                transferModeChunkSize = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("followRedirects")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                redirectMode = valoreProperty;
            }
            if (nomeProperty.equals("maxHopRedirect")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                redirectMaxHop = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("httpImpl")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                httpImpl = valoreProperty;
            }
            if (nomeProperty.equals("tokenPolicy")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                tokenPolicy = valoreProperty;
            }
            if (nomeProperty.equals("apiKey")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                apiKey = valoreProperty;
            }
            if (nomeProperty.equals("apiKeyHeader")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                apiKeyHeader = valoreProperty;
            }
            if (nomeProperty.equals("appId")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                appId = valoreProperty;
            }
            if (nomeProperty.equals("appIdHeader")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                appIdHeader = valoreProperty;
            }
            if (TipiConnettore.HTTP.getNome().equals(endpointtype)) {
                if (nomeProperty.equals("location")) {
                    url = valoreProperty;
                } else if (nomeProperty.equals("user")) {
                    utente = valoreProperty;
                } else if (nomeProperty.equals("password")) {
                    password = valoreProperty;
                }
            } else if (TipiConnettore.JMS.getNome().equals(endpointtype)) {
                if (nomeProperty.equals("location")) {
                    nome = valoreProperty;
                } else if (nomeProperty.equals("tipo")) {
                    tipo = valoreProperty;
                } else if (nomeProperty.equals("user")) {
                    utente = valoreProperty;
                } else if (nomeProperty.equals("password")) {
                    password = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.factory.initial")) {
                    initcont = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.factory.url.pkgs")) {
                    urlpkg = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.provider.url")) {
                    provurl = valoreProperty;
                } else if (nomeProperty.equals("connection-factory")) {
                    connectionfactory = valoreProperty;
                } else if (nomeProperty.equals("send-as")) {
                    sendas = valoreProperty;
                }
            }
            if (!endpointtype.equalsIgnoreCase(TipiConnettore.DISABILITATO.getNome())) {
                isAbilitato = true;
            }
            if (!nomeProperty.startsWith("-#ext#-")) continue;
            extendedProperties.put(nomeProperty, valoreProperty);
        }
        try {
            long idConnettore = 0L;
            switch (type) {
                case 1: {
                    String apiKeyInsert;
                    BYOKWrappedValue byokValue;
                    BYOKWrappedValue byokValue2;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("connettori");
                    sqlQueryObject.addInsertField("endpointtype", "?");
                    sqlQueryObject.addInsertField("url", "?");
                    sqlQueryObject.addInsertField("transfer_mode", "?");
                    sqlQueryObject.addInsertField("transfer_mode_chunk_size", "?");
                    sqlQueryObject.addInsertField("redirect_mode", "?");
                    sqlQueryObject.addInsertField("redirect_max_hop", "?");
                    sqlQueryObject.addInsertField("http_impl", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("utente", "?");
                    sqlQueryObject.addInsertField("password", "?");
                    sqlQueryObject.addInsertField("enc_password", "?");
                    sqlQueryObject.addInsertField("initcont", "?");
                    sqlQueryObject.addInsertField("urlpkg", "?");
                    sqlQueryObject.addInsertField("provurl", "?");
                    sqlQueryObject.addInsertField("connection_factory", "?");
                    sqlQueryObject.addInsertField("send_as", "?");
                    sqlQueryObject.addInsertField("nome_connettore", "?");
                    sqlQueryObject.addInsertField("debug", "?");
                    sqlQueryObject.addInsertField("proxy", "?");
                    sqlQueryObject.addInsertField("proxy_type", "?");
                    sqlQueryObject.addInsertField("proxy_hostname", "?");
                    sqlQueryObject.addInsertField("proxy_port", "?");
                    sqlQueryObject.addInsertField("proxy_username", "?");
                    sqlQueryObject.addInsertField("proxy_password", "?");
                    sqlQueryObject.addInsertField("enc_proxy_password", "?");
                    sqlQueryObject.addInsertField("connection_timeout", "?");
                    sqlQueryObject.addInsertField("read_timeout", "?");
                    sqlQueryObject.addInsertField("avg_response_time", "?");
                    sqlQueryObject.addInsertField("custom", "?");
                    sqlQueryObject.addInsertField("token_policy", "?");
                    sqlQueryObject.addInsertField("api_key", "?");
                    sqlQueryObject.addInsertField("api_key_header", "?");
                    sqlQueryObject.addInsertField("app_id", "?");
                    sqlQueryObject.addInsertField("app_id_header", "?");
                    String sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = connection.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, endpointtype);
                    stm.setString(index++, url);
                    stm.setString(index++, isAbilitato ? transferMode : null);
                    if (isAbilitato && transferModeChunkSize != null) {
                        stm.setInt(index++, transferModeChunkSize);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, isAbilitato ? redirectMode : null);
                    if (isAbilitato && redirectMaxHop != null) {
                        stm.setInt(index++, redirectMaxHop);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, isAbilitato ? httpImpl : null);
                    stm.setString(index++, isAbilitato ? nome : null);
                    stm.setString(index++, isAbilitato ? tipo : null);
                    stm.setString(index++, isAbilitato ? utente : null);
                    String plainPassword = isAbilitato ? password : null;
                    String encPassword = null;
                    if (isAbilitato && driverBYOK != null && plainPassword != null && (byokValue2 = driverBYOK.wrap(plainPassword)) != null) {
                        encPassword = byokValue2.getWrappedValue();
                        plainPassword = byokValue2.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainPassword);
                    stm.setString(index++, encPassword);
                    stm.setString(index++, isAbilitato ? initcont : null);
                    stm.setString(index++, isAbilitato ? urlpkg : null);
                    stm.setString(index++, isAbilitato ? provurl : null);
                    stm.setString(index++, isAbilitato ? connectionfactory : null);
                    stm.setString(index++, isAbilitato ? sendas : null);
                    stm.setString(index++, nomeConnettore);
                    if (debug) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    if (proxy) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, isAbilitato && proxy ? proxyType : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyHostname : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyPort : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyUsername : null);
                    String plainProxyPassword = isAbilitato ? proxyPassword : null;
                    String encProxyPassword = null;
                    if (isAbilitato && driverBYOK != null && plainProxyPassword != null && (byokValue = driverBYOK.wrap(plainProxyPassword)) != null) {
                        encProxyPassword = byokValue.getWrappedValue();
                        plainProxyPassword = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainProxyPassword);
                    stm.setString(index++, encProxyPassword);
                    if (tempiRispostaConnectionTimeout != null) {
                        stm.setInt(index++, tempiRispostaConnectionTimeout);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (tempiRispostaReadTimeout != null) {
                        stm.setInt(index++, tempiRispostaReadTimeout);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (tempiRispostaAvgResponseTime != null) {
                        stm.setInt(index++, tempiRispostaAvgResponseTime);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, tokenPolicy);
                    String string = apiKeyInsert = isAbilitato ? apiKey : null;
                    if (isAbilitato && apiKey != null && StringUtils.isNotEmpty((CharSequence)apiKey) && driverBYOK != null && CostantiConnettori.isConfidential("apiKey")) {
                        BYOKWrappedValue byokValue3 = driverBYOK.wrap(apiKey);
                        if (byokValue3 != null) {
                            apiKeyInsert = byokValue3.getWrappedValue();
                            stm.setString(index++, byokValue3.getWrappedValue());
                        } else {
                            stm.setString(index++, apiKey);
                        }
                    } else {
                        stm.setString(index++, apiKey);
                    }
                    stm.setString(index++, isAbilitato ? apiKeyHeader : null);
                    stm.setString(index++, isAbilitato ? appId : null);
                    stm.setString(index++, isAbilitato ? appIdHeader : null);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDConnettore CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, endpointtype, url, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, httpImpl, nome, tipo, utente, plainPassword, encPassword, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, debug, proxy, proxyType, proxyHostname, proxyPort, proxyUsername, plainProxyPassword, encProxyPassword, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaAvgResponseTime, connettore.getCustom() != null && connettore.getCustom() != false, tokenPolicy, apiKeyInsert, apiKeyHeader, appId, appIdHeader));
                    int n = stm.executeUpdate();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDConnettore type = " + type + " row affected =" + n);
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("connettori");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome_connettore = ?");
                    sqlQueryObject.addWhereCondition("endpointtype = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, nomeConnettore);
                    stm.setString(2, endpointtype);
                    DriverRegistroServiziDB_LIB.logDebug("Recupero idConnettore inserito : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeConnettore, endpointtype));
                    ResultSet rs = stm.executeQuery();
                    if (!rs.next()) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                    }
                    idConnettore = rs.getLong("id");
                    rs.close();
                    stm.close();
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                            BYOKWrappedValue byokValue4;
                            nomeProperty = connettore.getProperty(i).getNome();
                            if (propertiesGestiteAttraversoColonneAdHoc.contains(nomeProperty)) continue;
                            valoreProperty = connettore.getProperty(i).getValore();
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new DriverRegistroServiziException("Property [" + nomeProperty + "] without value");
                            }
                            String plainValue = valoreProperty;
                            String encValue = null;
                            if (driverBYOK != null && CostantiConnettori.isConfidential(nomeProperty) && (byokValue4 = driverBYOK.wrap(valoreProperty)) != null) {
                                encValue = byokValue4.getWrappedValue();
                                plainValue = byokValue4.getWrappedPlainValue();
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeProperty);
                            stm.setString(2, plainValue);
                            stm.setString(3, encValue);
                            stm.setLong(4, idConnettore);
                            stm.executeUpdate();
                            stm.close();
                        }
                    } else {
                        if (extendedProperties.size() <= 0) break;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (String nomeP : extendedProperties.keySet()) {
                            BYOKWrappedValue byokValue5;
                            valoreProperty = (String)extendedProperties.get(nomeP);
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new DriverRegistroServiziException("Property [" + nomeP + "] without value");
                            }
                            String plainValue = valoreProperty;
                            String encValue = null;
                            if (driverBYOK != null && CostantiConnettori.isConfidential(nomeProperty) && (byokValue5 = driverBYOK.wrap(valoreProperty)) != null) {
                                encValue = byokValue5.getWrappedValue();
                                plainValue = byokValue5.getWrappedPlainValue();
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nome);
                            stm.setString(2, plainValue);
                            stm.setString(3, encValue);
                            stm.setLong(4, idConnettore);
                            stm.executeUpdate();
                            stm.close();
                        }
                    }
                    break;
                }
                case 2: {
                    String apiKeyInsert;
                    BYOKWrappedValue byokValue;
                    idConnettore = connettore.getId();
                    if (idConnettore <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di update.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addUpdateTable("connettori");
                    sqlQueryObject.addUpdateField("endpointtype", "?");
                    sqlQueryObject.addUpdateField("url", "?");
                    sqlQueryObject.addUpdateField("transfer_mode", "?");
                    sqlQueryObject.addUpdateField("transfer_mode_chunk_size", "?");
                    sqlQueryObject.addUpdateField("redirect_mode", "?");
                    sqlQueryObject.addUpdateField("redirect_max_hop", "?");
                    sqlQueryObject.addUpdateField("http_impl", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("tipo", "?");
                    sqlQueryObject.addUpdateField("utente", "?");
                    sqlQueryObject.addUpdateField("password", "?");
                    sqlQueryObject.addUpdateField("enc_password", "?");
                    sqlQueryObject.addUpdateField("initcont", "?");
                    sqlQueryObject.addUpdateField("urlpkg", "?");
                    sqlQueryObject.addUpdateField("provurl", "?");
                    sqlQueryObject.addUpdateField("connection_factory", "?");
                    sqlQueryObject.addUpdateField("send_as", "?");
                    sqlQueryObject.addUpdateField("nome_connettore", "?");
                    sqlQueryObject.addUpdateField("debug", "?");
                    sqlQueryObject.addUpdateField("proxy", "?");
                    sqlQueryObject.addUpdateField("proxy_type", "?");
                    sqlQueryObject.addUpdateField("proxy_hostname", "?");
                    sqlQueryObject.addUpdateField("proxy_port", "?");
                    sqlQueryObject.addUpdateField("proxy_username", "?");
                    sqlQueryObject.addUpdateField("proxy_password", "?");
                    sqlQueryObject.addUpdateField("enc_proxy_password", "?");
                    sqlQueryObject.addUpdateField("connection_timeout", "?");
                    sqlQueryObject.addUpdateField("read_timeout", "?");
                    sqlQueryObject.addUpdateField("avg_response_time", "?");
                    sqlQueryObject.addUpdateField("custom", "?");
                    sqlQueryObject.addUpdateField("token_policy", "?");
                    sqlQueryObject.addUpdateField("api_key", "?");
                    sqlQueryObject.addUpdateField("api_key_header", "?");
                    sqlQueryObject.addUpdateField("app_id", "?");
                    sqlQueryObject.addUpdateField("app_id_header", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = connection.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, endpointtype);
                    stm.setString(index++, url);
                    stm.setString(index++, isAbilitato ? transferMode : null);
                    if (isAbilitato && transferModeChunkSize != null) {
                        stm.setInt(index++, transferModeChunkSize);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, isAbilitato ? redirectMode : null);
                    if (isAbilitato && redirectMaxHop != null) {
                        stm.setInt(index++, redirectMaxHop);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, isAbilitato ? httpImpl : null);
                    stm.setString(index++, isAbilitato ? nome : null);
                    stm.setString(index++, isAbilitato ? tipo : null);
                    stm.setString(index++, isAbilitato ? utente : null);
                    String plainPassword = isAbilitato ? password : null;
                    String encPassword = null;
                    if (isAbilitato && driverBYOK != null && plainPassword != null && (byokValue = driverBYOK.wrap(plainPassword)) != null) {
                        encPassword = byokValue.getWrappedValue();
                        plainPassword = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainPassword);
                    stm.setString(index++, encPassword);
                    stm.setString(index++, isAbilitato ? initcont : null);
                    stm.setString(index++, isAbilitato ? urlpkg : null);
                    stm.setString(index++, isAbilitato ? provurl : null);
                    stm.setString(index++, isAbilitato ? connectionfactory : null);
                    stm.setString(index++, isAbilitato ? sendas : null);
                    stm.setString(index++, nomeConnettore);
                    if (debug) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    if (proxy) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, isAbilitato && proxy ? proxyType : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyHostname : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyPort : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyUsername : null);
                    String plainProxyPassword = isAbilitato ? proxyPassword : null;
                    String encProxyPassword = null;
                    if (isAbilitato && driverBYOK != null && plainProxyPassword != null && (byokValue = driverBYOK.wrap(plainProxyPassword)) != null) {
                        encProxyPassword = byokValue.getWrappedValue();
                        plainProxyPassword = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainProxyPassword);
                    stm.setString(index++, encProxyPassword);
                    if (tempiRispostaConnectionTimeout != null) {
                        stm.setInt(index++, tempiRispostaConnectionTimeout);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (tempiRispostaReadTimeout != null) {
                        stm.setInt(index++, tempiRispostaReadTimeout);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (tempiRispostaAvgResponseTime != null) {
                        stm.setInt(index++, tempiRispostaAvgResponseTime);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, tokenPolicy);
                    String string = apiKeyInsert = isAbilitato ? apiKey : null;
                    if (isAbilitato && apiKey != null && StringUtils.isNotEmpty((CharSequence)apiKey) && driverBYOK != null && CostantiConnettori.isConfidential("apiKey")) {
                        byokValue = driverBYOK.wrap(apiKey);
                        if (byokValue != null) {
                            apiKeyInsert = byokValue.getWrappedValue();
                            stm.setString(index++, byokValue.getWrappedValue());
                        } else {
                            stm.setString(index++, apiKey);
                        }
                    } else {
                        stm.setString(index++, apiKey);
                    }
                    stm.setString(index++, isAbilitato ? apiKeyHeader : null);
                    stm.setString(index++, isAbilitato ? appId : null);
                    stm.setString(index++, isAbilitato ? appIdHeader : null);
                    stm.setLong(index++, idConnettore);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDConnettore UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, endpointtype, url, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, httpImpl, nome, tipo, utente, plainPassword, encPassword, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, debug, proxy, proxyType, proxyHostname, proxyPort, proxyUsername, plainProxyPassword, encProxyPassword, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaAvgResponseTime, connettore.getCustom() != null && connettore.getCustom() != false, tokenPolicy, apiKeyInsert, apiKeyHeader, appId, appIdHeader, idConnettore));
                    int n = stm.executeUpdate();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDConnettore type = " + type + " row affected =" + n);
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("connettori_custom");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                            BYOKWrappedValue byokValue6;
                            nomeProperty = connettore.getProperty(i).getNome();
                            if (propertiesGestiteAttraversoColonneAdHoc.contains(nomeProperty)) continue;
                            valoreProperty = connettore.getProperty(i).getValore();
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new DriverRegistroServiziException("Property [" + nomeProperty + "] without value");
                            }
                            String plainValue = valoreProperty;
                            String encValue = null;
                            if (driverBYOK != null && CostantiConnettori.isConfidential(nomeProperty) && (byokValue6 = driverBYOK.wrap(valoreProperty)) != null) {
                                encValue = byokValue6.getWrappedValue();
                                plainValue = byokValue6.getWrappedPlainValue();
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeProperty);
                            stm.setString(2, plainValue);
                            stm.setString(3, encValue);
                            stm.setLong(4, idConnettore);
                            stm.executeUpdate();
                            stm.close();
                        }
                    } else {
                        if (extendedProperties.size() <= 0) break;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (String nomeP : extendedProperties.keySet()) {
                            BYOKWrappedValue byokValue7;
                            valoreProperty = (String)extendedProperties.get(nomeP);
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new DriverRegistroServiziException("Property [" + nomeP + "] without value");
                            }
                            String plainValue = valoreProperty;
                            String encValue = null;
                            if (driverBYOK != null && CostantiConnettori.isConfidential(nomeProperty) && (byokValue7 = driverBYOK.wrap(valoreProperty)) != null) {
                                encValue = byokValue7.getWrappedValue();
                                plainValue = byokValue7.getWrappedPlainValue();
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeP);
                            stm.setString(2, plainValue);
                            stm.setString(3, encValue);
                            stm.setLong(4, idConnettore);
                            stm.executeUpdate();
                            stm.close();
                        }
                    }
                    break;
                }
                case 3: {
                    idConnettore = connettore.getId();
                    if (idConnettore <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di delete.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("connettori_custom");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("connettori");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDConnettore DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idConnettore));
                    int n = stm.executeUpdate();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDConnettore type = " + type + " row affected =" + n);
                    stm.close();
                }
            }
            connettore.setId(idConnettore);
            long l = idConnettore;
            return l;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(stm);
        }
    }
}

