/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.driver.ConnettorePropertiesUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_connettoriLIB;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_connettoriDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_connettoriDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    protected Connettore getConnettore(long idConnettore) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String nomeMetodo = "getConnettore(id)";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            Connettore connettore = this.getConnettore(idConnettore, con);
            if (connettore == null) {
                throw new DriverRegistroServiziNotFound("Connettore con id '" + idConnettore + "' non esistente");
            }
            Connettore connettore2 = connettore;
            return connettore2;
        }
        catch (Exception qe) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected Connettore getConnettore(String nomeConnettore) throws DriverRegistroServiziException {
        Connettore connettore;
        String nomeMetodo = "getConnettore(nome)";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("nome_connettore=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomeConnettore);
            risultato = stmt.executeQuery();
            Long idConnettore = null;
            if (!risultato.next()) {
                throw new DriverRegistroServiziNotFound("Connettore con nome '" + nomeConnettore + "' non esistente");
            }
            idConnettore = risultato.getLong("id");
            Connettore connettore2 = this.getConnettore(idConnettore, con);
            if (connettore2 == null) {
                throw new DriverRegistroServiziNotFound("Connettore con id '" + idConnettore + "' non esistente");
            }
            connettore = connettore2;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return connettore;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connettore getConnettore(long idConnettore, Connection connection) throws DriverRegistroServiziException {
        Connettore connettore;
        Connettore connettore2 = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            IDriverBYOK driverBYOK = this.driver.getDriverUnwrapBYOK();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idConnettore));
            rs = stm.executeQuery();
            if (rs.next()) {
                String endpoint = rs.getString("endpointtype");
                if (endpoint == null || endpoint.equals("") || endpoint.equals(TipiConnettore.DISABILITATO.getNome())) {
                    connettore2 = new Connettore();
                    connettore2.setNome(rs.getString("nome_connettore"));
                    connettore2.setTipo(TipiConnettore.DISABILITATO.getNome());
                    connettore2.setId(idConnettore);
                } else {
                    Property prop = null;
                    connettore2 = new Connettore();
                    connettore2.setNome(rs.getString("nome_connettore"));
                    connettore2.setTipo(endpoint);
                    connettore2.setId(idConnettore);
                    if (rs.getInt("debug") == 1) {
                        prop = new Property();
                        prop.setNome("debug");
                        prop.setValore("true");
                        connettore2.addProperty(prop);
                    }
                    DriverRegistroServiziDB_connettoriDriver.readConnettoreProxy(rs, connettore2, driverBYOK);
                    DriverRegistroServiziDB_connettoriDriver.readConnettoreTempiRisposta(rs, connettore2);
                    DriverRegistroServiziDB_connettoriDriver.readConnettoreTransferMode(rs, connettore2);
                    DriverRegistroServiziDB_connettoriDriver.readConnettoreRedirectMode(rs, connettore2);
                    DriverRegistroServiziDB_connettoriDriver.readConnettoreHttpImpl(rs, connettore2);
                    String tokenPolicy = rs.getString("token_policy");
                    if (tokenPolicy != null && !"".equals(tokenPolicy)) {
                        prop = new Property();
                        prop.setNome("tokenPolicy");
                        prop.setValore(tokenPolicy.trim());
                        connettore2.addProperty(prop);
                    }
                    DriverRegistroServiziDB_connettoriDriver.readAutenticazioneApiKey(rs, connettore2, driverBYOK);
                    if (endpoint.equals(CostantiDB.CONNETTORE_TIPO_HTTP)) {
                        DriverRegistroServiziDB_connettoriDriver.readConnettoreHttp(rs, connettore2, driverBYOK);
                    } else if (endpoint.equals(TipiConnettore.JMS.getNome())) {
                        DriverRegistroServiziDB_connettoriDriver.readConnettoreJms(rs, connettore2, driverBYOK);
                    } else if (!(endpoint.equals(TipiConnettore.NULL.getNome()) || endpoint.equals(TipiConnettore.NULLECHO.getNome()) || endpoint.equals(TipiConnettore.DISABILITATO.getNome()))) {
                        if (rs.getLong("custom") == 1L) {
                            this.readPropertiesConnettoreCustom(idConnettore, connettore2, connection, driverBYOK);
                            connettore2.setCustom(true);
                        } else {
                            connettore2.setPropertyList(ConnettorePropertiesUtilities.getPropertiesConnettore(endpoint, connection, this.driver.tipoDB));
                        }
                    }
                }
            }
            this.readPropertiesConnettoreExtendedInfo(idConnettore, connettore2, connection, driverBYOK);
            connettore = connettore2;
        }
        catch (SQLException sqle) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] SQLException : " + sqle.getMessage(), sqle);
                catch (CoreException e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] CoreException : " + e.getMessage(), e);
                }
                catch (Exception sqle2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] Exception : " + sqle2.getMessage(), sqle2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return connettore;
    }

    private static void readConnettoreProxy(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        if (rs.getInt("proxy") == 1) {
            Property prop;
            String tmp = rs.getString("proxy_type");
            if (tmp != null && !"".equals(tmp)) {
                prop = new Property();
                prop.setNome("proxyType");
                prop.setValore(tmp.trim());
                connettore.addProperty(prop);
            }
            if ((tmp = rs.getString("proxy_hostname")) != null && !"".equals(tmp)) {
                prop = new Property();
                prop.setNome("proxyHostname");
                prop.setValore(tmp.trim());
                connettore.addProperty(prop);
            }
            if ((tmp = rs.getString("proxy_port")) != null && !"".equals(tmp)) {
                prop = new Property();
                prop.setNome("proxyPort");
                prop.setValore(tmp.trim());
                connettore.addProperty(prop);
            }
            DriverRegistroServiziDB_connettoriDriver.readConnettoreProxyCredentials(rs, connettore, driverBYOK);
        }
    }

    private static void readConnettoreProxyCredentials(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String tmp = rs.getString("proxy_username");
        if (tmp != null && !"".equals(tmp)) {
            Property prop = new Property();
            prop.setNome("proxyUsername");
            prop.setValore(tmp.trim());
            connettore.addProperty(prop);
        }
        tmp = rs.getString("proxy_password");
        String encValue = rs.getString("enc_proxy_password");
        if (tmp != null && !"".equals(tmp)) {
            Property prop = new Property();
            prop.setNome("proxyPassword");
            if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                if (driverBYOK != null) {
                    prop.setValore(driverBYOK.unwrapAsString(encValue));
                } else {
                    prop.setValore(encValue);
                }
            } else {
                prop.setValore(tmp.trim());
            }
            connettore.addProperty(prop);
        }
    }

    private static void readConnettoreTempiRisposta(ResultSet rs, Connettore connettore) throws SQLException {
        int avgResponseTime;
        int readTimeout;
        int connectionTimeout = rs.getInt("connection_timeout");
        if (connectionTimeout > 0) {
            Property prop = new Property();
            prop.setNome("connectionTimeout");
            prop.setValore("" + connectionTimeout);
            connettore.addProperty(prop);
        }
        if ((readTimeout = rs.getInt("read_timeout")) > 0) {
            Property prop = new Property();
            prop.setNome("readConnectionTimeout");
            prop.setValore("" + readTimeout);
            connettore.addProperty(prop);
        }
        if ((avgResponseTime = rs.getInt("avg_response_time")) > 0) {
            Property prop = new Property();
            prop.setNome("avgResponseTime");
            prop.setValore("" + avgResponseTime);
            connettore.addProperty(prop);
        }
    }

    private static void readConnettoreTransferMode(ResultSet rs, Connettore connettore) throws SQLException {
        String transferMode = rs.getString("transfer_mode");
        if (transferMode != null && !"".equals(transferMode)) {
            Property prop = new Property();
            prop.setNome("dataTransferMode");
            prop.setValore(transferMode.trim());
            connettore.addProperty(prop);
            transferMode = rs.getString("transfer_mode_chunk_size");
            if (transferMode != null && !"".equals(transferMode)) {
                prop = new Property();
                prop.setNome("transferChunkSize");
                prop.setValore(transferMode.trim());
                connettore.addProperty(prop);
            }
        }
    }

    private static void readConnettoreRedirectMode(ResultSet rs, Connettore connettore) throws SQLException {
        String redirectMode = rs.getString("redirect_mode");
        if (redirectMode != null && !"".equals(redirectMode)) {
            Property prop = new Property();
            prop.setNome("followRedirects");
            prop.setValore(redirectMode.trim());
            connettore.addProperty(prop);
            redirectMode = rs.getString("redirect_max_hop");
            if (redirectMode != null && !"".equals(redirectMode)) {
                prop = new Property();
                prop.setNome("maxHopRedirect");
                prop.setValore(redirectMode.trim());
                connettore.addProperty(prop);
            }
        }
    }

    private static void readConnettoreHttpImpl(ResultSet rs, Connettore connettore) throws SQLException {
        String httpImpl = rs.getString("http_impl");
        if (httpImpl != null && !"".equals(httpImpl)) {
            Property prop = new Property();
            prop.setNome("httpImpl");
            prop.setValore(httpImpl.trim());
            connettore.addProperty(prop);
        }
    }

    private static void readAutenticazioneApiKey(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String apiKey = rs.getString("api_key");
        if (apiKey != null && !"".equals(apiKey)) {
            String appId;
            Property prop = new Property();
            prop.setNome("apiKey");
            if (driverBYOK != null) {
                prop.setValore(driverBYOK.unwrapAsString(apiKey));
            } else {
                prop.setValore(apiKey);
            }
            connettore.addProperty(prop);
            String apiKeyHeader = rs.getString("api_key_header");
            if (apiKeyHeader != null && !"".equals(apiKeyHeader)) {
                prop = new Property();
                prop.setNome("apiKeyHeader");
                prop.setValore(apiKeyHeader.trim());
                connettore.addProperty(prop);
            }
            if ((appId = rs.getString("app_id")) != null && !"".equals(appId)) {
                prop = new Property();
                prop.setNome("appId");
                prop.setValore(appId);
                connettore.addProperty(prop);
                String appIdHeader = rs.getString("app_id_header");
                if (appIdHeader != null && !"".equals(appIdHeader)) {
                    prop = new Property();
                    prop.setNome("appIdHeader");
                    prop.setValore(appIdHeader.trim());
                    connettore.addProperty(prop);
                }
            }
        }
    }

    private static void readConnettoreHttp(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws DriverRegistroServiziException, SQLException, UtilsException {
        String value = rs.getString("url");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverRegistroServiziException("Connettore di tipo http possiede una url non definita");
        }
        Property prop = new Property();
        prop.setNome("location");
        prop.setValore(value);
        connettore.addProperty(prop);
        String usr = rs.getString("utente");
        if (usr != null && !usr.trim().equals("")) {
            prop = new Property();
            prop.setNome("user");
            prop.setValore(usr);
            connettore.addProperty(prop);
        }
        String pwd = rs.getString("password");
        String encValue = rs.getString("enc_password");
        if (pwd != null && !pwd.trim().equals("")) {
            prop = new Property();
            prop.setNome("password");
            if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                if (driverBYOK != null) {
                    prop.setValore(driverBYOK.unwrapAsString(encValue));
                } else {
                    prop.setValore(encValue);
                }
            } else {
                prop.setValore(pwd);
            }
            connettore.addProperty(prop);
        }
    }

    private static void readConnettoreJms(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws DriverRegistroServiziException, SQLException, UtilsException {
        String value = rs.getString("nome");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverRegistroServiziException("Connettore di tipo jms possiede il nome della coda/topic non definito");
        }
        Property prop = new Property();
        prop.setNome("location");
        prop.setValore(value);
        connettore.addProperty(prop);
        value = rs.getString("tipo");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo della coda non definito");
        }
        prop = new Property();
        prop.setNome("tipo");
        prop.setValore(value);
        connettore.addProperty(prop);
        value = rs.getString("connection_factory");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverRegistroServiziException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
        }
        prop = new Property();
        prop.setNome("connection-factory");
        prop.setValore(value);
        connettore.addProperty(prop);
        value = rs.getString("send_as");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
        }
        prop = new Property();
        prop.setNome("send-as");
        prop.setValore(value);
        connettore.addProperty(prop);
        DriverRegistroServiziDB_connettoriDriver.readConnettoreJmsCredentials(rs, connettore, driverBYOK);
        DriverRegistroServiziDB_connettoriDriver.readConnettoreJmsContext(rs, connettore);
    }

    private static void readConnettoreJmsCredentials(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String usr = rs.getString("utente");
        if (usr != null && !usr.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("user");
            prop.setValore(usr);
            connettore.addProperty(prop);
        }
        String pwd = rs.getString("password");
        String encValue = rs.getString("enc_password");
        if (pwd != null && !pwd.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("password");
            if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                if (driverBYOK != null) {
                    prop.setValore(driverBYOK.unwrapAsString(encValue));
                } else {
                    prop.setValore(encValue);
                }
            } else {
                prop.setValore(pwd);
            }
            connettore.addProperty(prop);
        }
    }

    private static void readConnettoreJmsContext(ResultSet rs, Connettore connettore) throws SQLException {
        String provurl;
        String urlpkg;
        String initcont = rs.getString("initcont");
        if (initcont != null && !initcont.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("context-java.naming.factory.initial");
            prop.setValore(initcont);
            connettore.addProperty(prop);
        }
        if ((urlpkg = rs.getString("urlpkg")) != null && !urlpkg.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("context-java.naming.factory.url.pkgs");
            prop.setValore(urlpkg);
            connettore.addProperty(prop);
        }
        if ((provurl = rs.getString("provurl")) != null && !provurl.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("context-java.naming.provider.url");
            prop.setValore(provurl);
            connettore.addProperty(prop);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readPropertiesConnettoreCustom(long idConnettore, Connettore connettore, Connection connection, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_connettore = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore));
            rs = stm.executeQuery();
            while (rs.next()) {
                DriverRegistroServiziDB_connettoriDriver.processPropertiesConnettoreCustom(rs, connettore, driverBYOK);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException sqle) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreCustom] SQLException : " + sqle.getMessage(), sqle);
                catch (Exception sqle2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreCustom] Exception : " + sqle2.getMessage(), sqle2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
    }

    private static void processPropertiesConnettoreCustom(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String nome = rs.getString("name");
        String valore = rs.getString("value");
        String encValue = rs.getString("enc_value");
        if ("debug".equals(nome)) {
            boolean found = false;
            for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                if (!"debug".equals(connettore.getProperty(i).getNome())) continue;
                found = true;
                break;
            }
            if (found) {
                return;
            }
        }
        Property prop = new Property();
        prop.setNome(nome);
        if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
            if (driverBYOK != null) {
                prop.setValore(driverBYOK.unwrapAsString(encValue));
            } else {
                prop.setValore(encValue);
            }
        } else {
            prop.setValore(valore);
        }
        connettore.addProperty(prop);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readPropertiesConnettoreExtendedInfo(long idConnettore, Connettore connettore, Connection connection, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_connettore = ?");
            sqlQueryObject.addWhereLikeCondition("name", "-#ext#-%");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore));
            rs = stm.executeQuery();
            while (rs.next()) {
                DriverRegistroServiziDB_connettoriDriver.processPropertiesConnettoreExtendedInfo(rs, connettore, driverBYOK);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException sqle) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreExtendedInfo] SQLException : " + sqle.getMessage(), sqle);
                catch (Exception sqle2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreExtendedInfo] Exception : " + sqle2.getMessage(), sqle2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
    }

    private static void processPropertiesConnettoreExtendedInfo(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String nome = rs.getString("name");
        String valore = rs.getString("value");
        String encValue = rs.getString("enc_value");
        boolean found = false;
        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
            if (!nome.equals(connettore.getProperty(i).getNome())) continue;
            found = true;
            break;
        }
        if (found) {
            return;
        }
        Property prop = new Property();
        prop.setNome(nome);
        if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
            if (driverBYOK != null) {
                prop.setValore(driverBYOK.unwrapAsString(encValue));
            } else {
                prop.setValore(encValue);
            }
        } else {
            prop.setValore(valore);
        }
        connettore.addProperty(prop);
    }

    protected Property[] getPropertiesConnettore(String nomeConnettore) throws DriverRegistroServiziException {
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getPropertiesConnettore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPropertiesConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        return this.getPropertiesConnettore(nomeConnettore, con);
    }

    protected Property[] getPropertiesConnettore(String nomeConnettore, Connection connection) throws DriverRegistroServiziException {
        try {
            List<Property> l = ConnettorePropertiesUtilities.getPropertiesConnettore(nomeConnettore, connection, this.driver.tipoDB);
            return l != null && !l.isEmpty() ? l.toArray(new Property[1]) : null;
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPropertiesConnettore] CoreException : " + e.getMessage(), e);
        }
    }

    protected void createConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDConnettore type = 1");
            DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(1, connettore, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDConnettore type = 2");
            DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(2, connettore, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDConnettore type = 3");
            DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(3, connettore, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }
}

