/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.MessageType;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiCooperazioneLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiRestLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiSoapLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_documentiLIB;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class DriverRegistroServiziDB_accordiLIB {
    private static final String ACCORDO_DIVERSO_NULL = "L'accordo non pu\u00f2 essere null.";
    private static final String NOME_ACCORDO_NON_VALIDO = "Il nome dell'accordo non \u00e8 valido.";

    private DriverRegistroServiziDB_accordiLIB() {
    }

    private static void logDebug(Logger log, String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    private static void logError(Logger log, String msg, Exception e) {
        if (log != null) {
            log.error(msg, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizio, Connection con, String tabellaSoggetti, Logger log, IDAccordoFactory idAccordoFactory, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException(ACCORDO_DIVERSO_NULL);
        }
        String nome = accordoServizio.getNome();
        if (nome == null) throw new DriverRegistroServiziException(NOME_ACCORDO_NON_VALIDO);
        if (nome.equals("")) {
            throw new DriverRegistroServiziException(NOME_ACCORDO_NON_VALIDO);
        }
        ServiceBinding serviceBinding = accordoServizio.getServiceBinding();
        MessageType messageType = accordoServizio.getMessageType();
        StatoFunzionalita confermaRicezione = accordoServizio.getConfermaRicezione();
        StatoFunzionalita conegnaInOrdine = accordoServizio.getConsegnaInOrdine();
        String descrizione = accordoServizio.getDescrizione();
        StatoFunzionalita filtroDuplicati = accordoServizio.getFiltroDuplicati();
        StatoFunzionalita identificativoCollaborazione = accordoServizio.getIdCollaborazione();
        StatoFunzionalita identificativoRiferimentoRichiesta = accordoServizio.getIdRiferimentoRichiesta();
        ProfiloCollaborazione profiloCollaborazione = accordoServizio.getProfiloCollaborazione();
        String scadenza = accordoServizio.getScadenza();
        boolean utilizzioSenzaAzione = accordoServizio.getUtilizzoSenzaAzione();
        String wsdlConcettuale = accordoServizio.getByteWsdlConcettuale() != null ? new String(accordoServizio.getByteWsdlConcettuale()) : null;
        String wsdlDefinitorio = accordoServizio.getByteWsdlDefinitorio() != null ? new String(accordoServizio.getByteWsdlDefinitorio()) : null;
        String wsdlLogicoErogatore = accordoServizio.getByteWsdlLogicoErogatore() != null ? new String(accordoServizio.getByteWsdlLogicoErogatore()) : null;
        String wsdlLogicoFruitore = accordoServizio.getByteWsdlLogicoFruitore() != null ? new String(accordoServizio.getByteWsdlLogicoFruitore()) : null;
        String conversazioneConcettuale = accordoServizio.getByteSpecificaConversazioneConcettuale() != null ? new String(accordoServizio.getByteSpecificaConversazioneConcettuale()) : null;
        String conversazioneErogatore = accordoServizio.getByteSpecificaConversazioneErogatore() != null ? new String(accordoServizio.getByteSpecificaConversazioneErogatore()) : null;
        String conversazioneFruitore = accordoServizio.getByteSpecificaConversazioneFruitore() != null ? new String(accordoServizio.getByteSpecificaConversazioneFruitore()) : null;
        String superUser = accordoServizio.getSuperUser();
        FormatoSpecifica formatoSpecifica = accordoServizio.getFormatoSpecifica();
        wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replace("\n", "")) ? wsdlConcettuale : null;
        wsdlDefinitorio = wsdlDefinitorio != null && !"".equals(wsdlDefinitorio.trim().replace("\n", "")) ? wsdlDefinitorio : null;
        wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replace("\n", "")) ? wsdlLogicoErogatore : null;
        wsdlLogicoFruitore = wsdlLogicoFruitore != null && !"".equals(wsdlLogicoFruitore.trim().replace("\n", "")) ? wsdlLogicoFruitore : null;
        conversazioneConcettuale = conversazioneConcettuale != null && !"".equals(conversazioneConcettuale.trim().replace("\n", "")) ? conversazioneConcettuale : null;
        conversazioneErogatore = conversazioneErogatore != null && !"".equals(conversazioneErogatore.trim().replace("\n", "")) ? conversazioneErogatore : null;
        conversazioneFruitore = conversazioneFruitore != null && !"".equals(conversazioneFruitore.trim().replace("\n", "")) ? conversazioneFruitore : null;
        String utenteRichiedente = null;
        utenteRichiedente = accordoServizio.getProprietaOggetto() != null && accordoServizio.getProprietaOggetto().getUtenteRichiedente() != null ? accordoServizio.getProprietaOggetto().getUtenteRichiedente() : superUser;
        Timestamp dataCreazione = null;
        dataCreazione = accordoServizio.getProprietaOggetto() != null && accordoServizio.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(accordoServizio.getProprietaOggetto().getDataCreazione().getTime()) : (accordoServizio.getOraRegistrazione() != null ? new Timestamp(accordoServizio.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
        String sqlQuery = "";
        PreparedStatement stm = null;
        try {
            Documento doc;
            int i;
            int i2;
            IDAccordo idAccordoObject;
            long idAccordo;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addInsertTable("accordi");
            sqlQueryObject.addInsertField("service_binding", "?");
            sqlQueryObject.addInsertField("message_type", "?");
            sqlQueryObject.addInsertField("conferma_ricezione", "?");
            sqlQueryObject.addInsertField("consegna_in_ordine", "?");
            sqlQueryObject.addInsertField("descrizione", "?");
            sqlQueryObject.addInsertField("filtro_duplicati", "?");
            sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
            sqlQueryObject.addInsertField("id_riferimento_richiesta", "?");
            sqlQueryObject.addInsertField("nome", "?");
            sqlQueryObject.addInsertField("profilo_collaborazione", "?");
            sqlQueryObject.addInsertField("scadenza", "?");
            sqlQueryObject.addInsertField("formato_specifica", "?");
            sqlQueryObject.addInsertField("wsdl_concettuale", "?");
            sqlQueryObject.addInsertField("wsdl_definitorio", "?");
            sqlQueryObject.addInsertField("wsdl_logico_erogatore", "?");
            sqlQueryObject.addInsertField("wsdl_logico_fruitore", "?");
            sqlQueryObject.addInsertField("spec_conv_concettuale", "?");
            sqlQueryObject.addInsertField("spec_conv_erogatore", "?");
            sqlQueryObject.addInsertField("spec_conv_fruitore", "?");
            sqlQueryObject.addInsertField("superuser", "?");
            sqlQueryObject.addInsertField("utilizzo_senza_azione", "?");
            sqlQueryObject.addInsertField("privato", "?");
            if (accordoServizio.getStatoPackage() != null) {
                sqlQueryObject.addInsertField("stato", "?");
            }
            sqlQueryObject.addInsertField("canale", "?");
            if (accordoServizio.getSoggettoReferente() != null) {
                sqlQueryObject.addInsertField("id_referente", "?");
            }
            sqlQueryObject.addInsertField("versione", "?");
            if (accordoServizio.getOraRegistrazione() != null) {
                sqlQueryObject.addInsertField("ora_registrazione", "?");
            }
            if (utenteRichiedente != null) {
                sqlQueryObject.addInsertField("utente_richiedente", "?");
            }
            if (dataCreazione != null) {
                sqlQueryObject.addInsertField("data_creazione", "?");
            }
            sqlQuery = sqlQueryObject.createSQLInsert();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(serviceBinding));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(messageType));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(confermaRicezione));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(conegnaInOrdine));
            stm.setString(index++, descrizione);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(filtroDuplicati));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(identificativoCollaborazione));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(identificativoRiferimentoRichiesta));
            stm.setString(index++, nome);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(profiloCollaborazione));
            stm.setString(index++, scadenza);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(formatoSpecifica));
            stm.setString(index++, wsdlConcettuale != null && !wsdlConcettuale.trim().equals("") ? wsdlConcettuale : null);
            stm.setString(index++, wsdlDefinitorio != null && !wsdlDefinitorio.trim().equals("") ? wsdlDefinitorio : null);
            stm.setString(index++, wsdlLogicoErogatore != null && !wsdlLogicoErogatore.trim().equals("") ? wsdlLogicoErogatore : null);
            stm.setString(index++, wsdlLogicoFruitore != null && !wsdlLogicoFruitore.trim().equals("") ? wsdlLogicoFruitore : null);
            stm.setString(index++, conversazioneConcettuale != null && !conversazioneConcettuale.trim().equals("") ? conversazioneConcettuale : null);
            stm.setString(index++, conversazioneErogatore != null && !conversazioneErogatore.trim().equals("") ? conversazioneErogatore : null);
            stm.setString(index++, conversazioneFruitore != null && !conversazioneFruitore.trim().equals("") ? conversazioneFruitore : null);
            stm.setString(index++, superUser);
            stm.setInt(index++, utilizzioSenzaAzione ? 1 : 0);
            if (accordoServizio.getPrivato() != null && accordoServizio.getPrivato().booleanValue()) {
                stm.setInt(index++, 1);
            } else {
                stm.setInt(index++, 0);
            }
            if (accordoServizio.getStatoPackage() != null) {
                stm.setString(index, accordoServizio.getStatoPackage());
                ++index;
            }
            stm.setString(index, accordoServizio.getCanale());
            ++index;
            long idReferente = -1L;
            if (accordoServizio.getSoggettoReferente() != null) {
                idReferente = DBUtils.getIdSoggetto(accordoServizio.getSoggettoReferente().getNome(), accordoServizio.getSoggettoReferente().getTipo(), con, DriverRegistroServiziDB_LIB.tipoDB, tabellaSoggetti);
                if (idReferente <= 0L) {
                    throw new DriverRegistroServiziException("Soggetto Referente [" + accordoServizio.getSoggettoReferente().getTipo() + "/" + accordoServizio.getSoggettoReferente().getNome() + "] non trovato");
                }
                stm.setLong(index, idReferente);
                ++index;
            }
            stm.setInt(index, accordoServizio.getVersione());
            ++index;
            if (accordoServizio.getOraRegistrazione() != null) {
                stm.setTimestamp(index, new Timestamp(accordoServizio.getOraRegistrazione().getTime()));
                ++index;
            }
            if (utenteRichiedente != null) {
                stm.setString(index, utenteRichiedente);
                ++index;
            }
            if (dataCreazione != null) {
                stm.setTimestamp(index, dataCreazione);
                ++index;
            }
            String msgDebug = "inserisco accordoServizio : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, serviceBinding, messageType, confermaRicezione, conegnaInOrdine, descrizione, filtroDuplicati, identificativoCollaborazione, identificativoRiferimentoRichiesta, nome, profiloCollaborazione, scadenza, wsdlConcettuale, wsdlDefinitorio, wsdlLogicoErogatore, wsdlLogicoFruitore, conversazioneConcettuale, conversazioneErogatore, conversazioneFruitore, superUser, accordoServizio.getUtilizzoSenzaAzione(), accordoServizio.getPrivato() != null && accordoServizio.getPrivato() != false);
            log.debug(msgDebug);
            stm.executeUpdate();
            stm.close();
            IDSoggetto soggettoReferente = null;
            if (accordoServizio.getSoggettoReferente() != null) {
                soggettoReferente = new IDSoggetto(accordoServizio.getSoggettoReferente().getTipo(), accordoServizio.getSoggettoReferente().getNome());
            }
            if ((idAccordo = DBUtils.getIdAccordoServizioParteComune(idAccordoObject = idAccordoFactory.getIDAccordoFromValues(accordoServizio.getNome(), soggettoReferente, accordoServizio.getVersione()), con, DriverRegistroServiziDB_LIB.tipoDB)) <= 0L) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizio] non riesco a trovare l'id del'Accordo inserito");
            }
            accordoServizio.setId(idAccordo);
            Azione azione = null;
            for (int i3 = 0; i3 < accordoServizio.sizeAzioneList(); ++i3) {
                azione = accordoServizio.getAzione(i3);
                DriverRegistroServiziDB_accordiSoapLIB.CRUDAzione(1, accordoServizio, azione, con, idAccordo, driverBYOK);
            }
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "inserite " + accordoServizio.sizeAzioneList() + " azioni relative all'accordo :" + nome + " id :" + idAccordo);
            PortType pt = null;
            for (int i4 = 0; i4 < accordoServizio.sizePortTypeList(); ++i4) {
                pt = accordoServizio.getPortType(i4);
                DriverRegistroServiziDB_accordiSoapLIB.CRUDPortType(1, accordoServizio, pt, con, idAccordo, driverBYOK);
            }
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "inserite " + accordoServizio.sizePortTypeList() + " porttype relative all'accordo :" + nome + " id :" + idAccordo);
            Resource resource = null;
            for (i2 = 0; i2 < accordoServizio.sizeResourceList(); ++i2) {
                resource = accordoServizio.getResource(i2);
                DriverRegistroServiziDB_accordiRestLIB.CRUDResource(1, accordoServizio, resource, con, idAccordo, driverBYOK);
            }
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "inserite " + accordoServizio.sizeResourceList() + " resources relative all'accordo :" + nome + " id :" + idAccordo);
            if (accordoServizio.getGruppi() != null && accordoServizio.getGruppi().sizeGruppoList() > 0) {
                for (i2 = 0; i2 < accordoServizio.getGruppi().sizeGruppoList(); ++i2) {
                    GruppoAccordo gruppo = accordoServizio.getGruppi().getGruppo(i2);
                    DriverRegistroServiziDB_accordiLIB.CRUDAccordoGruppo(1, accordoServizio, gruppo, con, idAccordo);
                }
                DriverRegistroServiziDB_accordiLIB.logDebug(log, "inserite " + accordoServizio.sizeAzioneList() + " gruppi relative all'accordo :" + nome + " id :" + idAccordo);
            }
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_accordiCooperazioneLIB.CRUDAccordoServizioParteComuneServizioComposto(1, accordoServizio.getServizioComposto(), con, idAccordo);
            }
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            for (i = 0; i < accordoServizio.sizeAllegatoList(); ++i) {
                doc = accordoServizio.getAllegato(i);
                doc.setRuolo(RuoliDocumento.allegato.toString());
                documenti.add(doc);
            }
            for (i = 0; i < accordoServizio.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizio.getSpecificaSemiformale(i);
                doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                documenti.add(doc);
            }
            if (accordoServizio.getServizioComposto() != null) {
                for (i = 0; i < accordoServizio.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                    doc = accordoServizio.getServizioComposto().getSpecificaCoordinamento(i);
                    doc.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                    documenti.add(doc);
                }
            }
            DriverRegistroServiziDB_documentiLIB.CRUDDocumento(1, documenti, idAccordo, ProprietariDocumento.accordoServizio, con, DriverRegistroServiziDB_LIB.tipoDB);
            DriverRegistroServiziDB_LIB.CRUDProtocolProperty(1, accordoServizio.getProtocolPropertyList(), idAccordo, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteComune] SQLException [" + se.getMessage() + "].", se);
                catch (DriverRegistroServiziException e) {
                    throw new DriverRegistroServiziException(e.getMessage(), e);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteComune] Exception [" + e.getMessage() + "].", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)stm);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizio, Connection con, String tabellaSoggetti, Logger log, IDAccordoFactory idAccordoFactory, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException(ACCORDO_DIVERSO_NULL);
        }
        String nome = accordoServizio.getNome();
        if (nome == null) throw new DriverRegistroServiziException(NOME_ACCORDO_NON_VALIDO);
        if (nome.equals("")) {
            throw new DriverRegistroServiziException(NOME_ACCORDO_NON_VALIDO);
        }
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        ServiceBinding serviceBinding = accordoServizio.getServiceBinding();
        MessageType messageType = accordoServizio.getMessageType();
        StatoFunzionalita confermaRicezione = accordoServizio.getConfermaRicezione();
        StatoFunzionalita conegnaInOrdine = accordoServizio.getConsegnaInOrdine();
        String descrizione = accordoServizio.getDescrizione();
        StatoFunzionalita filtroDuplicati = accordoServizio.getFiltroDuplicati();
        StatoFunzionalita identificativoCollaborazione = accordoServizio.getIdCollaborazione();
        StatoFunzionalita identificativoRiferimentoRichiesta = accordoServizio.getIdRiferimentoRichiesta();
        ProfiloCollaborazione profiloCollaborazione = accordoServizio.getProfiloCollaborazione();
        String scadenza = accordoServizio.getScadenza();
        boolean utilizzioSenzaAzione = accordoServizio.getUtilizzoSenzaAzione();
        FormatoSpecifica formatoSpecifica = accordoServizio.getFormatoSpecifica();
        String wsdlConcettuale = accordoServizio.getByteWsdlConcettuale() != null ? new String(accordoServizio.getByteWsdlConcettuale()) : null;
        String wsdlDefinitorio = accordoServizio.getByteWsdlDefinitorio() != null ? new String(accordoServizio.getByteWsdlDefinitorio()) : null;
        String wsdlLogicoErogatore = accordoServizio.getByteWsdlLogicoErogatore() != null ? new String(accordoServizio.getByteWsdlLogicoErogatore()) : null;
        String wsdlLogicoFruitore = accordoServizio.getByteWsdlLogicoFruitore() != null ? new String(accordoServizio.getByteWsdlLogicoFruitore()) : null;
        String conversazioneConcettuale = accordoServizio.getByteSpecificaConversazioneConcettuale() != null ? new String(accordoServizio.getByteSpecificaConversazioneConcettuale()) : null;
        String conversazioneErogatore = accordoServizio.getByteSpecificaConversazioneErogatore() != null ? new String(accordoServizio.getByteSpecificaConversazioneErogatore()) : null;
        String conversazioneFruitore = accordoServizio.getByteSpecificaConversazioneFruitore() != null ? new String(accordoServizio.getByteSpecificaConversazioneFruitore()) : null;
        String superUser = accordoServizio.getSuperUser();
        wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replace("\n", "")) ? wsdlConcettuale : null;
        wsdlDefinitorio = wsdlDefinitorio != null && !"".equals(wsdlDefinitorio.trim().replace("\n", "")) ? wsdlDefinitorio : null;
        wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replace("\n", "")) ? wsdlLogicoErogatore : null;
        wsdlLogicoFruitore = wsdlLogicoFruitore != null && !"".equals(wsdlLogicoFruitore.trim().replace("\n", "")) ? wsdlLogicoFruitore : null;
        conversazioneConcettuale = conversazioneConcettuale != null && !"".equals(conversazioneConcettuale.trim().replace("\n", "")) ? conversazioneConcettuale : null;
        conversazioneErogatore = conversazioneErogatore != null && !"".equals(conversazioneErogatore.trim().replace("\n", "")) ? conversazioneErogatore : null;
        conversazioneFruitore = conversazioneFruitore != null && !"".equals(conversazioneFruitore.trim().replace("\n", "")) ? conversazioneFruitore : null;
        try {
            Documento doc;
            int i;
            GruppoAccordo gruppo;
            IDAccordo idAccordoAttualeInseritoDB = null;
            idAccordoAttualeInseritoDB = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            long idAccordoLong = -1L;
            try {
                idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordoAttualeInseritoDB, con, DriverRegistroServiziDB_LIB.tipoDB);
            }
            catch (Exception e) {
                if (accordoServizio.getOldIDAccordoForUpdate() == null) throw e;
                idAccordoAttualeInseritoDB = accordoServizio.getSoggettoReferente() != null ? idAccordoFactory.getIDAccordoFromValues(idAccordoAttualeInseritoDB.getNome(), new IDSoggetto(accordoServizio.getSoggettoReferente().getTipo(), accordoServizio.getSoggettoReferente().getNome()), idAccordoAttualeInseritoDB.getVersione()) : idAccordoFactory.getIDAccordoFromValues(idAccordoAttualeInseritoDB.getNome(), null, idAccordoAttualeInseritoDB.getVersione());
                idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordoAttualeInseritoDB, con, DriverRegistroServiziDB_LIB.tipoDB);
            }
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Servizio : " + nome);
            }
            String utenteUltimaModifica = null;
            utenteUltimaModifica = accordoServizio.getProprietaOggetto() != null && accordoServizio.getProprietaOggetto().getUtenteUltimaModifica() != null ? accordoServizio.getProprietaOggetto().getUtenteUltimaModifica() : superUser;
            Timestamp dataUltimaModifica = null;
            dataUltimaModifica = accordoServizio.getProprietaOggetto() != null && accordoServizio.getProprietaOggetto().getDataUltimaModifica() != null ? new Timestamp(accordoServizio.getProprietaOggetto().getDataUltimaModifica().getTime()) : DateManager.getTimestamp();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addUpdateTable("accordi");
            sqlQueryObject.addUpdateField("service_binding", "?");
            sqlQueryObject.addUpdateField("message_type", "?");
            sqlQueryObject.addUpdateField("conferma_ricezione", "?");
            sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
            sqlQueryObject.addUpdateField("descrizione", "?");
            sqlQueryObject.addUpdateField("filtro_duplicati", "?");
            sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
            sqlQueryObject.addUpdateField("id_riferimento_richiesta", "?");
            sqlQueryObject.addUpdateField("nome", "?");
            sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
            sqlQueryObject.addUpdateField("scadenza", "?");
            sqlQueryObject.addUpdateField("formato_specifica", "?");
            sqlQueryObject.addUpdateField("wsdl_concettuale", "?");
            sqlQueryObject.addUpdateField("wsdl_definitorio", "?");
            sqlQueryObject.addUpdateField("wsdl_logico_erogatore", "?");
            sqlQueryObject.addUpdateField("wsdl_logico_fruitore", "?");
            sqlQueryObject.addUpdateField("spec_conv_concettuale", "?");
            sqlQueryObject.addUpdateField("spec_conv_erogatore", "?");
            sqlQueryObject.addUpdateField("spec_conv_fruitore", "?");
            sqlQueryObject.addUpdateField("superuser", "?");
            sqlQueryObject.addUpdateField("utilizzo_senza_azione", "?");
            sqlQueryObject.addUpdateField("privato", "?");
            if (accordoServizio.getStatoPackage() != null) {
                sqlQueryObject.addUpdateField("stato", "?");
            }
            sqlQueryObject.addUpdateField("canale", "?");
            if (accordoServizio.getOraRegistrazione() != null) {
                sqlQueryObject.addUpdateField("ora_registrazione", "?");
            }
            sqlQueryObject.addUpdateField("id_referente", "?");
            sqlQueryObject.addUpdateField("versione", "?");
            if (utenteUltimaModifica != null) {
                sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
            }
            if (dataUltimaModifica != null) {
                sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
            }
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(serviceBinding));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(messageType));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(confermaRicezione));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(conegnaInOrdine));
            stm.setString(index++, descrizione);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(filtroDuplicati));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(identificativoCollaborazione));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(identificativoRiferimentoRichiesta));
            stm.setString(index++, nome);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(profiloCollaborazione));
            stm.setString(index++, scadenza);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(formatoSpecifica));
            stm.setString(index++, wsdlConcettuale);
            stm.setString(index++, wsdlDefinitorio);
            stm.setString(index++, wsdlLogicoErogatore);
            stm.setString(index++, wsdlLogicoFruitore);
            stm.setString(index++, conversazioneConcettuale);
            stm.setString(index++, conversazioneErogatore);
            stm.setString(index++, conversazioneFruitore);
            stm.setString(index++, superUser);
            stm.setInt(index++, utilizzioSenzaAzione ? 1 : 0);
            if (accordoServizio.getPrivato() != null && accordoServizio.getPrivato().booleanValue()) {
                stm.setInt(index++, 1);
            } else {
                stm.setInt(index++, 0);
            }
            if (accordoServizio.getStatoPackage() != null) {
                stm.setString(index++, accordoServizio.getStatoPackage());
            }
            stm.setString(index++, accordoServizio.getCanale());
            if (accordoServizio.getOraRegistrazione() != null) {
                stm.setTimestamp(index++, new Timestamp(accordoServizio.getOraRegistrazione().getTime()));
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                long idSRef = DBUtils.getIdSoggetto(accordoServizio.getSoggettoReferente().getNome(), accordoServizio.getSoggettoReferente().getTipo(), con, DriverRegistroServiziDB_LIB.tipoDB, tabellaSoggetti);
                stm.setLong(index++, idSRef);
            } else {
                stm.setLong(index++, 0L);
            }
            stm.setInt(index++, accordoServizio.getVersione());
            if (utenteUltimaModifica != null) {
                stm.setString(index++, utenteUltimaModifica);
            }
            if (dataUltimaModifica != null) {
                stm.setTimestamp(index++, dataUltimaModifica);
            }
            stm.setLong(index++, idAccordoLong);
            String msgDebug = "update accordoServizio : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, serviceBinding, messageType, confermaRicezione, conegnaInOrdine, descrizione, filtroDuplicati, identificativoCollaborazione, identificativoRiferimentoRichiesta, nome, profiloCollaborazione, scadenza, wsdlConcettuale, wsdlDefinitorio, wsdlLogicoErogatore, wsdlLogicoFruitore, conversazioneConcettuale, conversazioneErogatore, conversazioneFruitore, superUser, utilizzioSenzaAzione, idAccordoLong);
            DriverRegistroServiziDB_accordiLIB.logDebug(log, msgDebug);
            stm.executeUpdate();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            int n = stm.executeUpdate();
            stm.close();
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "Cancellate " + n + " azioni associate all'accordo " + idAccordoLong);
            for (int i2 = 0; i2 < accordoServizio.sizeAzioneList(); ++i2) {
                Azione azione = accordoServizio.getAzione(i2);
                String profiloAzione = azione.getProfAzione();
                if (profiloAzione != null && profiloAzione.equals("default")) {
                    azione.setProfiloCollaborazione(profiloCollaborazione);
                }
                DriverRegistroServiziDB_accordiSoapLIB.CRUDAzione(1, accordoServizio, azione, con, idAccordoLong, driverBYOK);
            }
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "Inserite " + accordoServizio.sizeAzioneList() + " azioni associate all'accordo " + idAccordoLong);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            ArrayList<Long> idPT = new ArrayList<Long>();
            while (rs.next()) {
                idPT.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "Trovati " + idPT.size() + " port type...");
            while (!idPT.isEmpty()) {
                Long idPortType = (Long)idPT.remove(0);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                rs = stm.executeQuery();
                ArrayList<Long> idPTAzione = new ArrayList<Long>();
                while (rs.next()) {
                    idPTAzione.add(rs.getLong("id"));
                }
                rs.close();
                stm.close();
                DriverRegistroServiziDB_accordiLIB.logDebug(log, "Trovati " + idPTAzione.size() + " port type azioni...");
                while (!idPTAzione.isEmpty()) {
                    Long idPortTypeAzione = (Long)idPTAzione.remove(0);
                    DriverRegistroServiziDB_accordiLIB.logDebug(log, "Eliminazione message con id[" + idPortTypeAzione + "]...");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortTypeAzione);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverRegistroServiziDB_accordiLIB.logDebug(log, "Cancellate " + n + " messages di un'azione con id[" + idPortTypeAzione + "] del port type [" + idPortType + "] associate all'accordo " + idAccordoLong);
                }
                DriverRegistroServiziDB_accordiLIB.logDebug(log, "Elimino port type azione del port types [" + idPortType + "]...");
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                sqlQueryObject.addDeleteTable("port_type_azioni");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                n = stm.executeUpdate();
                stm.close();
                DriverRegistroServiziDB_accordiLIB.logDebug(log, "Cancellate " + n + " azioni del port type [" + idPortType + "] associate all'accordo " + idAccordoLong);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            n = stm.executeUpdate();
            stm.close();
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "Cancellate " + n + " port type associate all'accordo " + idAccordoLong);
            PortType pt = null;
            for (int i3 = 0; i3 < accordoServizio.sizePortTypeList(); ++i3) {
                pt = accordoServizio.getPortType(i3);
                DriverRegistroServiziDB_accordiSoapLIB.CRUDPortType(1, accordoServizio, pt, con, idAccordoLong, driverBYOK);
            }
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "inserite " + accordoServizio.sizePortTypeList() + " porttype relative all'accordo :" + nome + " id :" + idAccordoLong);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("api_resources");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            ArrayList<Long> idResources = new ArrayList<Long>();
            while (rs.next()) {
                idResources.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            n = 0;
            while (!idResources.isEmpty()) {
                Long idR = (Long)idResources.remove(0);
                Resource resource = new Resource();
                resource.setId(idR);
                n += DriverRegistroServiziDB_accordiRestLIB.CRUDResource(3, accordoServizio, resource, con, idAccordoLong, driverBYOK);
            }
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "Cancellate " + n + " resources associate all'accordo :" + nome + " id :" + idAccordoLong);
            Resource resource = null;
            for (int i4 = 0; i4 < accordoServizio.sizeResourceList(); ++i4) {
                resource = accordoServizio.getResource(i4);
                DriverRegistroServiziDB_accordiRestLIB.CRUDResource(1, accordoServizio, resource, con, idAccordoLong, driverBYOK);
            }
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "inserite " + accordoServizio.sizeResourceList() + " resources relative all'accordo :" + nome + " id :" + idAccordoLong);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("accordi_gruppi");
            sqlQueryObject.addFromTable("gruppi");
            sqlQueryObject.addSelectAliasField("gruppi", "id", "identificativoGruppo");
            sqlQueryObject.addSelectAliasField("gruppi", "nome", "nomeGruppo");
            sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo = gruppi.id");
            sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            ArrayList<GruppoAccordo> gruppi = new ArrayList<GruppoAccordo>();
            while (rs.next()) {
                gruppo = new GruppoAccordo();
                gruppo.setNome(rs.getString("nomeGruppo"));
                gruppo.setId(rs.getLong("identificativoGruppo"));
                gruppi.add(gruppo);
            }
            rs.close();
            stm.close();
            while (!gruppi.isEmpty()) {
                gruppo = (GruppoAccordo)gruppi.remove(0);
                DriverRegistroServiziDB_accordiLIB.CRUDAccordoGruppo(3, accordoServizio, gruppo, con, idAccordoLong);
            }
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "Cancellate " + n + " resources associate all'accordo :" + nome + " id :" + idAccordoLong);
            if (accordoServizio.getGruppi() != null && accordoServizio.getGruppi().sizeGruppoList() > 0) {
                for (int i5 = 0; i5 < accordoServizio.getGruppi().sizeGruppoList(); ++i5) {
                    GruppoAccordo gruppo2 = accordoServizio.getGruppi().getGruppo(i5);
                    DriverRegistroServiziDB_accordiLIB.CRUDAccordoGruppo(1, accordoServizio, gruppo2, con, idAccordoLong);
                }
                DriverRegistroServiziDB_accordiLIB.logDebug(log, "inserite " + accordoServizio.sizeAzioneList() + " gruppi relative all'accordo :" + nome + " id :" + idAccordoLong);
            }
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_accordiCooperazioneLIB.CRUDAccordoServizioParteComuneServizioComposto(3, null, con, idAccordoLong);
                DriverRegistroServiziDB_accordiCooperazioneLIB.CRUDAccordoServizioParteComuneServizioComposto(1, accordoServizio.getServizioComposto(), con, idAccordoLong);
            } else {
                DriverRegistroServiziDB_accordiCooperazioneLIB.CRUDAccordoServizioParteComuneServizioComposto(3, null, con, idAccordoLong);
            }
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            for (i = 0; i < accordoServizio.sizeAllegatoList(); ++i) {
                doc = accordoServizio.getAllegato(i);
                doc.setRuolo(RuoliDocumento.allegato.toString());
                documenti.add(doc);
            }
            for (i = 0; i < accordoServizio.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizio.getSpecificaSemiformale(i);
                doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                documenti.add(doc);
            }
            if (accordoServizio.getServizioComposto() != null) {
                for (i = 0; i < accordoServizio.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                    doc = accordoServizio.getServizioComposto().getSpecificaCoordinamento(i);
                    doc.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                    documenti.add(doc);
                }
            }
            DriverRegistroServiziDB_documentiLIB.CRUDDocumento(2, documenti, idAccordoLong, ProprietariDocumento.accordoServizio, con, DriverRegistroServiziDB_LIB.tipoDB);
            DriverRegistroServiziDB_LIB.CRUDProtocolProperty(2, accordoServizio.getProtocolPropertyList(), idAccordoLong, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
        }
        catch (SQLException se) {
            try {
                DriverRegistroServiziDB_accordiLIB.logError(log, se.getMessage(), se);
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizio] SQLException [" + se.getMessage() + "].", se);
                catch (Exception se2) {
                    DriverRegistroServiziDB_accordiLIB.logError(log, se2.getMessage(), se2);
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizio] Exception [" + se2.getMessage() + "].", se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
    }

    public static long CRUDAccordoGruppo(int type, AccordoServizioParteComune as, GruppoAccordo gruppo, Connection con, long idAccordo) throws DriverRegistroServiziException {
        PreparedStatement updateStmt = null;
        long n = 0L;
        if (idAccordo <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoGruppo] ID Accordo non valido.");
        }
        try {
            IDGruppo idGruppo = new IDGruppo(gruppo.getNome());
            long idGruppoLong = DBUtils.getIdGruppo(idGruppo, con, DriverRegistroServiziDB_LIB.tipoDB);
            if (idGruppoLong <= 0L) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoGruppo] Gruppo con nome '" + idGruppo.getNome() + "' non esistente.");
            }
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("accordi_gruppi");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("id_gruppo", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setLong(index++, idAccordo);
                    updateStmt.setLong(index++, idGruppoLong);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoGruppo CREATE :\n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idAccordo, idGruppoLong));
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoGruppo type = " + type + " row affected =" + n);
                    break;
                }
                case 2: {
                    throw new DriverRegistroServiziException("Non supportato");
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_gruppi");
                    sqlQueryObject.addWhereCondition("id_accordo=?");
                    sqlQueryObject.addWhereCondition("id_gruppo=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    int index = 1;
                    updateStmt.setLong(index++, idAccordo);
                    updateStmt.setLong(index++, idGruppoLong);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDAccordoGruppo type = " + type + " row affected =" + n);
                }
            }
            long l = n;
            return l;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoGruppo] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoGruppo] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    public static ISQLQueryObject getSQLRicercaAccordiValidi() throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addWhereExistsCondition(false, DriverRegistroServiziDB_accordiLIB.getSQLRicercaServiziValidi("accordi.id", false));
        return sqlQueryObject;
    }

    public static ISQLQueryObject getSQLRicercaServiziValidiByIdAccordo(boolean isErogazione) throws Exception {
        return DriverRegistroServiziDB_accordiLIB.getSQLRicercaServiziValidi("?", isErogazione);
    }

    private static ISQLQueryObject getSQLRicercaServiziValidi(String idAccordo, boolean isErogazione) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
        sqlQueryObject.addFromTable("port_type");
        sqlQueryObject.addWhereCondition("port_type.id_accordo=" + idAccordo);
        ISQLQueryObject sqlQueryObjectExistsAlmenoUnAzione = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
        sqlQueryObjectExistsAlmenoUnAzione.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAlmenoUnAzione.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExistsAlmenoUnAzione);
        ISQLQueryObject sqlQueryServiziValidi = DriverRegistroServiziDB_accordiLIB.getSQLIndividuazioneServiziValidi(DriverRegistroServiziDB_LIB.tipoDB, isErogazione);
        sqlQueryObject.addWhereCondition("( " + sqlQueryServiziValidi.createSQLConditions() + " )");
        sqlQueryObject.setANDLogicOperator(true);
        return sqlQueryObject;
    }

    public static ISQLQueryObject getSQLIndividuazioneServiziValidi(String tipoDatabase, boolean isErogazione) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObject.addWhereCondition("port_type.profilo_collaborazione='oneway'");
        sqlQueryObject.addWhereCondition("port_type.profilo_collaborazione='sincrono'");
        ISQLQueryObject sqlQueryObjectExistsAsinAsimRichiesta = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinAsimRichiesta.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinAsimRichiesta.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinAsimRichiesta.addWhereCondition("port_type_azioni.correlata_servizio is null");
        sqlQueryObjectExistsAsinAsimRichiesta.addWhereCondition("port_type_azioni.correlata is null");
        sqlQueryObjectExistsAsinAsimRichiesta.setANDLogicOperator(true);
        ISQLQueryObject sqlQueryObjectExistsAsinAsimRisposta = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinAsimRisposta.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereCondition("port_type_azioni.correlata_servizio is not null");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereCondition("port_type_azioni.correlata_servizio=port_type.nome");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereCondition("port_type_azioni.correlata is not null");
        ISQLQueryObject sqlQueryObjectExistsAsinAsimRispostaCheckCorrelata = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinAsimRispostaCheckCorrelata.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinAsimRispostaCheckCorrelata.addSelectField("port_type_azioni", "nome");
        sqlQueryObjectExistsAsinAsimRispostaCheckCorrelata.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereINSelectSQLCondition(false, "port_type_azioni.correlata", sqlQueryObjectExistsAsinAsimRispostaCheckCorrelata);
        sqlQueryObjectExistsAsinAsimRisposta.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition(true, new String[]{"port_type.profilo_collaborazione='asincronoAsimmetrico'", sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinAsimRichiesta), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinAsimRisposta)});
        ISQLQueryObject sqlQueryObjectExistsAsinSimRichiesta = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinSimRichiesta.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinSimRichiesta.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinSimRichiesta.addWhereCondition("port_type_azioni.correlata_servizio is null");
        sqlQueryObjectExistsAsinSimRichiesta.addWhereCondition("port_type_azioni.correlata is null");
        sqlQueryObjectExistsAsinSimRichiesta.setANDLogicOperator(true);
        ISQLQueryObject sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        String portTypeAliasRicerca = "ptRicerca2";
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addFromTable("port_type as " + portTypeAliasRicerca);
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addWhereCondition(portTypeAliasRicerca + ".id_accordo=port_type.id_accordo");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addWhereCondition(portTypeAliasRicerca + ".profilo_collaborazione='asincronoSimmetrico'");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addWhereCondition(portTypeAliasRicerca + ".nome <> port_type.nome");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addWhereCondition("port_type_azioni.id_port_type=" + portTypeAliasRicerca + ".id");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addWhereCondition("port_type_azioni.correlata_servizio is not null");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addWhereCondition("port_type_azioni.correlata_servizio=port_type.nome");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addWhereCondition("port_type_azioni.correlata is not null");
        ISQLQueryObject sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazioneCheckAzione = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazioneCheckAzione.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazioneCheckAzione.addSelectField("port_type_azioni", "nome");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazioneCheckAzione.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.addWhereINSelectSQLCondition(false, "port_type_azioni.correlata", sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazioneCheckAzione);
        sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition(true, new String[]{"port_type.profilo_collaborazione='asincronoSimmetrico'", sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinSimRichiesta), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinSimRichiestaCheckCorrelazione)});
        if (!isErogazione) {
            ISQLQueryObject sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            String portTypeAliasRicercaAs = "ptRicerca2";
            String portTypeAzioniAliasRicercaAs = "ptAzioniRicerca2";
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addFromTable("port_type as " + portTypeAliasRicercaAs);
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addFromTable("port_type_azioni as " + portTypeAzioniAliasRicercaAs);
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addWhereCondition(portTypeAliasRicercaAs + ".id_accordo=port_type.id_accordo");
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addWhereCondition(portTypeAliasRicercaAs + ".profilo_collaborazione='asincronoSimmetrico'");
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addWhereCondition(portTypeAliasRicercaAs + ".nome <> port_type.nome");
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addWhereCondition(portTypeAzioniAliasRicercaAs + ".id_port_type=" + portTypeAliasRicercaAs + ".id");
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addWhereCondition(portTypeAzioniAliasRicercaAs + ".correlata_servizio is null");
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addWhereCondition(portTypeAliasRicercaAs + ".nome=port_type_azioni.correlata_servizio");
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addWhereCondition(portTypeAzioniAliasRicercaAs + ".correlata is null");
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.addWhereCondition(portTypeAzioniAliasRicercaAs + ".nome=port_type_azioni.correlata");
            sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObjectExistsAsinSimRisposta = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectExistsAsinSimRisposta.addFromTable("port_type_azioni");
            sqlQueryObjectExistsAsinSimRisposta.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
            sqlQueryObjectExistsAsinSimRisposta.addWhereCondition("port_type_azioni.correlata is not null");
            sqlQueryObjectExistsAsinSimRisposta.addWhereCondition("port_type_azioni.correlata_servizio is not null");
            sqlQueryObjectExistsAsinSimRisposta.addWhereExistsCondition(false, sqlQueryObjectExistsAsinSimRispostaCheckCorrelazione);
            sqlQueryObjectExistsAsinSimRisposta.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(true, new String[]{"port_type.profilo_collaborazione='asincronoSimmetrico'", sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinSimRisposta)});
        }
        sqlQueryObject.setANDLogicOperator(false);
        return sqlQueryObject;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizio, Connection con, String tabellaSoggetti, Logger log, IDAccordoFactory idAccordoFactory, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        if (tabellaSoggetti != null) {
            // empty if block
        }
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException(ACCORDO_DIVERSO_NULL);
        }
        String nome = accordoServizio.getNome();
        if (nome == null) throw new DriverRegistroServiziException(NOME_ACCORDO_NON_VALIDO);
        if (nome.equals("")) {
            throw new DriverRegistroServiziException(NOME_ACCORDO_NON_VALIDO);
        }
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        try {
            GruppoAccordo gruppo;
            IDAccordo idAccordo = idAccordoFactory.getIDAccordoFromValues(nome, BeanUtilities.getSoggettoReferenteID(accordoServizio.getSoggettoReferente()), accordoServizio.getVersione());
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, DriverRegistroServiziDB_LIB.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Servizio : " + nome);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "delete azioni :" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            int n = stm.executeUpdate();
            stm.close();
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "cancellate " + n + " azioni.");
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            ArrayList<Long> idPT = new ArrayList<Long>();
            while (rs.next()) {
                idPT.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            while (!idPT.isEmpty()) {
                Long idPortType = (Long)idPT.remove(0);
                ArrayList<Long> idPortTypeAzioni = new ArrayList<Long>();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idPortTypeAzioni.add(rs.getLong("id"));
                }
                rs.close();
                stm.close();
                while (!idPortTypeAzioni.isEmpty()) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, (Long)idPortTypeAzioni.remove(0));
                    n = stm.executeUpdate();
                    stm.close();
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                sqlQueryObject.addDeleteTable("port_type_azioni");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                n = stm.executeUpdate();
                stm.close();
                DriverRegistroServiziDB_accordiLIB.logDebug(log, "Cancellate " + n + " azioni del port type [" + idPortType + "] associate all'accordo " + idAccordoLong);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            n = stm.executeUpdate();
            stm.close();
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "Cancellate " + n + " port type associate all'accordo " + idAccordoLong);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("api_resources");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            ArrayList<Long> idResources = new ArrayList<Long>();
            while (rs.next()) {
                idResources.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            while (!idResources.isEmpty()) {
                Long idR = (Long)idResources.remove(0);
                Resource resource = new Resource();
                resource.setId(idR);
                DriverRegistroServiziDB_accordiRestLIB.CRUDResource(3, accordoServizio, resource, con, idAccordoLong, driverBYOK);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("accordi_gruppi");
            sqlQueryObject.addFromTable("gruppi");
            sqlQueryObject.addSelectAliasField("gruppi", "id", "identificativoGruppo");
            sqlQueryObject.addSelectAliasField("gruppi", "nome", "nomeGruppo");
            sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo = gruppi.id");
            sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            ArrayList<GruppoAccordo> gruppi = new ArrayList<GruppoAccordo>();
            while (rs.next()) {
                gruppo = new GruppoAccordo();
                gruppo.setNome(rs.getString("nomeGruppo"));
                gruppo.setId(rs.getLong("identificativoGruppo"));
                gruppi.add(gruppo);
            }
            rs.close();
            stm.close();
            while (!gruppi.isEmpty()) {
                gruppo = (GruppoAccordo)gruppi.remove(0);
                DriverRegistroServiziDB_accordiLIB.CRUDAccordoGruppo(3, accordoServizio, gruppo, con, idAccordoLong);
            }
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "Cancellate " + n + " resources associate all'accordo :" + nome + " id :" + idAccordoLong);
            DriverRegistroServiziDB_documentiLIB.CRUDDocumento(3, null, idAccordoLong, ProprietariDocumento.accordoServizio, con, DriverRegistroServiziDB_LIB.tipoDB);
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_accordiCooperazioneLIB.CRUDAccordoServizioParteComuneServizioComposto(3, accordoServizio.getServizioComposto(), con, idAccordoLong);
            } else {
                DriverRegistroServiziDB_accordiCooperazioneLIB.CRUDAccordoServizioParteComuneServizioComposto(3, null, con, idAccordoLong);
            }
            DriverRegistroServiziDB_LIB.CRUDProtocolProperty(3, null, idAccordoLong, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, con, DriverRegistroServiziDB_LIB.tipoDB, driverBYOK);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addDeleteTable("accordi");
            sqlQueryObject.addWhereCondition("id=?");
            updateString = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            DriverRegistroServiziDB_accordiLIB.logDebug(log, "delete accordoServizio :" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            stm.executeUpdate();
            stm.close();
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizio] SQLException [" + se.getMessage() + "].", se);
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizio] Exception [" + se2.getMessage() + "].", se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
    }
}

