/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazionePartecipanti;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_documentiLIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiCooperazioneLIB {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDAccordoServizioParteComuneServizioComposto(int type, AccordoServizioParteComuneServizioComposto asServComposto, Connection con, long idAccordo) throws DriverRegistroServiziException {
        PreparedStatement updateStmt = null;
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        if (idAccordo <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID Accordo non valido.");
        }
        try {
            switch (type) {
                case 1: {
                    if (asServComposto == null) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] Accordo Cooperazione non valido.");
                    }
                    long idAccordoCooperazione = -1L;
                    if (asServComposto.getIdAccordoCooperazione() != null) {
                        idAccordoCooperazione = asServComposto.getIdAccordoCooperazione();
                    }
                    if (asServComposto.getAccordoCooperazione() != null) {
                        idAccordoCooperazione = DBUtils.getIdAccordoCooperazione(IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(asServComposto.getAccordoCooperazione()), con, DriverRegistroServiziDB_LIB.tipoDB);
                    }
                    if (idAccordoCooperazione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] idAccordoCooperazione non fornito");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("acc_serv_composti");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("id_accordo_cooperazione", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordo);
                    updateStmt.setLong(2, idAccordoCooperazione);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.log.debug("Aggiungo acc servizio composto");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("acc_serv_composti");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_accordo=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLQuery();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordo);
                    selectRS = updateStmt.executeQuery();
                    long idAccServComposto = -1L;
                    if (!selectRS.next()) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID AccordoServizioComposto inserito non recuperato.");
                    idAccServComposto = selectRS.getLong("id");
                    asServComposto.setId(idAccServComposto);
                    selectRS.close();
                    updateStmt.close();
                    int i = 0;
                    while (i < asServComposto.sizeServizioComponenteList()) {
                        AccordoServizioParteComuneServizioCompostoServizioComponente tmp = asServComposto.getServizioComponente(i);
                        long idServizioComponente = -1L;
                        if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                            DriverRegistroServiziDB_LIB.log.debug("Provo a recuperare l'id del servizio con tipo/nome soggetto erogatore [" + tmp.getTipoSoggetto() + "/" + tmp.getNomeSoggetto() + "] e tipo/nome servizio [" + tmp.getTipo() + "/" + tmp.getNome() + "]");
                            if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                                idServizioComponente = DBUtils.getIdServizio(tmp.getNome(), tmp.getTipo(), tmp.getVersione(), tmp.getNomeSoggetto(), tmp.getTipoSoggetto(), con, DriverRegistroServiziDB_LIB.tipoDB);
                            }
                        }
                        if (idServizioComponente <= 0L) {
                            idServizioComponente = tmp.getIdServizioComponente();
                        }
                        if (idServizioComponente <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID ServizioComponente non definito.");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("acc_serv_componenti");
                        sqlQueryObject.addInsertField("id_servizio_composto", "?");
                        sqlQueryObject.addInsertField("id_servizio_componente", "?");
                        sqlQueryObject.addInsertField("azione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccServComposto);
                        updateStmt.setLong(2, idServizioComponente);
                        updateStmt.setString(3, tmp.getAzione());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        DriverRegistroServiziDB_LIB.log.debug("Aggiunto acc servizio componente");
                        ++i;
                    }
                    return;
                }
                case 2: {
                    if (asServComposto == null) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] Accordo Cooperazione non valido.");
                    }
                    long idAccServComposto = asServComposto.getId();
                    if (idAccServComposto <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID AccordoServizioComposto non definito.");
                    }
                    long idAccordoCooperazione = -1L;
                    if (asServComposto.getIdAccordoCooperazione() != null) {
                        idAccordoCooperazione = asServComposto.getIdAccordoCooperazione();
                    }
                    if (asServComposto.getAccordoCooperazione() != null) {
                        idAccordoCooperazione = DBUtils.getIdAccordoCooperazione(IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(asServComposto.getAccordoCooperazione()), con, DriverRegistroServiziDB_LIB.tipoDB);
                    }
                    if (idAccordoCooperazione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] idAccordoCooperazione non fornito");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addUpdateTable("acc_serv_composti");
                    sqlQueryObject.addUpdateField("id_accordo_cooperazione", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoCooperazione);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.log.debug("Aggiornato acc servizio composto");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("acc_serv_componenti");
                    sqlQueryObject.addWhereCondition("id_servizio_composto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccServComposto);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    int i = 0;
                    while (i < asServComposto.sizeServizioComponenteList()) {
                        AccordoServizioParteComuneServizioCompostoServizioComponente tmp = asServComposto.getServizioComponente(i);
                        long idServizioComponente = -1L;
                        if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                            DriverRegistroServiziDB_LIB.log.debug("Provo a recuperare l'id del servizio con tipo/nome soggetto erogatore [" + tmp.getTipoSoggetto() + "/" + tmp.getNomeSoggetto() + "] e tipo/nome servizio [" + tmp.getTipo() + "/" + tmp.getNome() + "]");
                            if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                                idServizioComponente = DBUtils.getIdServizio(tmp.getNome(), tmp.getTipo(), tmp.getVersione(), tmp.getNomeSoggetto(), tmp.getTipoSoggetto(), con, DriverRegistroServiziDB_LIB.tipoDB);
                            }
                        }
                        if (idServizioComponente <= 0L) {
                            idServizioComponente = tmp.getIdServizioComponente();
                        }
                        if (idServizioComponente <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID ServizioComponente non definito.");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("acc_serv_componenti");
                        sqlQueryObject.addInsertField("id_servizio_composto", "?");
                        sqlQueryObject.addInsertField("id_servizio_componente", "?");
                        sqlQueryObject.addInsertField("azione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccServComposto);
                        updateStmt.setLong(2, idServizioComponente);
                        updateStmt.setString(3, tmp.getAzione());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        DriverRegistroServiziDB_LIB.log.debug("Aggiungo acc servizio componente");
                        ++i;
                    }
                    return;
                }
                case 3: {
                    String updateQuery;
                    ISQLQueryObject sqlQueryObject;
                    long idAccServComposto = -1L;
                    if (asServComposto != null) {
                        idAccServComposto = asServComposto.getId();
                        if (idAccServComposto <= 0L) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addFromTable("acc_serv_composti");
                            sqlQueryObject.addSelectField("id");
                            sqlQueryObject.addWhereCondition("id_accordo=?");
                            updateQuery = sqlQueryObject.createSQLQuery();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, idAccordo);
                            selectRS = updateStmt.executeQuery();
                            if (selectRS.next()) {
                                idAccServComposto = selectRS.getLong("id");
                            }
                            selectRS.close();
                            updateStmt.close();
                            if (idAccServComposto <= 0L) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID AccordoServizioComposto non definito e non recuperabile.");
                            }
                        }
                    } else {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addFromTable("acc_serv_composti");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_accordo=?");
                        updateQuery = sqlQueryObject.createSQLQuery();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccordo);
                        selectRS = updateStmt.executeQuery();
                        if (selectRS.next()) {
                            idAccServComposto = selectRS.getLong("id");
                        }
                        selectRS.close();
                        updateStmt.close();
                    }
                    if (idAccServComposto <= 0L) return;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("acc_serv_componenti");
                    sqlQueryObject.addWhereCondition("id_servizio_composto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccServComposto);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("acc_serv_composti");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccServComposto);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDAccordoCooperazione(int type, AccordoCooperazione accordoCooperazione, Connection con, String tipoDatabase, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Accordo di Cooperazione non valido.");
        }
        String nome = accordoCooperazione.getNome();
        String descrizione = accordoCooperazione.getDescrizione();
        String stato = accordoCooperazione.getStatoPackage();
        boolean privato = accordoCooperazione.getPrivato() != null && accordoCooperazione.getPrivato() != false;
        String superUser = accordoCooperazione.getSuperUser();
        if (nome == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Parametro Nome non valido.");
        if (nome.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Parametro Nome non valido.");
        }
        IDSoggetto soggettoReferente = null;
        if (accordoCooperazione.getSoggettoReferente() != null) {
            soggettoReferente = new IDSoggetto(accordoCooperazione.getSoggettoReferente().getTipo(), accordoCooperazione.getSoggettoReferente().getNome());
        }
        PreparedStatement updateStmt = null;
        ResultSet updateRS = null;
        try {
            switch (type) {
                case 1: {
                    Documento doc;
                    int i;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("accordi_cooperazione");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("versione", "?");
                    sqlQueryObject.addInsertField("privato", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (stato != null) {
                        sqlQueryObject.addInsertField("stato", "?");
                    }
                    if (accordoCooperazione.getSoggettoReferente() != null) {
                        sqlQueryObject.addInsertField("id_referente", "?");
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setInt(3, accordoCooperazione.getVersione());
                    if (privato) {
                        updateStmt.setInt(4, 1);
                    } else {
                        updateStmt.setInt(4, 0);
                    }
                    updateStmt.setString(5, superUser);
                    int index = 6;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (accordoCooperazione.getSoggettoReferente() != null) {
                        long idReferente = DBUtils.getIdSoggetto(accordoCooperazione.getSoggettoReferente().getNome(), accordoCooperazione.getSoggettoReferente().getTipo(), con, DriverRegistroServiziDB_LIB.tipoDB);
                        if (idReferente <= 0L) {
                            throw new DriverRegistroServiziException("Soggetto Referente [" + accordoCooperazione.getSoggettoReferente().getTipo() + "/" + accordoCooperazione.getSoggettoReferente().getNome() + "] non trovato");
                        }
                        updateStmt.setLong(index, idReferente);
                        ++index;
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(accordoCooperazione.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    int n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.log.debug("CRUDAccordoServizioParteSpecifica CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione));
                    DriverRegistroServiziDB_LIB.log.debug("CRUDAccordoServizioParteSpecifica type = " + type + " row affected =" + n);
                    IDAccordoCooperazione idAccordoObject = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromValues(accordoCooperazione.getNome(), soggettoReferente, accordoCooperazione.getVersione());
                    long idAccordoCooperazione = DBUtils.getIdAccordoCooperazione(idAccordoObject, con, DriverRegistroServiziDB_LIB.tipoDB);
                    if (idAccordoCooperazione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB::CRUDAccordoCooperazione] non riesco a trovare l'id del'Accordo inserito");
                    }
                    accordoCooperazione.setId(idAccordoCooperazione);
                    if (accordoCooperazione.getElencoPartecipanti() != null) {
                        AccordoCooperazionePartecipanti partecipanti = accordoCooperazione.getElencoPartecipanti();
                        for (i = 0; i < partecipanti.sizeSoggettoPartecipanteList(); ++i) {
                            IdSoggetto soggettoPartecipante = partecipanti.getSoggettoPartecipante(i);
                            long idSoggettoPartecipante = -1L;
                            if (idSoggettoPartecipante <= 0L) {
                                DriverRegistroServiziDB_LIB.log.debug("Provo a recuperare l'id del soggetto con tipo/nome [" + soggettoPartecipante.getTipo() + "]/[" + soggettoPartecipante.getNome() + "]");
                                if (soggettoPartecipante.getTipo() != null && soggettoPartecipante.getNome() != null) {
                                    idSoggettoPartecipante = DBUtils.getIdSoggetto(soggettoPartecipante.getNome(), soggettoPartecipante.getTipo(), con, DriverRegistroServiziDB_LIB.tipoDB);
                                }
                            }
                            if (idSoggettoPartecipante <= 0L) {
                                idSoggettoPartecipante = soggettoPartecipante.getIdSoggetto();
                            }
                            if (idSoggettoPartecipante <= 0L) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::CRUDAccordoCooperazione] idSoggettoPartecipante non presente");
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addInsertTable("accordi_coop_partecipanti");
                            sqlQueryObject.addInsertField("id_accordo_cooperazione", "?");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, idAccordoCooperazione);
                            updateStmt.setLong(2, idSoggettoPartecipante);
                            n = updateStmt.executeUpdate();
                            updateStmt.close();
                            DriverRegistroServiziDB_LIB.log.debug("CRUDAccordoCooperazione (servizioComposto) type = " + type + " row affected =" + n);
                        }
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < accordoCooperazione.sizeAllegatoList(); ++i) {
                        doc = accordoCooperazione.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    i = 0;
                    while (true) {
                        if (i >= accordoCooperazione.sizeSpecificaSemiformaleList()) {
                            DriverRegistroServiziDB_documentiLIB.CRUDDocumento(1, documenti, idAccordoCooperazione, ProprietariDocumento.accordoCooperazione, con, tipoDatabase);
                            DriverRegistroServiziDB_LIB.CRUDProtocolProperty(1, accordoCooperazione.getProtocolPropertyList(), idAccordoCooperazione, ProprietariProtocolProperty.ACCORDO_COOPERAZIONE, con, tipoDatabase, driverBYOK);
                            return;
                        }
                        doc = accordoCooperazione.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                        ++i;
                    }
                }
                case 2: {
                    int i;
                    IDAccordoCooperazione idAccordoAttualeInseritoDB = null;
                    idAccordoAttualeInseritoDB = accordoCooperazione.getOldIDAccordoForUpdate() != null ? accordoCooperazione.getOldIDAccordoForUpdate() : IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromAccordo(accordoCooperazione);
                    long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordoAttualeInseritoDB, con, DriverRegistroServiziDB_LIB.tipoDB);
                    if (idAccordoLong <= 0L) {
                        throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Cooperazione : " + nome);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addUpdateTable("accordi_cooperazione");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("versione", "?");
                    sqlQueryObject.addUpdateField("privato", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    sqlQueryObject.addUpdateField("id_referente", "?");
                    if (stato != null) {
                        sqlQueryObject.addUpdateField("stato", "?");
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setInt(3, accordoCooperazione.getVersione());
                    if (privato) {
                        updateStmt.setInt(4, 1);
                    } else {
                        updateStmt.setInt(4, 0);
                    }
                    updateStmt.setString(5, superUser);
                    int index = 6;
                    if (accordoCooperazione.getSoggettoReferente() != null) {
                        long idSRef = DBUtils.getIdSoggetto(accordoCooperazione.getSoggettoReferente().getNome(), accordoCooperazione.getSoggettoReferente().getTipo(), con, DriverRegistroServiziDB_LIB.tipoDB);
                        updateStmt.setLong(index, idSRef);
                    } else {
                        updateStmt.setLong(index, 0L);
                    }
                    ++index;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(accordoCooperazione.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    updateStmt.setLong(index, idAccordoLong);
                    int n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.log.debug("CRUDAccordoCooperazione type = " + type + " row affected =" + n);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_coop_partecipanti");
                    sqlQueryObject.addWhereCondition("id_accordo_cooperazione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoLong);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (accordoCooperazione.getElencoPartecipanti() != null) {
                        AccordoCooperazionePartecipanti partecipanti = accordoCooperazione.getElencoPartecipanti();
                        for (int i2 = 0; i2 < partecipanti.sizeSoggettoPartecipanteList(); ++i2) {
                            IdSoggetto soggettoPartecipante = partecipanti.getSoggettoPartecipante(i2);
                            Long idSoggettoPartecipante = -1L;
                            if (idSoggettoPartecipante == null || idSoggettoPartecipante <= 0L) {
                                DriverRegistroServiziDB_LIB.log.debug("Provo a recuperare l'id del soggetto con tipo/nome [" + soggettoPartecipante.getTipo() + "]/[" + soggettoPartecipante.getNome() + "]");
                                if (soggettoPartecipante.getTipo() != null && soggettoPartecipante.getNome() != null) {
                                    idSoggettoPartecipante = DBUtils.getIdSoggetto(soggettoPartecipante.getNome(), soggettoPartecipante.getTipo(), con, DriverRegistroServiziDB_LIB.tipoDB);
                                }
                            }
                            if (idSoggettoPartecipante <= 0L) {
                                idSoggettoPartecipante = soggettoPartecipante.getIdSoggetto();
                            }
                            if (idSoggettoPartecipante <= 0L) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::CRUDAccordoCooperazione] idSoggettoPartecipante non presente");
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addInsertTable("accordi_coop_partecipanti");
                            sqlQueryObject.addInsertField("id_accordo_cooperazione", "?");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, idAccordoLong);
                            updateStmt.setLong(2, idSoggettoPartecipante);
                            n = updateStmt.executeUpdate();
                            updateStmt.close();
                            DriverRegistroServiziDB_LIB.log.debug("CRUDAccordoCooperazione (servizioComposto) type = " + type + " row affected =" + n);
                        }
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < accordoCooperazione.sizeAllegatoList(); ++i) {
                        Documento doc = accordoCooperazione.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    i = 0;
                    while (true) {
                        if (i >= accordoCooperazione.sizeSpecificaSemiformaleList()) {
                            DriverRegistroServiziDB_documentiLIB.CRUDDocumento(2, documenti, idAccordoLong, ProprietariDocumento.accordoCooperazione, con, tipoDatabase);
                            DriverRegistroServiziDB_LIB.CRUDProtocolProperty(2, accordoCooperazione.getProtocolPropertyList(), idAccordoLong, ProprietariProtocolProperty.ACCORDO_COOPERAZIONE, con, tipoDatabase, driverBYOK);
                            return;
                        }
                        Documento doc = accordoCooperazione.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                        ++i;
                    }
                }
                case 3: {
                    IDAccordoCooperazione idAccordo = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromValues(nome, soggettoReferente, accordoCooperazione.getVersione());
                    long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordo, con, DriverRegistroServiziDB_LIB.tipoDB);
                    if (idAccordoLong <= 0L) {
                        throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Cooperazione : " + nome);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_coop_partecipanti");
                    sqlQueryObject.addWhereCondition("id_accordo_cooperazione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoLong);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_documentiLIB.CRUDDocumento(3, null, idAccordoLong, ProprietariDocumento.accordoCooperazione, con, tipoDatabase);
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(3, null, idAccordoLong, ProprietariProtocolProperty.ACCORDO_COOPERAZIONE, con, tipoDatabase, driverBYOK);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_cooperazione");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoLong);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
            }
            return;
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException(e);
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateRS, updateStmt);
        }
    }
}

