/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazionePartecipanti;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiCooperazioneLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_documentiLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_protocolPropertiesDriver;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiCooperazioneDriver {
    private DriverRegistroServiziDB driver = null;
    private DriverRegistroServiziDB_protocolPropertiesDriver protocolPropertiesDriver = null;

    protected DriverRegistroServiziDB_accordiCooperazioneDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
        this.protocolPropertiesDriver = new DriverRegistroServiziDB_protocolPropertiesDriver(driver);
    }

    protected AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(idAccordo, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoCooperazione accordoCooperazione;
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo.getNome non e' definito");
        }
        this.driver.logDebug("richiesto getAccordoCooperazione: " + idAccordo.toString());
        AccordoCooperazione accordoCooperazione2 = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        PreparedStatement stm2 = null;
        ResultSet rs2 = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAccordoCooperazione(idAccordo)") : this.driver.globalConnection;
            long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordo, con, this.driver.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] Accordo non trovato (id:" + idAccordoLong + ")");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            }
            accordoCooperazione2 = new AccordoCooperazione();
            accordoCooperazione2.setId(rs.getLong("id"));
            String tmp = rs.getString("nome");
            accordoCooperazione2.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("descrizione");
            accordoCooperazione2.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            long id_referente = rs.getLong("id_referente");
            if (id_referente > 0L) {
                IDSoggetto soggettoReferente = null;
                try {
                    soggettoReferente = this.driver.getIdSoggetto(id_referente, con);
                    if (soggettoReferente == null) {
                        throw new DriverRegistroServiziNotFound("non esiste");
                    }
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    throw new Exception("Soggetto referente [" + id_referente + "] dell'accordo non esiste");
                }
                IdSoggetto assr = new IdSoggetto();
                assr.setTipo(soggettoReferente.getTipo());
                assr.setNome(soggettoReferente.getNome());
                accordoCooperazione2.setSoggettoReferente(assr);
            }
            if (rs.getString("versione") != null && !"".equals(rs.getString("versione"))) {
                accordoCooperazione2.setVersione(rs.getInt("versione"));
            }
            accordoCooperazione2.setStatoPackage((tmp = rs.getString("stato")) == null || tmp.equals("") ? null : tmp);
            if (rs.getInt("privato") == 1) {
                accordoCooperazione2.setPrivato(true);
            } else {
                accordoCooperazione2.setPrivato(false);
            }
            tmp = rs.getString("superuser");
            accordoCooperazione2.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getTimestamp("ora_registrazione") != null) {
                accordoCooperazione2.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addWhereCondition("id_accordo_cooperazione = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            rs = stm.executeQuery();
            while (rs.next()) {
                long idAccServizioComposto = rs.getLong("id_accordo");
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("versione");
                sqlQueryObject.addSelectField("id_referente");
                sqlQueryObject.addWhereCondition("id = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm2 = con.prepareStatement(sqlQuery);
                stm2.setLong(1, idAccServizioComposto);
                rs2 = stm2.executeQuery();
                if (!rs2.next()) {
                    throw new DriverRegistroServiziException("IDAccordo con id [" + rs.getLong("id_accordo_servizio") + "] non presente");
                }
                IDSoggetto soggettoReferente = null;
                long id_referenteInternal = rs2.getLong("id_referente");
                if (id_referenteInternal > 0L) {
                    try {
                        soggettoReferente = this.driver.getIdSoggetto(id_referenteInternal, con);
                        if (soggettoReferente == null) {
                            throw new DriverRegistroServiziNotFound("non esiste");
                        }
                    }
                    catch (DriverRegistroServiziNotFound notFound) {
                        throw new Exception("Soggetto referente [" + id_referenteInternal + "] dell'accordo non esiste");
                    }
                }
                String uriAccordo = this.driver.idAccordoFactory.getUriFromValues(rs2.getString("nome"), soggettoReferente, rs2.getInt("versione"));
                accordoCooperazione2.addUriServiziComposti(uriAccordo);
                rs2.close();
                stm2.close();
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_coop_partecipanti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo_cooperazione = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            rs = stm.executeQuery();
            IdSoggetto accCompPartecipante = null;
            AccordoCooperazionePartecipanti accCopPartecipanti = null;
            while (rs.next()) {
                accCompPartecipante = new IdSoggetto();
                accCompPartecipante.setIdSoggetto(rs.getLong("id_soggetto"));
                Soggetto s = this.driver.getSoggetto(rs.getLong("id_soggetto"), con);
                accCompPartecipante.setTipo(s.getTipo());
                accCompPartecipante.setNome(s.getNome());
                if (accCopPartecipanti == null) {
                    accCopPartecipanti = new AccordoCooperazionePartecipanti();
                    accordoCooperazione2.setElencoPartecipanti(accCopPartecipanti);
                }
                accordoCooperazione2.getElencoPartecipanti().addSoggettoPartecipante(accCompPartecipante);
            }
            rs.close();
            stm.close();
            try {
                List<Documento> allegati = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(RuoliDocumento.allegato.toString(), idAccordoLong, ProprietariDocumento.accordoCooperazione, readContenutoAllegati, con, this.driver.tipoDB);
                for (int i = 0; i < allegati.size(); ++i) {
                    accordoCooperazione2.addAllegato(allegati.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound allegati) {
                // empty catch block
            }
            try {
                List<Documento> specificheSemiformali = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), idAccordoLong, ProprietariDocumento.accordoCooperazione, readContenutoAllegati, con, this.driver.tipoDB);
                for (int i = 0; i < specificheSemiformali.size(); ++i) {
                    accordoCooperazione2.addSpecificaSemiformale(specificheSemiformali.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound specificheSemiformali) {
                // empty catch block
            }
            try {
                List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(idAccordoLong, ProprietariProtocolProperty.ACCORDO_COOPERAZIONE, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                if (listPP != null && !listPP.isEmpty()) {
                    for (ProtocolProperty protocolProperty : listPP) {
                        accordoCooperazione2.addProtocolProperty(protocolProperty);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {}
            accordoCooperazione = accordoCooperazione2;
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs2, stm2);
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs2, (PreparedStatement)stm2);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accordoCooperazione;
    }

    protected IDAccordoCooperazione getIdAccordoCooperazione(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdAccordoCooperazione(id, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IDAccordoCooperazione getIdAccordoCooperazione(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.driver.logDebug("richiesto getIdAccordoCooperazione: " + id);
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        IDAccordoCooperazione idAccordo = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("getIdAccordoCooperazione(longId)") : this.driver.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (!rs.next()) {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getIdAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            IDSoggetto referente = null;
            long idReferente = rs.getLong("id_referente");
            if (idReferente > 0L && (referente = this.driver.getIdSoggetto(idReferente, con)) == null) {
                throw new Exception("Soggetto referente non presente?");
            }
            idAccordo = this.driver.idAccordoCooperazioneFactory.getIDAccordoFromValues(rs.getString("nome"), referente, rs.getInt("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoCooperazione] SQLException :" + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoCooperazione] Exception :" + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return idAccordo;
    }

    protected AccordoCooperazione getAccordoCooperazione(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(id, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccordoCooperazione getAccordoCooperazione(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.driver.logDebug("richiesto getAccordoCooperazione: " + id);
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        IDAccordoCooperazione idAccordo = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("getAccordoCooperazione(longId)") : this.driver.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (!rs.next()) {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            IDSoggetto referente = null;
            long idReferente = rs.getLong("id_referente");
            if (idReferente > 0L && (referente = this.driver.getIdSoggetto(idReferente, con)) == null) {
                throw new Exception("Soggetto referente non presente?");
            }
            idAccordo = this.driver.idAccordoCooperazioneFactory.getIDAccordoFromValues(rs.getString("nome"), referente, rs.getInt("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] SQLException :" + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] Exception :" + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return this.getAccordoCooperazione(idAccordo, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDAccordoCooperazione> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        this.driver.logDebug("getAllIdAccordiCooperazione...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdAccordiCooperazione") : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            sqlQueryObject.addSelectField("accordi_cooperazione", "nome");
            sqlQueryObject.addSelectField("accordi_cooperazione", "versione");
            sqlQueryObject.addSelectField(this.driver.tabellaSoggetti, "tipo_soggetto");
            sqlQueryObject.addSelectField(this.driver.tabellaSoggetti, "nome_soggetto");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addWhereCondition("accordi_cooperazione.id_referente=" + this.driver.tabellaSoggetti + ".id");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.ora_registrazione < ?");
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.nome = ?");
                }
                if (filtroRicerca.getVersione() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.versione = ?");
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition(this.driver.tabellaSoggetti + ".tipo_soggetto=?");
                }
                if (filtroRicerca.getNomeSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition(this.driver.tabellaSoggetti + ".nome_soggetto=?");
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca, "accordi_cooperazione");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + String.valueOf(filtroRicerca.getMinDate()) + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + String.valueOf(filtroRicerca.getMaxDate()) + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    this.driver.logDebug("nomeAccordo stmt.setString(" + filtroRicerca.getNomeAccordo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeAccordo());
                    ++indexStmt;
                }
                if (filtroRicerca.getVersione() != null) {
                    this.driver.logDebug("versioneAccordo stmt.setString(" + filtroRicerca.getVersione() + ")");
                    stm.setInt(indexStmt, filtroRicerca.getVersione());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null) {
                    this.driver.logDebug("tipoSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getTipoSoggettoReferente() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoReferente());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoReferente() != null) {
                    this.driver.logDebug("nomeSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getNomeSoggettoReferente() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoReferente());
                    ++indexStmt;
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroRicerca, ProprietariProtocolProperty.ACCORDO_COOPERAZIONE);
            }
            rs = stm.executeQuery();
            ArrayList<IDAccordoCooperazione> idAccordi = new ArrayList<IDAccordoCooperazione>();
            while (rs.next()) {
                IDSoggetto idSoggetto = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDAccordoCooperazione idAccordo = this.driver.idAccordoCooperazioneFactory.getIDAccordoFromValues(rs.getString("nome"), idSoggetto, rs.getInt("versione"));
                idAccordi.add(idAccordo);
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi non trovati");
            }
            arrayList = idAccordi;
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createAccordoCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDServizio tupe=1");
            DriverRegistroServiziDB_accordiCooperazioneLIB.CRUDAccordoCooperazione(1, accordoCooperazione, con, this.driver.tipoDB, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Errore durante la creazione dell'accordo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsAccordoCooperazione");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordo, connection, this.driver.tipoDB);
            if (idAccordoLong <= 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            this.driver.closeConnection(connection);
        }
    }

    protected void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateAccordoCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            DriverRegistroServiziDB_accordiCooperazioneLIB.CRUDAccordoCooperazione(2, accordoCooperazione, con, this.driver.tipoDB, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Errore durante l'update dell'accordo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteAccordoCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDServizio type = 3");
            DriverRegistroServiziDB_accordiCooperazioneLIB.CRUDAccordoCooperazione(3, accordoCooperazione, con, this.driver.tipoDB, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Errore durante la delete dell'accordo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected List<AccordoCooperazione> accordiCooperazioneList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCooperazioneList";
        int idLista = Liste.ACCORDI_COOPERAZIONE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        String filterStatoAccordo = SearchUtils.getFilter(ricerca, idLista, "filtroStatoAccordo");
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filterStatoAccordo : " + filterStatoAccordo);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDAccordoCooperazione> idAccordi = new ArrayList<IDAccordoCooperazione>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiCooperazioneList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addWhereCondition("id_referente = soggetti.id");
                    sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.stato = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addWhereCondition("id_referente = soggetti.id");
                    sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.stato = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectAliasField("accordi_cooperazione", "id", "idAccordoCooperazione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_referente");
                sqlQueryObject.addSelectAliasField("accordi_cooperazione", "descrizione", "descrizioneAccordoCooperazione");
                sqlQueryObject.addSelectField("versione");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addWhereCondition("id_referente = soggetti.id");
                    sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.stato = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectAliasField("accordi_cooperazione", "id", "idAccordoCooperazione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_referente");
                sqlQueryObject.addSelectAliasField("accordi_cooperazione", "descrizione", "descrizioneAccordoCooperazione");
                sqlQueryObject.addSelectField("versione");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addWhereCondition("id_referente = soggetti.id");
                    sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.stato = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String nomeAcc = risultato.getString("nome");
                int versioneAcc = risultato.getInt("versione");
                long idReferente = risultato.getLong("id_referente");
                IDSoggetto soggettoReferente = null;
                if (idReferente > 0L) {
                    Soggetto s = this.driver.getSoggetto(idReferente);
                    soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
                }
                IDAccordoCooperazione id = this.driver.idAccordoCooperazioneFactory.getIDAccordoFromValues(nomeAcc, soggettoReferente, versioneAcc);
                idAccordi.add(id);
            }
            this.driver.logDebug("size lista :" + (idAccordi == null ? null : Integer.valueOf(idAccordi.size())));
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        ArrayList<AccordoCooperazione> lista = new ArrayList<AccordoCooperazione>();
        for (int i = 0; i < idAccordi.size(); ++i) {
            try {
                lista.add(this.getAccordoCooperazione((IDAccordoCooperazione)idAccordi.get(i)));
                continue;
            }
            catch (DriverRegistroServiziNotFound dNot) {
                throw new DriverRegistroServiziException("Accordo non trovato con id?: " + dNot.getMessage(), dNot);
            }
        }
        return lista;
    }

    protected List<IDSoggetto> accordiCoopPartecipantiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCoopPartecipantiList";
        int idLista = Liste.ACCORDI_COOP_PARTECIPANTI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.driver.logDebug("search : " + search);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDSoggetto> idSoggetti = new ArrayList<IDSoggetto>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiCoopPartecipantiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObjectSoggetti;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectCountField("*", "cont");
                sqlQueryObjectSoggetti.addWhereCondition(true, new String[]{sqlQueryObjectSoggetti.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), "accordi_coop_partecipanti.id_soggetto=soggetti.id"});
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            } else {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi_coop_partecipanti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "id");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_soggetto");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_accordo_cooperazione");
                sqlQueryObjectSoggetti.addWhereCondition(true, new String[]{sqlQueryObjectSoggetti.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), "accordi_coop_partecipanti.id_soggetto=soggetti.id"});
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addOrderBy("tipo_soggetto");
                sqlQueryObjectSoggetti.addOrderBy("nome_soggetto");
                sqlQueryObjectSoggetti.setSortType(true);
                sqlQueryObjectSoggetti.setLimit(limit);
                sqlQueryObjectSoggetti.setOffset(offset);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            } else {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "id");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_soggetto");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_accordo_cooperazione");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addOrderBy("tipo_soggetto");
                sqlQueryObjectSoggetti.addOrderBy("nome_soggetto");
                sqlQueryObjectSoggetti.setSortType(true);
                sqlQueryObjectSoggetti.setLimit(limit);
                sqlQueryObjectSoggetti.setOffset(offset);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            }
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipo = risultato.getString("tipo_soggetto");
                String nome = risultato.getString("nome_soggetto");
                IDSoggetto idSogg = new IDSoggetto(tipo, nome);
                idSoggetti.add(idSogg);
            }
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return idSoggetti;
    }

    protected List<AccordoCooperazione> accordiCoopWithSoggettoPartecipante(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCoopWithSoggettoPartecipante";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoCooperazione> idAccordoCooperazione = new ArrayList<AccordoCooperazione>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiCoopWithSoggettoPartecipante");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
            sqlQueryObjectSoggetti.addFromTable("accordi_cooperazione");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi_cooperazione", "id", "idAccordoCooperazione");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=accordi_cooperazione.id");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_soggetto=soggetti.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoCooperazioneLong = risultato.getLong("idAccordoCooperazione");
                idAccordoCooperazione.add(this.getAccordoCooperazione(idAccordoCooperazioneLong));
            }
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return idAccordoCooperazione;
    }

    protected void validaStatoAccordoCooperazione(AccordoCooperazione ac) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione = new ValidazioneStatoPackageException("AccordoCooperazione", ac.getStatoPackage(), null);
        try {
            AccordoCooperazionePartecipanti partecipanti;
            if (!(ac.getPrivato() != null && ac.getPrivato().booleanValue() || ac.getSoggettoReferente() == null)) {
                IDSoggetto idS = new IDSoggetto(ac.getSoggettoReferente().getTipo(), ac.getSoggettoReferente().getNome());
                try {
                    Soggetto s = this.driver.getSoggetto(idS);
                    if (s.getPrivato() != null && s.getPrivato().booleanValue()) {
                        erroreValidazione.addErroreValidazione("soggetto referente [" + String.valueOf(idS) + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                    }
                }
                catch (DriverRegistroServiziNotFound s) {
                    // empty catch block
                }
            }
            if (ac.getElencoPartecipanti() != null && (partecipanti = ac.getElencoPartecipanti()).sizeSoggettoPartecipanteList() >= 2) {
                for (int i = 0; i < partecipanti.sizeSoggettoPartecipanteList(); ++i) {
                    Soggetto s2;
                    IdSoggetto idSoggettoPartecipante = partecipanti.getSoggettoPartecipante(i);
                    if (idSoggettoPartecipante.getIdSoggetto() != null && idSoggettoPartecipante.getIdSoggetto() > 0L) {
                        try {
                            s2 = this.driver.getSoggetto(partecipanti.getSoggettoPartecipante(i).getIdSoggetto());
                            if (s2.getPrivato() == null || !s2.getPrivato().booleanValue()) continue;
                            erroreValidazione.addErroreValidazione("soggetto partecipante [" + s2.getTipo() + "/" + s2.getNome() + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                        }
                        catch (DriverRegistroServiziNotFound s2) {}
                        continue;
                    }
                    if (idSoggettoPartecipante.getTipo() == null || idSoggettoPartecipante.getNome() == null) continue;
                    try {
                        s2 = this.driver.getSoggetto(new IDSoggetto(idSoggettoPartecipante.getTipo(), idSoggettoPartecipante.getNome()));
                        if (s2.getPrivato() == null || !s2.getPrivato().booleanValue()) continue;
                        erroreValidazione.addErroreValidazione("soggetto partecipante [" + s2.getTipo() + "/" + s2.getNome() + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                        continue;
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                }
            }
            if (!StatiAccordo.bozza.toString().equals(ac.getStatoPackage())) {
                if (ac.getElencoPartecipanti() == null) {
                    erroreValidazione.addErroreValidazione("soggetti partecipanti non definiti");
                } else if (ac.getElencoPartecipanti().sizeSoggettoPartecipanteList() <= 0) {
                    erroreValidazione.addErroreValidazione("soggetti partecipanti non definiti");
                } else if (ac.getElencoPartecipanti().sizeSoggettoPartecipanteList() < 2) {
                    erroreValidazione.addErroreValidazione("almeno 2 soggetti partecipanti devono essere definiti");
                }
            }
        }
        catch (Exception e) {
            throw new ValidazioneStatoPackageException(e);
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }
}

