/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import java.io.Serializable;
import java.util.Map;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.utils.crypt.CryptConfig;

public class FiltroRicercaSoggetti
extends FiltroRicerca
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nomePdd;
    private IDRuolo idRuolo;
    private CredenzialiSoggetto credenzialiSoggetto;
    private CryptConfig cryptConfig;
    private Map<String, String> proprieta;

    public String getNomePdd() {
        return this.nomePdd;
    }

    public void setNomePdd(String nomePdd) {
        this.nomePdd = nomePdd;
    }

    public IDRuolo getIdRuolo() {
        return this.idRuolo;
    }

    public void setIdRuolo(IDRuolo idRuolo) {
        this.idRuolo = idRuolo;
    }

    public CryptConfig getCryptConfig() {
        return this.cryptConfig;
    }

    public CredenzialiSoggetto getCredenzialiSoggetto() {
        return this.credenzialiSoggetto;
    }

    public void setCredenzialiSoggetto(CredenzialiSoggetto credenzialiSoggetto, CryptConfig cryptConfig) {
        this.credenzialiSoggetto = credenzialiSoggetto;
        this.cryptConfig = cryptConfig;
    }

    public Map<String, String> getProprieta() {
        return this.proprieta;
    }

    public void setProprieta(Map<String, String> proprieta) {
        this.proprieta = proprieta;
    }

    @Override
    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("Filtro:");
        this.addDetails(bf);
        if (this.idRuolo != null) {
            bf.append(" [ruolo:" + String.valueOf(this.idRuolo) + "]");
        }
        if (this.credenzialiSoggetto != null) {
            if (this.credenzialiSoggetto.getTipo() != null) {
                bf.append(" [credenziali-tipo:" + this.credenzialiSoggetto.getTipo().getValue() + "]");
            }
            if (this.credenzialiSoggetto.getUser() != null) {
                bf.append(" [credenziali-user:" + this.credenzialiSoggetto.getUser() + "]");
            }
            if (this.credenzialiSoggetto.getPassword() != null) {
                bf.append(" [credenziali-password:" + this.credenzialiSoggetto.getPassword() + "]");
            }
            if (this.credenzialiSoggetto.getSubject() != null) {
                bf.append(" [credenziali-subject:" + this.credenzialiSoggetto.getSubject() + "]");
            }
        }
        if (this.proprieta != null && !this.proprieta.isEmpty()) {
            bf.append(" [proprieta:" + this.proprieta.size() + "]");
            for (String key : this.proprieta.keySet()) {
                bf.append(" [proprieta[" + key + "]:");
                bf.append(this.proprieta.get(key) != null ? this.proprieta.get(key) : "");
                bf.append("]");
            }
        }
        if (bf.length() == "Filtro:".length()) {
            bf.append(" nessun filtro presente");
        }
        return bf.toString();
    }

    @Override
    public void addDetails(StringBuilder bf) {
        if (this.nomePdd != null) {
            bf.append(" [nomePdd:" + this.nomePdd + "]");
        }
        super.addDetails(bf);
    }
}

