/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.registry.driver.FiltroRicercaProtocolPropertyRegistry;

public class FiltroRicerca
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date minDate;
    private Date maxDate;
    private String nome;
    private String tipo;
    private List<FiltroRicercaProtocolPropertyRegistry> protocolProperties = new ArrayList<FiltroRicercaProtocolPropertyRegistry>();

    public List<FiltroRicercaProtocolPropertyRegistry> getProtocolProperties() {
        return this.protocolProperties;
    }

    public void setProtocolProperties(List<FiltroRicercaProtocolPropertyRegistry> list) {
        this.protocolProperties = list;
    }

    public void addProtocolProperty(FiltroRicercaProtocolPropertyRegistry filtro) {
        this.protocolProperties.add(filtro);
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean checkEmpty) {
        StringBuilder bf = new StringBuilder();
        bf.append("Filtro:");
        this.addDetails(bf);
        if (checkEmpty && bf.length() == "Filtro:".length()) {
            bf.append(" nessun filtro presente");
        }
        return bf.toString();
    }

    public void addDetails(StringBuilder bf) {
        if (this.minDate != null) {
            bf.append(" [intervallo-inferiore-data:" + String.valueOf(this.minDate) + "]");
        }
        if (this.maxDate != null) {
            bf.append(" [intervallo-superiore-data:" + String.valueOf(this.maxDate) + "]");
        }
        if (this.tipo != null) {
            bf.append(" [tipo:" + this.tipo + "]");
        }
        if (this.nome != null) {
            bf.append(" [nome:" + this.nome + "]");
        }
        if (this.protocolProperties != null && this.protocolProperties.size() > 0) {
            bf.append(" [protocol-properties:" + this.protocolProperties.size() + "]");
            for (int i = 0; i < this.protocolProperties.size(); ++i) {
                bf.append(" [protocol-properties[" + i + "]:");
                this.protocolProperties.get(i).addDetails(bf);
                bf.append("]");
            }
        }
    }
}

