/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.mvc.properties.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_genericPropertiesDriver;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBPropertiesUtils {
    private DBPropertiesUtils() {
    }

    public static Map<String, String> readProperties(Connection con, String tipoDB, String nomeTabella, String nomeColonnaKey, String nomeColonnaValue, String nomeColonnaEncValue, String nomeColonnaParent, Long idParent, IDriverBYOK driverBYOK) throws CoreException {
        String methodName = "readProperties Tabella[" + nomeTabella + "], NomeColonnaKey[" + nomeColonnaKey + "], NomeColonnaValue[" + nomeColonnaValue + "], nomeColonnaEncValue[" + nomeColonnaEncValue + "], NomeColonnaParent[" + nomeColonnaParent + "], IDParent[" + idParent + "]";
        HashMap<String, String> map = new HashMap<String, String>();
        Statement stmt = null;
        ResultSet risultato = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField(nomeTabella + "." + nomeColonnaKey);
            sqlQueryObject.addSelectField(nomeTabella + "." + nomeColonnaValue);
            sqlQueryObject.addSelectField(nomeTabella + "." + nomeColonnaEncValue);
            sqlQueryObject.addWhereCondition(nomeTabella + "." + nomeColonnaParent + " = ?");
            sqlQueryObject.addOrderBy(nomeTabella + "." + nomeColonnaKey);
            sqlQueryObject.setSortType(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idParent);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String key = risultato.getString(nomeColonnaKey);
                String value = null;
                String plainValue = risultato.getString(nomeColonnaValue);
                String encValue = risultato.getString(nomeColonnaEncValue);
                value = encValue != null && StringUtils.isNotEmpty((CharSequence)encValue) ? (driverBYOK != null ? driverBYOK.unwrapAsString(encValue) : encValue) : plainValue;
                map.put(key, value);
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            throw new CoreException(methodName + " error", e);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void writeProperties(Connection con, String tipoDB, Map<String, String> map, String nomeTabella, String nomeColonnaKey, String nomeColonnaValue, String nomeColonnaEncValue, String nomeColonnaParent, Long idParent, IDriverBYOK driverBYOK, String tipoParent) throws CoreException {
        String methodName = "writeProperties Tabella[" + nomeTabella + "], NomeColonnaKey[" + nomeColonnaKey + "], NomeColonnaValue[" + nomeColonnaValue + "], nomeColonnaEncValue[" + nomeColonnaEncValue + "], NomeColonnaParent[" + nomeColonnaParent + "], IDParent[" + idParent + "]";
        Statement stmt = null;
        if (idParent <= 0L) {
            throw new CoreException("IdParent non fornito");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addInsertTable(nomeTabella);
            sqlQueryObject.addInsertField(nomeColonnaKey, "?");
            sqlQueryObject.addInsertField(nomeColonnaValue, "?");
            sqlQueryObject.addInsertField(nomeColonnaEncValue, "?");
            sqlQueryObject.addInsertField(nomeColonnaParent, "?");
            String queryString = sqlQueryObject.createSQLInsert();
            for (String key : map.keySet()) {
                BYOKWrappedValue byokValue;
                stmt = con.prepareStatement(queryString);
                int index = 1;
                stmt.setString(index++, key);
                String plainValue = map.get(key);
                String encValue = null;
                if (driverBYOK != null && DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(tipoParent, key) && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                    encValue = byokValue.getWrappedValue();
                    plainValue = byokValue.getWrappedPlainValue();
                }
                stmt.setString(index++, plainValue);
                stmt.setString(index++, encValue);
                stmt.setLong(index++, idParent);
                stmt.executeUpdate();
                stmt.close();
            }
        }
        catch (Exception e) {
            throw new CoreException(methodName + " error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void deleteProperties(Connection con, String tipoDB, String nomeTabella, String nomeColonnaParent, Long idParent) throws CoreException {
        String methodName = "deleteProperties Tabella[" + nomeTabella + "], NomeColonnaParent[" + nomeColonnaParent + "], IDParent[" + idParent + "]";
        Statement stmt = null;
        if (idParent <= 0L) {
            throw new CoreException("IdParent non fornito");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable(nomeTabella);
            sqlQueryObject.addWhereCondition(nomeTabella + "." + nomeColonnaParent + " = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idParent);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException(methodName + " error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Map<String, String> toMap(Map<String, Properties> propertiesMap) throws Exception {
        HashMap<String, String> map = null;
        if (propertiesMap == null) {
            return map;
        }
        map = new HashMap<String, String>();
        for (String nomeProperties : propertiesMap.keySet()) {
            Properties properties = propertiesMap.get(nomeProperties);
            for (Object key : properties.keySet()) {
                Object keyAsString = (String)key;
                String val = properties.getProperty((String)keyAsString);
                if (!nomeProperties.equals("___defaultMap")) {
                    keyAsString = nomeProperties + "_@@@_" + (String)keyAsString;
                }
                map.put((String)keyAsString, val);
            }
        }
        return map;
    }

    public static Map<String, Properties> toMultiMap(Map<String, String> dbMap) throws Exception {
        ArrayList<String> nomiProperties = new ArrayList<String>();
        Iterator<String> iterator = dbMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String keyToAdd = key = iterator.next();
            if (key.contains("_@@@_")) {
                int idx = key.indexOf("_@@@_");
                keyToAdd = key.substring(0, idx);
            }
            if (nomiProperties.contains(keyToAdd)) continue;
            nomiProperties.add(keyToAdd);
        }
        return DBPropertiesUtils.toMultiMap(dbMap, nomiProperties);
    }

    public static Map<String, Properties> toMultiMap(Map<String, String> dbMap, List<String> nomiProperties) {
        HashMap<String, Properties> map = null;
        if (dbMap == null) {
            return map;
        }
        map = new HashMap<String, Properties>();
        for (String key : dbMap.keySet()) {
            Properties properties;
            String value = dbMap.get(key);
            String nomeProperties = "___defaultMap";
            String startsWith = DBPropertiesUtils.startsWith(nomiProperties, key);
            if (startsWith != null) {
                nomeProperties = startsWith;
                key = DBPropertiesUtils.normalizePropertyName(nomeProperties, key);
            }
            if ((properties = (Properties)map.remove(nomeProperties)) == null) {
                properties = new Properties();
            }
            properties.put(key, value);
            map.put(nomeProperties, properties);
        }
        return map;
    }

    public static String startsWith(List<String> nomiProperties, String key) {
        if (nomiProperties != null && !nomiProperties.isEmpty()) {
            for (String string : nomiProperties) {
                if (!key.startsWith(string + "_@@@_")) continue;
                return string;
            }
        }
        return null;
    }

    public static String normalizePropertyName(String nomiProperties, String key) {
        int prefixLength = nomiProperties.length() + "_@@@_".length();
        return key.substring(prefixLength);
    }
}

