/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.id;

import java.io.Serializable;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.Utilities;

public class IDServizioApplicativo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected IDSoggetto idSoggettoProprietario;
    protected String nome;

    public IDSoggetto getIdSoggettoProprietario() {
        return this.idSoggettoProprietario;
    }

    public void setIdSoggettoProprietario(IDSoggetto idSoggettoProprietario) {
        this.idSoggettoProprietario = idSoggettoProprietario;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.nome != null) {
            bf.append("Nome:" + this.nome);
        } else {
            bf.append("Nome:NonDefinito");
        }
        bf.append(" ");
        if (this.idSoggettoProprietario != null) {
            bf.append("Soggetto:" + this.idSoggettoProprietario.toString());
        } else {
            bf.append("Soggetto:NonDefinito");
        }
        return bf.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!Utilities.equalsClass((Object)object, (Object)this)) {
            return false;
        }
        IDServizioApplicativo id = (IDServizioApplicativo)object;
        if (this.nome == null ? id.nome != null : !this.nome.equals(id.nome)) {
            return false;
        }
        return !(this.idSoggettoProprietario == null ? id.idSoggettoProprietario != null : !this.idSoggettoProprietario.equals(id.idSoggettoProprietario));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public IDServizioApplicativo clone() {
        IDServizioApplicativo clone = null;
        try {
            clone = (IDServizioApplicativo)super.clone();
        }
        catch (Throwable t) {
            clone = new IDServizioApplicativo();
        }
        if (this.nome != null) {
            clone.nome = new String(this.nome);
        }
        if (this.idSoggettoProprietario != null) {
            clone.idSoggettoProprietario = this.idSoggettoProprietario.clone();
        }
        return clone;
    }

    public String toFormatString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.idSoggettoProprietario.getTipo());
        sb.append("/");
        sb.append(this.idSoggettoProprietario.getNome());
        sb.append("/");
        sb.append(this.nome);
        return sb.toString();
    }

    public static IDServizioApplicativo toIDServizioApplicativo(String formatString) throws Exception {
        String[] tmp = formatString.split("/");
        if (tmp.length != 3) {
            throw new Exception("Formato non supportato, attesi 3 valori, trovati " + tmp.length);
        }
        String tipoSoggettoErogatore = tmp[0];
        String nomeSoggettoErogatore = tmp[1];
        String nome = tmp[2];
        IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
        idServizioApplicativo.idSoggettoProprietario = new IDSoggetto(tipoSoggettoErogatore, nomeSoggettoErogatore);
        idServizioApplicativo.nome = nome;
        return idServizioApplicativo;
    }
}

