/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.eventi.dao.jdbc;

import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.eventi.dao.IEventoService;
import org.openspcoop2.core.eventi.dao.IEventoServiceSearch;
import org.openspcoop2.core.eventi.dao.IServiceManager;
import org.openspcoop2.core.eventi.dao.jdbc.JDBCEventoService;
import org.openspcoop2.core.eventi.dao.jdbc.JDBCEventoServiceSearch;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerBase;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.slf4j.Logger;

public class JDBCServiceManager
extends JDBCServiceManagerBase
implements IServiceManager {
    protected Connection getConnectionInternalResource() {
        return this.connection;
    }

    protected DataSource getDatasourceInternalResource() {
        return this.datasource;
    }

    protected JDBCServiceManagerProperties getJdbcPropertiesInternalResource() {
        return this.jdbcProperties;
    }

    protected Logger getLoggerInternalResource() {
        return this.log;
    }

    protected Connection getConnection() throws ServiceException {
        try {
            return super.getConnection();
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    protected void closeConnection(Connection connection) throws ServiceException {
        try {
            super.closeConnection(connection);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    protected JDBCServiceManager() {
    }

    public JDBCServiceManager(String jndiName, Properties contextJNDI, ServiceManagerProperties smProperties) throws ServiceException {
        super(jndiName, contextJNDI, smProperties);
    }

    public JDBCServiceManager(String jndiName, Properties contextJNDI, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        super(jndiName, contextJNDI, jdbcProperties);
    }

    public JDBCServiceManager(String jndiName, Properties contextJNDI, ServiceManagerProperties smProperties, Logger alog) throws ServiceException {
        super(jndiName, contextJNDI, smProperties, alog);
    }

    public JDBCServiceManager(String jndiName, Properties contextJNDI, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        super(jndiName, contextJNDI, jdbcProperties, alog);
    }

    public JDBCServiceManager(DataSource ds, ServiceManagerProperties smProperties) throws ServiceException {
        super(ds, smProperties);
    }

    public JDBCServiceManager(DataSource ds, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        super(ds, jdbcProperties);
    }

    public JDBCServiceManager(DataSource ds, ServiceManagerProperties smProperties, Logger alog) throws ServiceException {
        super(ds, smProperties, alog);
    }

    public JDBCServiceManager(DataSource ds, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        super(ds, jdbcProperties, alog);
    }

    public JDBCServiceManager(String connectionUrl, String driverJDBC, String username, String password, ServiceManagerProperties smProperties) throws ServiceException {
        super(connectionUrl, driverJDBC, username, password, smProperties);
    }

    public JDBCServiceManager(String connectionUrl, String driverJDBC, String username, String password, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        super(connectionUrl, driverJDBC, username, password, jdbcProperties);
    }

    public JDBCServiceManager(String connectionUrl, String driverJDBC, String username, String password, ServiceManagerProperties smProperties, Logger alog) throws ServiceException {
        super(connectionUrl, driverJDBC, username, password, smProperties, alog);
    }

    public JDBCServiceManager(String connectionUrl, String driverJDBC, String username, String password, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        super(connectionUrl, driverJDBC, username, password, jdbcProperties, alog);
    }

    public JDBCServiceManager(Connection connection, ServiceManagerProperties smProperties) throws ServiceException {
        super(connection, smProperties);
    }

    public JDBCServiceManager(Connection connection, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        super(connection, jdbcProperties);
    }

    public JDBCServiceManager(Connection connection, ServiceManagerProperties smProperties, Logger alog) throws ServiceException {
        super(connection, smProperties, alog);
    }

    public JDBCServiceManager(Connection connection, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        super(connection, jdbcProperties, alog);
    }

    @Override
    public IEventoServiceSearch getEventoServiceSearch() throws ServiceException, NotImplementedException {
        return new JDBCEventoServiceSearch(this);
    }

    @Override
    public IEventoService getEventoService() throws ServiceException, NotImplementedException {
        return new JDBCEventoService(this);
    }
}

