/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.diagnostica.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop2.core.diagnostica.DominioDiagnostico;
import org.openspcoop2.core.diagnostica.MessaggioDiagnostico;
import org.openspcoop2.core.diagnostica.Protocollo;
import org.openspcoop2.core.diagnostica.utils.XMLUtilsException;
import org.openspcoop2.core.diagnostica.utils.serializer.JsonJacksonDeserializer;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.serialization.IDeserializer;
import org.openspcoop2.utils.serialization.SerializationConfig;
import org.openspcoop2.utils.serialization.SerializationFactory;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    private XMLUtils() {
    }

    private static synchronized void initValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), log, XMLUtils.class.getResourceAsStream("/openspcoopDiagnostica.xsd"));
        }
    }

    public static ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            XMLUtils.initValidatoreXSD(log);
        }
        return validatoreXSD;
    }

    public static boolean validate(MessaggioDiagnostico messaggioDiagnostico, StringBuilder motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (messaggioDiagnostico.getDominio() == null) {
            motivoErroreValidazione.append("Dominio non definito\n");
        } else {
            XMLUtils.validate(messaggioDiagnostico.getDominio(), motivoErroreValidazione);
        }
        if (messaggioDiagnostico.getOraRegistrazione() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (messaggioDiagnostico.getCodice() == null) {
            motivoErroreValidazione.append("Codice non definito\n");
        }
        if (messaggioDiagnostico.getMessaggio() == null) {
            motivoErroreValidazione.append("Messaggio non definito\n");
        }
        if (messaggioDiagnostico.getSeverita() == null) {
            motivoErroreValidazione.append("Severita non definito\n");
        }
        if (messaggioDiagnostico.getProtocollo() != null) {
            XMLUtils.validate(messaggioDiagnostico.getProtocollo(), motivoErroreValidazione);
        }
        return motivoErroreValidazione.length() == size;
    }

    private static void validate(DominioDiagnostico dominio, StringBuilder motivoErroreValidazione) {
        if (dominio.getIdentificativoPorta() == null) {
            motivoErroreValidazione.append("Dominio.identificativoPorta non definito\n");
        }
        if (dominio.getModulo() == null) {
            motivoErroreValidazione.append("Dominio.modulo non definito\n");
        }
        if (dominio.getSoggetto() == null) {
            motivoErroreValidazione.append("Dominio.soggetto non definita\n");
        } else {
            if (dominio.getSoggetto().getTipo() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.tipo non definita\n");
            }
            if (dominio.getSoggetto().getBase() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.nome non definita\n");
            }
        }
    }

    private static void validate(Protocollo protocollo, StringBuilder motivoErroreValidazione) {
        if (protocollo.getIdentificativo() == null) {
            motivoErroreValidazione.append("Protocollo.identificativo non definito\n");
        }
    }

    public static MessaggioDiagnostico getMessaggioDiagnostico(Logger log, byte[] m) throws XMLUtilsException {
        MessaggioDiagnostico messaggioDiagnostico;
        ByteArrayInputStream bin = new ByteArrayInputStream(m);
        try {
            messaggioDiagnostico = XMLUtils.getMessaggioDiagnostico(log, bin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        bin.close();
        return messaggioDiagnostico;
    }

    public static MessaggioDiagnostico getMessaggioDiagnostico(Logger log, File m) throws XMLUtilsException {
        MessaggioDiagnostico messaggioDiagnostico;
        FileInputStream fin = new FileInputStream(m);
        try {
            messaggioDiagnostico = XMLUtils.getMessaggioDiagnostico(log, fin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        fin.close();
        return messaggioDiagnostico;
    }

    public static MessaggioDiagnostico getMessaggioDiagnostico(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getMessaggioDiagnostico(log, m.getBytes());
    }

    public static MessaggioDiagnostico getMessaggioDiagnostico(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida((InputStream)binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (MessaggioDiagnostico)JaxbUtils.xmlToObj((InputStream)binTrasformazione, MessaggioDiagnostico.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static MessaggioDiagnostico getMessaggioDiagnosticoFromJson(Logger log, InputStream is) throws XMLUtilsException {
        try {
            if (log != null) {
                // empty if block
            }
            JsonJacksonDeserializer deserializer = new JsonJacksonDeserializer();
            return deserializer.readMessaggioDiagnostico(is);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, File out) throws XMLUtilsException {
        XMLUtils.generateMessaggioDiagnostico(messaggioDiagnostico, out, false, false);
    }

    public static void generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, File out, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(messaggioDiagnostico, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)out.getName(), (byte[])XMLUtils.generateMessaggioDiagnosticoEngine(messaggioDiagnostico, prettyDocument, omitXmlDeclaration));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, String fileName) throws XMLUtilsException {
        XMLUtils.generateMessaggioDiagnostico(messaggioDiagnostico, fileName, false, false);
    }

    public static void generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, String fileName, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(messaggioDiagnostico, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)fileName, (byte[])XMLUtils.generateMessaggioDiagnosticoEngine(messaggioDiagnostico, prettyDocument, omitXmlDeclaration));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico) throws XMLUtilsException {
        return XMLUtils.generateMessaggioDiagnostico(messaggioDiagnostico, false, false);
    }

    public static byte[] generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(messaggioDiagnostico, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            return XMLUtils.generateMessaggioDiagnosticoEngine(messaggioDiagnostico, prettyDocument, omitXmlDeclaration);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, OutputStream out) throws XMLUtilsException {
        XMLUtils.generateMessaggioDiagnostico(messaggioDiagnostico, out, false, false);
    }

    public static void generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, OutputStream out, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(messaggioDiagnostico, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateMessaggioDiagnosticoEngine(messaggioDiagnostico, prettyDocument, omitXmlDeclaration));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static String generateMessaggioDiagnosticoAsJson(MessaggioDiagnostico messaggioDiagnostico) throws XMLUtilsException {
        return XMLUtils.generateMessaggioDiagnosticoAsJson(messaggioDiagnostico, false);
    }

    public static String generateMessaggioDiagnosticoAsJson(MessaggioDiagnostico messaggioDiagnostico, boolean prettyDocument) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(messaggioDiagnostico, risultatoValidazione)) {
                throw new XMLUtilsException(risultatoValidazione.toString());
            }
            return XMLUtils.generateMessaggioDiagnosticoAsJsonEngine(messaggioDiagnostico, prettyDocument);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateMessaggioDiagnosticoEngine(MessaggioDiagnostico messaggioDiagnostico, boolean prettyDocument, boolean omitXmlDeclaration) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JaxbUtils.objToXml((OutputStream)bout, MessaggioDiagnostico.class, (Object)messaggioDiagnostico, (boolean)prettyDocument, (boolean)omitXmlDeclaration);
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static String generateMessaggioDiagnosticoAsJsonEngine(MessaggioDiagnostico messaggioDiagnostico, boolean prettyDocument) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            messaggioDiagnostico.writeTo(bout, WriteToSerializerType.JSON_JACKSON, prettyDocument);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static MessaggioDiagnostico toMessaggioDiagnosticoFromXml(String messaggioDiagnostico) throws XMLUtilsException {
        return XMLUtils.toMessaggioDiagnosticoFromXml(messaggioDiagnostico.getBytes());
    }

    public static MessaggioDiagnostico toMessaggioDiagnosticoFromXml(byte[] messaggioDiagnostico) throws XMLUtilsException {
        MessaggioDiagnostico messaggioDiagnostico2;
        ByteArrayInputStream bin = new ByteArrayInputStream(messaggioDiagnostico);
        try {
            messaggioDiagnostico2 = (MessaggioDiagnostico)JaxbUtils.xmlToObj((InputStream)bin, MessaggioDiagnostico.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        bin.close();
        return messaggioDiagnostico2;
    }

    public static MessaggioDiagnostico toMessaggioDiagnosticoFromJson(String messaggioDiagnostico) throws XMLUtilsException {
        return XMLUtils.toMessaggioDiagnosticoFromJson(messaggioDiagnostico.getBytes());
    }

    public static MessaggioDiagnostico toMessaggioDiagnosticoFromJson(byte[] messaggioDiagnostico) throws XMLUtilsException {
        MessaggioDiagnostico messaggioDiagnostico2;
        ByteArrayInputStream bin = new ByteArrayInputStream(messaggioDiagnostico);
        try {
            SerializationConfig config = new SerializationConfig();
            IDeserializer deserializer = SerializationFactory.getDeserializer((SerializationFactory.SERIALIZATION_TYPE)SerializationFactory.SERIALIZATION_TYPE.JSON_JACKSON, (SerializationConfig)config);
            messaggioDiagnostico2 = (MessaggioDiagnostico)deserializer.readObject((InputStream)bin, MessaggioDiagnostico.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        bin.close();
        return messaggioDiagnostico2;
    }

    public static boolean isMessaggioDiagnostico(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isMessaggioDiagnosticoEngine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMessaggioDiagnostico(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isMessaggioDiagnosticoEngine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMessaggioDiagnostico(Element elemXML) {
        return XMLUtils.isMessaggioDiagnosticoEngine(elemXML);
    }

    public static boolean isMessaggioDiagnostico(Node nodeXml) {
        return XMLUtils.isMessaggioDiagnosticoEngine(nodeXml);
    }

    private static boolean isMessaggioDiagnosticoEngine(Node nodeXml) {
        try {
            return "messaggio-diagnostico".equals(nodeXml.getLocalName()) && "http://www.openspcoop2.org/core/diagnostica".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }
}

