/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;

public enum PolicyGroupByActiveThreadsType {
    LOCAL,
    LOCAL_DIVIDED_BY_NODES,
    DATABASE,
    HAZELCAST_ATOMIC_LONG,
    HAZELCAST_ATOMIC_LONG_ASYNC,
    HAZELCAST_PNCOUNTER,
    HAZELCAST_MAP,
    HAZELCAST_NEAR_CACHE,
    HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP,
    HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP,
    HAZELCAST_LOCAL_CACHE,
    HAZELCAST_REPLICATED_MAP,
    REDISSON_ATOMIC_LONG,
    REDISSON_LONGADDER,
    REDISSON_MAP;

    private static List<PolicyGroupByActiveThreadsType> hazelcastMapTypes;
    private static List<PolicyGroupByActiveThreadsType> hazelcastCountersTypes;
    private static List<PolicyGroupByActiveThreadsType> hazelcastTypes;
    private static List<PolicyGroupByActiveThreadsType> redisMapTypes;
    private static List<PolicyGroupByActiveThreadsType> redisCountersTypes;
    private static List<PolicyGroupByActiveThreadsType> redisTypes;
    private static Set<PolicyGroupByActiveThreadsType> exactModes;
    private static Set<PolicyGroupByActiveThreadsType> approxModes;
    private static Set<PolicyGroupByActiveThreadsType> inconsistentModes;
    private static Set<PolicyGroupByActiveThreadsType> nearCacheModes;

    public boolean isHazelcast() {
        return hazelcastTypes.contains((Object)this);
    }

    public boolean isHazelcastMap() {
        return hazelcastMapTypes.contains((Object)this);
    }

    public boolean isHazelcastCounters() {
        return hazelcastCountersTypes.contains((Object)this);
    }

    public boolean isRedis() {
        return redisTypes.contains((Object)this);
    }

    public boolean isRedisMap() {
        return redisMapTypes.contains((Object)this);
    }

    public boolean isRedisCounters() {
        return redisCountersTypes.contains((Object)this);
    }

    public boolean isExact() {
        return exactModes.contains((Object)this);
    }

    public boolean isApproximated() {
        return approxModes.contains((Object)this);
    }

    public boolean isInconsistent() {
        return inconsistentModes.contains((Object)this);
    }

    public boolean useNearCache() {
        return nearCacheModes.contains((Object)this);
    }

    public String toLabel() {
        switch (this.ordinal()) {
            case 0: {
                return "Locale";
            }
            case 1: {
                return "Locale - Quota divisa sui nodi";
            }
            case 2: {
                return "Distribuita - embedded";
            }
            case 6: {
                return "Distribuita - hazelcast (map)";
            }
            case 7: {
                return "Distribuita - hazelcast (near-cache)";
            }
            case 10: {
                return "Distribuita - hazelcast (local-cache)";
            }
            case 8: {
                return "Distribuita - hazelcast (remote-sync)";
            }
            case 9: {
                return "Distribuita - hazelcast (remote-async)";
            }
            case 5: {
                return "Distribuita - hazelcast (pn-counters)";
            }
            case 3: {
                return "Distribuita - hazelcast (atomic-long-counters)";
            }
            case 4: {
                return "Distribuita - hazelcast (atomic-long-async-counters)";
            }
            case 11: {
                return "Distribuita - hazelcast (replicated-map)";
            }
            case 12: {
                return "Distribuita - redis (atomic-long-counters)";
            }
            case 13: {
                return "Distribuita - redis (longadder-counters)";
            }
            case 14: {
                return "Distribuita - redis (map)";
            }
        }
        return null;
    }

    public List<TipoRisorsaPolicyAttiva> getSupportedResources() {
        ArrayList<TipoRisorsaPolicyAttiva> list = new ArrayList<TipoRisorsaPolicyAttiva>();
        for (TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva : TipoRisorsaPolicyAttiva.values()) {
            list.add(tipoRisorsaPolicyAttiva);
        }
        switch (this.ordinal()) {
            case 0: {
                return list;
            }
            case 1: {
                list.remove(TipoRisorsaPolicyAttiva.OCCUPAZIONE_BANDA);
                list.remove(TipoRisorsaPolicyAttiva.TEMPO_COMPLESSIVO_RISPOSTA);
                list.remove(TipoRisorsaPolicyAttiva.TEMPO_MEDIO_RISPOSTA);
                return list;
            }
            case 2: {
                return list;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return list;
            }
            case 13: {
                list.remove(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE);
                return list;
            }
            case 7: {
                list.remove(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE);
                return list;
            }
            case 10: {
                return list;
            }
            case 11: {
                list.remove(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE);
                return list;
            }
            case 8: 
            case 9: {
                list.remove(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE);
                return list;
            }
            case 14: {
                return list;
            }
        }
        return null;
    }

    public boolean isSupportedResource(TipoRisorsaPolicyAttiva resource) {
        List<TipoRisorsaPolicyAttiva> l = this.getSupportedResources();
        return l != null && l.contains(resource);
    }

    static {
        hazelcastMapTypes = List.of(HAZELCAST_MAP, HAZELCAST_NEAR_CACHE, HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP, HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP, HAZELCAST_LOCAL_CACHE, HAZELCAST_REPLICATED_MAP);
        hazelcastCountersTypes = List.of(HAZELCAST_PNCOUNTER, HAZELCAST_ATOMIC_LONG, HAZELCAST_ATOMIC_LONG_ASYNC);
        hazelcastTypes = new ArrayList<PolicyGroupByActiveThreadsType>();
        hazelcastTypes.addAll(hazelcastMapTypes);
        hazelcastTypes.addAll(hazelcastCountersTypes);
        redisMapTypes = List.of(REDISSON_MAP);
        redisCountersTypes = List.of(REDISSON_ATOMIC_LONG, REDISSON_LONGADDER);
        redisTypes = new ArrayList<PolicyGroupByActiveThreadsType>();
        redisTypes.addAll(redisMapTypes);
        redisTypes.addAll(redisCountersTypes);
        exactModes = Set.of(HAZELCAST_ATOMIC_LONG, REDISSON_ATOMIC_LONG, HAZELCAST_MAP, REDISSON_MAP);
        approxModes = Set.of(HAZELCAST_PNCOUNTER, HAZELCAST_ATOMIC_LONG_ASYNC, HAZELCAST_NEAR_CACHE, HAZELCAST_LOCAL_CACHE);
        inconsistentModes = Set.of(HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP, HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP, HAZELCAST_REPLICATED_MAP, REDISSON_LONGADDER);
        nearCacheModes = Set.of(HAZELCAST_NEAR_CACHE, HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP, HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP);
    }
}

