/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.beans;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.controllo_traffico.constants.TipoBanda;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.core.controllo_traffico.constants.TipoFinestra;
import org.openspcoop2.core.controllo_traffico.constants.TipoLatenza;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.date.UnitaTemporale;
import org.slf4j.Logger;

public class DatiCollezionati
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date cloneDate = null;
    protected TipoRisorsa tipoRisorsa = null;
    protected Long activeRequestCounter = null;
    protected Date creationDate = null;
    private Date updatePolicyDate = null;
    protected Date gestorePolicyConfigDate = null;
    private Long manuallyResetPolicyTimeMillis = null;
    private static final MapKey<String> START_PROCESS_REQUEST_TIME_MS = Map.newMapKey((String)"START_PROCESS_REQUEST_TIME_MS");
    private UnitaTemporale policyDateTypeInterval = null;
    private Integer policyDateInterval = null;
    private Boolean policyDateCurrentInterval = null;
    private TipoFinestra policyDateWindowInterval = null;
    protected Boolean policyRealtime = null;
    protected Date policyDate = null;
    protected Long policyRequestCounter = null;
    protected Long policyCounter = null;
    protected Long policyDenyRequestCounter = null;
    private Date oldPolicyDate = null;
    private Long oldPolicyRequestCounter = null;
    private Long oldPolicyCounter = null;
    private UnitaTemporale policyDegradoPrestazionaleDateTypeInterval = null;
    private Integer policyDegradoPrestazionaleDateInterval = null;
    private Boolean policyDegradoPrestazionaleDateCurrentInterval = null;
    private TipoFinestra policyDegradoPrestazionaleDateWindowInterval = null;
    protected Boolean policyDegradoPrestazionaleRealtime = null;
    protected Date policyDegradoPrestazionaleDate = null;
    protected Long policyDegradoPrestazionaleRequestCounter = null;
    protected Long policyDegradoPrestazionaleCounter = null;
    private Date oldPolicyDegradoPrestazionaleDate = null;
    private Long oldPolicyDegradoPrestazionaleRequestCounter = null;
    private Long oldPolicyDegradoPrestazionaleCounter = null;
    private static final String OCCUPAZIONE_BANDA_KB_INFO = " kb (";
    private static final String OCCUPAZIONE_BANDA_BYTES_INFO = " bytes)";
    private static final String TEMPO_COMPLESSIVO_RISPOSTA_SECONDI_INFO = " secondi (";
    private static final String TEMPO_COMPLESSIVO_RISPOSTA_MILLISECONDI_INFO = " ms)";
    private static final String TEMPO_MEDIO_RISPOSTA_MILLISECONDI_INFO = " ms";

    public DatiCollezionati(Date updatePolicyDate, Date gestorePolicyConfigDate) {
        this.updatePolicyDate = updatePolicyDate;
        this.gestorePolicyConfigDate = gestorePolicyConfigDate;
    }

    public void initDatiIniziali(ActivePolicy activePolicy) {
        this.tipoRisorsa = activePolicy.getTipoRisorsaPolicy();
        this.activeRequestCounter = 0L;
        this.creationDate = DateManager.getDate();
        this.updatePolicyDate = activePolicy.getInstanceConfiguration().getUpdateTime();
        if (!activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals(activePolicy.getConfigurazionePolicy().getModalitaControllo())) {
            this.policyDateCurrentInterval = true;
            this.policyDateWindowInterval = activePolicy.getConfigurazionePolicy().getFinestraOsservazione();
            switch (activePolicy.getConfigurazionePolicy().getTipoIntervalloOsservazioneRealtime()) {
                case SECONDI: {
                    this.policyDateTypeInterval = UnitaTemporale.SECONDI;
                    break;
                }
                case MINUTI: {
                    this.policyDateTypeInterval = UnitaTemporale.MINUTI;
                    break;
                }
                case ORARIO: {
                    this.policyDateTypeInterval = UnitaTemporale.ORARIO;
                    break;
                }
                case GIORNALIERO: {
                    this.policyDateTypeInterval = UnitaTemporale.GIORNALIERO;
                }
            }
            this.policyDateInterval = activePolicy.getConfigurazionePolicy().getIntervalloOsservazione();
            this.policyRealtime = true;
        } else if (TipoControlloPeriodo.STATISTIC.equals(activePolicy.getConfigurazionePolicy().getModalitaControllo())) {
            this.policyDateWindowInterval = activePolicy.getConfigurazionePolicy().getFinestraOsservazione();
            if (TipoFinestra.SCORREVOLE.equals(activePolicy.getConfigurazionePolicy().getFinestraOsservazione())) {
                this.policyDateCurrentInterval = activePolicy.getConfigurazioneControlloTraffico().isElaborazioneStatistica_finestraScorrevole_gestioneIntervalloCorrente();
                this.policyDateTypeInterval = UnitaTemporale.ORARIO;
                switch (activePolicy.getConfigurazionePolicy().getTipoIntervalloOsservazioneStatistico()) {
                    case ORARIO: {
                        this.policyDateInterval = activePolicy.getConfigurazionePolicy().getIntervalloOsservazione();
                        break;
                    }
                    case GIORNALIERO: {
                        this.policyDateInterval = activePolicy.getConfigurazionePolicy().getIntervalloOsservazione() * 24;
                        break;
                    }
                    case SETTIMANALE: {
                        this.policyDateInterval = activePolicy.getConfigurazionePolicy().getIntervalloOsservazione() * 24 * 7;
                        break;
                    }
                    case MENSILE: {
                        this.policyDateInterval = activePolicy.getConfigurazionePolicy().getIntervalloOsservazione() * 24 * 30;
                    }
                }
            } else {
                this.policyDateCurrentInterval = true;
                switch (activePolicy.getConfigurazionePolicy().getTipoIntervalloOsservazioneStatistico()) {
                    case ORARIO: {
                        this.policyDateTypeInterval = UnitaTemporale.ORARIO;
                        break;
                    }
                    case GIORNALIERO: {
                        this.policyDateTypeInterval = UnitaTemporale.GIORNALIERO;
                        break;
                    }
                    case SETTIMANALE: {
                        this.policyDateTypeInterval = UnitaTemporale.SETTIMANALE;
                        break;
                    }
                    case MENSILE: {
                        this.policyDateTypeInterval = UnitaTemporale.MENSILE;
                    }
                }
                this.policyDateInterval = activePolicy.getConfigurazionePolicy().getIntervalloOsservazione();
            }
            this.policyRealtime = false;
        }
        if (activePolicy.getConfigurazionePolicy().isApplicabilitaDegradoPrestazionale()) {
            if (TipoControlloPeriodo.REALTIME.equals(activePolicy.getConfigurazionePolicy().getDegradoAvgTimeModalitaControllo())) {
                this.policyDegradoPrestazionaleDateCurrentInterval = true;
                this.policyDegradoPrestazionaleDateWindowInterval = activePolicy.getConfigurazionePolicy().getDegradoAvgTimeFinestraOsservazione();
                switch (activePolicy.getConfigurazionePolicy().getDegradoAvgTimeTipoIntervalloOsservazioneRealtime()) {
                    case SECONDI: {
                        this.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.SECONDI;
                        break;
                    }
                    case MINUTI: {
                        this.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.MINUTI;
                        break;
                    }
                    case ORARIO: {
                        this.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.ORARIO;
                        break;
                    }
                    case GIORNALIERO: {
                        this.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.GIORNALIERO;
                    }
                }
                this.policyDegradoPrestazionaleDateInterval = activePolicy.getConfigurazionePolicy().getDegradoAvgTimeIntervalloOsservazione();
                this.policyDegradoPrestazionaleRealtime = true;
            } else if (TipoControlloPeriodo.STATISTIC.equals(activePolicy.getConfigurazionePolicy().getDegradoAvgTimeModalitaControllo())) {
                this.policyDegradoPrestazionaleDateWindowInterval = activePolicy.getConfigurazionePolicy().getDegradoAvgTimeFinestraOsservazione();
                if (TipoFinestra.SCORREVOLE.equals(activePolicy.getConfigurazionePolicy().getDegradoAvgTimeFinestraOsservazione())) {
                    this.policyDegradoPrestazionaleDateCurrentInterval = activePolicy.getConfigurazioneControlloTraffico().isElaborazioneStatistica_finestraScorrevole_gestioneIntervalloCorrente();
                    this.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.ORARIO;
                    switch (activePolicy.getConfigurazionePolicy().getDegradoAvgTimeTipoIntervalloOsservazioneStatistico()) {
                        case ORARIO: {
                            this.policyDegradoPrestazionaleDateInterval = activePolicy.getConfigurazionePolicy().getDegradoAvgTimeIntervalloOsservazione();
                            break;
                        }
                        case GIORNALIERO: {
                            this.policyDegradoPrestazionaleDateInterval = activePolicy.getConfigurazionePolicy().getDegradoAvgTimeIntervalloOsservazione() * 24;
                            break;
                        }
                        case SETTIMANALE: {
                            this.policyDegradoPrestazionaleDateInterval = activePolicy.getConfigurazionePolicy().getDegradoAvgTimeIntervalloOsservazione() * 24 * 7;
                            break;
                        }
                        case MENSILE: {
                            this.policyDegradoPrestazionaleDateInterval = activePolicy.getConfigurazionePolicy().getDegradoAvgTimeIntervalloOsservazione() * 24 * 30;
                        }
                    }
                } else {
                    this.policyDegradoPrestazionaleDateCurrentInterval = true;
                    switch (activePolicy.getConfigurazionePolicy().getDegradoAvgTimeTipoIntervalloOsservazioneStatistico()) {
                        case ORARIO: {
                            this.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.ORARIO;
                            break;
                        }
                        case GIORNALIERO: {
                            this.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.GIORNALIERO;
                            break;
                        }
                        case SETTIMANALE: {
                            this.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.SETTIMANALE;
                            break;
                        }
                        case MENSILE: {
                            this.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.MENSILE;
                        }
                    }
                    this.policyDegradoPrestazionaleDateInterval = activePolicy.getConfigurazionePolicy().getDegradoAvgTimeIntervalloOsservazione();
                }
                this.policyDegradoPrestazionaleRealtime = false;
            }
        }
    }

    public DatiCollezionati newInstance() {
        return this.internalNewInstance(false);
    }

    public DatiCollezionati newInstance(boolean readRemoteInfo) {
        return this.internalNewInstance(readRemoteInfo);
    }

    private DatiCollezionati internalNewInstance(boolean readRemoteInfo) {
        Date updatePolicyDateCheck = new Date(this.updatePolicyDate.getTime());
        Date gestorePolicyConfigDateCheck = null;
        if (this.gestorePolicyConfigDate != null) {
            gestorePolicyConfigDateCheck = new Date(this.gestorePolicyConfigDate.getTime());
        }
        DatiCollezionati dati = new DatiCollezionati(updatePolicyDateCheck, gestorePolicyConfigDateCheck);
        return this.setValuesIn(dati, readRemoteInfo);
    }

    public DatiCollezionati setValuesIn(DatiCollezionati dati, boolean readRemoteInfo) {
        Long getPolicyDegradoPrestazionaleCounter;
        Long getPolicyDegradoPrestazionaleRequestCounter;
        Long getPolicyDenyRequestCounter;
        Long getPolicyCounter;
        Long getPolicyRequestCounter;
        Long getActiveRequestCounter;
        dati.cloneDate = DateManager.getDate();
        if (this.tipoRisorsa != null) {
            dati.tipoRisorsa = TipoRisorsa.toEnumConstant(this.tipoRisorsa.getValue());
        }
        if ((getActiveRequestCounter = this.getActiveRequestCounter(readRemoteInfo)) != null) {
            dati.activeRequestCounter = Long.valueOf("" + getActiveRequestCounter);
        }
        if (this.creationDate != null) {
            dati.creationDate = new Date(this.creationDate.getTime());
        }
        if (this.policyDateTypeInterval != null) {
            dati.policyDateTypeInterval = UnitaTemporale.toEnumConstant((String)this.policyDateTypeInterval.getValue());
        }
        if (this.policyDateInterval != null) {
            dati.policyDateInterval = Integer.valueOf("" + this.policyDateInterval);
        }
        if (this.policyDateCurrentInterval != null) {
            dati.policyDateCurrentInterval = Boolean.valueOf("" + this.policyDateCurrentInterval);
        }
        if (this.policyDateWindowInterval != null) {
            dati.policyDateWindowInterval = TipoFinestra.toEnumConstant(this.policyDateWindowInterval.getValue());
        }
        if (this.policyRealtime != null) {
            dati.policyRealtime = Boolean.valueOf("" + this.policyRealtime);
        }
        if (this.policyDate != null) {
            dati.policyDate = new Date(this.policyDate.getTime());
        }
        if ((getPolicyRequestCounter = this.getPolicyRequestCounter(readRemoteInfo)) != null) {
            dati.policyRequestCounter = Long.valueOf("" + getPolicyRequestCounter);
        }
        if ((getPolicyCounter = this.getPolicyCounter(readRemoteInfo)) != null) {
            dati.policyCounter = Long.valueOf("" + getPolicyCounter);
        }
        if ((getPolicyDenyRequestCounter = this.getPolicyDenyRequestCounter(readRemoteInfo)) != null) {
            dati.policyDenyRequestCounter = Long.valueOf("" + getPolicyDenyRequestCounter);
        }
        if (this.oldPolicyDate != null) {
            dati.oldPolicyDate = new Date(this.oldPolicyDate.getTime());
        }
        if (this.oldPolicyRequestCounter != null) {
            dati.oldPolicyRequestCounter = Long.valueOf("" + this.oldPolicyRequestCounter);
        }
        if (this.oldPolicyCounter != null) {
            dati.oldPolicyCounter = Long.valueOf("" + this.oldPolicyCounter);
        }
        if (this.policyDegradoPrestazionaleDateTypeInterval != null) {
            dati.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.toEnumConstant((String)this.policyDegradoPrestazionaleDateTypeInterval.getValue());
        }
        if (this.policyDegradoPrestazionaleDateInterval != null) {
            dati.policyDegradoPrestazionaleDateInterval = Integer.valueOf("" + this.policyDegradoPrestazionaleDateInterval);
        }
        if (this.policyDegradoPrestazionaleDateCurrentInterval != null) {
            dati.policyDegradoPrestazionaleDateCurrentInterval = Boolean.valueOf("" + this.policyDegradoPrestazionaleDateCurrentInterval);
        }
        if (this.policyDegradoPrestazionaleDateWindowInterval != null) {
            dati.policyDegradoPrestazionaleDateWindowInterval = TipoFinestra.toEnumConstant(this.policyDegradoPrestazionaleDateWindowInterval.getValue());
        }
        if (this.policyDegradoPrestazionaleRealtime != null) {
            dati.policyDegradoPrestazionaleRealtime = Boolean.valueOf("" + this.policyDegradoPrestazionaleRealtime);
        }
        if (this.policyDegradoPrestazionaleDate != null) {
            dati.policyDegradoPrestazionaleDate = new Date(this.policyDegradoPrestazionaleDate.getTime());
        }
        if ((getPolicyDegradoPrestazionaleRequestCounter = this.getPolicyDegradoPrestazionaleRequestCounter(readRemoteInfo)) != null) {
            dati.policyDegradoPrestazionaleRequestCounter = Long.valueOf("" + getPolicyDegradoPrestazionaleRequestCounter);
        }
        if ((getPolicyDegradoPrestazionaleCounter = this.getPolicyDegradoPrestazionaleCounter(readRemoteInfo)) != null) {
            dati.policyDegradoPrestazionaleCounter = Long.valueOf("" + getPolicyDegradoPrestazionaleCounter);
        }
        if (this.oldPolicyDegradoPrestazionaleDate != null) {
            dati.oldPolicyDegradoPrestazionaleDate = new Date(this.oldPolicyDegradoPrestazionaleDate.getTime());
        }
        if (this.oldPolicyDegradoPrestazionaleRequestCounter != null) {
            dati.oldPolicyDegradoPrestazionaleRequestCounter = Long.valueOf("" + this.oldPolicyDegradoPrestazionaleRequestCounter);
        }
        if (this.oldPolicyDegradoPrestazionaleCounter != null) {
            dati.oldPolicyDegradoPrestazionaleCounter = Long.valueOf("" + this.oldPolicyDegradoPrestazionaleCounter);
        }
        return dati;
    }

    public String toString() {
        Double oldAvgDegradoPrestazionale;
        Double avgDegradoPrestazionale;
        Long getPolicyDegradoPrestazionaleCounter;
        Long getPolicyDegradoPrestazionaleRequestCounter;
        Double oldAvg;
        Long getPolicyDenyRequestCounter;
        Double avg;
        Long getPolicyCounter;
        Long getPolicyRequestCounter;
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        StringBuilder bf = new StringBuilder();
        bf.append("Dati Generali");
        String nomeRisorsa = null;
        if (this.tipoRisorsa != null) {
            nomeRisorsa = this.tipoRisorsa.getValue();
        }
        if (bf.length() > 0) {
            bf.append("\n");
        }
        bf.append("\tRichieste Attive: ");
        bf.append(this.getActiveRequestCounter(true));
        bf.append("\n");
        bf.append("\tData Attivazione Policy: ");
        bf.append(dateformat.format(this.creationDate));
        bf.append("\n");
        bf.append("\tData Registrazione/Aggiornamento Policy: ");
        bf.append(dateformat.format(this.updatePolicyDate));
        if (this.gestorePolicyConfigDate != null) {
            bf.append("\n");
            bf.append("\tData Configurazione Gestore Policy: ");
            bf.append(dateformat.format(this.gestorePolicyConfigDate));
        }
        Date now = null;
        Date leftPrecedente = null;
        Date rightPrecedente = null;
        if (this.policyDateWindowInterval != null) {
            bf.append("\nDati collezionati per la metrica '" + nomeRisorsa + "'");
            if (this.policyRealtime != null) {
                bf.append("\n");
                bf.append("\tModalit\u00e0 di Controllo: ");
                if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
                    bf.append("realtime");
                } else {
                    bf.append("statistica");
                }
            }
            bf.append("\n");
            bf.append("\tFinestra Osservazione: ");
            bf.append(this.policyDateWindowInterval.getValue());
            Date left = null;
            Date right = null;
            switch (this.policyDateWindowInterval) {
                case CORRENTE: {
                    left = this.getLeftDateWindowCurrentInterval();
                    right = this.getRightDateWindowCurrentInterval();
                    break;
                }
                case PRECEDENTE: {
                    left = this.getLeftDateWindowCurrentInterval();
                    right = this.getRightDateWindowCurrentInterval();
                    leftPrecedente = this.getLeftDateWindowPrecedentInterval();
                    rightPrecedente = this.getRightDateWindowPrecedentInterval();
                    break;
                }
                case SCORREVOLE: {
                    if (now == null) {
                        now = DateManager.getDate();
                    }
                    left = this.getLeftDateWindowSlidingInterval(now);
                    right = this.getRightDateWindowSlidingInterval(now);
                }
            }
            bf.append("\n");
            if (left != null && right != null) {
                bf.append("\tIntervallo [");
                bf.append(dateformat.format(left));
                bf.append(" - ");
                bf.append(dateformat.format(right));
                bf.append("]");
            } else if (this.policyDate != null) {
                bf.append("\tData: ");
                bf.append(dateformat.format(this.policyDate));
            }
        }
        if ((getPolicyRequestCounter = this.getPolicyRequestCounter(true)) != null) {
            bf.append("\n");
            bf.append("\tNumero Richieste Conteggiate: ");
            bf.append(getPolicyRequestCounter);
        }
        if ((getPolicyCounter = this.getPolicyCounter(true)) != null) {
            bf.append("\n");
            bf.append("\tContatore: ");
            if (this.tipoRisorsa != null) {
                switch (this.tipoRisorsa) {
                    case NUMERO_RICHIESTE: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                    case NUMERO_RICHIESTE_FALLITE: 
                    case NUMERO_FAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: 
                    case DIMENSIONE_MASSIMA_MESSAGGIO: {
                        bf.append(getPolicyCounter);
                        break;
                    }
                    case OCCUPAZIONE_BANDA: {
                        bf.append(DatiCollezionati.translateToKb(getPolicyCounter));
                        bf.append(OCCUPAZIONE_BANDA_KB_INFO);
                        bf.append(getPolicyCounter);
                        bf.append(OCCUPAZIONE_BANDA_BYTES_INFO);
                        break;
                    }
                    case TEMPO_COMPLESSIVO_RISPOSTA: {
                        bf.append(DatiCollezionati.translateToSeconds(getPolicyCounter));
                        bf.append(TEMPO_COMPLESSIVO_RISPOSTA_SECONDI_INFO);
                        bf.append(getPolicyCounter);
                        bf.append(TEMPO_COMPLESSIVO_RISPOSTA_MILLISECONDI_INFO);
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        bf.append(getPolicyCounter);
                        bf.append(TEMPO_MEDIO_RISPOSTA_MILLISECONDI_INFO);
                    }
                }
            } else {
                bf.append(getPolicyCounter);
            }
        }
        if ((avg = this.getPolicyAvgValue(true)) != null) {
            bf.append("\n");
            bf.append("\tValore Medio: ");
            if (this.tipoRisorsa != null) {
                switch (this.tipoRisorsa) {
                    case NUMERO_RICHIESTE: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                    case NUMERO_RICHIESTE_FALLITE: 
                    case NUMERO_FAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: 
                    case DIMENSIONE_MASSIMA_MESSAGGIO: {
                        bf.append(avg.longValue());
                        break;
                    }
                    case OCCUPAZIONE_BANDA: {
                        bf.append(DatiCollezionati.translateToKb(avg.longValue()));
                        bf.append(OCCUPAZIONE_BANDA_KB_INFO);
                        bf.append(avg.longValue());
                        bf.append(OCCUPAZIONE_BANDA_BYTES_INFO);
                        break;
                    }
                    case TEMPO_COMPLESSIVO_RISPOSTA: {
                        bf.append(DatiCollezionati.translateToSeconds(avg.longValue()));
                        bf.append(TEMPO_COMPLESSIVO_RISPOSTA_SECONDI_INFO);
                        bf.append(avg.longValue());
                        bf.append(TEMPO_COMPLESSIVO_RISPOSTA_MILLISECONDI_INFO);
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        bf.append(avg.longValue());
                        bf.append(TEMPO_MEDIO_RISPOSTA_MILLISECONDI_INFO);
                    }
                }
            } else {
                bf.append(avg.longValue());
            }
        }
        if ((getPolicyDenyRequestCounter = this.getPolicyDenyRequestCounter(true)) != null) {
            bf.append("\n");
            bf.append("\tNumero Richieste Bloccate: ");
            bf.append(getPolicyDenyRequestCounter);
        }
        if (leftPrecedente != null && rightPrecedente != null) {
            bf.append("\n");
            bf.append("\tIntervallo Precedente [");
            bf.append(dateformat.format(leftPrecedente));
            bf.append(" - ");
            bf.append(dateformat.format(rightPrecedente));
            bf.append("]");
        }
        boolean oldExists = false;
        if (this.oldPolicyRequestCounter != null) {
            oldExists = true;
            bf.append("\n");
            bf.append("\tIntervallo Precedente - Numero Richieste Conteggiate: ");
            bf.append(this.oldPolicyRequestCounter);
        }
        if (this.oldPolicyCounter != null) {
            oldExists = true;
            bf.append("\n");
            bf.append("\tIntervallo Precedente - Contatore: ");
            if (this.tipoRisorsa != null) {
                switch (this.tipoRisorsa) {
                    case NUMERO_RICHIESTE: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                    case NUMERO_RICHIESTE_FALLITE: 
                    case NUMERO_FAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: 
                    case DIMENSIONE_MASSIMA_MESSAGGIO: {
                        bf.append(this.oldPolicyCounter);
                        break;
                    }
                    case OCCUPAZIONE_BANDA: {
                        bf.append(DatiCollezionati.translateToKb(this.oldPolicyCounter));
                        bf.append(OCCUPAZIONE_BANDA_KB_INFO);
                        bf.append(this.oldPolicyCounter);
                        bf.append(OCCUPAZIONE_BANDA_BYTES_INFO);
                        break;
                    }
                    case TEMPO_COMPLESSIVO_RISPOSTA: {
                        bf.append(DatiCollezionati.translateToSeconds(this.oldPolicyCounter));
                        bf.append(TEMPO_COMPLESSIVO_RISPOSTA_SECONDI_INFO);
                        bf.append(this.oldPolicyCounter);
                        bf.append(TEMPO_COMPLESSIVO_RISPOSTA_MILLISECONDI_INFO);
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        bf.append(this.oldPolicyCounter);
                        bf.append(TEMPO_MEDIO_RISPOSTA_MILLISECONDI_INFO);
                    }
                }
            } else {
                bf.append(this.oldPolicyCounter);
            }
        }
        if ((oldAvg = this.getOldPolicyAvgValue()) != null) {
            oldExists = true;
            bf.append("\n");
            bf.append("\tIntervallo Precedente - Valore Medio: ");
            if (this.tipoRisorsa != null) {
                switch (this.tipoRisorsa) {
                    case NUMERO_RICHIESTE: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                    case NUMERO_RICHIESTE_FALLITE: 
                    case NUMERO_FAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: 
                    case DIMENSIONE_MASSIMA_MESSAGGIO: {
                        bf.append(oldAvg.longValue());
                        break;
                    }
                    case OCCUPAZIONE_BANDA: {
                        bf.append(DatiCollezionati.translateToKb(oldAvg.longValue()));
                        bf.append(OCCUPAZIONE_BANDA_KB_INFO);
                        bf.append(oldAvg.longValue());
                        bf.append(OCCUPAZIONE_BANDA_BYTES_INFO);
                        break;
                    }
                    case TEMPO_COMPLESSIVO_RISPOSTA: {
                        bf.append(DatiCollezionati.translateToSeconds(oldAvg.longValue()));
                        bf.append(TEMPO_COMPLESSIVO_RISPOSTA_SECONDI_INFO);
                        bf.append(oldAvg.longValue());
                        bf.append(TEMPO_COMPLESSIVO_RISPOSTA_MILLISECONDI_INFO);
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        bf.append(oldAvg.longValue());
                        bf.append(TEMPO_MEDIO_RISPOSTA_MILLISECONDI_INFO);
                    }
                }
            } else {
                bf.append(oldAvg.longValue());
            }
        }
        if (!oldExists && this.policyDateWindowInterval != null && TipoFinestra.PRECEDENTE.equals(this.policyDateWindowInterval) && this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            bf.append("\n");
            bf.append("\tIntervallo Precedente - Dati non ancora disponibili");
        }
        leftPrecedente = null;
        rightPrecedente = null;
        if (this.policyDegradoPrestazionaleDateWindowInterval != null) {
            bf.append("\nDati collezionati per Degrado Prestazionale");
            if (this.policyDegradoPrestazionaleRealtime != null) {
                bf.append("\n");
                bf.append("\tModalit\u00e0 di Controllo: ");
                if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
                    bf.append("realtime");
                } else {
                    bf.append("statistica");
                }
            }
            bf.append("\n");
            bf.append("\tFinestra Osservazione: ");
            bf.append(this.policyDegradoPrestazionaleDateWindowInterval.getValue());
            Date left = null;
            Date right = null;
            switch (this.policyDegradoPrestazionaleDateWindowInterval) {
                case CORRENTE: {
                    left = this.getDegradoPrestazionaleLeftDateWindowCurrentInterval();
                    right = this.getDegradoPrestazionaleRightDateWindowCurrentInterval();
                    break;
                }
                case PRECEDENTE: {
                    left = this.getDegradoPrestazionaleLeftDateWindowCurrentInterval();
                    right = this.getDegradoPrestazionaleRightDateWindowCurrentInterval();
                    leftPrecedente = this.getDegradoPrestazionaleLeftDateWindowPrecedentInterval();
                    rightPrecedente = this.getDegradoPrestazionaleRightDateWindowPrecedentInterval();
                    break;
                }
                case SCORREVOLE: {
                    if (now == null) {
                        now = DateManager.getDate();
                    }
                    left = this.getDegradoPrestazionaleLeftDateWindowSlidingInterval(now);
                    right = this.getDegradoPrestazionaleRightDateWindowSlidingInterval(now);
                }
            }
            bf.append("\n");
            if (left != null && right != null) {
                bf.append("\tIntervallo [");
                bf.append(dateformat.format(left));
                bf.append(" - ");
                bf.append(dateformat.format(right));
                bf.append("]");
            } else if (this.policyDegradoPrestazionaleDate != null) {
                bf.append("\tData: ");
                bf.append(dateformat.format(this.policyDegradoPrestazionaleDate));
            }
        }
        if ((getPolicyDegradoPrestazionaleRequestCounter = this.getPolicyDegradoPrestazionaleRequestCounter(true)) != null) {
            bf.append("\n");
            bf.append("\tNumeroRichieste: ");
            bf.append(getPolicyDegradoPrestazionaleRequestCounter);
        }
        if ((getPolicyDegradoPrestazionaleCounter = this.getPolicyDegradoPrestazionaleCounter(true)) != null) {
            bf.append("\n");
            bf.append("\tContatore: ");
            bf.append(getPolicyDegradoPrestazionaleCounter);
            bf.append(TEMPO_MEDIO_RISPOSTA_MILLISECONDI_INFO);
        }
        if ((avgDegradoPrestazionale = this.getPolicyDegradoPrestazionaleAvgValue(true)) != null) {
            bf.append("\n");
            bf.append("\tValore Medio: ");
            bf.append(avgDegradoPrestazionale.longValue());
            bf.append(TEMPO_MEDIO_RISPOSTA_MILLISECONDI_INFO);
        }
        if (leftPrecedente != null && rightPrecedente != null) {
            bf.append("\n");
            bf.append("\tIntervallo Precedente [");
            bf.append(dateformat.format(leftPrecedente));
            bf.append(" - ");
            bf.append(dateformat.format(rightPrecedente));
            bf.append("]");
        }
        boolean oldDegradoPrestazionaleExists = false;
        if (this.oldPolicyDegradoPrestazionaleRequestCounter != null) {
            oldDegradoPrestazionaleExists = true;
            bf.append("\n");
            bf.append("\tIntervallo Precedente - Numero Richieste: ");
            bf.append(this.oldPolicyDegradoPrestazionaleRequestCounter);
        }
        if (this.oldPolicyDegradoPrestazionaleCounter != null) {
            oldDegradoPrestazionaleExists = true;
            bf.append("\n");
            bf.append("\tIntervallo Precedente - Contatore: ");
            bf.append(this.oldPolicyDegradoPrestazionaleCounter);
            bf.append(TEMPO_MEDIO_RISPOSTA_MILLISECONDI_INFO);
        }
        if ((oldAvgDegradoPrestazionale = this.getOldPolicyDegradoPrestazionaleAvgValue()) != null) {
            oldDegradoPrestazionaleExists = true;
            bf.append("\n");
            bf.append("\tIntervallo Precedente - Valore Medio: ");
            bf.append(oldAvgDegradoPrestazionale.longValue());
            bf.append(TEMPO_MEDIO_RISPOSTA_MILLISECONDI_INFO);
        }
        if (!oldDegradoPrestazionaleExists && this.policyDegradoPrestazionaleDateWindowInterval != null && TipoFinestra.PRECEDENTE.equals(this.policyDegradoPrestazionaleDateWindowInterval) && this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            bf.append("\n");
            bf.append("\tIntervallo Precedente - Dati non ancora disponibili");
        }
        return bf.toString();
    }

    protected boolean isRisorsaContaNumeroRichieste(TipoRisorsa tipoRisorsa) {
        switch (tipoRisorsa) {
            case NUMERO_RICHIESTE: 
            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
            case NUMERO_RICHIESTE_FALLITE: 
            case NUMERO_FAULT_APPLICATIVI: 
            case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                return true;
            }
            case DIMENSIONE_MASSIMA_MESSAGGIO: 
            case OCCUPAZIONE_BANDA: 
            case TEMPO_COMPLESSIVO_RISPOSTA: 
            case TEMPO_MEDIO_RISPOSTA: {
                return false;
            }
        }
        return false;
    }

    protected boolean isRisorsaContaNumeroRichiesteDipendentiEsito(TipoRisorsa tipoRisorsa) {
        switch (tipoRisorsa) {
            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
            case NUMERO_RICHIESTE_FALLITE: 
            case NUMERO_FAULT_APPLICATIVI: 
            case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                return true;
            }
            case NUMERO_RICHIESTE: 
            case DIMENSIONE_MASSIMA_MESSAGGIO: 
            case OCCUPAZIONE_BANDA: 
            case TEMPO_COMPLESSIVO_RISPOSTA: 
            case TEMPO_MEDIO_RISPOSTA: {
                return false;
            }
        }
        return false;
    }

    protected void resetPolicyCounterForDate(Date d) {
        this.policyDate = d;
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.policyRequestCounter = 0L;
            this.policyDenyRequestCounter = 0L;
            if (this.tipoRisorsa == null || !this.isRisorsaContaNumeroRichieste(this.tipoRisorsa)) {
                this.policyCounter = 0L;
            }
        }
    }

    protected void resetPolicyCounterForDateDegradoPrestazionale(Date d) {
        this.policyDegradoPrestazionaleDate = d;
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.policyDegradoPrestazionaleRequestCounter = 0L;
            this.policyDegradoPrestazionaleCounter = 0L;
        }
    }

    protected void logDebug(Logger log, String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    protected void checkPolicyCounterForDate(Logger log, ActivePolicy activePolicy) {
        if (this.policyDate == null) {
            this.resetPolicyCounterForDate(DateUtils.convertToLeftInterval((Date)DateManager.getDate(), (UnitaTemporale)this.policyDateTypeInterval));
            if (this.policyRealtime != null && !this.policyRealtime.booleanValue()) {
                this.oldPolicyDate = DateUtils.incrementDate((Date)this.policyDate, (UnitaTemporale)this.policyDateTypeInterval, (int)(this.policyDateInterval * -1));
            }
        } else {
            Date rightInterval = this.getRightDateWindowCurrentInterval();
            Date now = DateManager.getDate();
            boolean after = now.after(rightInterval);
            if (activePolicy.getConfigurazioneControlloTraffico().isDebug()) {
                SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
                this.logDebug(log, "checkPolicyCounterForDate now[" + dateformat.format(now) + "] after policyDate[" + dateformat.format(rightInterval) + "]: " + after);
            }
            if (after) {
                SimpleDateFormat dateformat;
                if (TipoFinestra.PRECEDENTE.equals(this.getPolicyDateWindowInterval())) {
                    this.oldPolicyDate = this.policyDate;
                    if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
                        this.oldPolicyRequestCounter = this.policyRequestCounter;
                        if (this.tipoRisorsa == null || !this.isRisorsaContaNumeroRichieste(this.tipoRisorsa)) {
                            this.oldPolicyCounter = this.policyCounter;
                        }
                    }
                }
                Date d = DateUtils.incrementDate((Date)this.policyDate, (UnitaTemporale)this.policyDateTypeInterval, (int)this.policyDateInterval);
                Date dRight = DateUtils.convertToRightInterval((Date)d, (UnitaTemporale)this.policyDateTypeInterval);
                dRight = DatiCollezionati.incrementDate(dRight, this.policyDateTypeInterval, this.policyDateInterval, this.policyDateCurrentInterval);
                boolean before = dRight.before(now);
                if (activePolicy.getConfigurazioneControlloTraffico().isDebug()) {
                    dateformat = DateUtils.getSimpleDateFormatMs();
                    this.logDebug(log, "checkPolicyCounterForDate Increment d[" + dateformat.format(d) + "] dRight[" + dateformat.format(dRight) + "] before now[" + dateformat.format(now) + "]: " + before);
                }
                while (before) {
                    if (TipoFinestra.PRECEDENTE.equals(this.getPolicyDateWindowInterval())) {
                        this.oldPolicyDate = d;
                        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
                            this.oldPolicyRequestCounter = 0L;
                            if (this.tipoRisorsa == null || !this.isRisorsaContaNumeroRichieste(this.tipoRisorsa)) {
                                this.oldPolicyCounter = 0L;
                            }
                        }
                    }
                    d = DateUtils.incrementDate((Date)d, (UnitaTemporale)this.policyDateTypeInterval, (int)this.policyDateInterval);
                    dRight = DateUtils.convertToRightInterval((Date)d, (UnitaTemporale)this.policyDateTypeInterval);
                    dRight = DatiCollezionati.incrementDate(dRight, this.policyDateTypeInterval, this.policyDateInterval, this.policyDateCurrentInterval);
                    before = dRight.before(now);
                    if (!activePolicy.getConfigurazioneControlloTraffico().isDebug()) continue;
                    dateformat = DateUtils.getSimpleDateFormatMs();
                    this.logDebug(log, "checkPolicyCounterForDate Increment d[" + dateformat.format(d) + "] dRight[" + dateformat.format(dRight) + "] before now[" + dateformat.format(now) + "]: " + before);
                }
                this.resetPolicyCounterForDate(d);
            }
        }
    }

    protected void checkPolicyCounterForDateDegradoPrestazionale(Logger log, ActivePolicy activePolicy) {
        if (this.policyDegradoPrestazionaleDate == null) {
            this.resetPolicyCounterForDateDegradoPrestazionale(DateUtils.convertToLeftInterval((Date)DateManager.getDate(), (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval));
            if (this.policyDegradoPrestazionaleRealtime != null && !this.policyDegradoPrestazionaleRealtime.booleanValue()) {
                this.oldPolicyDegradoPrestazionaleDate = DateUtils.incrementDate((Date)this.policyDegradoPrestazionaleDate, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval, (int)(this.policyDegradoPrestazionaleDateInterval * -1));
            }
        } else {
            Date rightInterval = this.getDegradoPrestazionaleRightDateWindowCurrentInterval();
            Date now = DateManager.getDate();
            boolean after = now.after(rightInterval);
            if (activePolicy.getConfigurazioneControlloTraffico().isDebug()) {
                SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
                this.logDebug(log, "checkPolicyCounterForDateDegradoPrestazionale now[" + dateformat.format(now) + "] after policyDate[" + dateformat.format(rightInterval) + "]: " + after);
            }
            if (after) {
                SimpleDateFormat dateformat;
                if (TipoFinestra.PRECEDENTE.equals(this.getPolicyDegradoPrestazionaleDateWindowInterval())) {
                    this.oldPolicyDegradoPrestazionaleDate = this.policyDegradoPrestazionaleDate;
                    if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
                        this.oldPolicyDegradoPrestazionaleRequestCounter = this.policyDegradoPrestazionaleRequestCounter;
                        this.oldPolicyDegradoPrestazionaleCounter = this.policyDegradoPrestazionaleCounter;
                    }
                }
                Date d = DateUtils.incrementDate((Date)this.policyDegradoPrestazionaleDate, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval, (int)this.policyDegradoPrestazionaleDateInterval);
                Date dRight = DateUtils.incrementDate((Date)d, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval, (int)this.policyDegradoPrestazionaleDateInterval);
                dRight = DateUtils.convertToRightInterval((Date)dRight, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval);
                boolean before = dRight.before(now);
                if (activePolicy.getConfigurazioneControlloTraffico().isDebug()) {
                    dateformat = DateUtils.getSimpleDateFormatMs();
                    this.logDebug(log, "checkPolicyCounterForDateDegradoPrestazionale Increment d[" + dateformat.format(d) + "] dRight[" + dateformat.format(dRight) + "] before now[" + dateformat.format(now) + "]: " + before);
                }
                while (before) {
                    if (TipoFinestra.PRECEDENTE.equals(this.getPolicyDegradoPrestazionaleDateWindowInterval())) {
                        this.oldPolicyDegradoPrestazionaleDate = d;
                        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
                            this.oldPolicyDegradoPrestazionaleRequestCounter = 0L;
                            this.oldPolicyDegradoPrestazionaleCounter = 0L;
                        }
                    }
                    d = DateUtils.incrementDate((Date)d, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval, (int)this.policyDegradoPrestazionaleDateInterval);
                    dRight = DateUtils.incrementDate((Date)d, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval, (int)this.policyDegradoPrestazionaleDateInterval);
                    dRight = DateUtils.convertToRightInterval((Date)dRight, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval);
                    before = dRight.before(now);
                    if (!activePolicy.getConfigurazioneControlloTraffico().isDebug()) continue;
                    dateformat = DateUtils.getSimpleDateFormatMs();
                    this.logDebug(log, "checkPolicyCounterForDateDegradoPrestazionale Increment d[" + dateformat.format(d) + "] dRight[" + dateformat.format(dRight) + "] before now[" + dateformat.format(now) + "]: " + before);
                }
                this.resetPolicyCounterForDateDegradoPrestazionale(d);
            }
        }
    }

    public void resetCounters() {
        this.resetCounters(null);
        this.manuallyResetPolicyTimeMillis = DateManager.getTimeMillis();
    }

    public void resetCounters(Date updatePolicyDate) {
        if (updatePolicyDate != null) {
            this.updatePolicyDate = updatePolicyDate;
        }
        if (this.policyRequestCounter != null) {
            this.policyRequestCounter = 0L;
        }
        if (this.policyCounter != null) {
            this.policyCounter = 0L;
        }
        if (this.policyDenyRequestCounter != null) {
            this.policyDenyRequestCounter = 0L;
        }
        this.oldPolicyDate = null;
        if (this.oldPolicyRequestCounter != null) {
            this.oldPolicyRequestCounter = 0L;
        }
        if (this.oldPolicyCounter != null) {
            this.oldPolicyCounter = 0L;
        }
        if (this.policyDegradoPrestazionaleRequestCounter != null) {
            this.policyDegradoPrestazionaleRequestCounter = 0L;
        }
        if (this.policyDegradoPrestazionaleCounter != null) {
            this.policyDegradoPrestazionaleCounter = 0L;
        }
        this.oldPolicyDegradoPrestazionaleDate = null;
        if (this.oldPolicyDegradoPrestazionaleRequestCounter != null) {
            this.oldPolicyDegradoPrestazionaleRequestCounter = 0L;
        }
        if (this.oldPolicyDegradoPrestazionaleCounter != null) {
            this.oldPolicyDegradoPrestazionaleCounter = 0L;
        }
    }

    public void checkDate(Logger log, ActivePolicy activePolicy) {
        if (this.creationDate == null) {
            this.initDatiIniziali(activePolicy);
        }
        if (this.getPolicyDateWindowInterval() != null && !TipoFinestra.SCORREVOLE.equals(this.getPolicyDateWindowInterval())) {
            this.checkPolicyCounterForDate(log, activePolicy);
        }
        if (this.getPolicyDegradoPrestazionaleDateWindowInterval() != null && !TipoFinestra.SCORREVOLE.equals(this.getPolicyDegradoPrestazionaleDateWindowInterval())) {
            this.checkPolicyCounterForDateDegradoPrestazionale(log, activePolicy);
        }
    }

    private boolean skipBecauseManuallyResetAfterStartRequest(String source, Map<Object> ctx) {
        if (source != null) {
            // empty if block
        }
        if (this.manuallyResetPolicyTimeMillis != null && ctx != null) {
            Object o = ctx.get(START_PROCESS_REQUEST_TIME_MS);
            if (o == null) {
                return true;
            }
            Long l = (Long)o;
            if (l < this.manuallyResetPolicyTimeMillis) {
                return true;
            }
        }
        return false;
    }

    protected void internalRegisterStartRequestIncrementActiveRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        Long l = this.activeRequestCounter;
        this.activeRequestCounter = this.activeRequestCounter + 1L;
        if (datiCollezionatiPerPolicyVerifier != null) {
            datiCollezionatiPerPolicyVerifier.activeRequestCounter = this.activeRequestCounter;
        }
    }

    public void registerStartRequest(Logger log, ActivePolicy activePolicy, Map<Object> ctx) {
        this.registerStartRequest(log, activePolicy, ctx, null);
    }

    public void registerStartRequest(Logger log, ActivePolicy activePolicy, Map<Object> ctx, DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        if (this.creationDate == null) {
            this.initDatiIniziali(activePolicy);
        }
        this.internalRegisterStartRequestIncrementActiveRequestCounter(datiCollezionatiPerPolicyVerifier);
        if (this.getPolicyDateWindowInterval() != null && !TipoFinestra.SCORREVOLE.equals(this.getPolicyDateWindowInterval())) {
            this.checkPolicyCounterForDate(log, activePolicy);
        }
        if (this.getPolicyDegradoPrestazionaleDateWindowInterval() != null && !TipoFinestra.SCORREVOLE.equals(this.getPolicyDegradoPrestazionaleDateWindowInterval())) {
            this.checkPolicyCounterForDateDegradoPrestazionale(log, activePolicy);
        }
        if (this.manuallyResetPolicyTimeMillis != null && ctx != null) {
            ctx.put(START_PROCESS_REQUEST_TIME_MS, (Object)DateManager.getTimeMillis());
        }
    }

    protected void internalUpdateDatiStartRequestApplicabileIncrementRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        Long l = this.policyRequestCounter;
        this.policyRequestCounter = this.policyRequestCounter + 1L;
        if (datiCollezionatiPerPolicyVerifier != null) {
            datiCollezionatiPerPolicyVerifier.policyRequestCounter = this.policyRequestCounter;
        }
    }

    public boolean updateDatiStartRequestApplicabile(Logger log, ActivePolicy activePolicy, Map<Object> ctx) {
        return this.updateDatiStartRequestApplicabile(log, activePolicy, ctx, null);
    }

    public boolean updateDatiStartRequestApplicabile(Logger log, ActivePolicy activePolicy, Map<Object> ctx, DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        if (log != null) {
            // empty if block
        }
        if (this.skipBecauseManuallyResetAfterStartRequest("updateDatiStartRequestApplicabile", ctx)) {
            return false;
        }
        if (this.getPolicyDateWindowInterval() != null && !TipoFinestra.SCORREVOLE.equals(this.getPolicyDateWindowInterval()) && this.policyRealtime != null && this.policyRealtime.booleanValue() && !TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals(activePolicy.getTipoRisorsaPolicy()) && !this.isRisorsaContaNumeroRichiesteDipendentiEsito(activePolicy.getTipoRisorsaPolicy())) {
            this.internalUpdateDatiStartRequestApplicabileIncrementRequestCounter(datiCollezionatiPerPolicyVerifier);
            return true;
        }
        return false;
    }

    protected void internalRegisterEndRequestDecrementActiveRequestCounter() {
        Long l = this.activeRequestCounter;
        this.activeRequestCounter = this.activeRequestCounter - 1L;
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleRequestCounter() {
        Long l = this.policyDegradoPrestazionaleRequestCounter;
        this.policyDegradoPrestazionaleRequestCounter = this.policyDegradoPrestazionaleRequestCounter + 1L;
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleCounter(long latenza) {
        this.policyDegradoPrestazionaleCounter = this.policyDegradoPrestazionaleCounter + latenza;
    }

    public void registerEndRequest(Logger log, ActivePolicy activePolicy, Map<Object> ctx, MisurazioniTransazione dati) {
        if (log != null) {
            // empty if block
        }
        if (this.creationDate == null) {
            return;
        }
        this.internalRegisterEndRequestDecrementActiveRequestCounter();
        if (this.skipBecauseManuallyResetAfterStartRequest("registerEndRequest", ctx)) {
            return;
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            long latenza = 0L;
            int[] esitiValidi = null;
            esitiValidi = TipoPdD.DELEGATA.equals(dati.getTipoPdD()) ? activePolicy.getConfigurazioneControlloTraffico().getCalcoloLatenzaPortaDelegataEsitiConsiderati().get(dati.getProtocollo()) : activePolicy.getConfigurazioneControlloTraffico().getCalcoloLatenzaPortaApplicativaEsitiConsiderati().get(dati.getProtocollo());
            boolean found = false;
            for (int esitoValido : esitiValidi) {
                if (dati.getEsitoTransazione() != esitoValido) continue;
                latenza = this.getLatenza(activePolicy.getConfigurazionePolicy().getDegradoAvgTimeTipoLatenza(), dati);
                found = true;
                break;
            }
            if (found) {
                this.internalRegisterEndRequestIncrementDegradoPrestazionaleRequestCounter();
                this.internalRegisterEndRequestIncrementDegradoPrestazionaleCounter(latenza);
            }
        }
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementRequestCounter() {
        Long l = this.policyRequestCounter;
        this.policyRequestCounter = this.policyRequestCounter + 1L;
    }

    protected void internalUpdateDatiEndRequestApplicabileDecrementRequestCounter() {
        Long l = this.policyRequestCounter;
        this.policyRequestCounter = this.policyRequestCounter - 1L;
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementDenyRequestCounter() {
        Long l = this.policyDenyRequestCounter;
        this.policyDenyRequestCounter = this.policyDenyRequestCounter + 1L;
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementCounter(long v) {
        this.policyCounter = this.policyCounter + v;
    }

    public void updateDatiEndRequestApplicabile(Logger log, ActivePolicy activePolicy, Map<Object> ctx, MisurazioniTransazione dati, List<Integer> esitiCodeOk, List<Integer> esitiCodeKoSenzaFaultApplicativo, List<Integer> esitiCodeFaultApplicativo, boolean isViolata) throws PolicyException {
        if (log != null) {
            // empty if block
        }
        if (this.skipBecauseManuallyResetAfterStartRequest("updateDatiEndRequestApplicabile", ctx)) {
            return;
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            int[] esitiPolicyViolate = activePolicy.getConfigurazioneControlloTraffico().getEsitiPolicyViolate().get(dati.getProtocollo());
            boolean foundEsitoDeny = false;
            for (int esitoViolato : esitiPolicyViolate) {
                if (dati.getEsitoTransazione() != esitoViolato) continue;
                foundEsitoDeny = true;
                break;
            }
            if (foundEsitoDeny) {
                if (!TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals(activePolicy.getTipoRisorsaPolicy()) && !this.isRisorsaContaNumeroRichiesteDipendentiEsito(activePolicy.getTipoRisorsaPolicy())) {
                    this.internalUpdateDatiEndRequestApplicabileDecrementRequestCounter();
                }
                if (isViolata) {
                    this.internalUpdateDatiEndRequestApplicabileIncrementDenyRequestCounter();
                }
                return;
            }
            block1 : switch (activePolicy.getTipoRisorsaPolicy()) {
                case DIMENSIONE_MASSIMA_MESSAGGIO: {
                    break;
                }
                case NUMERO_RICHIESTE: {
                    break;
                }
                case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                case NUMERO_RICHIESTE_FALLITE: 
                case NUMERO_FAULT_APPLICATIVI: 
                case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                    List<Integer> esitiAppartenentiGruppo = null;
                    try {
                        if (TipoRisorsa.NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO.equals(activePolicy.getTipoRisorsaPolicy())) {
                            esitiAppartenentiGruppo = esitiCodeOk;
                        } else if (TipoRisorsa.NUMERO_RICHIESTE_FALLITE.equals(activePolicy.getTipoRisorsaPolicy())) {
                            esitiAppartenentiGruppo = esitiCodeKoSenzaFaultApplicativo;
                        } else if (TipoRisorsa.NUMERO_FAULT_APPLICATIVI.equals(activePolicy.getTipoRisorsaPolicy())) {
                            esitiAppartenentiGruppo = esitiCodeFaultApplicativo;
                        } else if (TipoRisorsa.NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI.equals(activePolicy.getTipoRisorsaPolicy())) {
                            esitiAppartenentiGruppo = new ArrayList<Integer>();
                            esitiAppartenentiGruppo.addAll(esitiCodeKoSenzaFaultApplicativo);
                            esitiAppartenentiGruppo.addAll(esitiCodeFaultApplicativo);
                        } else {
                            esitiAppartenentiGruppo = new ArrayList<Integer>();
                            esitiAppartenentiGruppo.addAll(esitiCodeOk);
                            esitiAppartenentiGruppo.addAll(esitiCodeFaultApplicativo);
                        }
                    }
                    catch (Exception e) {
                        throw new PolicyException(e.getMessage(), e);
                    }
                    for (int esitoAppartenenteGruppo : esitiAppartenentiGruppo) {
                        if (dati.getEsitoTransazione() != esitoAppartenenteGruppo) continue;
                        this.internalUpdateDatiEndRequestApplicabileIncrementRequestCounter();
                        break block1;
                    }
                    break;
                }
                case OCCUPAZIONE_BANDA: {
                    long banda = this.getBanda(activePolicy.getConfigurazionePolicy().getValoreTipoBanda(), dati);
                    this.internalUpdateDatiEndRequestApplicabileIncrementCounter(banda);
                    break;
                }
                case TEMPO_COMPLESSIVO_RISPOSTA: 
                case TEMPO_MEDIO_RISPOSTA: {
                    int[] esitiValidi = null;
                    esitiValidi = TipoPdD.DELEGATA.equals(dati.getTipoPdD()) ? activePolicy.getConfigurazioneControlloTraffico().getCalcoloLatenzaPortaDelegataEsitiConsiderati().get(dati.getProtocollo()) : activePolicy.getConfigurazioneControlloTraffico().getCalcoloLatenzaPortaApplicativaEsitiConsiderati().get(dati.getProtocollo());
                    boolean found = false;
                    for (int esitoValido : esitiValidi) {
                        if (dati.getEsitoTransazione() != esitoValido) continue;
                        long latenza = this.getLatenza(activePolicy.getConfigurazionePolicy().getValoreTipoLatenza(), dati);
                        this.internalUpdateDatiEndRequestApplicabileIncrementCounter(latenza);
                        found = true;
                        break;
                    }
                    if (!found || !TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals(activePolicy.getTipoRisorsaPolicy())) break;
                    this.internalUpdateDatiEndRequestApplicabileIncrementRequestCounter();
                }
            }
        }
    }

    protected long getLatenza(TipoLatenza tipoLatenza, MisurazioniTransazione dati) {
        long latenza = 0L;
        switch (tipoLatenza) {
            case TOTALE: {
                if (dati.getDataUscitaRisposta() == null || dati.getDataIngressoRichiesta() == null) break;
                latenza = dati.getDataUscitaRisposta().getTime() - dati.getDataIngressoRichiesta().getTime();
                break;
            }
            case SERVIZIO: {
                if (dati.getDataUscitaRichiesta() == null || dati.getDataIngressoRisposta() == null) break;
                latenza = dati.getDataIngressoRisposta().getTime() - dati.getDataUscitaRichiesta().getTime();
                break;
            }
            case PORTA: {
                if (dati.getDataUscitaRichiesta() != null && dati.getDataIngressoRichiesta() != null) {
                    latenza = dati.getDataUscitaRichiesta().getTime() - dati.getDataIngressoRichiesta().getTime();
                }
                if (dati.getDataIngressoRisposta() == null || dati.getDataUscitaRisposta() == null) break;
                latenza = latenza + dati.getDataUscitaRisposta().getTime() - dati.getDataIngressoRisposta().getTime();
            }
        }
        return latenza;
    }

    protected long getBanda(TipoBanda tipoBanda, MisurazioniTransazione dati) {
        long bandaInterna = 0L;
        long bandaEsterna = 0L;
        if (TipoPdD.DELEGATA.equals(dati.getTipoPdD())) {
            if (dati.getRichiestaIngressoBytes() != null && dati.getRichiestaIngressoBytes() > 0L) {
                bandaInterna += dati.getRichiestaIngressoBytes().longValue();
            }
            if (dati.getRispostaUscitaBytes() != null && dati.getRispostaUscitaBytes() > 0L) {
                bandaInterna += dati.getRispostaUscitaBytes().longValue();
            }
            if (dati.getRichiestaUscitaBytes() != null && dati.getRichiestaUscitaBytes() > 0L) {
                bandaEsterna += dati.getRichiestaUscitaBytes().longValue();
            }
            if (dati.getRispostaIngressoBytes() != null && dati.getRispostaIngressoBytes() > 0L) {
                bandaEsterna += dati.getRispostaIngressoBytes().longValue();
            }
        } else {
            if (dati.getRichiestaIngressoBytes() != null && dati.getRichiestaIngressoBytes() > 0L) {
                bandaEsterna += dati.getRichiestaIngressoBytes().longValue();
            }
            if (dati.getRispostaUscitaBytes() != null && dati.getRispostaUscitaBytes() > 0L) {
                bandaEsterna += dati.getRispostaUscitaBytes().longValue();
            }
            if (dati.getRichiestaUscitaBytes() != null && dati.getRichiestaUscitaBytes() > 0L) {
                bandaInterna += dati.getRichiestaUscitaBytes().longValue();
            }
            if (dati.getRispostaIngressoBytes() != null && dati.getRispostaIngressoBytes() > 0L) {
                bandaInterna += dati.getRispostaIngressoBytes().longValue();
            }
        }
        switch (tipoBanda) {
            case COMPLESSIVA: {
                return bandaEsterna + bandaInterna;
            }
            case INTERNA: {
                return bandaInterna;
            }
            case ESTERNA: {
                return bandaEsterna;
            }
        }
        return 0L;
    }

    public Date getCloneDate() {
        return this.cloneDate;
    }

    public TipoRisorsa getTipoRisorsa() {
        return this.tipoRisorsa;
    }

    public Long getActiveRequestCounter() {
        return this.getActiveRequestCounter(false);
    }

    protected Long getActiveRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            // empty if block
        }
        return this.activeRequestCounter;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getUpdatePolicyDate() {
        return this.updatePolicyDate;
    }

    public Date getGestorePolicyConfigDate() {
        return this.gestorePolicyConfigDate;
    }

    @Deprecated
    public Long getManuallyResetPolicyTimeMillis() {
        return this.manuallyResetPolicyTimeMillis;
    }

    public Date getPolicyDate() {
        return this.policyDate;
    }

    public Long getPolicyRequestCounter() {
        return this.getPolicyRequestCounter(false);
    }

    protected Long getPolicyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            // empty if block
        }
        return this.policyRequestCounter;
    }

    public Long getPolicyCounter() {
        return this.getPolicyCounter(false);
    }

    protected Long getPolicyCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            // empty if block
        }
        return this.policyCounter;
    }

    @Deprecated
    public Long getPolicyDenyRequestCounter() {
        return this.policyDenyRequestCounter;
    }

    @Deprecated
    public Long getPolicyDegradoPrestazionaleRequestCounter() {
        return this.policyDegradoPrestazionaleRequestCounter;
    }

    @Deprecated
    public Long getPolicyDegradoPrestazionaleCounter() {
        return this.policyDegradoPrestazionaleCounter;
    }

    public Double getPolicyAvgValue() {
        return this.getPolicyAvgValue(false);
    }

    protected Double getPolicyAvgValue(boolean readRemoteInfo) {
        Double doubleValue = null;
        Long getPolicyCounter = this.getPolicyCounter(readRemoteInfo);
        Long getPolicyRequestCounter = this.getPolicyRequestCounter(readRemoteInfo);
        if (getPolicyCounter != null && getPolicyRequestCounter != null) {
            double c = getPolicyCounter.doubleValue();
            double n = getPolicyRequestCounter.doubleValue();
            doubleValue = c / n;
        }
        return doubleValue;
    }

    protected Long getPolicyDenyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            // empty if block
        }
        return this.policyDenyRequestCounter;
    }

    public Date getLeftDateWindowCurrentInterval() {
        if (this.policyDate != null && this.policyDateTypeInterval != null) {
            return DateUtils.convertToLeftInterval((Date)this.policyDate, (UnitaTemporale)this.policyDateTypeInterval);
        }
        return null;
    }

    public Date getRightDateWindowCurrentInterval() {
        if (this.policyDate != null && this.policyDateTypeInterval != null && this.policyDateInterval != null && this.policyDateCurrentInterval != null) {
            Date d = DateUtils.convertToRightInterval((Date)this.policyDate, (UnitaTemporale)this.policyDateTypeInterval);
            return DatiCollezionati.incrementDate(d, this.policyDateTypeInterval, this.policyDateInterval, this.policyDateCurrentInterval);
        }
        return null;
    }

    public Date getOldPolicyDate() {
        return this.oldPolicyDate;
    }

    public Long getOldPolicyRequestCounter() {
        return this.oldPolicyRequestCounter;
    }

    public Long getOldPolicyCounter() {
        return this.oldPolicyCounter;
    }

    public Double getOldPolicyAvgValue() {
        Double doubleValue = null;
        if (this.oldPolicyCounter != null && this.oldPolicyRequestCounter != null) {
            double c = this.oldPolicyCounter.doubleValue();
            double n = this.oldPolicyRequestCounter.doubleValue();
            doubleValue = c / n;
        }
        return doubleValue;
    }

    public Date getLeftDateWindowPrecedentInterval() {
        if (this.oldPolicyDate != null && this.policyDateTypeInterval != null) {
            return DateUtils.convertToLeftInterval((Date)this.oldPolicyDate, (UnitaTemporale)this.policyDateTypeInterval);
        }
        return null;
    }

    public Date getRightDateWindowPrecedentInterval() {
        if (this.oldPolicyDate != null && this.policyDateTypeInterval != null && this.policyDateInterval != null && this.policyDateCurrentInterval != null) {
            Date d = DateUtils.convertToRightInterval((Date)this.oldPolicyDate, (UnitaTemporale)this.policyDateTypeInterval);
            return DatiCollezionati.incrementDate(d, this.policyDateTypeInterval, this.policyDateInterval, this.policyDateCurrentInterval);
        }
        return null;
    }

    public Integer getPolicyDateInterval() {
        return this.policyDateInterval;
    }

    public Boolean getPolicyDateCurrentInterval() {
        return this.policyDateCurrentInterval;
    }

    public UnitaTemporale getPolicyDateTypeInterval() {
        return this.policyDateTypeInterval;
    }

    public TipoFinestra getPolicyDateWindowInterval() {
        return this.policyDateWindowInterval;
    }

    public Boolean getPolicyRealtime() {
        return this.policyRealtime;
    }

    public Date getLeftDateWindowSlidingInterval(Date now) {
        if (this.policyDateTypeInterval != null && this.policyDateInterval != null && this.policyDateCurrentInterval != null) {
            Date d = DateUtils.convertToLeftInterval((Date)now, (UnitaTemporale)this.policyDateTypeInterval);
            return DatiCollezionati.decrementDate(d, this.policyDateTypeInterval, this.policyDateInterval, this.policyDateCurrentInterval);
        }
        return null;
    }

    public Date getRightDateWindowSlidingInterval(Date now) {
        if (this.policyDateTypeInterval != null && this.policyDateCurrentInterval != null) {
            Date d = DateUtils.convertToRightInterval((Date)now, (UnitaTemporale)this.policyDateTypeInterval);
            if (!this.policyDateCurrentInterval.booleanValue()) {
                d = DateUtils.incrementDate((Date)d, (UnitaTemporale)this.policyDateTypeInterval, (int)-1);
            }
            return d;
        }
        return null;
    }

    public Date getPolicyDegradoPrestazionaleDate() {
        return this.policyDegradoPrestazionaleDate;
    }

    protected Long getPolicyDegradoPrestazionaleRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            // empty if block
        }
        return this.policyDegradoPrestazionaleRequestCounter;
    }

    protected Long getPolicyDegradoPrestazionaleCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            // empty if block
        }
        return this.policyDegradoPrestazionaleCounter;
    }

    public Double getPolicyDegradoPrestazionaleAvgValue() {
        return this.getPolicyDegradoPrestazionaleAvgValue(false);
    }

    protected Double getPolicyDegradoPrestazionaleAvgValue(boolean readRemoteInfo) {
        Double doubleValue = null;
        Long getPolicyDegradoPrestazionaleRequestCounter = this.getPolicyDegradoPrestazionaleRequestCounter(readRemoteInfo);
        Long getPolicyDegradoPrestazionaleCounter = this.getPolicyDegradoPrestazionaleCounter(readRemoteInfo);
        if (getPolicyDegradoPrestazionaleCounter != null && getPolicyDegradoPrestazionaleRequestCounter != null) {
            double c = getPolicyDegradoPrestazionaleCounter.doubleValue();
            double n = getPolicyDegradoPrestazionaleRequestCounter.doubleValue();
            doubleValue = c / n;
        }
        return doubleValue;
    }

    public Date getDegradoPrestazionaleLeftDateWindowCurrentInterval() {
        if (this.policyDegradoPrestazionaleDate != null && this.policyDegradoPrestazionaleDateTypeInterval != null) {
            return DateUtils.convertToLeftInterval((Date)this.policyDegradoPrestazionaleDate, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval);
        }
        return null;
    }

    public Date getDegradoPrestazionaleRightDateWindowCurrentInterval() {
        if (this.policyDegradoPrestazionaleDate != null && this.policyDegradoPrestazionaleDateTypeInterval != null && this.policyDegradoPrestazionaleDateInterval != null && this.policyDegradoPrestazionaleDateCurrentInterval != null) {
            Date d = DateUtils.convertToRightInterval((Date)this.policyDegradoPrestazionaleDate, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval);
            return DatiCollezionati.incrementDate(d, this.policyDegradoPrestazionaleDateTypeInterval, this.policyDegradoPrestazionaleDateInterval, this.policyDegradoPrestazionaleDateCurrentInterval);
        }
        return null;
    }

    public Date getOldPolicyDegradoPrestazionaleDate() {
        return this.oldPolicyDegradoPrestazionaleDate;
    }

    public Long getOldPolicyDegradoPrestazionaleRequestCounter() {
        return this.oldPolicyDegradoPrestazionaleRequestCounter;
    }

    public Long getOldPolicyDegradoPrestazionaleCounter() {
        return this.oldPolicyDegradoPrestazionaleCounter;
    }

    public Double getOldPolicyDegradoPrestazionaleAvgValue() {
        Double doubleValue = null;
        if (this.oldPolicyDegradoPrestazionaleCounter != null && this.oldPolicyDegradoPrestazionaleRequestCounter != null) {
            double c = this.oldPolicyDegradoPrestazionaleCounter.doubleValue();
            double n = this.oldPolicyDegradoPrestazionaleRequestCounter.doubleValue();
            doubleValue = c / n;
        }
        return doubleValue;
    }

    public Date getDegradoPrestazionaleLeftDateWindowPrecedentInterval() {
        if (this.oldPolicyDegradoPrestazionaleDate != null && this.policyDegradoPrestazionaleDateTypeInterval != null) {
            return DateUtils.convertToLeftInterval((Date)this.oldPolicyDegradoPrestazionaleDate, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval);
        }
        return null;
    }

    public Date getDegradoPrestazionaleRightDateWindowPrecedentInterval() {
        if (this.oldPolicyDegradoPrestazionaleDate != null && this.policyDegradoPrestazionaleDateTypeInterval != null && this.policyDegradoPrestazionaleDateInterval != null && this.policyDegradoPrestazionaleDateCurrentInterval != null) {
            Date d = DateUtils.convertToRightInterval((Date)this.oldPolicyDegradoPrestazionaleDate, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval);
            return DatiCollezionati.incrementDate(d, this.policyDegradoPrestazionaleDateTypeInterval, this.policyDegradoPrestazionaleDateInterval, this.policyDegradoPrestazionaleDateCurrentInterval);
        }
        return null;
    }

    public Integer getPolicyDegradoPrestazionaleDateInterval() {
        return this.policyDegradoPrestazionaleDateInterval;
    }

    public Boolean getPolicyDegradoPrestazionaleDateCurrentInterval() {
        return this.policyDegradoPrestazionaleDateCurrentInterval;
    }

    public UnitaTemporale getPolicyDegradoPrestazionaleDateTypeInterval() {
        return this.policyDegradoPrestazionaleDateTypeInterval;
    }

    public TipoFinestra getPolicyDegradoPrestazionaleDateWindowInterval() {
        return this.policyDegradoPrestazionaleDateWindowInterval;
    }

    public Boolean getPolicyDegradoPrestazionaleRealtime() {
        return this.policyDegradoPrestazionaleRealtime;
    }

    public Date getDegradoPrestazionaleLeftDateWindowSlidingInterval(Date now) {
        if (this.policyDegradoPrestazionaleDateTypeInterval != null && this.policyDegradoPrestazionaleDateInterval != null && this.policyDegradoPrestazionaleDateCurrentInterval != null) {
            Date d = DateUtils.convertToLeftInterval((Date)now, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval);
            return DatiCollezionati.decrementDate(d, this.policyDegradoPrestazionaleDateTypeInterval, this.policyDegradoPrestazionaleDateInterval, this.policyDegradoPrestazionaleDateCurrentInterval);
        }
        return null;
    }

    public Date getDegradoPrestazionaleRightDateWindowSlidingInterval(Date now) {
        if (this.policyDegradoPrestazionaleDateTypeInterval != null && this.policyDegradoPrestazionaleDateCurrentInterval != null) {
            Date d = DateUtils.convertToRightInterval((Date)now, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval);
            if (!this.policyDegradoPrestazionaleDateCurrentInterval.booleanValue()) {
                d = DateUtils.incrementDate((Date)d, (UnitaTemporale)this.policyDegradoPrestazionaleDateTypeInterval, (int)-1);
            }
            return d;
        }
        return null;
    }

    @Deprecated
    public void setTipoRisorsa(TipoRisorsa tipoRisorsa) {
        this.tipoRisorsa = tipoRisorsa;
    }

    public void initActiveRequestCounter() {
        this.activeRequestCounter = 0L;
    }

    @Deprecated
    public void setActiveRequestCounter(long activeRequestCounter) {
        this.activeRequestCounter = activeRequestCounter;
    }

    public long setAndGetActiveRequestCounter(long activeRequestCounter) {
        this.activeRequestCounter = activeRequestCounter;
        return this.activeRequestCounter;
    }

    @Deprecated
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Deprecated
    public void setUpdatePolicyDate(Date updatePolicyDate) {
        this.updatePolicyDate = updatePolicyDate;
    }

    @Deprecated
    public void setPolicyDateInterval(Integer policyDateInterval) {
        this.policyDateInterval = policyDateInterval;
    }

    @Deprecated
    public void setPolicyDateCurrentInterval(Boolean policyDateCurrentInterval) {
        this.policyDateCurrentInterval = policyDateCurrentInterval;
    }

    @Deprecated
    public void setPolicyDateTypeInterval(UnitaTemporale policyDateTypeInterval) {
        this.policyDateTypeInterval = policyDateTypeInterval;
    }

    @Deprecated
    public void setPolicyDateWindowInterval(TipoFinestra policyDateWindowInterval) {
        this.policyDateWindowInterval = policyDateWindowInterval;
    }

    @Deprecated
    public void setPolicyRealtime(Boolean policyRealtime) {
        this.policyRealtime = policyRealtime;
    }

    @Deprecated
    public void setPolicyDate(Date policyDate) {
        this.policyDate = policyDate;
    }

    @Deprecated
    public void setPolicyRequestCounter(Long policyRequestCounter) {
        this.policyRequestCounter = policyRequestCounter;
    }

    public Long setAndGetPolicyRequestCounter(Long policyRequestCounter) {
        this.policyRequestCounter = policyRequestCounter;
        return this.policyRequestCounter;
    }

    @Deprecated
    public void setPolicyCounter(Long policyCounter) {
        this.policyCounter = policyCounter;
    }

    @Deprecated
    public void setPolicyDenyRequestCounter(Long policyDenyRequestCounter) {
        this.policyDenyRequestCounter = policyDenyRequestCounter;
    }

    @Deprecated
    public void setOldPolicyDate(Date oldPolicyDate) {
        this.oldPolicyDate = oldPolicyDate;
    }

    @Deprecated
    public void setOldPolicyRequestCounter(Long oldPolicyRequestCounter) {
        this.oldPolicyRequestCounter = oldPolicyRequestCounter;
    }

    @Deprecated
    public void setOldPolicyCounter(Long oldPolicyCounter) {
        this.oldPolicyCounter = oldPolicyCounter;
    }

    @Deprecated
    public void setPolicyDegradoPrestazionaleDateInterval(Integer policyDegradoPrestazionaleDateInterval) {
        this.policyDegradoPrestazionaleDateInterval = policyDegradoPrestazionaleDateInterval;
    }

    @Deprecated
    public void setPolicyDegradoPrestazionaleDateCurrentInterval(Boolean policyDegradoPrestazionaleDateCurrentInterval) {
        this.policyDegradoPrestazionaleDateCurrentInterval = policyDegradoPrestazionaleDateCurrentInterval;
    }

    @Deprecated
    public void setPolicyDegradoPrestazionaleDateTypeInterval(UnitaTemporale policyDegradoPrestazionaleDateTypeInterval) {
        this.policyDegradoPrestazionaleDateTypeInterval = policyDegradoPrestazionaleDateTypeInterval;
    }

    @Deprecated
    public void setPolicyDegradoPrestazionaleDateWindowInterval(TipoFinestra policyDegradoPrestazionaleDateWindowInterval) {
        this.policyDegradoPrestazionaleDateWindowInterval = policyDegradoPrestazionaleDateWindowInterval;
    }

    @Deprecated
    public void setPolicyDegradoPrestazionaleRealtime(Boolean policyDegradoPrestazionaleRealtime) {
        this.policyDegradoPrestazionaleRealtime = policyDegradoPrestazionaleRealtime;
    }

    @Deprecated
    public void setPolicyDegradoPrestazionaleDate(Date policyDegradoPrestazionaleDate) {
        this.policyDegradoPrestazionaleDate = policyDegradoPrestazionaleDate;
    }

    @Deprecated
    public void setPolicyDegradoPrestazionaleRequestCounter(Long policyDegradoPrestazionaleRequestCounter) {
        this.policyDegradoPrestazionaleRequestCounter = policyDegradoPrestazionaleRequestCounter;
    }

    @Deprecated
    public void setPolicyDegradoPrestazionaleCounter(Long policyDegradoPrestazionaleCounter) {
        this.policyDegradoPrestazionaleCounter = policyDegradoPrestazionaleCounter;
    }

    @Deprecated
    public void setOldPolicyDegradoPrestazionaleDate(Date oldPolicyDegradoPrestazionaleDate) {
        this.oldPolicyDegradoPrestazionaleDate = oldPolicyDegradoPrestazionaleDate;
    }

    @Deprecated
    public void setOldPolicyDegradoPrestazionaleRequestCounter(Long oldPolicyDegradoPrestazionaleRequestCounter) {
        this.oldPolicyDegradoPrestazionaleRequestCounter = oldPolicyDegradoPrestazionaleRequestCounter;
    }

    @Deprecated
    public void setOldPolicyDegradoPrestazionaleCounter(Long oldPolicyDegradoPrestazionaleCounter) {
        this.oldPolicyDegradoPrestazionaleCounter = oldPolicyDegradoPrestazionaleCounter;
    }

    public static String serialize(DatiCollezionati dati) {
        StringBuilder bf = new StringBuilder();
        if (dati.cloneDate != null) {
            bf.append(dati.cloneDate.getTime());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.tipoRisorsa != null) {
            bf.append(dati.tipoRisorsa.getValue());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        Long getActiveRequestCounter = dati.getActiveRequestCounter(true);
        if (getActiveRequestCounter != null) {
            bf.append(getActiveRequestCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.creationDate != null) {
            bf.append(dati.creationDate.getTime());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDateTypeInterval != null) {
            bf.append(dati.policyDateTypeInterval.getValue());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDateInterval != null) {
            bf.append(dati.policyDateInterval);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDateCurrentInterval != null) {
            bf.append(dati.policyDateCurrentInterval);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDateWindowInterval != null) {
            bf.append(dati.policyDateWindowInterval.getValue());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyRealtime != null) {
            bf.append(dati.policyRealtime);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDate != null) {
            bf.append(dati.policyDate.getTime());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        Long getPolicyRequestCounter = dati.getPolicyRequestCounter(true);
        if (getPolicyRequestCounter != null) {
            bf.append(getPolicyRequestCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        Long getPolicyCounter = dati.getPolicyCounter(true);
        if (getPolicyCounter != null) {
            bf.append(getPolicyCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        Long getPolicyDenyRequestCounter = dati.getPolicyDenyRequestCounter(true);
        if (getPolicyDenyRequestCounter != null) {
            bf.append(getPolicyDenyRequestCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.oldPolicyDate != null) {
            bf.append(dati.oldPolicyDate.getTime());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.oldPolicyRequestCounter != null) {
            bf.append(dati.oldPolicyRequestCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.oldPolicyCounter != null) {
            bf.append(dati.oldPolicyCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDegradoPrestazionaleDateTypeInterval != null) {
            bf.append(dati.policyDegradoPrestazionaleDateTypeInterval.getValue());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDegradoPrestazionaleDateInterval != null) {
            bf.append(dati.policyDegradoPrestazionaleDateInterval);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDegradoPrestazionaleDateCurrentInterval != null) {
            bf.append(dati.policyDegradoPrestazionaleDateCurrentInterval);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDegradoPrestazionaleDateWindowInterval != null) {
            bf.append(dati.policyDegradoPrestazionaleDateWindowInterval.getValue());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDegradoPrestazionaleRealtime != null) {
            bf.append(dati.policyDegradoPrestazionaleRealtime);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.policyDegradoPrestazionaleDate != null) {
            bf.append(dati.policyDegradoPrestazionaleDate.getTime());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        Long getPolicyDegradoPrestazionaleRequestCounter = dati.getPolicyDegradoPrestazionaleRequestCounter(true);
        if (getPolicyDegradoPrestazionaleRequestCounter != null) {
            bf.append(getPolicyDegradoPrestazionaleRequestCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        Long getPolicyDegradoPrestazionaleCounter = dati.getPolicyDegradoPrestazionaleCounter(true);
        if (getPolicyDegradoPrestazionaleCounter != null) {
            bf.append(getPolicyDegradoPrestazionaleCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.oldPolicyDegradoPrestazionaleDate != null) {
            bf.append(dati.oldPolicyDegradoPrestazionaleDate.getTime());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.oldPolicyDegradoPrestazionaleRequestCounter != null) {
            bf.append(dati.oldPolicyDegradoPrestazionaleRequestCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.oldPolicyDegradoPrestazionaleCounter != null) {
            bf.append(dati.oldPolicyDegradoPrestazionaleCounter);
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.updatePolicyDate != null) {
            bf.append(dati.updatePolicyDate.getTime());
        } else {
            bf.append("-");
        }
        bf.append("\n");
        if (dati.gestorePolicyConfigDate != null) {
            bf.append(dati.gestorePolicyConfigDate.getTime());
        } else {
            bf.append("-");
        }
        return bf.toString();
    }

    public static DatiCollezionati deserialize(String s) throws CoreException {
        DatiCollezionati dati = new DatiCollezionati(null, null);
        String[] tmp = s.split("\n");
        if (tmp == null) {
            throw new CoreException("Wrong Format");
        }
        int oldLength = 27;
        int dataPolicyLength = oldLength + 1;
        int dataConfigPolicyLength = dataPolicyLength + 1;
        if (tmp.length != oldLength && tmp.length != dataPolicyLength && tmp.length != dataConfigPolicyLength) {
            throw new CoreException("Wrong Format (size: " + tmp.length + ")");
        }
        for (int i = 0; i < tmp.length; ++i) {
            String tmpValue;
            if (i == 0) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.cloneDate = new Date(Long.parseLong(tmpValue));
                continue;
            }
            if (i == 1) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.tipoRisorsa = TipoRisorsa.toEnumConstant(tmpValue);
                continue;
            }
            if (i == 2) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.activeRequestCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 3) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.creationDate = new Date(Long.parseLong(tmpValue));
                continue;
            }
            if (i == 4) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDateTypeInterval = UnitaTemporale.toEnumConstant((String)tmpValue);
                continue;
            }
            if (i == 5) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDateInterval = Integer.parseInt(tmpValue);
                continue;
            }
            if (i == 6) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDateCurrentInterval = Boolean.parseBoolean(tmpValue);
                continue;
            }
            if (i == 7) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDateWindowInterval = TipoFinestra.toEnumConstant(tmpValue);
                continue;
            }
            if (i == 8) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyRealtime = Boolean.parseBoolean(tmpValue);
                continue;
            }
            if (i == 9) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDate = new Date(Long.parseLong(tmpValue));
                continue;
            }
            if (i == 10) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyRequestCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 11) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 12) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDenyRequestCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 13) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.oldPolicyDate = new Date(Long.parseLong(tmpValue));
                continue;
            }
            if (i == 14) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.oldPolicyRequestCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 15) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.oldPolicyCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 16) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDegradoPrestazionaleDateTypeInterval = UnitaTemporale.toEnumConstant((String)tmpValue);
                continue;
            }
            if (i == 17) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDegradoPrestazionaleDateInterval = Integer.parseInt(tmpValue);
                continue;
            }
            if (i == 18) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDegradoPrestazionaleDateCurrentInterval = Boolean.parseBoolean(tmpValue);
                continue;
            }
            if (i == 19) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDegradoPrestazionaleDateWindowInterval = TipoFinestra.toEnumConstant(tmpValue);
                continue;
            }
            if (i == 20) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDegradoPrestazionaleRealtime = Boolean.parseBoolean(tmpValue);
                continue;
            }
            if (i == 21) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDegradoPrestazionaleDate = new Date(Long.parseLong(tmpValue));
                continue;
            }
            if (i == 22) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDegradoPrestazionaleRequestCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 23) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.policyDegradoPrestazionaleCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 24) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.oldPolicyDegradoPrestazionaleDate = new Date(Long.parseLong(tmpValue));
                continue;
            }
            if (i == 25) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.oldPolicyDegradoPrestazionaleRequestCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 26) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.oldPolicyDegradoPrestazionaleCounter = Long.parseLong(tmpValue);
                continue;
            }
            if (i == 27) {
                tmpValue = tmp[i].trim();
                if (tmpValue == null || "-".equals(tmpValue)) continue;
                dati.updatePolicyDate = new Date(Long.parseLong(tmpValue));
                continue;
            }
            if (i != 28 || (tmpValue = tmp[i].trim()) == null || "-".equals(tmpValue)) continue;
            dati.gestorePolicyConfigDate = new Date(Long.parseLong(tmpValue));
        }
        if (dati.updatePolicyDate == null) {
            dati.updatePolicyDate = dati.creationDate;
        }
        return dati;
    }

    public static Long translateToKb(long counter) {
        return counter / 1024L;
    }

    public static Long translateToSeconds(long counter) {
        return counter / 1000L;
    }

    private static Date incrementDate(Date date, UnitaTemporale unitaTemporale, int intervallo, boolean consideraIntervalloAttuale) {
        int increment = 0;
        if (consideraIntervalloAttuale) {
            if (intervallo > 1) {
                increment = intervallo - 1;
            }
        } else {
            increment = intervallo;
        }
        return DateUtils.incrementDate((Date)date, (UnitaTemporale)unitaTemporale, (int)increment);
    }

    private static Date decrementDate(Date date, UnitaTemporale unitaTemporale, int intervallo, boolean consideraIntervalloAttuale) {
        int increment = 0;
        if (consideraIntervalloAttuale) {
            if (intervallo > 1) {
                increment = intervallo - 1;
            }
        } else {
            increment = intervallo;
        }
        if (increment != 0) {
            increment *= -1;
        }
        return DateUtils.incrementDate((Date)date, (UnitaTemporale)unitaTemporale, (int)increment);
    }
}

