/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.utils;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;

public class ConfigUtils {
    private static final String PROPS_SEPARATOR_VALUES = "!,!";

    public static SortedMap<List<String>> toSortedListMap(List<Proprieta> proprieta) throws UtilsException {
        SortedMap map = new SortedMap();
        if (proprieta != null && !proprieta.isEmpty()) {
            for (Proprieta p : proprieta) {
                String valore;
                ArrayList<String> l = (ArrayList<String>)map.get(p.getNome());
                if (l == null) {
                    l = new ArrayList<String>();
                    map.add(p.getNome(), l);
                }
                if ((valore = p.getValore()).contains(PROPS_SEPARATOR_VALUES)) {
                    String[] split = valore.split(PROPS_SEPARATOR_VALUES);
                    if (split == null || split.length <= 0) {
                        l.add(valore);
                        continue;
                    }
                    for (String v : split) {
                        l.add(v);
                    }
                    continue;
                }
                l.add(valore);
            }
        }
        return map;
    }

    public static void addFromSortedListMap(List<Proprieta> proprieta, SortedMap<List<String>> map) {
        List keys = map.keys();
        if (keys != null && !keys.isEmpty()) {
            for (String nome : keys) {
                Object proprietaAutorizzazioneContenuto;
                List valori = (List)map.get(nome);
                if (valori == null || valori.isEmpty()) continue;
                if (valori.size() == 1) {
                    String valore = (String)valori.get(0);
                    proprietaAutorizzazioneContenuto = new Proprieta();
                    ((Proprieta)proprietaAutorizzazioneContenuto).setNome(nome);
                    ((Proprieta)proprietaAutorizzazioneContenuto).setValore(valore);
                    proprieta.add((Proprieta)proprietaAutorizzazioneContenuto);
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                for (String valore : valori) {
                    if (sb.length() > 0) {
                        sb.append(PROPS_SEPARATOR_VALUES);
                    }
                    sb.append(valore);
                }
                proprietaAutorizzazioneContenuto = new Proprieta();
                ((Proprieta)proprietaAutorizzazioneContenuto).setNome(nome);
                ((Proprieta)proprietaAutorizzazioneContenuto).setValore(sb.toString());
                proprieta.add((Proprieta)proprietaAutorizzazioneContenuto);
            }
        }
    }
}

