/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.Route;
import org.openspcoop2.core.config.RouteGateway;
import org.openspcoop2.core.config.RouteRegistro;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.RoutingTableDefault;
import org.openspcoop2.core.config.RoutingTableDestinazione;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_routingTableLIB {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDRoutingTable(int type, RoutingTable aRT, Connection con) throws DriverConfigurazioneException {
        PreparedStatement updateStmt = null;
        PreparedStatement insertStmt = null;
        PreparedStatement updateStmtSelectRegistri = null;
        ResultSet rsSelectRegistri = null;
        String updateQuery = "";
        int i = 0;
        RoutingTableDestinazione rtd = null;
        Route route = null;
        RouteGateway gw = null;
        RouteRegistro rg = null;
        String tipo = null;
        String nome = null;
        long idRoute = 0L;
        try {
            switch (type) {
                case 1: {
                    String selectQuery;
                    long registroRotta;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addUpdateTable("configurazione");
                    sqlQueryObject.addUpdateField("routing_enabled", "?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    if (aRT.getAbilitata() != null && aRT.getAbilitata().booleanValue()) {
                        updateStmt.setString(1, CostantiConfigurazione.ABILITATO.toString());
                    } else {
                        updateStmt.setString(1, CostantiConfigurazione.DISABILITATO.toString());
                    }
                    DriverConfigurazioneDBLib.log.debug("eseguo query :" + DBUtils.formatSQLString(updateQuery, aRT.getAbilitata() != null && aRT.getAbilitata() != false));
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("routing");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tiporotta", "?");
                    sqlQueryObject.addInsertField("tiposoggrotta", "?");
                    sqlQueryObject.addInsertField("nomesoggrotta", "?");
                    sqlQueryObject.addInsertField("registrorotta", "?");
                    sqlQueryObject.addInsertField("is_default", "?");
                    updateQuery = sqlQueryObject.createSQLInsert();
                    i = 0;
                    if (aRT.getDefault() != null) {
                        RoutingTableDefault rtDefault = aRT.getDefault();
                        for (i = 0; i < rtDefault.sizeRouteList(); ++i) {
                            route = rtDefault.getRoute(i);
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setString(1, null);
                            updateStmt.setString(2, null);
                            updateStmt.setString(3, gw != null ? "gateway" : "registro");
                            updateStmt.setString(4, gw != null ? gw.getTipo() : null);
                            updateStmt.setString(5, gw != null ? gw.getNome() : null);
                            registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                if (rsSelectRegistri != null) {
                                    rsSelectRegistri.close();
                                }
                                updateStmtSelectRegistri.close();
                            }
                            updateStmt.setLong(6, registroRotta);
                            updateStmt.setInt(7, 1);
                            updateStmt.executeUpdate();
                            updateStmt.close();
                        }
                    }
                    DriverConfigurazioneDBLib.log.debug("Inserted " + i + " Default route.");
                    i = 0;
                    while (true) {
                        if (i >= aRT.sizeDestinazioneList()) {
                            DriverConfigurazioneDBLib.log.debug("Inserted " + i + " Destination route.");
                            return;
                        }
                        rtd = aRT.getDestinazione(i);
                        nome = rtd.getNome();
                        tipo = rtd.getTipo();
                        for (int j = 0; j < rtd.sizeRouteList(); ++j) {
                            route = rtd.getRoute(j);
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setString(1, tipo);
                            updateStmt.setString(2, nome);
                            updateStmt.setString(3, gw != null ? "gateway" : "registro");
                            updateStmt.setString(4, gw != null ? gw.getTipo() : null);
                            updateStmt.setString(5, gw != null ? gw.getNome() : null);
                            registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                rsSelectRegistri.close();
                                updateStmtSelectRegistri.close();
                            }
                            updateStmt.setLong(6, registroRotta);
                            updateStmt.setInt(7, 0);
                            updateStmt.executeUpdate();
                            updateStmt.close();
                        }
                        ++i;
                    }
                }
                case 2: {
                    String selectQuery;
                    long registroRotta;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addUpdateTable("configurazione");
                    sqlQueryObject.addUpdateField("routing_enabled", "?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    if (aRT.getAbilitata() != null && aRT.getAbilitata().booleanValue()) {
                        updateStmt.setString(1, CostantiConfigurazione.ABILITATO.toString());
                    } else {
                        updateStmt.setString(1, CostantiConfigurazione.DISABILITATO.toString());
                    }
                    DriverConfigurazioneDBLib.log.debug("eseguo query :" + DBUtils.formatSQLString(updateQuery, aRT.getAbilitata() != null && aRT.getAbilitata() != false));
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addUpdateTable("routing");
                    sqlQueryObject.addUpdateField("tipo", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("tiporotta", "?");
                    sqlQueryObject.addUpdateField("tiposoggrotta", "?");
                    sqlQueryObject.addUpdateField("nomesoggrotta", "?");
                    sqlQueryObject.addUpdateField("registrorotta", "?");
                    sqlQueryObject.addUpdateField("is_default", "?");
                    sqlQueryObject.addWhereCondition("id = ?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("routing");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tiporotta", "?");
                    sqlQueryObject.addInsertField("tiposoggrotta", "?");
                    sqlQueryObject.addInsertField("nomesoggrotta", "?");
                    sqlQueryObject.addInsertField("registrorotta", "?");
                    sqlQueryObject.addInsertField("is_default", "?");
                    String insertQuery = sqlQueryObject.createSQLInsert();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addDeleteTable("routing");
                    String queryDelete = sqlQueryObject.createSQLDelete();
                    DriverConfigurazioneDBLib.log.debug("DELETING Destination Route : " + queryDelete);
                    updateStmt = con.prepareStatement(queryDelete);
                    int n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.log.debug("Deleted " + n + " Destination route.");
                    i = 0;
                    if (aRT.getDefault() != null) {
                        RoutingTableDefault rtDefault = aRT.getDefault();
                        for (i = 0; i < rtDefault.sizeRouteList(); ++i) {
                            route = rtDefault.getRoute(i);
                            idRoute = route.getId();
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                rsSelectRegistri.close();
                                updateStmtSelectRegistri.close();
                            }
                            insertStmt = con.prepareStatement(insertQuery);
                            insertStmt.setString(1, null);
                            insertStmt.setString(2, null);
                            insertStmt.setString(3, gw != null ? "gateway" : "registro");
                            insertStmt.setString(4, gw != null ? gw.getTipo() : null);
                            insertStmt.setString(5, gw != null ? gw.getNome() : null);
                            insertStmt.setLong(6, registroRotta);
                            insertStmt.setInt(7, 1);
                            insertStmt.executeUpdate();
                            insertStmt.close();
                        }
                    }
                    DriverConfigurazioneDBLib.log.debug("Updated " + i + " Default route.");
                    i = 0;
                    while (true) {
                        if (i >= aRT.sizeDestinazioneList()) {
                            DriverConfigurazioneDBLib.log.debug("Updated " + i + " Destination route.");
                            return;
                        }
                        rtd = aRT.getDestinazione(i);
                        nome = rtd.getNome();
                        tipo = rtd.getTipo();
                        for (int j = 0; j < rtd.sizeRouteList(); ++j) {
                            route = rtd.getRoute(j);
                            idRoute = route.getId();
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                rsSelectRegistri.close();
                                updateStmtSelectRegistri.close();
                            }
                            insertStmt = con.prepareStatement(insertQuery);
                            insertStmt.setString(1, tipo);
                            insertStmt.setString(2, nome);
                            insertStmt.setString(3, gw != null ? "gateway" : "registro");
                            insertStmt.setString(4, gw != null ? gw.getTipo() : null);
                            insertStmt.setString(5, gw != null ? gw.getNome() : null);
                            insertStmt.setLong(6, registroRotta);
                            insertStmt.setInt(7, 0);
                            insertStmt.executeUpdate();
                            insertStmt.close();
                        }
                        ++i;
                    }
                }
                case 3: {
                    i = 0;
                    if (aRT.getDefault() == null) return;
                    RoutingTableDefault rtDefault = aRT.getDefault();
                    i = 0;
                    while (i < rtDefault.sizeRouteList()) {
                        route = rtDefault.getRoute(i);
                        if (route.getId() == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable(DELETE)] id route non valida.");
                        if (route.getId() <= 0L) {
                            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable(DELETE)] id route non valida.");
                        }
                        idRoute = route.getId();
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addDeleteTable("routing");
                        sqlQueryObject.addWhereCondition("id=?");
                        String sqlQuery = sqlQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(sqlQuery);
                        updateStmt.setLong(1, idRoute);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        DriverConfigurazioneDBLib.log.debug("Deleted " + i + " Destination route.");
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
            JDBCUtilities.closeResources(insertStmt);
            JDBCUtilities.closeResources(rsSelectRegistri, updateStmtSelectRegistri);
        }
    }
}

