/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.ProtocolProperty;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.FiltroRicercaProtocolPropertyConfig;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.mapping.DBProtocolPropertiesUtils;
import org.openspcoop2.core.mapping.FiltroRicercaProtocolProperty;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class DriverConfigurazioneDB_protocolPropertiesDriver {
    private DriverConfigurazioneDB driver = null;

    protected DriverConfigurazioneDB_protocolPropertiesDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    protected boolean existsProtocolProperty(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome) throws DriverConfigurazioneException {
        Connection connection;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsProtocolProperty");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("DriverConfigurazioneDB::existsProtocolProperty] Exception accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            boolean e = DBProtocolPropertiesUtils.existsProtocolProperty(proprietarioProtocolProperty, idProprietario, nome, connection, this.driver.tipoDB);
            return e;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        finally {
            this.driver.closeConnection(connection);
        }
    }

    protected ProtocolProperty getProtocolProperty(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "getProtocolProperty";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getProtocolProperty");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ProtocolProperty e = DBProtocolPropertiesUtils.getProtocolPropertyConfig(proprietarioProtocolProperty, idProprietario, nome, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
            return e;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected ProtocolProperty getProtocolProperty(long idProtocolProperty) throws DriverConfigurazioneException {
        String nomeMetodo = "getProtocolProperty";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getProtocolProperty");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ProtocolProperty e = DriverConfigurazioneDBLib.getProtocolProperty(idProtocolProperty, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
            return e;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected void setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, FiltroRicercaServiziApplicativi filtroRicerca, String tabella) throws SQLQueryObjectException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca.getProtocolProperties(), tabella);
        }
    }

    protected void _setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, List<FiltroRicercaProtocolPropertyConfig> list, String tabella) throws SQLQueryObjectException {
        if (list != null && !list.isEmpty()) {
            ArrayList<FiltroRicercaProtocolProperty> l = new ArrayList<FiltroRicercaProtocolProperty>();
            l.addAll(list);
            DBProtocolPropertiesUtils.setProtocolPropertiesForSearch(sqlQueryObject, l, tabella);
        }
    }

    protected void setProtocolPropertiesForSearch(PreparedStatement stmt, int index, FiltroRicercaServiziApplicativi filtroRicerca, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (filtroRicerca != null) {
            this._setProtocolPropertiesForSearch(stmt, index, filtroRicerca.getProtocolProperties(), proprietario);
        }
    }

    protected void _setProtocolPropertiesForSearch(PreparedStatement stmt, int index, List<FiltroRicercaProtocolPropertyConfig> list, ProprietariProtocolProperty proprietario) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        if (list != null && !list.isEmpty()) {
            ArrayList<FiltroRicercaProtocolProperty> l = new ArrayList<FiltroRicercaProtocolProperty>();
            l.addAll(list);
            DBProtocolPropertiesUtils.setProtocolPropertiesForSearch(stmt, index, l, proprietario, this.driver.tipoDB, this.driver.log);
        }
    }
}

